/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import java.util.Calendar;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RememberMeStore {
    private static RememberMeStore store = new RememberMeStore();
    private static Log log = LogFactory.getLog(RememberMeStore.class);
    private Map<String, Long> rememberMeMap = new HashedMap();

    private RememberMeStore() {
    }

    public static synchronized RememberMeStore getInstance() {
        return store;
    }

    public synchronized void addUserToStore(String username) {
        long timestamp = Calendar.getInstance().getTimeInMillis();
        this.rememberMeMap.put(username, timestamp);
    }

    public synchronized boolean isUserInStore(String username) {
        if (this.rememberMeMap.containsKey(username)) {
            long timestamp = this.rememberMeMap.get(username);
            long curtime = Calendar.getInstance().getTimeInMillis();
            if (curtime - timestamp > 1200000L) {
                log.warn((Object)"RememberMe session expired. Please login");
                return false;
            }
            return true;
        }
        return false;
    }
}

