/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;

public class OpenIDConnectSystemClaimImpl
implements ClaimProvider {
    private static final String SHA384 = "SHA-384";
    private static final String SHA512 = "SHA-512";
    private JWSAlgorithm signatureAlgorithm = null;

    @Override
    public Map<String, Object> getAdditionalClaims(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuth2AuthorizeRespDTO authorizeRespDTO) throws IdentityOAuth2Exception {
        this.setSignatureAlgorithm();
        HashMap<String, Object> oidcSystemClaims = new HashMap<String, Object>();
        String responseType = authAuthzReqMessageContext.getAuthorizationReqDTO().getResponseType();
        String authorizationCode = authorizeRespDTO.getAuthorizationCode();
        String accessToken = authorizeRespDTO.getAccessToken();
        if (this.isIDTokenSigned() && this.isAccessTokenHashApplicable(responseType) && StringUtils.isNotBlank((String)accessToken)) {
            String atHash = this.getHashValue(accessToken);
            oidcSystemClaims.put("at_hash", atHash);
        }
        if (this.isIDTokenSigned() && this.isCodeHashApplicable(responseType) && StringUtils.isNotBlank((String)authorizationCode)) {
            String cHash = this.getHashValue(authorizationCode);
            oidcSystemClaims.put("c_hash", cHash);
        }
        return oidcSystemClaims;
    }

    @Override
    public Map<String, Object> getAdditionalClaims(OAuthTokenReqMessageContext tokenReqMessageContext, OAuth2AccessTokenRespDTO tokenRespDTO) throws IdentityOAuth2Exception {
        this.setSignatureAlgorithm();
        HashMap<String, Object> oidcSystemClaims = new HashMap<String, Object>();
        String authorizationCode = tokenReqMessageContext.getOauth2AccessTokenReqDTO().getAuthorizationCode();
        String accessToken = tokenRespDTO.getAccessToken();
        if (this.isIDTokenSigned() && StringUtils.isNotBlank((String)accessToken)) {
            String atHash = this.getHashValue(accessToken);
            oidcSystemClaims.put("at_hash", atHash);
        }
        if (this.isIDTokenSigned() && StringUtils.isNotBlank((String)authorizationCode)) {
            String cHash = this.getHashValue(authorizationCode);
            oidcSystemClaims.put("c_hash", cHash);
        }
        return oidcSystemClaims;
    }

    private void setSignatureAlgorithm() throws IdentityOAuth2Exception {
        this.signatureAlgorithm = OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(OAuthServerConfiguration.getInstance().getIdTokenSignatureAlgorithm());
    }

    private boolean isIDTokenSigned() {
        return !JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName());
    }

    private String getHashValue(String value) throws IdentityOAuth2Exception {
        MessageDigest md;
        String digAlg = OAuth2Util.mapDigestAlgorithm((Algorithm)this.signatureAlgorithm);
        try {
            md = MessageDigest.getInstance(digAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityOAuth2Exception("Error creating the hash value. Invalid Digest Algorithm: " + digAlg);
        }
        md.update(value.getBytes(Charsets.UTF_8));
        byte[] digest = md.digest();
        int leftHalfBytes = 16;
        if (SHA384.equals(digAlg)) {
            leftHalfBytes = 24;
        } else if (SHA512.equals(digAlg)) {
            leftHalfBytes = 32;
        }
        byte[] leftmost = new byte[leftHalfBytes];
        System.arraycopy(digest, 0, leftmost, 0, leftHalfBytes);
        return new String(Base64.encodeBase64URLSafe((byte[])leftmost), Charsets.UTF_8);
    }

    private boolean isCodeHashApplicable(String responseType) {
        return responseType.contains(ResponseType.CODE.toString()) && !"none".equalsIgnoreCase(responseType);
    }

    private boolean isAccessTokenHashApplicable(String responseType) {
        return !"id_token".equalsIgnoreCase(responseType) && !"none".equalsIgnoreCase(responseType);
    }
}

