/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.ClaimMetaData;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.exception.SSOConsentServiceException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.Claim;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.OpenIDConnectClaimFilter;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;

public class OpenIDConnectClaimFilterImpl
implements OpenIDConnectClaimFilter {
    private static final String ADDRESS_PREFIX = "address.";
    private static final String ADDRESS_SCOPE = "address";
    private static final String OIDC_DIALECT = "http://wso2.org/oidc/claim";
    private static final Log log = LogFactory.getLog(OpenIDConnectClaimFilterImpl.class);
    private static final int DEFAULT_PRIORITY = 100;

    @Override
    public Map<String, Object> getClaimsFilteredByOIDCScopes(Map<String, Object> userClaims, String[] requestedScopes, String clientId, String spTenantDomain) {
        if (MapUtils.isEmpty(userClaims)) {
            this.logDebugForEmptyUserClaims();
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> claimsToBeReturned = new HashMap<String, Object>();
        HashMap<String, Object> addressScopeClaims = new HashMap<String, Object>();
        HashMap<String, List<String>> scopeClaimsMap = new HashMap<String, List<String>>();
        int tenantId = IdentityTenantUtil.getTenantId((String)spTenantDomain);
        List<ScopeDTO> oidcScopesList = this.getOIDCScopes(tenantId);
        for (ScopeDTO scope : oidcScopesList) {
            scopeClaimsMap.put(scope.getName(), Arrays.asList(scope.getClaim()));
        }
        if (MapUtils.isNotEmpty(scopeClaimsMap)) {
            List<String> addressScopeClaimUris = this.getAddressScopeClaimUris(scopeClaimsMap);
            for (String requestedScope : requestedScopes) {
                if (scopeClaimsMap.containsKey(requestedScope)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Requested scope: " + requestedScope + " is a defined OIDC Scope in tenantDomain: " + spTenantDomain + ". Filtering claims based on the permitted claims in the scope."));
                    }
                    Map<String, Object> filteredClaims = this.handleRequestedOIDCScope(userClaims, addressScopeClaims, scopeClaimsMap, addressScopeClaimUris, requestedScope);
                    claimsToBeReturned.putAll(filteredClaims);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Requested scope: " + requestedScope + " is not a defined OIDC Scope in tenantDomain: " + spTenantDomain + "."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No OIDC scopes defined for tenantDomain: " + spTenantDomain + ". Cannot proceed with filtering user claims therefore returning an empty claim map."));
        }
        if (this.isNotEmpty(addressScopeClaims)) {
            this.handleAddressClaim(claimsToBeReturned, addressScopeClaims);
        }
        this.handleUpdateAtClaim(claimsToBeReturned);
        this.handlePhoneNumberVerifiedClaim(claimsToBeReturned);
        this.handleEmailVerifiedClaim(claimsToBeReturned);
        return claimsToBeReturned;
    }

    @Override
    public List<String> getClaimsFilteredByOIDCScopes(Set<String> requestedScopes, String spTenantDomain) {
        HashMap<String, List<String>> scopeClaimsMap = new HashMap<String, List<String>>();
        int tenantId = IdentityTenantUtil.getTenantId((String)spTenantDomain);
        ArrayList<String> filteredClaims = new ArrayList<String>();
        List<ScopeDTO> oidcScopesList = this.getOIDCScopes(tenantId);
        if (CollectionUtils.isNotEmpty(oidcScopesList)) {
            for (ScopeDTO scope : oidcScopesList) {
                scopeClaimsMap.put(scope.getName(), Arrays.asList(scope.getClaim()));
            }
            for (String requestedScope : requestedScopes) {
                if (scopeClaimsMap.containsKey(requestedScope)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Requested scope: " + requestedScope + " is a defined OIDC Scope in tenantDomain: " + spTenantDomain + ". Filtering claims based on the permitted claims in the scope."));
                    }
                    filteredClaims.addAll(this.getClaimUrisInSupportedOIDCScope(scopeClaimsMap, requestedScope));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Requested scope: " + requestedScope + " is not a defined OIDC Scope in tenantDomain: " + spTenantDomain + "."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No OIDC scopes defined for tenantDomain: " + spTenantDomain + ". Cannot proceed with getting claims for the requested scopes. Therefore returning an empty claim list."));
        }
        return filteredClaims;
    }

    @Override
    public Map<String, Object> getClaimsFilteredByUserConsent(Map<String, Object> userClaims, AuthenticatedUser authenticatedUser, String clientId, String spTenantDomain) {
        if (MapUtils.isEmpty(userClaims)) {
            this.logDebugForEmptyUserClaims();
            return new HashMap<String, Object>();
        }
        try {
            ServiceProvider serviceProvider = OAuth2Util.getServiceProvider(clientId, spTenantDomain);
            if (this.isConsentManagementServiceDisabled(serviceProvider)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Consent Management disabled or not applicable for Service Provider: " + serviceProvider.getApplicationName() + ". Skipping filtering user claims based on consent."));
                }
                return userClaims;
            }
            List<String> userConsentedClaimUris = this.getUserConsentedLocalClaimURIs(authenticatedUser, serviceProvider);
            List<String> userConsentClaimUrisInOIDCDialect = this.getOIDCClaimURIs(userConsentedClaimUris, spTenantDomain);
            return userClaims.keySet().stream().filter(userConsentClaimUrisInOIDCDialect::contains).collect(Collectors.toMap(key -> key, userClaims::get));
        }
        catch (SSOConsentServiceException | IdentityOAuth2Exception e) {
            String msg = "Error while filtering claims based on user consent for user: " + authenticatedUser.toFullQualifiedUsername() + " for client_id: " + clientId;
            log.error((Object)msg, (Throwable)e);
            return userClaims;
        }
    }

    private boolean isConsentManagementServiceDisabled(ServiceProvider serviceProvider) {
        return !OpenIDConnectServiceComponentHolder.getInstance().getSsoConsentService().isSSOConsentManagementEnabled(serviceProvider);
    }

    private List<String> getUserConsentedLocalClaimURIs(AuthenticatedUser authenticatedUser, ServiceProvider sp) throws SSOConsentServiceException {
        List claimsWithConsents = OpenIDConnectServiceComponentHolder.getInstance().getSsoConsentService().getClaimsWithConsents(sp, authenticatedUser);
        return this.getClaimUrisWithConsent(claimsWithConsents);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Map<String, Object> getClaimsFilteredByEssentialClaims(Map<String, Object> userClaims, List<RequestedClaim> requestParamClaims) {
        if (MapUtils.isEmpty(userClaims)) {
            this.logDebugForEmptyUserClaims();
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> essentialClaims = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(requestParamClaims)) {
            for (RequestedClaim essentialClaim : requestParamClaims) {
                String claimName = essentialClaim.getName();
                if (!essentialClaim.isEssential() || userClaims.get(claimName) == null) continue;
                List<String> values = essentialClaim.getValues();
                if (CollectionUtils.isEmpty(values) && StringUtils.isNotEmpty((String)essentialClaim.getValue())) {
                    values = Collections.singletonList(essentialClaim.getValue());
                }
                if (CollectionUtils.isNotEmpty(values)) {
                    String userClaimValue = (String)userClaims.get(claimName);
                    if (!values.contains(userClaimValue)) continue;
                    essentialClaims.put(claimName, userClaims.get(claimName));
                    continue;
                }
                essentialClaims.put(claimName, userClaims.get(claimName));
            }
        }
        return essentialClaims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getOIDCScopeProperties(String spTenantDomain) {
        Resource oidcScopesResource = null;
        try {
            int tenantId = IdentityTenantUtil.getTenantId((String)spTenantDomain);
            this.startTenantFlow(spTenantDomain, tenantId);
            RegistryService registryService = OAuth2ServiceComponentHolder.getRegistryService();
            if (registryService == null) {
                throw new RegistryException("Registry Service not set in OAuth2 Component. Component may not have initialized correctly.");
            }
            oidcScopesResource = registryService.getConfigSystemRegistry(tenantId).get("/oidc");
        }
        catch (RegistryException e) {
            log.error((Object)"Error while obtaining registry collection from registry path:/oidc", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        Properties propertiesToReturn = new Properties();
        if (oidcScopesResource != null) {
            for (Object scopeProperty : oidcScopesResource.getProperties().keySet()) {
                String propertyKey = (String)scopeProperty;
                propertiesToReturn.setProperty(propertyKey, oidcScopesResource.getProperty(propertyKey));
            }
        } else {
            log.error((Object)("OIDC scope resource cannot be found at /oidc for tenantDomain: " + spTenantDomain));
        }
        return propertiesToReturn;
    }

    private List<ScopeDTO> getOIDCScopes(int tenantId) {
        ArrayList<ScopeDTO> oidcScopesList = new ArrayList();
        try {
            oidcScopesList = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getScopes(tenantId);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error while loading oidc scopes and claims for the tenant: " + tenantId));
        }
        return oidcScopesList;
    }

    private Map<String, Object> handleRequestedOIDCScope(Map<String, Object> userClaimsInOIDCDialect, Map<String, Object> addressScopeClaims, Map<String, List<String>> scopeClaimsMap, List<String> addressScopeClaimUris, String oidcScope) {
        HashMap<String, Object> filteredClaims = new HashMap<String, Object>();
        List<String> claimUrisInRequestedScope = this.getClaimUrisInSupportedOIDCScope(scopeClaimsMap, oidcScope);
        Iterator<String> iterator = claimUrisInRequestedScope.iterator();
        while (iterator.hasNext()) {
            String scopeClaim;
            String oidcClaimUri = scopeClaim = iterator.next();
            boolean isAddressClaim = false;
            if (this.isAddressClaim(scopeClaim, addressScopeClaimUris)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Identified an address claim: " + scopeClaim + ". Removing \"address.\" prefix from the claimUri"));
                }
                oidcClaimUri = this.removeAddressPrefix(scopeClaim);
                isAddressClaim = true;
            }
            if (userClaimsInOIDCDialect.containsKey(oidcClaimUri)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding claim:" + oidcClaimUri + " into the filtered claims"));
                }
                Object claimValue = userClaimsInOIDCDialect.get(oidcClaimUri);
                if (isAddressClaim) {
                    addressScopeClaims.put(oidcClaimUri, claimValue);
                    continue;
                }
                filteredClaims.put(oidcClaimUri, claimValue);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("No valid user claim value found for the claimUri:" + oidcClaimUri));
        }
        return filteredClaims;
    }

    private String removeAddressPrefix(String scopeClaim) {
        return StringUtils.startsWith((String)scopeClaim, (String)ADDRESS_PREFIX) ? StringUtils.substringAfterLast((String)scopeClaim, (String)ADDRESS_PREFIX) : scopeClaim;
    }

    private void handleAddressClaim(Map<String, Object> returnedClaims, Map<String, Object> claimsforAddressScope) {
        if (MapUtils.isNotEmpty(claimsforAddressScope)) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, Object> addressScopeClaimEntry : claimsforAddressScope.entrySet()) {
                jsonObject.put((Object)addressScopeClaimEntry.getKey(), addressScopeClaimEntry.getValue());
            }
            returnedClaims.put(ADDRESS_SCOPE, jsonObject);
        }
    }

    private List<String> getAddressScopeClaimUris(Map<String, List<String>> scopeClaimsMap) {
        return this.getClaimUrisInSupportedOIDCScope(scopeClaimsMap, ADDRESS_SCOPE);
    }

    private boolean isAddressClaim(String scopeClaim, List<String> addressScopeClaims) {
        return StringUtils.startsWith((String)scopeClaim, (String)ADDRESS_PREFIX) || addressScopeClaims.contains(scopeClaim);
    }

    private List<String> getClaimUrisInSupportedOIDCScope(Map<String, List<String>> scopeClaimsMap, String requestedScope) {
        List<String> requestedScopeClaimsList = new ArrayList<String>();
        if (scopeClaimsMap.containsKey(requestedScope)) {
            requestedScopeClaimsList = scopeClaimsMap.get(requestedScope);
        }
        return requestedScopeClaimsList;
    }

    private void handleUpdateAtClaim(Map<String, Object> returnClaims) {
        if (returnClaims.containsKey("updated_at") && returnClaims.get("updated_at") != null && returnClaims.get("updated_at") instanceof String) {
            Date date = this.getDateIfValidDateString((String)returnClaims.get("updated_at"));
            long timeInMillis = date != null ? date.getTime() : Long.parseLong((String)returnClaims.get("updated_at"));
            returnClaims.put("updated_at", timeInMillis);
        }
    }

    private void handlePhoneNumberVerifiedClaim(Map<String, Object> returnClaims) {
        if (returnClaims.containsKey("phone_number_verified") && returnClaims.get("phone_number_verified") != null && returnClaims.get("phone_number_verified") instanceof String) {
            returnClaims.put("phone_number_verified", Boolean.valueOf((String)returnClaims.get("phone_number_verified")));
        }
    }

    private void handleEmailVerifiedClaim(Map<String, Object> returnClaims) {
        if (returnClaims.containsKey("email_verified") && returnClaims.get("email_verified") != null && returnClaims.get("email_verified") instanceof String) {
            returnClaims.put("email_verified", Boolean.valueOf((String)returnClaims.get("email_verified")));
        }
    }

    private void startTenantFlow(String tenantDomain, int tenantId) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(tenantId);
        carbonContext.setTenantDomain(tenantDomain);
    }

    private boolean isNotEmpty(Map<String, Object> claimsToBeReturned) {
        return claimsToBeReturned != null && !claimsToBeReturned.isEmpty();
    }

    private boolean isNotEmpty(Properties properties) {
        return properties != null && !properties.isEmpty();
    }

    private Date getDateIfValidDateString(String dateString) {
        Date date;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(dateString);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The given date string: " + dateString + " is not in correct date time format."));
            }
            return null;
        }
        return date;
    }

    private List<String> getOIDCClaimURIs(List<String> userConsentedClaimUris, String tenantDomain) {
        try {
            List externalClaims = OpenIDConnectServiceComponentHolder.getInstance().getClaimMetadataManagementService().getExternalClaims(OIDC_DIALECT, tenantDomain);
            return externalClaims.stream().filter(externalClaim -> userConsentedClaimUris.contains(externalClaim.getMappedLocalClaim())).map(Claim::getClaimURI).collect(Collectors.toList());
        }
        catch (ClaimMetadataException e) {
            String msg = "Error while trying to convert user consented claims to OIDC dialect in tenantDomain: " + tenantDomain;
            log.error((Object)msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    private List<String> getClaimUrisWithConsent(List<ClaimMetaData> claimsWithConsents) {
        return claimsWithConsents.stream().map(ClaimMetaData::getClaimUri).collect(Collectors.toList());
    }

    private void logDebugForEmptyUserClaims() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No user claims to filter. Returning an empty map of filtered claims.");
        }
    }
}

