/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.RequestObjectBuilder;
import org.wso2.carbon.identity.openidconnect.RequestObjectValidator;
import org.wso2.carbon.identity.openidconnect.model.RequestObject;

public class OIDCRequestObjectUtil {
    private static final Log log = LogFactory.getLog(OIDCRequestObjectUtil.class);
    private static final String REQUEST = "request";
    private static final String REQUEST_URI = "request_uri";
    private static final String REQUEST_PARAM_VALUE_BUILDER = "request_param_value_builder";
    private static final String REQUEST_URI_PARAM_VALUE_BUILDER = "request_uri_param_value_builder";

    public static RequestObject buildRequestObject(OAuthAuthzRequest oauthRequest, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        String requestObjType;
        RequestObjectBuilder requestObjectBuilder;
        if (OIDCRequestObjectUtil.isRequestParameter(oauthRequest)) {
            requestObjectBuilder = OIDCRequestObjectUtil.getRequestObjectBuilder(REQUEST_PARAM_VALUE_BUILDER);
            requestObjType = REQUEST;
        } else if (OIDCRequestObjectUtil.isRequestUri(oauthRequest)) {
            requestObjectBuilder = OIDCRequestObjectUtil.getRequestObjectBuilder(REQUEST_URI_PARAM_VALUE_BUILDER);
            requestObjType = REQUEST_URI;
        } else {
            return null;
        }
        if (requestObjectBuilder == null) {
            String error = "Unable to build the OIDC Request Object from:";
            throw new RequestObjectException("server_error", error + requestObjType);
        }
        RequestObject requestObject = requestObjectBuilder.buildRequestObject(oauthRequest.getParam(requestObjType), oAuth2Parameters);
        RequestObjectValidator requestObjectValidator = OAuthServerConfiguration.getInstance().getRequestObjectValidator();
        OIDCRequestObjectUtil.validateRequestObjectSignature(oAuth2Parameters, requestObject, requestObjectValidator);
        if (!requestObjectValidator.validateRequestObject(requestObject, oAuth2Parameters)) {
            throw new RequestObjectException("invalid_request", "Invalid parameters found in the Request Object.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully build and and validated request Object for: " + requestObjType));
        }
        return requestObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateRequestObjectSignature(OAuth2Parameters oAuth2Parameters, RequestObject requestObject, RequestObjectValidator requestObjectValidator) throws RequestObjectException {
        OAuthAppDO oAuthAppDO;
        String clientId = oAuth2Parameters.getClientId();
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            throw new RequestObjectException("Error while retrieving app information for client_id: " + clientId + ". Cannot proceed with signature validation", (Throwable)e);
        }
        if (oAuthAppDO.isRequestObjectSignatureValidationEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request Object Signature Verification enabled for client_id: " + clientId));
            }
            if (!requestObject.isSigned()) throw new RequestObjectException("Request object signature validation is enabled but request object is not signed.");
            OIDCRequestObjectUtil.validateSignature(oAuth2Parameters, requestObject, requestObjectValidator);
            return;
        } else {
            if (!requestObject.isSigned()) return;
            OIDCRequestObjectUtil.validateSignature(oAuth2Parameters, requestObject, requestObjectValidator);
        }
    }

    private static void validateSignature(OAuth2Parameters oAuth2Parameters, RequestObject requestObject, RequestObjectValidator requestObjectValidator) throws RequestObjectException {
        if (!requestObjectValidator.validateSignature(requestObject, oAuth2Parameters)) {
            throw new RequestObjectException("invalid_request", "Request Object signature verification failed.");
        }
    }

    private static RequestObjectBuilder getRequestObjectBuilder(String requestParamValueBuilder) {
        return OAuthServerConfiguration.getInstance().getRequestObjectBuilders().get(requestParamValueBuilder);
    }

    private static boolean isRequestUri(OAuthAuthzRequest oAuthAuthzRequest) {
        return StringUtils.isNotBlank((String)oAuthAuthzRequest.getParam(REQUEST_URI));
    }

    private static boolean isRequestParameter(OAuthAuthzRequest oAuthAuthzRequest) {
        return StringUtils.isNotBlank((String)oAuthAuthzRequest.getParam(REQUEST));
    }
}

