/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class OIDCClaimUtil {
    private static final Log log = LogFactory.getLog(OIDCClaimUtil.class);
    private static final String OPENID_IDP_ENTITY_ID = "IdPEntityId";
    private static final String SEND_ONLY_SP_MAPPED_ROLES = "SPRoleManagement.ReturnOnlyMappedLocalRoles";

    private OIDCClaimUtil() {
    }

    public static String getServiceProviderMappedUserRoles(ServiceProvider serviceProvider, List<String> locallyMappedUserRoles, String claimSeparator) throws FrameworkException {
        if (CollectionUtils.isNotEmpty(locallyMappedUserRoles)) {
            List<String> domainRemovedRoles;
            locallyMappedUserRoles = new ArrayList<String>(locallyMappedUserRoles);
            Object[] localToSpRoleMapping = serviceProvider.getPermissionAndRoleConfig().getRoleMappings();
            List<Object> listOfRolesToRemoveDomainName = new ArrayList();
            List<Object> spMappedRoles = new ArrayList();
            boolean returnOnlyMappedLocalRoles = Boolean.parseBoolean(IdentityUtil.getProperty((String)SEND_ONLY_SP_MAPPED_ROLES));
            boolean isRemoveUserDomainInRole = OIDCClaimUtil.isRemoveUserDomainInRole(serviceProvider);
            if (ArrayUtils.isNotEmpty((Object[])localToSpRoleMapping)) {
                for (Object roleMapping : localToSpRoleMapping) {
                    if (!locallyMappedUserRoles.contains(OIDCClaimUtil.getLocalRoleName((RoleMapping)roleMapping))) continue;
                    locallyMappedUserRoles.removeAll(Collections.singletonList(OIDCClaimUtil.getLocalRoleName((RoleMapping)roleMapping)));
                    spMappedRoles.add(roleMapping.getRemoteRole());
                }
                if (!returnOnlyMappedLocalRoles) {
                    if (isRemoveUserDomainInRole) {
                        listOfRolesToRemoveDomainName = locallyMappedUserRoles;
                    } else {
                        spMappedRoles.addAll(locallyMappedUserRoles);
                    }
                }
            } else if (isRemoveUserDomainInRole) {
                listOfRolesToRemoveDomainName = locallyMappedUserRoles;
            } else {
                spMappedRoles = locallyMappedUserRoles;
            }
            if (isRemoveUserDomainInRole && !(domainRemovedRoles = OIDCClaimUtil.removeDomainFromNamesExcludeHybrid(listOfRolesToRemoveDomainName)).isEmpty()) {
                spMappedRoles.addAll(domainRemovedRoles);
            }
            return StringUtils.join(spMappedRoles, (String)claimSeparator);
        }
        return null;
    }

    private static boolean isRemoveUserDomainInRole(ServiceProvider serviceProvider) {
        if (serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return !serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInRoles();
        }
        return false;
    }

    private static List<String> removeDomainFromNamesExcludeHybrid(List<String> names) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : names) {
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)name);
            if ("Internal".equalsIgnoreCase(userStoreDomain) || "Application".equalsIgnoreCase(userStoreDomain) || "Workflow".equalsIgnoreCase(userStoreDomain)) {
                nameList.add(name);
                continue;
            }
            nameList.add(UserCoreUtil.removeDomainFromName((String)name));
        }
        return nameList;
    }

    public static String getSubjectClaimCachedAgainstAccessToken(String accessToken) {
        if (StringUtils.isNotBlank((String)accessToken)) {
            AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(accessToken);
            AuthorizationGrantCacheEntry cacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByToken(cacheKey);
            if (cacheEntry != null) {
                return cacheEntry.getSubjectClaim();
            }
        }
        return null;
    }

    private static String getLocalRoleName(RoleMapping roleMapping) {
        return roleMapping.getLocalRole().getLocalRoleName();
    }

    @Deprecated
    public static Map<String, Object> filterUserClaimsBasedOnConsent(Map<String, Object> userClaims, AuthenticatedUser authenticatedUser, String clientId, String spTenantDomain, String grantType) {
        if (OIDCClaimUtil.isConsentBasedClaimFilteringApplicable(grantType)) {
            return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByUserConsent(userClaims, authenticatedUser, clientId, spTenantDomain);
        }
        if (log.isDebugEnabled()) {
            String msg = "Filtering user claims based on consent skipped for grant type:%s. Returning original user claims for user: %s, for clientId: %s of tenantDomain: %s";
            log.debug((Object)String.format(msg, grantType, authenticatedUser.toFullQualifiedUsername(), clientId, spTenantDomain));
        }
        return userClaims;
    }

    public static Map<String, Object> filterUserClaimsBasedOnConsent(Map<String, Object> userClaims, AuthenticatedUser authenticatedUser, String clientId, String spTenantDomain, String grantType, ServiceProvider serviceProvider) {
        if (OIDCClaimUtil.isConsentBasedClaimFilteringApplicable(grantType) && !FrameworkUtils.isConsentPageSkippedForSP((ServiceProvider)serviceProvider)) {
            return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByUserConsent(userClaims, authenticatedUser, clientId, spTenantDomain);
        }
        if (log.isDebugEnabled()) {
            String msg = "Filtering user claims based on consent skipped for grant type:%s. Returning original user claims for user:%s, for clientId:%s of tenantDomain:%s";
            log.debug((Object)String.format(msg, grantType, authenticatedUser.toFullQualifiedUsername(), clientId, spTenantDomain));
        }
        return userClaims;
    }

    private static boolean isConsentBasedClaimFilteringApplicable(String grantType) {
        return OIDCClaimUtil.isOIDCConsentPageNotSkipped() && OIDCClaimUtil.isUserConsentRequiredForClaims(grantType);
    }

    private static boolean isOIDCConsentPageNotSkipped() {
        return !OAuthServerConfiguration.getInstance().getOpenIDConnectSkipeUserConsentConfig();
    }

    private static boolean isUserConsentRequiredForClaims(String grantType) {
        return OAuthServerConfiguration.getInstance().isUserConsentRequiredForClaims(grantType);
    }
}

