/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.openidconnect.CustomClaimsCallbackHandler;
import org.wso2.carbon.identity.openidconnect.OIDCClaimUtil;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultOIDCClaimsCallbackHandler
implements CustomClaimsCallbackHandler {
    private static final Log log = LogFactory.getLog(DefaultOIDCClaimsCallbackHandler.class);
    private static final String OAUTH2 = "oauth2";
    private static final String OIDC_DIALECT = "http://wso2.org/oidc/claim";
    private static final String ATTRIBUTE_SEPARATOR = FrameworkUtils.getMultiAttributeSeparator();

    @Override
    public JWTClaimsSet handleCustomClaims(JWTClaimsSet.Builder jwtClaimsSetBuilder, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        try {
            Map<String, Object> userClaimsInOIDCDialect = this.getUserClaimsInOIDCDialect(tokenReqMessageContext);
            return this.setClaimsToJwtClaimSet(jwtClaimsSetBuilder, userClaimsInOIDCDialect);
        }
        catch (OAuthSystemException e) {
            log.error((Object)("Error occurred while adding claims of user: " + tokenReqMessageContext.getAuthorizedUser() + " to the JWTClaimSet used to build the id_token."), (Throwable)e);
            return null;
        }
    }

    @Override
    public JWTClaimsSet handleCustomClaims(JWTClaimsSet.Builder jwtClaimsSet, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        try {
            Map<String, Object> userClaimsInOIDCDialect = this.getUserClaimsInOIDCDialect(authzReqMessageContext);
            return this.setClaimsToJwtClaimSet(jwtClaimsSet, userClaimsInOIDCDialect);
        }
        catch (OAuthSystemException e) {
            log.error((Object)("Error occurred while adding claims of user: " + authzReqMessageContext.getAuthorizationReqDTO().getUser() + " to the JWTClaimSet used to build the id_token."), (Throwable)e);
            return null;
        }
    }

    protected Map<String, Object> filterClaimsByScope(Map<String, Object> userClaims, String[] requestedScopes, String clientId, String serviceProviderTenantDomain) {
        return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByOIDCScopes(userClaims, requestedScopes, clientId, serviceProviderTenantDomain);
    }

    private Map<String, Object> getUserClaimsInOIDCDialect(OAuthTokenReqMessageContext requestMsgCtx) throws OAuthSystemException, IdentityOAuth2Exception {
        Map<String, Object> userClaimsInOIDCDialect;
        Map<ClaimMapping, String> userAttributes = this.getCachedUserAttributes(requestMsgCtx);
        if (MapUtils.isEmpty(userAttributes) && this.isLocalUser(requestMsgCtx.getAuthorizedUser())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User attributes not found in cache against the access token or authorization code. Retrieving claims for local user: " + requestMsgCtx.getAuthorizedUser() + " from userstore."));
            }
            userClaimsInOIDCDialect = this.retrieveClaimsForLocalUser(requestMsgCtx);
        } else {
            userClaimsInOIDCDialect = this.getOIDCClaimMapFromUserAttributes(userAttributes);
        }
        Object hasNonOIDCClaimsProperty = requestMsgCtx.getProperty("hasNonOIDCClaims");
        if (this.isPreserverClaimUrisInAssertion(requestMsgCtx) || hasNonOIDCClaimsProperty != null && ((Boolean)hasNonOIDCClaimsProperty).booleanValue()) {
            return userClaimsInOIDCDialect;
        }
        return this.filterOIDCClaims(requestMsgCtx, userClaimsInOIDCDialect);
    }

    private Map<String, Object> filterOIDCClaims(OAuthTokenReqMessageContext requestMsgCtx, Map<String, Object> userClaimsInOIDCDialect) throws OAuthSystemException {
        AuthenticatedUser user = requestMsgCtx.getAuthorizedUser();
        String clientId = requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId();
        String spTenantDomain = requestMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        String[] approvedScopes = requestMsgCtx.getScope();
        String token = this.getAccessToken(requestMsgCtx);
        String grantType = requestMsgCtx.getOauth2AccessTokenReqDTO().getGrantType();
        return this.filterOIDCClaims(token, grantType, userClaimsInOIDCDialect, user, approvedScopes, clientId, spTenantDomain);
    }

    private Map<String, Object> filterOIDCClaims(String accessToken, String grantType, Map<String, Object> userClaimsInOIDCDialect, AuthenticatedUser authenticatedUser, String[] approvedScopes, String clientId, String spTenantDomain) throws OAuthSystemException {
        Map<String, Object> filteredUserClaimsByOIDCScopes = this.filterClaimsByScope(userClaimsInOIDCDialect, approvedScopes, clientId, spTenantDomain);
        if (accessToken != null) {
            Map<String, Object> claimsFromRequestObject = this.filterClaimsFromRequestObject(userClaimsInOIDCDialect, accessToken);
            filteredUserClaimsByOIDCScopes.putAll(claimsFromRequestObject);
        }
        return this.getUserConsentedClaims(filteredUserClaimsByOIDCScopes, authenticatedUser, grantType, clientId, spTenantDomain);
    }

    private boolean isPreserverClaimUrisInAssertion(OAuthTokenReqMessageContext requestMsgCtx) {
        return !OAuthServerConfiguration.getInstance().isConvertOriginalClaimsFromAssertionsToOIDCDialect() && requestMsgCtx.getAuthorizedUser().isFederatedUser();
    }

    private Map<String, Object> filterClaimsFromRequestObject(Map<String, Object> userAttributes, String token) throws OAuthSystemException {
        try {
            List<RequestedClaim> requestedClaims = OpenIDConnectServiceComponentHolder.getRequestObjectService().getRequestedClaimsForIDToken(token);
            return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByEssentialClaims(userAttributes, requestedClaims);
        }
        catch (RequestObjectException e) {
            throw new OAuthSystemException("Unable to retrieve requested claims from Request Object." + (Object)((Object)e));
        }
    }

    private Map<String, Object> getUserConsentedClaims(Map<String, Object> userClaims, AuthenticatedUser authenticatedUser, String grantType, String clientId, String spTenantDomain) throws OAuthSystemException {
        ServiceProvider serviceProvider;
        try {
            serviceProvider = this.getServiceProvider(spTenantDomain, clientId);
        }
        catch (IdentityApplicationManagementException e) {
            throw new OAuthSystemException("Error while obtaining service provider for tenant domain: " + spTenantDomain + " client id: " + clientId, (Throwable)e);
        }
        return OIDCClaimUtil.filterUserClaimsBasedOnConsent(userClaims, authenticatedUser, clientId, spTenantDomain, grantType, serviceProvider);
    }

    private Map<ClaimMapping, String> getCachedUserAttributes(OAuthTokenReqMessageContext requestMsgCtx) {
        Map<ClaimMapping, String> userAttributes = this.getUserAttributesCachedAgainstToken(this.getAccessToken(requestMsgCtx));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving claims cached against access_token for user: " + requestMsgCtx.getAuthorizedUser()));
        }
        if (MapUtils.isEmpty(userAttributes)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No claims cached against the access_token for user: " + requestMsgCtx.getAuthorizedUser() + ". Retrieving claims cached against the authorization code."));
            }
            userAttributes = this.getUserAttributesCachedAgainstAuthorizationCode(this.getAuthorizationCode(requestMsgCtx));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving claims cached against authorization_code for user: " + requestMsgCtx.getAuthorizedUser()));
            }
        }
        if (MapUtils.isEmpty(userAttributes)) {
            AuthenticatedUser user;
            if (log.isDebugEnabled()) {
                log.debug((Object)("No claims found in authorization cache. Retrieving claims from attributes of user : " + requestMsgCtx.getAuthorizedUser()));
            }
            Map<ClaimMapping, String> map = userAttributes = (user = requestMsgCtx.getAuthorizedUser()) != null ? user.getUserAttributes() : null;
        }
        if (MapUtils.isEmpty(userAttributes)) {
            Object previousAccessTokenObject;
            if (log.isDebugEnabled()) {
                log.debug((Object)("No claims found in user in user attributes for user : " + requestMsgCtx.getAuthorizedUser()));
            }
            if ((previousAccessTokenObject = requestMsgCtx.getProperty("previousAccessToken")) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieving claims from previous access token of user : " + requestMsgCtx.getAuthorizedUser()));
                }
                RefreshTokenValidationDataDO refreshTokenValidationDataDO = (RefreshTokenValidationDataDO)previousAccessTokenObject;
                userAttributes = this.getUserAttributesCachedAgainstToken(refreshTokenValidationDataDO.getAccessToken());
                requestMsgCtx.addProperty("hasNonOIDCClaims", this.isTokenHasCustomUserClaims(refreshTokenValidationDataDO));
            }
        }
        return userAttributes;
    }

    private Map<String, Object> retrieveClaimsForLocalUser(OAuthTokenReqMessageContext requestMsgCtx) throws IdentityOAuth2Exception {
        try {
            String spTenantDomain = this.getServiceProviderTenantDomain(requestMsgCtx);
            String clientId = requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId();
            AuthenticatedUser authenticatedUser = requestMsgCtx.getAuthorizedUser();
            return this.getUserClaimsInOIDCDialect(spTenantDomain, clientId, authenticatedUser);
        }
        catch (IdentityApplicationManagementException | IdentityException | UserStoreException e) {
            if (!FrameworkUtils.isContinueOnClaimHandlingErrorAllowed()) {
                throw new IdentityOAuth2Exception("Error occurred while getting claims for user: " + requestMsgCtx.getAuthorizedUser() + " from userstore.", e);
            }
            log.error((Object)("Error occurred while getting claims for user: " + requestMsgCtx.getAuthorizedUser() + " from userstore."), e);
            return new HashMap<String, Object>();
        }
    }

    private Map<ClaimMapping, String> getUserAttributesCachedAgainstAuthorizationCode(String authorizationCode) {
        Map<ClaimMapping, String> userAttributes = Collections.emptyMap();
        if (authorizationCode != null) {
            userAttributes = this.getUserAttributesFromCacheUsingCode(authorizationCode);
        }
        return userAttributes;
    }

    private Map<ClaimMapping, String> getUserAttributesCachedAgainstToken(String accessToken) {
        Map<ClaimMapping, String> userAttributes = Collections.emptyMap();
        if (accessToken != null) {
            userAttributes = this.getUserAttributesFromCacheUsingToken(accessToken);
        }
        return userAttributes;
    }

    private Map<String, Object> getUserClaimsInOIDCDialect(OAuthAuthzReqMessageContext authzReqMessageContext) throws OAuthSystemException, IdentityOAuth2Exception {
        Map<String, Object> userClaimsInOIDCDialect;
        Map<ClaimMapping, String> userAttributes = this.getUserAttributesCachedAgainstToken(this.getAccessToken(authzReqMessageContext));
        if (MapUtils.isEmpty(userAttributes)) {
            if (this.isLocalUser(authzReqMessageContext)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User attributes not found in cache. Trying to retrieve attribute for local user: " + authzReqMessageContext.getAuthorizationReqDTO().getUser()));
                }
                userClaimsInOIDCDialect = this.retrieveClaimsForLocalUser(authzReqMessageContext);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User attributes not found in cache. Trying to retrieve attribute for federated user: " + authzReqMessageContext.getAuthorizationReqDTO().getUser()));
                }
                userClaimsInOIDCDialect = this.retrieveClaimsForFederatedUser(authzReqMessageContext);
            }
        } else {
            userClaimsInOIDCDialect = this.getOIDCClaimMapFromUserAttributes(userAttributes);
        }
        return this.filterOIDCClaims(authzReqMessageContext, userClaimsInOIDCDialect);
    }

    private Map<String, Object> retrieveClaimsForFederatedUser(OAuthAuthzReqMessageContext authzReqMessageContext) {
        OAuth2AuthorizeReqDTO oAuth2AuthorizeReqDTO = authzReqMessageContext.getAuthorizationReqDTO();
        Map<String, Object> userClaimsMappedToOIDCDialect = new HashMap<String, Object>();
        if (oAuth2AuthorizeReqDTO == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth2AuthorizeReqDTO is NULL for federated user: " + authzReqMessageContext.getAuthorizationReqDTO().getUser()));
            }
            return userClaimsMappedToOIDCDialect;
        }
        AuthenticatedUser authenticatedUser = oAuth2AuthorizeReqDTO.getUser();
        if (authenticatedUser == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authenticated User is not available in the request");
            }
            return userClaimsMappedToOIDCDialect;
        }
        userClaimsMappedToOIDCDialect = this.getOIDCClaimMapFromUserAttributes(authenticatedUser.getUserAttributes());
        return userClaimsMappedToOIDCDialect;
    }

    private Map<String, Object> filterOIDCClaims(OAuthAuthzReqMessageContext authzReqMessageContext, Map<String, Object> userClaimsInOIDCDialect) throws OAuthSystemException {
        AuthenticatedUser user = authzReqMessageContext.getAuthorizationReqDTO().getUser();
        String clientId = authzReqMessageContext.getAuthorizationReqDTO().getConsumerKey();
        String spTenantDomain = authzReqMessageContext.getAuthorizationReqDTO().getTenantDomain();
        String[] approvedScopes = authzReqMessageContext.getApprovedScope();
        String accessToken = this.getAccessToken(authzReqMessageContext);
        String grantType = "implicit";
        return this.filterOIDCClaims(accessToken, grantType, userClaimsInOIDCDialect, user, approvedScopes, clientId, spTenantDomain);
    }

    private Map<String, Object> retrieveClaimsForLocalUser(OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        try {
            String spTenantDomain = this.getServiceProviderTenantDomain(authzReqMessageContext);
            String clientId = authzReqMessageContext.getAuthorizationReqDTO().getConsumerKey();
            AuthenticatedUser authenticatedUser = authzReqMessageContext.getAuthorizationReqDTO().getUser();
            return this.getUserClaimsInOIDCDialect(spTenantDomain, clientId, authenticatedUser);
        }
        catch (IdentityApplicationManagementException | IdentityException | UserStoreException e) {
            if (!FrameworkUtils.isContinueOnClaimHandlingErrorAllowed()) {
                throw new IdentityOAuth2Exception("Error occurred while getting claims for user " + authzReqMessageContext.getAuthorizationReqDTO().getUser(), e);
            }
            log.error((Object)("Error occurred while getting claims for user " + authzReqMessageContext.getAuthorizationReqDTO().getUser()), e);
            return new HashMap<String, Object>();
        }
    }

    private Map<String, Object> getOIDCClaimMapFromUserAttributes(Map<ClaimMapping, String> userAttributes) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty(userAttributes)) {
            for (Map.Entry<ClaimMapping, String> entry : userAttributes.entrySet()) {
                claims.put(entry.getKey().getRemoteClaim().getClaimUri(), entry.getValue());
            }
        }
        return claims;
    }

    private Map<String, Object> getUserClaimsInOIDCDialect(String spTenantDomain, String clientId, AuthenticatedUser authenticatedUser) throws IdentityApplicationManagementException, IdentityException, UserStoreException {
        String fullQualifiedUsername;
        HashMap<String, Object> userClaimsMappedToOIDCDialect = new HashMap<String, Object>();
        ServiceProvider serviceProvider = this.getServiceProvider(spTenantDomain, clientId);
        if (serviceProvider == null) {
            log.warn((Object)("Unable to find a service provider associated with client_id: " + clientId + " in tenantDomain: " + spTenantDomain + ". Returning empty claim map for user."));
            return userClaimsMappedToOIDCDialect;
        }
        Object[] requestClaimMappings = this.getRequestedClaimMappings(serviceProvider);
        if (ArrayUtils.isEmpty((Object[])requestClaimMappings)) {
            if (log.isDebugEnabled()) {
                String spName = serviceProvider.getApplicationName();
                log.debug((Object)("No requested claims configured for service provider: " + spName + " of tenantDomain: " + spTenantDomain + ". No claims returned for user: " + authenticatedUser));
            }
            return userClaimsMappedToOIDCDialect;
        }
        String userTenantDomain = authenticatedUser.getTenantDomain();
        org.wso2.carbon.user.core.UserRealm realm = IdentityTenantUtil.getRealm((String)userTenantDomain, (String)(fullQualifiedUsername = authenticatedUser.toFullQualifiedUsername()));
        if (realm == null) {
            log.warn((Object)("Invalid tenant domain: " + userTenantDomain + " provided. Cannot get claims for user: " + fullQualifiedUsername));
            return userClaimsMappedToOIDCDialect;
        }
        List<String> requestedClaimUris = this.getRequestedClaimUris((ClaimMapping[])requestClaimMappings);
        Map<String, String> userClaims = this.getUserClaimsInLocalDialect(fullQualifiedUsername, (UserRealm)realm, requestedClaimUris);
        if (MapUtils.isEmpty(userClaims)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No claims found for " + fullQualifiedUsername + " from user store."));
            }
            return userClaimsMappedToOIDCDialect;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of user claims retrieved for " + fullQualifiedUsername + " from user store: " + userClaims.size()));
        }
        this.handleServiceProviderRoleMappings(serviceProvider, ATTRIBUTE_SEPARATOR, userClaims);
        Map<String, Object> userClaimsInOIDCDialect = this.getUserClaimsInOIDCDialect(spTenantDomain, userClaims);
        userClaimsMappedToOIDCDialect.putAll(userClaimsInOIDCDialect);
        return userClaimsMappedToOIDCDialect;
    }

    private ClaimMapping[] getRequestedClaimMappings(ServiceProvider serviceProvider) {
        if (serviceProvider.getClaimConfig() == null) {
            return new ClaimMapping[0];
        }
        return serviceProvider.getClaimConfig().getClaimMappings();
    }

    private Map<String, Object> getUserClaimsInOIDCDialect(String spTenantDomain, Map<String, String> userClaims) throws ClaimMetadataException {
        Map oidcToLocalClaimMappings = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(OIDC_DIALECT, null, spTenantDomain, false);
        return this.getUserClaimsInOidcDialect(oidcToLocalClaimMappings, userClaims);
    }

    private Map<String, String> getUserClaimsInLocalDialect(String username, UserRealm realm, List<String> claimURIList) throws UserStoreException {
        return realm.getUserStoreManager().getUserClaimValues(MultitenantUtils.getTenantAwareUsername((String)username), claimURIList.toArray(new String[claimURIList.size()]), null);
    }

    private void handleServiceProviderRoleMappings(ServiceProvider serviceProvider, String claimSeparator, Map<String, String> userClaims) throws FrameworkException {
        if (MapUtils.isNotEmpty(userClaims) && userClaims.containsKey("http://wso2.org/claims/role")) {
            String roleClaim = userClaims.get("http://wso2.org/claims/role");
            List<String> rolesList = Arrays.asList(roleClaim.split(Pattern.quote(claimSeparator)));
            String spMappedRoleClaim = OIDCClaimUtil.getServiceProviderMappedUserRoles(serviceProvider, rolesList, claimSeparator);
            userClaims.put("http://wso2.org/claims/role", spMappedRoleClaim);
        }
    }

    private String getServiceProviderTenantDomain(OAuthTokenReqMessageContext requestMsgCtx) {
        String spTenantDomain = (String)requestMsgCtx.getProperty("tenantDomain");
        if (spTenantDomain == null) {
            spTenantDomain = requestMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        }
        return spTenantDomain;
    }

    private String getServiceProviderTenantDomain(OAuthAuthzReqMessageContext requestMsgCtx) {
        String spTenantDomain = (String)requestMsgCtx.getProperty("tenantDomain");
        if (spTenantDomain == null) {
            spTenantDomain = requestMsgCtx.getAuthorizationReqDTO().getTenantDomain();
        }
        return spTenantDomain;
    }

    private List<String> getRequestedClaimUris(ClaimMapping[] requestedLocalClaimMap) {
        ArrayList<String> claimURIList = new ArrayList<String>();
        for (ClaimMapping mapping : requestedLocalClaimMap) {
            if (!mapping.isRequested()) continue;
            claimURIList.add(mapping.getLocalClaim().getClaimUri());
        }
        return claimURIList;
    }

    private ServiceProvider getServiceProvider(String spTenantDomain, String clientId) throws IdentityApplicationManagementException {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        String spName = applicationMgtService.getServiceProviderNameByClientId(clientId, OAUTH2, spTenantDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving service provider for clientId: " + clientId + " in tenantDomain: " + spTenantDomain));
        }
        return applicationMgtService.getApplicationExcludingFileBasedSPs(spName, spTenantDomain);
    }

    private Map<String, Object> getUserClaimsInOidcDialect(Map<String, String> oidcToLocalClaimMappings, Map<String, String> userClaims) {
        HashMap<String, Object> userClaimsInOidcDialect = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty(userClaims)) {
            for (Map.Entry<String, String> claimMapping : oidcToLocalClaimMappings.entrySet()) {
                String claimValue = userClaims.get(claimMapping.getValue());
                if (claimValue == null) continue;
                String oidcClaimUri = claimMapping.getKey();
                userClaimsInOidcDialect.put(oidcClaimUri, claimValue);
                if (!log.isDebugEnabled() || !IdentityUtil.isTokenLoggable((String)"UserClaims")) continue;
                log.debug((Object)("Mapped claim: key - " + oidcClaimUri + " value - " + claimValue));
            }
        }
        return userClaimsInOidcDialect;
    }

    private boolean isTokenHasCustomUserClaims(RefreshTokenValidationDataDO refreshTokenValidationDataDO) {
        boolean hasNonOIDCClaims;
        AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(refreshTokenValidationDataDO.getAccessToken());
        AuthorizationGrantCacheEntry cacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByToken(cacheKey);
        boolean bl = hasNonOIDCClaims = cacheEntry != null && cacheEntry.isHasNonOIDCClaims();
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasNonOIDCClaims is set to " + hasNonOIDCClaims + " for the access token of the user : " + refreshTokenValidationDataDO.getAuthorizedUser()));
        }
        return cacheEntry != null && cacheEntry.isHasNonOIDCClaims();
    }

    private Map<ClaimMapping, String> getUserAttributesFromCacheUsingToken(String accessToken) {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieving user attributes cached against access token: " + accessToken));
            } else {
                log.debug((Object)"Retrieving user attributes cached against access token.");
            }
        }
        AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(accessToken);
        AuthorizationGrantCacheEntry cacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByToken(cacheKey);
        return cacheEntry == null ? new HashMap() : cacheEntry.getUserAttributes();
    }

    private Map<ClaimMapping, String> getUserAttributesFromCacheUsingCode(String authorizationCode) {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AuthorizationCode")) {
                log.debug((Object)("Retrieving user attributes cached against authorization code: " + authorizationCode));
            } else {
                log.debug((Object)"Retrieving user attributes cached against authorization code.");
            }
        }
        AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(authorizationCode);
        AuthorizationGrantCacheEntry cacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByCode(cacheKey);
        return cacheEntry == null ? new HashMap() : cacheEntry.getUserAttributes();
    }

    private JWTClaimsSet setClaimsToJwtClaimSet(JWTClaimsSet.Builder jwtClaimsSetBuilder, Map<String, Object> userClaimsInOIDCDialect) {
        JWTClaimsSet jwtClaimsSet = jwtClaimsSetBuilder.build();
        for (Map.Entry<String, Object> claimEntry : userClaimsInOIDCDialect.entrySet()) {
            String claimValue = claimEntry.getValue().toString();
            String claimKey = claimEntry.getKey();
            if (this.isMultiValuedAttribute(claimValue)) {
                String[] attributeValues;
                JSONArray claimValues = new JSONArray();
                for (String attributeValue : attributeValues = claimValue.split(Pattern.quote(ATTRIBUTE_SEPARATOR))) {
                    if (!StringUtils.isNotBlank((String)attributeValue)) continue;
                    claimValues.add((Object)attributeValue);
                }
                if (jwtClaimsSet.getClaim(claimKey) != null) continue;
                jwtClaimsSetBuilder.claim(claimEntry.getKey(), (Object)claimValues);
                continue;
            }
            if (jwtClaimsSet.getClaim(claimKey) != null) continue;
            jwtClaimsSetBuilder.claim(claimEntry.getKey(), claimEntry.getValue());
        }
        return jwtClaimsSetBuilder.build();
    }

    private String getAuthorizationCode(OAuthTokenReqMessageContext requestMsgCtx) {
        return (String)requestMsgCtx.getProperty("AuthorizationCode");
    }

    private String getAccessToken(OAuthTokenReqMessageContext requestMsgCtx) {
        return (String)requestMsgCtx.getProperty("accessToken");
    }

    private String getAccessToken(OAuthAuthzReqMessageContext authzReqMessageContext) {
        return (String)authzReqMessageContext.getProperty("accessToken");
    }

    private boolean isLocalUser(AuthenticatedUser authenticatedUser) {
        return !authenticatedUser.isFederatedUser();
    }

    private boolean isLocalUser(OAuthAuthzReqMessageContext authzReqMessageContext) {
        return !authzReqMessageContext.getAuthorizationReqDTO().getUser().isFederatedUser();
    }

    private boolean isMultiValuedAttribute(String claimValue) {
        return StringUtils.contains((String)claimValue, (String)ATTRIBUTE_SEPARATOR);
    }
}

