/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationMethodNameTranslator;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IDTokenValidationFailureException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;
import org.wso2.carbon.identity.openidconnect.CustomClaimsCallbackHandler;
import org.wso2.carbon.identity.openidconnect.IDTokenBuilder;
import org.wso2.carbon.identity.openidconnect.OIDCClaimUtil;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class DefaultIDTokenBuilder
implements IDTokenBuilder {
    private static final String AUTHORIZATION_CODE = "AuthorizationCode";
    private static final String INBOUND_AUTH2_TYPE = "oauth2";
    private static final Log log = LogFactory.getLog(DefaultIDTokenBuilder.class);
    private JWSAlgorithm signatureAlgorithm = OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(OAuthServerConfiguration.getInstance().getIdTokenSignatureAlgorithm());
    private JWEAlgorithm encryptionAlgorithm;
    private EncryptionMethod encryptionMethod;

    private void setupEncryptionAlgorithms(OAuthAppDO oAuthAppDO, String clientId) throws IdentityOAuth2Exception {
        this.encryptionAlgorithm = OAuth2Util.mapEncryptionAlgorithmForJWEAlgorithm(oAuthAppDO.getIdTokenEncryptionAlgorithm());
        this.encryptionMethod = OAuth2Util.mapEncryptionMethodForJWEAlgorithm(oAuthAppDO.getIdTokenEncryptionMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Id token encryption is enabled using encryption algorithm: " + this.encryptionAlgorithm + " and encryption method: " + this.encryptionMethod + ", for client: " + clientId));
        }
    }

    @Override
    public String buildIDToken(OAuthTokenReqMessageContext tokenReqMsgCtxt, OAuth2AccessTokenRespDTO tokenRespDTO) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        String clientId = tokenReqMsgCtxt.getOauth2AccessTokenReqDTO().getClientId();
        String spTenantDomain = this.getSpTenantDomain(tokenReqMsgCtxt);
        String idTokenIssuer = OAuth2Util.getIdTokenIssuer(spTenantDomain);
        String accessToken = tokenRespDTO.getAccessToken();
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException e) {
            String error = "Error occurred while getting app information for client_id: " + clientId;
            throw new IdentityOAuth2Exception(error, e);
        }
        long idTokenValidityInMillis = this.getIDTokenExpiryInMillis(oAuthAppDO);
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        AuthenticatedUser authorizedUser = tokenReqMsgCtxt.getAuthorizedUser();
        String subjectClaim = this.getSubjectClaim(tokenReqMsgCtxt, tokenRespDTO, clientId, spTenantDomain, authorizedUser);
        String nonceValue = null;
        long authTime = 0L;
        String acrValue = null;
        List<String> amrValues = Collections.emptyList();
        if (this.getAuthorizationCode(tokenReqMsgCtxt) != null) {
            AuthorizationGrantCacheEntry authzGrantCacheEntry = this.getAuthorizationGrantCacheEntryFromCode(this.getAuthorizationCode(tokenReqMsgCtxt));
            if (authzGrantCacheEntry != null) {
                nonceValue = authzGrantCacheEntry.getNonceValue();
                acrValue = authzGrantCacheEntry.getSelectedAcrValue();
                if (this.isAuthTimeRequired(authzGrantCacheEntry)) {
                    authTime = authzGrantCacheEntry.getAuthTime();
                }
                amrValues = authzGrantCacheEntry.getAmrList();
            }
        } else {
            amrValues = tokenReqMsgCtxt.getOauth2AccessTokenReqDTO().getAuthenticationMethodReferences();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.buildDebugMessage(idTokenIssuer, subjectClaim, nonceValue, idTokenValidityInMillis, currentTimeInMillis));
        }
        List<String> audience = OAuth2Util.getOIDCAudience(clientId, oAuthAppDO);
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.issuer(idTokenIssuer);
        jwtClaimsSetBuilder.audience(audience);
        jwtClaimsSetBuilder.claim("azp", (Object)clientId);
        jwtClaimsSetBuilder.expirationTime(this.getIdTokenExpiryInMillis(idTokenValidityInMillis, currentTimeInMillis));
        jwtClaimsSetBuilder.issueTime(new Date(currentTimeInMillis));
        jwtClaimsSetBuilder.notBeforeTime(new Date(currentTimeInMillis));
        if (authTime != 0L) {
            jwtClaimsSetBuilder.claim("auth_time", (Object)(authTime / 1000L));
        }
        if (nonceValue != null) {
            jwtClaimsSetBuilder.claim("nonce", (Object)nonceValue);
        }
        if (StringUtils.isNotEmpty((String)acrValue)) {
            jwtClaimsSetBuilder.claim("acr", (Object)acrValue);
        }
        if (amrValues != null) {
            jwtClaimsSetBuilder.claim("amr", this.translateAmrToResponse(amrValues));
        }
        this.setUserRealm(authorizedUser, jwtClaimsSetBuilder);
        this.setAdditionalClaims(tokenReqMsgCtxt, tokenRespDTO, jwtClaimsSetBuilder);
        tokenReqMsgCtxt.addProperty("accessToken", accessToken);
        tokenReqMsgCtxt.addProperty("tenantDomain", this.getSpTenantDomain(tokenReqMsgCtxt));
        jwtClaimsSetBuilder.subject(subjectClaim);
        JWTClaimsSet jwtClaimsSet = this.handleOIDCCustomClaims(tokenReqMsgCtxt, jwtClaimsSetBuilder);
        if (this.isInvalidToken(jwtClaimsSet)) {
            throw new IDTokenValidationFailureException("Error while validating ID Token token for required claims");
        }
        if (this.isUnsignedIDToken()) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.getIDToken(clientId, spTenantDomain, jwtClaimsSet, oAuthAppDO, this.getSigningTenantDomain(tokenReqMsgCtxt));
    }

    @Override
    public String buildIDToken(OAuthAuthzReqMessageContext authzReqMessageContext, OAuth2AuthorizeRespDTO tokenRespDTO) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        String accessToken = tokenRespDTO.getAccessToken();
        String clientId = authzReqMessageContext.getAuthorizationReqDTO().getConsumerKey();
        String spTenantDomain = this.getSpTenantDomain(authzReqMessageContext);
        String issuer = OAuth2Util.getIdTokenIssuer(spTenantDomain);
        AuthenticatedUser authorizedUser = authzReqMessageContext.getAuthorizationReqDTO().getUser();
        String subject = this.getSubjectClaim(authzReqMessageContext, tokenRespDTO, clientId, spTenantDomain, authorizedUser);
        String nonceValue = authzReqMessageContext.getAuthorizationReqDTO().getNonce();
        String acrValue = authzReqMessageContext.getAuthorizationReqDTO().getSelectedAcr();
        List<String> amrValues = Collections.emptyList();
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException e) {
            String error = "Error occurred while getting app information for client_id: " + clientId;
            throw new IdentityOAuth2Exception(error, e);
        }
        Object[] amrValueArray = (String[])authzReqMessageContext.getAuthorizationReqDTO().getProperty("amr");
        if (ArrayUtils.isNotEmpty((Object[])amrValueArray)) {
            amrValues = Arrays.asList(amrValueArray);
        }
        long idTokenLifeTimeInMillis = this.getIDTokenExpiryInMillis(oAuthAppDO);
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.buildDebugMessage(issuer, subject, nonceValue, idTokenLifeTimeInMillis, currentTimeInMillis));
        }
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.issuer(issuer);
        List<String> audience = OAuth2Util.getOIDCAudience(clientId, oAuthAppDO);
        jwtClaimsSetBuilder.audience(audience);
        jwtClaimsSetBuilder.claim("azp", (Object)clientId);
        jwtClaimsSetBuilder.expirationTime(this.getIdTokenExpiryInMillis(idTokenLifeTimeInMillis, currentTimeInMillis));
        jwtClaimsSetBuilder.issueTime(new Date(currentTimeInMillis));
        long authTime = this.getAuthTime(authzReqMessageContext);
        if (authTime != 0L) {
            jwtClaimsSetBuilder.claim("auth_time", (Object)(authTime / 1000L));
        }
        if (nonceValue != null) {
            jwtClaimsSetBuilder.claim("nonce", (Object)nonceValue);
        }
        if (StringUtils.isNotEmpty((String)acrValue)) {
            jwtClaimsSetBuilder.claim("acr", (Object)acrValue);
        }
        if (amrValues != null) {
            jwtClaimsSetBuilder.claim("amr", this.translateAmrToResponse(amrValues));
        }
        this.setUserRealm(authorizedUser, jwtClaimsSetBuilder);
        this.setAdditionalClaims(authzReqMessageContext, tokenRespDTO, jwtClaimsSetBuilder);
        authzReqMessageContext.addProperty("accessToken", accessToken);
        authzReqMessageContext.addProperty("tenantDomain", this.getSpTenantDomain(authzReqMessageContext));
        jwtClaimsSetBuilder.subject(subject);
        JWTClaimsSet jwtClaimsSet = this.handleCustomOIDCClaims(authzReqMessageContext, jwtClaimsSetBuilder);
        if (this.isUnsignedIDToken()) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.getIDToken(clientId, spTenantDomain, jwtClaimsSet, oAuthAppDO, this.getSigningTenantDomain(authzReqMessageContext));
    }

    private String getIDToken(String clientId, String spTenantDomain, JWTClaimsSet jwtClaimsSet, OAuthAppDO oAuthAppDO, String signingTenantDomain) throws IdentityOAuth2Exception {
        if (oAuthAppDO.isIdTokenEncryptionEnabled()) {
            this.setupEncryptionAlgorithms(oAuthAppDO, clientId);
            return OAuth2Util.encryptJWT(jwtClaimsSet, this.encryptionAlgorithm, this.encryptionMethod, spTenantDomain, clientId).serialize();
        }
        return OAuth2Util.signJWT(jwtClaimsSet, this.signatureAlgorithm, signingTenantDomain).serialize();
    }

    protected String getSubjectClaim(OAuthTokenReqMessageContext tokenReqMessageContext, OAuth2AccessTokenRespDTO tokenRespDTO, String clientId, String spTenantDomain, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String accessToken = tokenRespDTO.getAccessToken();
        String subjectClaim = OIDCClaimUtil.getSubjectClaimCachedAgainstAccessToken(accessToken);
        if (StringUtils.isNotBlank((String)subjectClaim)) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"UserClaims")) {
                    log.debug((Object)("Subject claim cached against the access token found for user: " + authorizedUser));
                } else {
                    log.debug((Object)("Subject claim: " + subjectClaim + " cached against the access token found for user: " + authorizedUser));
                }
            }
            return subjectClaim;
        }
        return this.getSubjectClaim(clientId, spTenantDomain, authorizedUser);
    }

    protected String getSubjectClaim(OAuthAuthzReqMessageContext authzReqMessageContext, OAuth2AuthorizeRespDTO authorizeRespDTO, String clientId, String spTenantDomain, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String accessToken = authorizeRespDTO.getAccessToken();
        String subjectClaim = OIDCClaimUtil.getSubjectClaimCachedAgainstAccessToken(accessToken);
        if (StringUtils.isNotBlank((String)subjectClaim)) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"UserClaims")) {
                    log.debug((Object)("Subject claim cached against the authz code found for user: " + authorizedUser));
                } else {
                    log.debug((Object)("Subject claim: " + subjectClaim + " cached against the authz code found for user: " + authorizedUser));
                }
            }
            return subjectClaim;
        }
        return this.getSubjectClaim(clientId, spTenantDomain, authorizedUser);
    }

    private String getSubjectClaim(String clientId, String spTenantDomain, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String subjectClaim;
        if (this.isLocalUser(authorizedUser)) {
            ServiceProvider serviceProvider = this.getServiceProvider(spTenantDomain, clientId);
            if (serviceProvider == null) {
                throw new IdentityOAuth2Exception("Cannot find an service provider for client_id: " + clientId + " in tenantDomain: " + spTenantDomain);
            }
            subjectClaim = this.getSubjectClaimForLocalUser(serviceProvider, authorizedUser);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subject claim: " + subjectClaim + " set for local user: " + authorizedUser + " for application: " + clientId + " of tenantDomain: " + spTenantDomain));
            }
        } else {
            subjectClaim = authorizedUser.getAuthenticatedSubjectIdentifier();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subject claim: " + subjectClaim + " set for federated user: " + authorizedUser + " for application: " + clientId + " of tenantDomain: " + spTenantDomain));
            }
        }
        return subjectClaim;
    }

    private String buildDebugMessage(String issuer, String subject, String nonceValue, long idTokenLifeTimeInMillis, long currentTimeInMillis) {
        return "Using issuer " + issuer + "\n" + "Subject " + subject + "\n" + "ID Token life time " + idTokenLifeTimeInMillis / 1000L + "\n" + "Current time " + currentTimeInMillis / 1000L + "\n" + "Nonce Value " + nonceValue + "\n" + "Signature Algorithm " + this.signatureAlgorithm + "\n";
    }

    private boolean isInvalidToken(JWTClaimsSet jwtClaimsSet) {
        return !this.isValidIdToken(jwtClaimsSet);
    }

    private boolean isEssentialClaim(AuthorizationGrantCacheEntry authorizationGrantCacheEntry, String oidcClaimUri) {
        return this.isEssentialClaim(authorizationGrantCacheEntry.getEssentialClaims(), oidcClaimUri);
    }

    private boolean isEssentialClaim(String essentialClaims, String oidcClaimUri) {
        return StringUtils.isNotBlank((String)essentialClaims) && OAuth2Util.getEssentialClaims(essentialClaims, "id_token").contains(oidcClaimUri);
    }

    private boolean isMaxAgePresentInAuthzRequest(AuthorizationGrantCacheEntry authorizationGrantCacheEntry) {
        return authorizationGrantCacheEntry.getMaxAge() != 0L;
    }

    private boolean isUnsignedIDToken() {
        return JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName());
    }

    private boolean isIDTokenSigned() {
        return !JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName());
    }

    private String getAuthorizationCode(OAuthTokenReqMessageContext tokenReqMsgCtxt) {
        return (String)tokenReqMsgCtxt.getProperty(AUTHORIZATION_CODE);
    }

    private boolean isLocalUser(AuthenticatedUser authorizedUser) {
        return !authorizedUser.isFederatedUser();
    }

    private String getSpTenantDomain(OAuthTokenReqMessageContext tokReqMsgCtx) {
        return tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
    }

    private JWTClaimsSet handleOIDCCustomClaims(OAuthTokenReqMessageContext tokReqMsgCtx, JWTClaimsSet.Builder jwtClaimsSetBuilder) throws IdentityOAuth2Exception {
        CustomClaimsCallbackHandler claimsCallBackHandler = OAuthServerConfiguration.getInstance().getOpenIDConnectCustomClaimsCallbackHandler();
        return claimsCallBackHandler.handleCustomClaims(jwtClaimsSetBuilder, tokReqMsgCtx);
    }

    private String getSubjectClaimForLocalUser(ServiceProvider serviceProvider, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String subject;
        String username = authorizedUser.getUserName();
        String userStoreDomain = authorizedUser.getUserStoreDomain();
        String userTenantDomain = authorizedUser.getTenantDomain();
        String subjectClaimUri = this.getSubjectClaimUriInLocalDialect(serviceProvider);
        if (StringUtils.isNotBlank((String)subjectClaimUri)) {
            String fullQualifiedUsername = authorizedUser.toFullQualifiedUsername();
            try {
                subject = this.getSubjectClaimFromUserStore(subjectClaimUri, authorizedUser);
                if (StringUtils.isBlank((String)subject)) {
                    subject = username;
                    log.warn((Object)("Cannot find subject claim: " + subjectClaimUri + " for user:" + fullQualifiedUsername + ". Defaulting to username: " + subject + " as the subject identifier."));
                }
                subject = this.getFormattedSubjectClaim(serviceProvider, subject, userStoreDomain, userTenantDomain);
            }
            catch (IdentityException e) {
                String error = "Error occurred while getting user claim for user: " + authorizedUser + ", claim: " + subjectClaimUri;
                throw new IdentityOAuth2Exception(error, e);
            }
            catch (UserStoreException e) {
                String error = "Error occurred while getting subject claim: " + subjectClaimUri + " for user: " + fullQualifiedUsername;
                throw new IdentityOAuth2Exception(error, e);
            }
        } else {
            subject = this.getFormattedSubjectClaim(serviceProvider, username, userStoreDomain, userTenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No subject claim defined for service provider: " + serviceProvider.getApplicationName() + ". Using username as the subject claim."));
            }
        }
        return subject;
    }

    private String getSubjectClaimFromUserStore(String subjectClaimUri, AuthenticatedUser authenticatedUser) throws UserStoreException, IdentityException {
        UserStoreManager userStoreManager = IdentityTenantUtil.getRealm((String)authenticatedUser.getTenantDomain(), (String)authenticatedUser.toFullQualifiedUsername()).getUserStoreManager();
        return userStoreManager.getSecondaryUserStoreManager(authenticatedUser.getUserStoreDomain()).getUserClaimValue(authenticatedUser.getUserName(), subjectClaimUri, null);
    }

    private String getSubjectClaimUriInLocalDialect(ServiceProvider serviceProvider) {
        String subjectClaimUri = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSubjectClaimUri();
        if (log.isDebugEnabled()) {
            if (StringUtils.isNotBlank((String)subjectClaimUri)) {
                log.debug((Object)(subjectClaimUri + " is defined as subject claim for service provider: " + serviceProvider.getApplicationName()));
            } else {
                log.debug((Object)("No subject claim defined for service provider: " + serviceProvider.getApplicationName()));
            }
        }
        return this.getSubjectClaimUriInLocalDialect(serviceProvider, subjectClaimUri);
    }

    private String getFormattedSubjectClaim(ServiceProvider serviceProvider, String subjectClaimValue, String userStoreDomain, String tenantDomain) {
        boolean appendUserStoreDomainToSubjectClaim = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
        boolean appendTenantDomainToSubjectClaim = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseTenantDomainInLocalSubjectIdentifier();
        if (appendTenantDomainToSubjectClaim) {
            subjectClaimValue = UserCoreUtil.addTenantDomainToEntry((String)subjectClaimValue, (String)tenantDomain);
        }
        if (appendUserStoreDomainToSubjectClaim) {
            subjectClaimValue = IdentityUtil.addDomainToName((String)subjectClaimValue, (String)userStoreDomain);
        }
        return subjectClaimValue;
    }

    private String getSigningTenantDomain(OAuthTokenReqMessageContext tokReqMsgCtx) {
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        if (isJWTSignedWithSPKey) {
            return (String)tokReqMsgCtx.getProperty("tenantDomain");
        }
        return tokReqMsgCtx.getAuthorizedUser().getTenantDomain();
    }

    private String getSubjectClaimUriInLocalDialect(ServiceProvider serviceProvider, String subjectClaimUri) {
        ClaimConfig claimConfig;
        if (StringUtils.isNotBlank((String)subjectClaimUri) && (claimConfig = serviceProvider.getClaimConfig()) != null) {
            boolean isLocalClaimDialect = claimConfig.isLocalClaimDialect();
            Object[] claimMappings = claimConfig.getClaimMappings();
            if (!isLocalClaimDialect && ArrayUtils.isNotEmpty((Object[])claimMappings)) {
                for (Object claimMapping : claimMappings) {
                    if (!StringUtils.equals((String)claimMapping.getRemoteClaim().getClaimUri(), (String)subjectClaimUri)) continue;
                    return claimMapping.getLocalClaim().getClaimUri();
                }
            }
        }
        return subjectClaimUri;
    }

    private ServiceProvider getServiceProvider(String spTenantDomain, String clientId) throws IdentityOAuth2Exception {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        try {
            String spName = applicationMgtService.getServiceProviderNameByClientId(clientId, INBOUND_AUTH2_TYPE, spTenantDomain);
            return applicationMgtService.getApplicationExcludingFileBasedSPs(spName, spTenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error while getting service provider information for client_id: " + clientId + " tenantDomain: " + spTenantDomain, e);
        }
    }

    private long getAuthTime(OAuthAuthzReqMessageContext authzReqMessageContext) {
        long authTime = 0L;
        if (this.isAuthTimeRequired(authzReqMessageContext.getAuthorizationReqDTO())) {
            authTime = authzReqMessageContext.getAuthorizationReqDTO().getAuthTime();
        }
        return authTime;
    }

    private boolean isAuthTimeRequired(AuthorizationGrantCacheEntry authzGrantCacheEntry) {
        return this.isMaxAgePresentInAuthzRequest(authzGrantCacheEntry) || this.isEssentialClaim(authzGrantCacheEntry, "auth_time");
    }

    private boolean isAuthTimeRequired(OAuth2AuthorizeReqDTO oAuth2AuthorizeReqDTO) {
        return oAuth2AuthorizeReqDTO.getMaxAge() != 0L || this.isEssentialClaim(oAuth2AuthorizeReqDTO.getEssentialClaims(), "auth_time");
    }

    private boolean isAccessTokenHashApplicable(String responseType) {
        return !"id_token".equalsIgnoreCase(responseType) && !"none".equalsIgnoreCase(responseType);
    }

    private Date getIdTokenExpiryInMillis(long currentTimeInMillis, long lifetimeInMillis) {
        return new Date(currentTimeInMillis + lifetimeInMillis);
    }

    private JWTClaimsSet handleCustomOIDCClaims(OAuthAuthzReqMessageContext request, JWTClaimsSet.Builder jwtClaimsSetBuilder) throws IdentityOAuth2Exception {
        CustomClaimsCallbackHandler claimsCallBackHandler = OAuthServerConfiguration.getInstance().getOpenIDConnectCustomClaimsCallbackHandler();
        return claimsCallBackHandler.handleCustomClaims(jwtClaimsSetBuilder, request);
    }

    private String getSpTenantDomain(OAuthAuthzReqMessageContext request) {
        return request.getAuthorizationReqDTO().getTenantDomain();
    }

    private String getSigningTenantDomain(OAuthAuthzReqMessageContext request) {
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        String signingTenantDomain = isJWTSignedWithSPKey ? (String)request.getProperty("tenantDomain") : request.getAuthorizationReqDTO().getUser().getTenantDomain();
        return signingTenantDomain;
    }

    @Deprecated
    protected String signJWTWithRSA(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        String tenantDomain = this.getSigningTenantDomain(tokenReqMessageContext);
        return OAuth2Util.signJWTWithRSA(jwtClaimsSet, this.signatureAlgorithm, tenantDomain).serialize();
    }

    @Deprecated
    protected String signJWTWithRSA(JWTClaimsSet jwtClaimsSet, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        String signingTenantDomain = this.getSigningTenantDomain(authzReqMessageContext);
        return OAuth2Util.signJWTWithRSA(jwtClaimsSet, this.signatureAlgorithm, signingTenantDomain).serialize();
    }

    private AuthorizationGrantCacheEntry getAuthorizationGrantCacheEntryFromCode(String authorizationCode) {
        AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(authorizationCode);
        return AuthorizationGrantCache.getInstance().getValueFromCacheByCode(authorizationGrantCacheKey);
    }

    @Deprecated
    protected String signJWT(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenMsgContext) throws IdentityOAuth2Exception {
        if (this.isRSA(this.signatureAlgorithm)) {
            return this.signJWTWithRSA(jwtClaimsSet, tokenMsgContext);
        }
        if (this.isHMAC(this.signatureAlgorithm)) {
            return null;
        }
        return null;
    }

    private boolean isRSA(JWSAlgorithm signatureAlgorithm) {
        return JWSAlgorithm.RS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)signatureAlgorithm);
    }

    @Deprecated
    protected String signJWT(JWTClaimsSet jwtClaimsSet, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        if (this.isRSA(this.signatureAlgorithm)) {
            return this.signJWTWithRSA(jwtClaimsSet, authzReqMessageContext);
        }
        if (this.isHMAC(this.signatureAlgorithm)) {
            return null;
        }
        return null;
    }

    private boolean isHMAC(JWSAlgorithm signatureAlgorithm) {
        return JWSAlgorithm.HS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)signatureAlgorithm);
    }

    @Deprecated
    protected JWSAlgorithm mapSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        return OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(signatureAlgorithm);
    }

    @Deprecated
    protected String mapDigestAlgorithm(Algorithm signatureAlgorithm) throws IdentityOAuth2Exception {
        return OAuth2Util.mapDigestAlgorithm(signatureAlgorithm);
    }

    private boolean isValidIdToken(JWTClaimsSet jwtClaimsSet) {
        if (StringUtils.isBlank((String)jwtClaimsSet.getIssuer())) {
            log.error((Object)"ID token does not have required issuer claim");
            return false;
        }
        if (StringUtils.isBlank((String)jwtClaimsSet.getSubject())) {
            log.error((Object)"ID token does not have required subject claim");
            return false;
        }
        if (jwtClaimsSet.getAudience() == null) {
            log.error((Object)"ID token does not have required audience claim");
            return false;
        }
        if (jwtClaimsSet.getExpirationTime() == null) {
            log.error((Object)"ID token does not have required expiration time claim");
            return false;
        }
        if (jwtClaimsSet.getIssueTime() == null) {
            log.error((Object)"ID token does not have required issued time claim");
            return false;
        }
        return true;
    }

    private long getIDTokenExpiryInMillis(OAuthAppDO oAuthAppDO) {
        return oAuthAppDO.getIdTokenExpiryTime() * 1000L;
    }

    private void setAdditionalClaims(OAuthTokenReqMessageContext tokenReqMsgCtxt, OAuth2AccessTokenRespDTO tokenRespDTO, JWTClaimsSet.Builder jwtClaimsSetBuilder) throws IdentityOAuth2Exception {
        List<ClaimProvider> claimProviders = this.getClaimProviders();
        if (CollectionUtils.isNotEmpty(claimProviders)) {
            for (ClaimProvider claimProvider : claimProviders) {
                Map<String, Object> additionalIdTokenClaims = claimProvider.getAdditionalClaims(tokenReqMsgCtxt, tokenRespDTO);
                this.setAdditionalClaimSet(jwtClaimsSetBuilder, additionalIdTokenClaims);
            }
        }
    }

    private void setAdditionalClaims(OAuthAuthzReqMessageContext authzReqMessageContext, OAuth2AuthorizeRespDTO authorizeRespDTO, JWTClaimsSet.Builder jwtClaimsSetBuilder) throws IdentityOAuth2Exception {
        List<ClaimProvider> claimProviders = this.getClaimProviders();
        if (CollectionUtils.isNotEmpty(claimProviders)) {
            for (ClaimProvider claimProvider : claimProviders) {
                Map<String, Object> additionalIdTokenClaims = claimProvider.getAdditionalClaims(authzReqMessageContext, authorizeRespDTO);
                this.setAdditionalClaimSet(jwtClaimsSetBuilder, additionalIdTokenClaims);
            }
        }
    }

    private List<ClaimProvider> getClaimProviders() {
        return OpenIDConnectServiceComponentHolder.getInstance().getClaimProviders();
    }

    private void setAdditionalClaimSet(JWTClaimsSet.Builder jwtClaimsSetBuilder, Map<String, Object> additionalIdTokenClaims) {
        for (Map.Entry<String, Object> entry : additionalIdTokenClaims.entrySet()) {
            jwtClaimsSetBuilder.claim(entry.getKey(), entry.getValue());
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<String, Object> entry : additionalIdTokenClaims.entrySet()) {
                log.debug((Object)("Additional claim added to JWTClaimSet, key: " + entry.getKey() + ", value: " + entry.getValue()));
            }
        }
    }

    private List<String> translateAmrToResponse(List<String> internalList) {
        HashSet<String> result = new HashSet<String>();
        for (String internalValue : internalList) {
            result.addAll(this.translateToResponse(internalValue));
        }
        return new ArrayList<String>(result);
    }

    private List<String> translateToResponse(String internalValue) {
        ArrayList<String> result = Collections.EMPTY_LIST;
        AuthenticationMethodNameTranslator authenticationMethodNameTranslator = OAuth2ServiceComponentHolder.getAuthenticationMethodNameTranslator();
        if (authenticationMethodNameTranslator != null) {
            Set externalAmrSet = authenticationMethodNameTranslator.translateToExternalAmr(internalValue, INBOUND_AUTH2_TYPE);
            if (externalAmrSet == null || externalAmrSet.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("There was no mapping found to translate AMR from internal to external URI. Internal Method Reference : " + internalValue));
                }
                result = new ArrayList<String>();
                result.add(internalValue);
            } else {
                result = new ArrayList(externalAmrSet);
            }
        }
        return result;
    }

    private void setUserRealm(AuthenticatedUser authorizedUser, JWTClaimsSet.Builder jwtClaimsSetBuilder) {
        String tenantDomain = authorizedUser.getTenantDomain();
        String userstoreDomain = authorizedUser.getUserStoreDomain();
        HashMap<String, String> realm = new HashMap<String, String>();
        if (OAuthServerConfiguration.getInstance().isAddTenantDomainToIdTokenEnabled() && StringUtils.isNotBlank((String)tenantDomain)) {
            realm.put("tenant", tenantDomain);
        }
        if (OAuthServerConfiguration.getInstance().isAddUserstoreDomainToIdTokenEnabled() && StringUtils.isNotBlank((String)userstoreDomain)) {
            realm.put("userstore", userstoreDomain);
        }
        if (realm.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting authorized user tenant domain : " + tenantDomain + " and userstore domain : " + userstoreDomain + " to the 'realm' claim of id_token for the user : " + authorizedUser.getUserName()));
            }
            jwtClaimsSetBuilder.claim("realm", realm);
        }
    }
}

