/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.user.UserInfoEndpointException;
import org.wso2.carbon.identity.oauth.user.UserInfoResponseBuilder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.OIDCClaimUtil;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public abstract class AbstractUserInfoResponseBuilder
implements UserInfoResponseBuilder {
    private static final Log log = LogFactory.getLog(AbstractUserInfoResponseBuilder.class);

    @Override
    public String getResponseString(OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException, OAuthSystemException {
        String clientId = this.getClientId(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        String spTenantDomain = this.getServiceProviderTenantDomain(tokenResponse);
        Map<String, Object> userClaims = this.retrieveUserClaims(tokenResponse);
        Map<String, Object> filteredUserClaims = this.filterOIDCClaims(tokenResponse, clientId, spTenantDomain, userClaims);
        String subjectClaim = this.getSubjectClaim(userClaims, clientId, spTenantDomain, tokenResponse);
        filteredUserClaims.put("sub", subjectClaim);
        return this.buildResponse(tokenResponse, spTenantDomain, filteredUserClaims);
    }

    private Map<String, Object> filterOIDCClaims(OAuth2TokenValidationResponseDTO tokenResponse, String clientId, String spTenantDomain, Map<String, Object> userClaims) throws OAuthSystemException, UserInfoEndpointException {
        if (MapUtils.isEmpty(userClaims)) {
            if (log.isDebugEnabled()) {
                AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
                log.debug((Object)("No user claims available to be filtered for user: " + authenticatedUser.toFullQualifiedUsername() + " for client_id: " + clientId + " of tenantDomain: " + spTenantDomain));
            }
            return new HashMap<String, Object>();
        }
        Map<String, Object> userClaimsFilteredByScope = this.getUserClaimsFilteredByScope(tokenResponse, userClaims, tokenResponse.getScope(), clientId, spTenantDomain);
        Map<String, Object> essentialClaims = this.getEssentialClaims(tokenResponse, userClaims);
        userClaimsFilteredByScope.putAll(essentialClaims);
        Map<String, Object> filteredClaimsFromRequestObject = this.filterClaimsFromRequestObject(userClaims, OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        userClaimsFilteredByScope.putAll(filteredClaimsFromRequestObject);
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        return this.getUserClaimsFilteredByConsent(tokenResponse, userClaimsFilteredByScope, authenticatedUser, clientId, spTenantDomain);
    }

    private String getGrantType(OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException {
        try {
            return OAuth2Util.getAccessTokenDOfromTokenIdentifier(OAuth2Util.getAccessTokenIdentifier(tokenResponse)).getGrantType();
        }
        catch (IdentityOAuth2Exception e) {
            throw new UserInfoEndpointException("Error while retrieving access token information to derive the grant type.", (Throwable)((Object)e));
        }
    }

    private Map<String, Object> filterClaimsFromRequestObject(Map<String, Object> userAttributes, String token) throws OAuthSystemException {
        try {
            List<RequestedClaim> requestedClaims = OpenIDConnectServiceComponentHolder.getRequestObjectService().getRequestedClaimsForUserInfo(token);
            return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByEssentialClaims(userAttributes, requestedClaims);
        }
        catch (RequestObjectException e) {
            throw new OAuthSystemException("Unable to retrieve requested claims from Request Object." + (Object)((Object)e));
        }
    }

    protected String getSubjectClaim(Map<String, Object> userClaims, String clientId, String spTenantDomain, OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException, OAuthSystemException {
        String subjectClaim = OIDCClaimUtil.getSubjectClaimCachedAgainstAccessToken(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        if (StringUtils.isNotBlank((String)subjectClaim)) {
            return subjectClaim;
        }
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        subjectClaim = (String)userClaims.get("sub");
        if (StringUtils.isBlank((String)subjectClaim)) {
            subjectClaim = authenticatedUser.isFederatedUser() ? authenticatedUser.getAuthenticatedSubjectIdentifier() : authenticatedUser.getUserName();
        }
        if (this.isLocalUser(authenticatedUser)) {
            subjectClaim = this.buildSubjectClaim(subjectClaim, authenticatedUser.getTenantDomain(), authenticatedUser.getUserStoreDomain(), clientId, spTenantDomain);
        }
        return subjectClaim;
    }

    protected Map<String, Object> getUserClaimsFilteredByScope(OAuth2TokenValidationResponseDTO validationResponseDTO, Map<String, Object> userClaims, String[] requestedScopes, String clientId, String tenantDomain) throws UserInfoEndpointException {
        return OpenIDConnectServiceComponentHolder.getInstance().getHighestPriorityOpenIDConnectClaimFilter().getClaimsFilteredByOIDCScopes(userClaims, requestedScopes, clientId, tenantDomain);
    }

    protected Map<String, Object> getUserClaimsFilteredByConsent(OAuth2TokenValidationResponseDTO validationResponseDTO, Map<String, Object> userClaims, AuthenticatedUser user, String clientId, String tenantDomain) throws UserInfoEndpointException {
        String grantType = this.getGrantType(validationResponseDTO);
        return OIDCClaimUtil.filterUserClaimsBasedOnConsent(userClaims, user, clientId, tenantDomain, grantType, this.getServiceProvider(tenantDomain, clientId));
    }

    protected Map<String, Object> getEssentialClaims(OAuth2TokenValidationResponseDTO tokenResponse, Map<String, Object> claims) throws UserInfoEndpointException {
        HashMap<String, Object> essentialClaimMap = new HashMap<String, Object>();
        List<String> essentialClaims = this.getEssentialClaimUris(tokenResponse);
        if (CollectionUtils.isNotEmpty(essentialClaims)) {
            for (String key : essentialClaims) {
                essentialClaimMap.put(key, claims.get(key));
            }
        }
        return essentialClaimMap;
    }

    protected abstract Map<String, Object> retrieveUserClaims(OAuth2TokenValidationResponseDTO var1) throws UserInfoEndpointException;

    protected abstract String buildResponse(OAuth2TokenValidationResponseDTO var1, String var2, Map<String, Object> var3) throws UserInfoEndpointException;

    private AuthenticatedUser getAuthenticatedUser(String accessToken) throws OAuthSystemException {
        try {
            AccessTokenDO accessTokenDO = OAuth2Util.getAccessTokenDOfromTokenIdentifier(accessToken);
            return OAuth2Util.getAuthenticatedUser(accessTokenDO);
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException();
        }
    }

    private String getServiceProviderTenantDomain(OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException {
        OAuthAppDO oAuthAppDO;
        String clientId = null;
        try {
            clientId = this.getClientId(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            throw new UserInfoEndpointException("Error while retrieving OAuth app information for clientId: " + clientId);
        }
        return OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO);
    }

    private String buildSubjectClaim(String sub, String userTenantDomain, String userStoreDomain, String clientId, String spTenantDomain) throws UserInfoEndpointException {
        ServiceProvider serviceProvider = this.getServiceProvider(spTenantDomain, clientId);
        if (serviceProvider != null) {
            boolean isUseTenantDomainInLocalSubject = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseTenantDomainInLocalSubjectIdentifier();
            boolean isUseUserStoreDomainInLocalSubject = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
            if (StringUtils.isNotEmpty((String)sub)) {
                if (isUseUserStoreDomainInLocalSubject) {
                    sub = IdentityUtil.addDomainToName((String)sub, (String)userStoreDomain);
                }
                if (isUseTenantDomainInLocalSubject) {
                    sub = UserCoreUtil.addTenantDomainToEntry((String)sub, (String)userTenantDomain);
                }
            }
        }
        return sub;
    }

    private String getClientId(String accessToken) throws UserInfoEndpointException {
        try {
            return OAuth2Util.getClientIdForAccessToken(accessToken);
        }
        catch (IdentityOAuth2Exception e) {
            throw new UserInfoEndpointException("Error while obtaining the client_id from accessToken.", (Throwable)((Object)e));
        }
    }

    private ServiceProvider getServiceProvider(String tenantDomain, String clientId) throws UserInfoEndpointException {
        ServiceProvider serviceProvider;
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        try {
            serviceProvider = applicationMgtService.getServiceProviderByClientId(clientId, "oauth2", tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new UserInfoEndpointException("Error while obtaining the service provider for client_id: " + clientId + " of tenantDomain: " + tenantDomain, e);
        }
        return serviceProvider;
    }

    private List<String> getEssentialClaimUris(OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException {
        AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(OAuth2Util.getAccessTokenIdentifier(tokenResponse));
        AuthorizationGrantCacheEntry cacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByToken(cacheKey);
        if (cacheEntry != null && StringUtils.isNotEmpty((String)cacheEntry.getEssentialClaims())) {
            return OAuth2Util.getEssentialClaims(cacheEntry.getEssentialClaims(), "userinfo");
        }
        return new ArrayList<String>();
    }

    private boolean isLocalUser(AuthenticatedUser authenticatedUser) {
        return !authenticatedUser.isFederatedUser();
    }
}

