/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators.jwt;

import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.cache.JWKSCache;
import org.wso2.carbon.identity.oauth2.cache.JWKSCacheEntry;
import org.wso2.carbon.identity.oauth2.cache.JWKSCacheKey;

public class JWKSourceDataProvider {
    private static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 1000;
    private static final int DEFAULT_HTTP_READ_TIMEOUT = 1000;
    private static final String HTTP_CONNECTION_TIMEOUT_XPATH = "JWTValidatorConfigs.JWKSEndpoint.HTTPConnectionTimeout";
    private static final String HTTP_READ_TIMEOUT_XPATH = "JWTValidatorConfigs.JWKSEndpoint.HTTPReadTimeout";
    private static final String HTTP_SIZE_LIMIT_XPATH = "JWTValidatorConfigs.JWKSEndpoint.HTTPSizeLimit";
    private static final Log log = LogFactory.getLog(JWKSourceDataProvider.class);
    private static JWKSourceDataProvider jwkSourceDataProvider = new JWKSourceDataProvider();

    private JWKSourceDataProvider() {
    }

    public static JWKSourceDataProvider getInstance() {
        return jwkSourceDataProvider;
    }

    public RemoteJWKSet<SecurityContext> getJWKSource(String jwksUri) throws MalformedURLException {
        JWKSCacheKey jwksCacheKey = new JWKSCacheKey(jwksUri);
        JWKSCacheEntry jwksCacheEntry = (JWKSCacheEntry)((Object)JWKSCache.getInstance().getValueFromCache(jwksCacheKey));
        RemoteJWKSet<SecurityContext> jwkSet = null;
        if (jwksCacheEntry != null) {
            jwkSet = jwksCacheEntry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving JWKS for " + jwksUri + " from cache."));
            }
        }
        if (jwkSet == null) {
            jwkSet = this.retrieveJWKSFromJWKSEndpoint(jwksUri);
            JWKSCache.getInstance().addToCache(jwksCacheKey, (Serializable)((Object)new JWKSCacheEntry(jwkSet)));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fetching JWKS from remote endpoint.");
            }
        }
        return jwkSet;
    }

    public void refreshJWKSResource(String jwksUri) throws IdentityOAuth2Exception {
        try {
            JWKSCacheKey jwksCacheKey = new JWKSCacheKey(jwksUri);
            JWKSCache.getInstance().clearCacheEntry(jwksCacheKey);
            RemoteJWKSet<SecurityContext> jwkSet = this.retrieveJWKSFromJWKSEndpoint(jwksUri);
            JWKSCache.getInstance().addToCache(jwksCacheKey, (Serializable)((Object)new JWKSCacheEntry(jwkSet)));
        }
        catch (MalformedURLException e) {
            throw new IdentityOAuth2Exception("Provided URI is malformed. jwks_uri: " + jwksUri, e);
        }
    }

    private RemoteJWKSet<SecurityContext> retrieveJWKSFromJWKSEndpoint(String jwksUri) throws MalformedURLException {
        int connectionTimeout = this.readHTTPConnectionConfigValue(HTTP_CONNECTION_TIMEOUT_XPATH);
        int readTimeout = this.readHTTPConnectionConfigValue(HTTP_READ_TIMEOUT_XPATH);
        int sizeLimit = this.readHTTPConnectionConfigValue(HTTP_SIZE_LIMIT_XPATH);
        if (connectionTimeout <= 0) {
            connectionTimeout = 1000;
        }
        if (readTimeout <= 0) {
            readTimeout = 1000;
        }
        if (sizeLimit <= 0) {
            sizeLimit = 51200;
        }
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(connectionTimeout, readTimeout, sizeLimit);
        return new RemoteJWKSet(new URL(jwksUri), (ResourceRetriever)resourceRetriever);
    }

    private int readHTTPConnectionConfigValue(String xPath) {
        int configValue = 0;
        String config = IdentityUtil.getProperty((String)xPath);
        if (StringUtils.isNotBlank((String)config)) {
            try {
                configValue = Integer.parseInt(config);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Provided HTTP connection config value in " + xPath + " should be an integer type. Value : " + config));
            }
        }
        return configValue;
    }
}

