/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SimpleSecurityContext;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertUtils;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.net.MalformedURLException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.validators.jwt.JWKSourceDataProvider;
import org.wso2.carbon.identity.oauth2.validators.jwt.JWTValidator;

public class JWKSBasedJWTValidator
implements JWTValidator {
    private static final Log log = LogFactory.getLog(JWKSBasedJWTValidator.class);
    private ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor();
    private static final String ENFORCE_CERTIFICATE_VALIDITY = "JWTValidatorConfigs.EnforceCertificateExpiryTimeValidity";

    @Override
    public boolean validateSignature(String jwtString, String jwksUri, String algorithm, Map<String, Object> opts) throws IdentityOAuth2Exception {
        try {
            JWT jwt = JWTParser.parse((String)jwtString);
            this.checkCertificateValidity(jwksUri, (SignedJWT)jwt);
            return this.validateSignature(jwt, jwksUri, algorithm, opts);
        }
        catch (ParseException e) {
            throw new IdentityOAuth2Exception("Error occurred while parsing JWT string.", e);
        }
        catch (BadJOSEException e) {
            throw new IdentityOAuth2Exception("Signature validation failed for the provided JWT.", e);
        }
        catch (MalformedURLException e) {
            throw new IdentityOAuth2Exception("Provided jwks_uri: " + jwksUri + " is malformed.", e);
        }
        catch (KeySourceException e) {
            throw new IdentityOAuth2Exception("Error occurred while accessing remote JWKS endpoint: " + jwksUri, e);
        }
        catch (CertificateNotYetValidException e) {
            throw new IdentityOAuth2Exception("X509Certificate is not yet valid.", e);
        }
        catch (CertificateExpiredException e) {
            throw new IdentityOAuth2Exception("X509Certificate has expired.", e);
        }
    }

    private void checkCertificateValidity(String jwksUri, SignedJWT jwt) throws MalformedURLException, CertificateNotYetValidException, CertificateExpiredException, KeySourceException, BadJOSEException {
        String isEnforceCertificateValidity = IdentityUtil.getProperty((String)ENFORCE_CERTIFICATE_VALIDITY);
        if (StringUtils.isNotEmpty((String)isEnforceCertificateValidity) && !Boolean.parseBoolean(isEnforceCertificateValidity)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check for the certificate validity is disabled.");
            }
            return;
        }
        X509Certificate x509Certificate = null;
        RemoteJWKSet<SecurityContext> remoteJWKSet = JWKSourceDataProvider.getInstance().getJWKSource(jwksUri);
        String kid = Optional.ofNullable(jwt.getHeader()).map(rec$ -> ((JWSHeader)rec$).getKeyID()).orElse(null);
        if (kid == null) {
            throw new BadJOSEException("Value of the \"kid\" property in JWS header is null.");
        }
        if (remoteJWKSet != null) {
            List matchingJWKs = remoteJWKSet.get(new JWKSelector(new JWKMatcher.Builder().keyID(kid).build()), null);
            if (CollectionUtils.isNotEmpty((Collection)matchingJWKs)) {
                JWK key;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matching key found in JWKS endpoint: " + jwksUri));
                }
                if (CollectionUtils.isNotEmpty((Collection)(key = (JWK)matchingJWKs.get(0)).getX509CertChain())) {
                    x509Certificate = X509CertUtils.parse((byte[])((Base64)key.getX509CertChain().get(0)).decode());
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("x5c parameter is undefined in JWK having the kid: " + kid));
                }
            } else {
                throw new KeySourceException("No matching keys found in JWKS endpoint: " + jwksUri);
            }
            if (x509Certificate != null) {
                x509Certificate.checkValidity();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"X509Certificate is null. Hence, certificate expiry date validation is skipped.");
            }
        } else {
            throw new KeySourceException("Remote JWK set not found in the JWKS endpoint: " + jwksUri);
        }
    }

    @Override
    public boolean validateSignature(JWT jwt, String jwksUri, String algorithm, Map<String, Object> opts) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("validating JWT signature using jwks_uri: " + jwksUri + " , for signing algorithm: " + algorithm));
        }
        try {
            this.setJWKeySelector(jwksUri, algorithm);
            SimpleSecurityContext securityContext = null;
            if (MapUtils.isNotEmpty(opts)) {
                securityContext = new SimpleSecurityContext();
                securityContext.putAll(opts);
            }
            if (jwt instanceof PlainJWT) {
                this.jwtProcessor.process((PlainJWT)jwt, (SecurityContext)securityContext);
            } else if (jwt instanceof SignedJWT) {
                this.jwtProcessor.process((SignedJWT)jwt, (SecurityContext)securityContext);
            } else if (jwt instanceof EncryptedJWT) {
                this.jwtProcessor.process((EncryptedJWT)jwt, (SecurityContext)securityContext);
            } else {
                this.jwtProcessor.process(jwt, (SecurityContext)securityContext);
            }
            return true;
        }
        catch (MalformedURLException e) {
            throw new IdentityOAuth2Exception("Provided jwks_uri is malformed.", e);
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Signature validation failed for the provided JWT.", e);
        }
        catch (BadJOSEException e) {
            throw new IdentityOAuth2Exception("Signature validation failed for the provided JWT", e);
        }
    }

    private void setJWKeySelector(String jwksUri, String algorithm) throws MalformedURLException {
        RemoteJWKSet<SecurityContext> keySource = JWKSourceDataProvider.getInstance().getJWKSource(jwksUri);
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.parse((String)algorithm);
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, keySource);
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
    }
}

