/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authcontext.AuthorizationContextTokenGenerator;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientApplicationDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.DefaultOAuth2TokenValidator;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidator;
import org.wso2.carbon.identity.oauth2.validators.RefreshTokenValidator;

public class TokenValidationHandler {
    private static TokenValidationHandler instance = null;
    AuthorizationContextTokenGenerator tokenGenerator = null;
    private static final Log log = LogFactory.getLog(TokenValidationHandler.class);
    private Map<String, OAuth2TokenValidator> tokenValidators = new TreeMap<String, OAuth2TokenValidator>(String.CASE_INSENSITIVE_ORDER);
    private static final String BEARER_TOKEN_TYPE = "Bearer";
    private static final String BEARER_TOKEN_TYPE_JWT = "jwt";
    private static final String BUILD_FQU_FROM_SP_CONFIG = "OAuth.BuildSubjectIdentifierFromSPConfig";
    private static final String ENABLE_JWT_TOKEN_VALIDATION = "OAuth.EnableJWTTokenValidationDuringIntrospection";

    private TokenValidationHandler() {
        this.tokenValidators.put("bearer", new DefaultOAuth2TokenValidator());
        this.tokenValidators.put("refresh_token", new RefreshTokenValidator());
        for (Map.Entry<String, String> entry : OAuthServerConfiguration.getInstance().getTokenValidatorClassNames().entrySet()) {
            String className = null;
            try {
                String type = entry.getKey();
                className = entry.getValue();
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(entry.getValue());
                OAuth2TokenValidator tokenValidator = (OAuth2TokenValidator)clazz.newInstance();
                this.tokenValidators.put(type, tokenValidator);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Class not in build path " + className), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)("Class initialization error " + className), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Class access error " + className), (Throwable)e);
            }
        }
        if (OAuthServerConfiguration.getInstance().isAuthContextTokGenEnabled()) {
            String errorMsg;
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass());
                this.tokenGenerator = (AuthorizationContextTokenGenerator)clazz.newInstance();
                this.tokenGenerator.init();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An instance of " + OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass() + " is created for OAuthServerConfiguration."));
                }
            }
            catch (ClassNotFoundException e) {
                errorMsg = "Class not found: " + OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass();
                log.error((Object)errorMsg, (Throwable)e);
            }
            catch (InstantiationException e) {
                errorMsg = "Error while instantiating: " + OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass();
                log.error((Object)errorMsg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                errorMsg = "Illegal access to: " + OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass();
                log.error((Object)errorMsg, (Throwable)e);
            }
            catch (IdentityOAuth2Exception e) {
                errorMsg = "Error while initializing: " + OAuthServerConfiguration.getInstance().getTokenGeneratorImplClass();
                log.error((Object)errorMsg, (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenValidationHandler getInstance() {
        if (instance != null) return instance;
        Class<TokenValidationHandler> clazz = TokenValidationHandler.class;
        synchronized (TokenValidationHandler.class) {
            if (instance != null) return instance;
            instance = new TokenValidationHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addTokenValidator(String type, OAuth2TokenValidator handler) {
        this.tokenValidators.put(type, handler);
    }

    public OAuth2TokenValidationResponseDTO validate(OAuth2TokenValidationRequestDTO requestDTO) throws IdentityOAuth2Exception {
        OAuth2ClientApplicationDTO appToken = this.findOAuthConsumerIfTokenIsValid(requestDTO);
        return appToken.getAccessTokenValidationResponse();
    }

    @Deprecated
    public OAuth2ClientApplicationDTO findOAuthConsumerIfTokenIsValid(OAuth2TokenValidationRequestDTO requestDTO) throws IdentityOAuth2Exception {
        OAuth2ClientApplicationDTO clientApp = new OAuth2ClientApplicationDTO();
        OAuth2TokenValidationResponseDTO responseDTO = new OAuth2TokenValidationResponseDTO();
        OAuth2TokenValidationMessageContext messageContext = new OAuth2TokenValidationMessageContext(requestDTO, responseDTO);
        OAuth2TokenValidationRequestDTO.OAuth2AccessToken accessToken = requestDTO.getAccessToken();
        OAuth2TokenValidator tokenValidator = null;
        AccessTokenDO accessTokenDO = null;
        try {
            tokenValidator = this.findAccessTokenValidator(accessToken);
        }
        catch (IllegalArgumentException e) {
            return this.buildClientAppErrorResponse(e.getMessage());
        }
        try {
            accessTokenDO = OAuth2Util.findAccessToken(requestDTO.getAccessToken().getIdentifier(), false);
        }
        catch (IllegalArgumentException e) {
            return this.buildClientAppErrorResponse(e.getMessage());
        }
        if (this.hasAccessTokenExpired(accessTokenDO)) {
            return this.buildClientAppErrorResponse("Access token expired");
        }
        responseDTO.setExpiryTime(this.getAccessTokenExpirationTime(accessTokenDO));
        messageContext.addProperty("AccessTokenDO", (Object)accessTokenDO);
        if (!tokenValidator.validateAccessDelegation(messageContext)) {
            return this.buildClientAppErrorResponse("Invalid access delegation");
        }
        if (!tokenValidator.validateScope(messageContext)) {
            return this.buildClientAppErrorResponse("Scope validation failed at app level");
        }
        if (!tokenValidator.validateAccessToken(messageContext)) {
            return this.buildClientAppErrorResponse("OAuth2 access token validation failed");
        }
        responseDTO.setAuthorizedUser(this.getAuthzUser(accessTokenDO));
        responseDTO.setScope(accessTokenDO.getScope());
        responseDTO.setValid(true);
        responseDTO.setTokenBinding(accessTokenDO.getTokenBinding());
        if (this.tokenGenerator != null) {
            this.tokenGenerator.generateToken(messageContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.tokenGenerator.getClass().getName() + " generated token set to response"));
            }
        }
        clientApp.setAccessTokenValidationResponse(responseDTO);
        clientApp.setConsumerKey(accessTokenDO.getConsumerKey());
        return clientApp;
    }

    public OAuth2IntrospectionResponseDTO buildIntrospectionResponse(OAuth2TokenValidationRequestDTO validationRequest) throws IdentityOAuth2Exception {
        OAuth2TokenValidationResponseDTO responseDTO = new OAuth2TokenValidationResponseDTO();
        OAuth2IntrospectionResponseDTO introResp = new OAuth2IntrospectionResponseDTO();
        OAuth2TokenValidationMessageContext messageContext = new OAuth2TokenValidationMessageContext(validationRequest, responseDTO);
        OAuth2TokenValidationRequestDTO.OAuth2AccessToken oAuth2Token = validationRequest.getAccessToken();
        ArrayList<OAuth2TokenValidator> applicableValidators = new ArrayList<OAuth2TokenValidator>();
        boolean isJWTTokenValidation = this.isJWTTokenValidation(oAuth2Token.getIdentifier());
        if (oAuth2Token.getTokenType() != null && this.tokenValidators.get(oAuth2Token.getTokenType()) != null && !this.isSkipValidatorForJWT(this.tokenValidators.get(oAuth2Token.getTokenType()), isJWTTokenValidation)) {
            applicableValidators.add(this.tokenValidators.get(oAuth2Token.getTokenType()));
        }
        for (Map.Entry<String, OAuth2TokenValidator> oAuth2TokenValidator : this.tokenValidators.entrySet()) {
            if (StringUtils.equals((String)oAuth2TokenValidator.getKey(), (String)oAuth2Token.getTokenType()) || this.isSkipValidatorForJWT(oAuth2TokenValidator.getValue(), isJWTTokenValidation) || oAuth2TokenValidator.getValue() == null) continue;
            applicableValidators.add(oAuth2TokenValidator.getValue());
        }
        Exception exception = null;
        for (OAuth2TokenValidator tokenValidator : applicableValidators) {
            try {
                if (!tokenValidator.validateAccessToken(messageContext)) continue;
                if (tokenValidator instanceof DefaultOAuth2TokenValidator) {
                    introResp = this.validateAccessToken(messageContext, validationRequest, tokenValidator);
                } else if (tokenValidator instanceof RefreshTokenValidator) {
                    introResp = this.validateRefreshToken(messageContext, validationRequest, tokenValidator);
                }
                if (!introResp.isActive()) continue;
                introResp.setTokenType(tokenValidator.getTokenType());
                break;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (!introResp.isActive()) {
            if (introResp.getError() != null) {
                return introResp;
            }
            if (exception != null) {
                throw new IdentityOAuth2Exception("Error occurred while validating token.", exception);
            }
            return this.buildIntrospectionErrorResponse("Token validation failed");
        }
        if (introResp.getUsername() != null) {
            responseDTO.setAuthorizedUser(introResp.getUsername());
        }
        if (this.tokenGenerator != null) {
            this.tokenGenerator.generateToken(messageContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.tokenGenerator.getClass().getName() + " generated token set to response"));
            }
            if (responseDTO.getAuthorizationContextToken() != null) {
                introResp.setUserContext(responseDTO.getAuthorizationContextToken().getTokenString());
            }
        }
        introResp.getProperties().put("OAuth2TokenValidationMessageContext", messageContext);
        return introResp;
    }

    private OAuth2IntrospectionResponseDTO validateRefreshToken(OAuth2TokenValidationMessageContext messageContext, OAuth2TokenValidationRequestDTO validationRequest, OAuth2TokenValidator tokenValidator) throws IdentityOAuth2Exception {
        AccessTokenDO refreshTokenDataDO;
        OAuth2IntrospectionResponseDTO introResp = new OAuth2IntrospectionResponseDTO();
        try {
            refreshTokenDataDO = this.findRefreshToken(validationRequest.getAccessToken().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            return this.buildIntrospectionErrorResponse(e.getMessage());
        }
        if (refreshTokenDataDO == null || this.hasRefreshTokenExpired(refreshTokenDataDO)) {
            introResp.setActive(false);
            return introResp;
        }
        introResp.setExp((refreshTokenDataDO.getRefreshTokenValidityPeriodInMillis() + refreshTokenDataDO.getRefreshTokenIssuedTime().getTime()) / 1000L);
        introResp.setIat(refreshTokenDataDO.getRefreshTokenIssuedTime().getTime() / 1000L);
        introResp.setNbf(refreshTokenDataDO.getRefreshTokenIssuedTime().getTime() / 1000L);
        introResp.setScope(OAuth2Util.buildScopeString(refreshTokenDataDO.getScope()));
        introResp.setUsername(this.getAuthzUser(refreshTokenDataDO));
        introResp.setClientId(refreshTokenDataDO.getConsumerKey());
        messageContext.addProperty("RefreshTokenDO", (Object)refreshTokenDataDO);
        if (!tokenValidator.validateAccessDelegation(messageContext)) {
            introResp.setActive(false);
            return this.buildIntrospectionErrorResponse("Invalid access delegation");
        }
        if (!tokenValidator.validateScope(messageContext)) {
            introResp.setActive(false);
            return this.buildIntrospectionErrorResponse("Scope validation failed");
        }
        introResp.setActive(true);
        return introResp;
    }

    private OAuth2IntrospectionResponseDTO validateAccessToken(OAuth2TokenValidationMessageContext messageContext, OAuth2TokenValidationRequestDTO validationRequest, OAuth2TokenValidator tokenValidator) throws IdentityOAuth2Exception {
        OAuth2IntrospectionResponseDTO introResp = new OAuth2IntrospectionResponseDTO();
        ArrayList<String> requestedAllowedScopes = new ArrayList<String>();
        if (messageContext.getProperty("REMOTE_ACCESS_TOKEN") != null && "true".equalsIgnoreCase((String)messageContext.getProperty("REMOTE_ACCESS_TOKEN"))) {
            if (messageContext.getProperty("exp") != null) {
                introResp.setExp(Long.parseLong((String)messageContext.getProperty("exp")));
            }
            if (messageContext.getProperty("iat") != null) {
                introResp.setIat(Long.parseLong((String)messageContext.getProperty("iat")));
            }
            if (messageContext.getProperty("scope") != null) {
                introResp.setScope((String)messageContext.getProperty("scope"));
            }
            if (messageContext.getProperty("username") != null) {
                introResp.setUsername((String)messageContext.getProperty("username"));
            }
            if (messageContext.getProperty("client_id") != null) {
                introResp.setClientId((String)messageContext.getProperty("client_id"));
            }
        } else {
            AccessTokenDO accessTokenDO;
            try {
                accessTokenDO = OAuth2Util.findAccessToken(validationRequest.getAccessToken().getIdentifier(), false);
                List<String> allowedScopes = OAuthServerConfiguration.getInstance().getAllowedScopes();
                String[] requestedScopes = accessTokenDO.getScope();
                ArrayList<String> scopesToBeValidated = new ArrayList<String>();
                if (requestedScopes != null) {
                    for (String scope : requestedScopes) {
                        if (OAuth2Util.isAllowedScope(allowedScopes, scope)) {
                            requestedAllowedScopes.add(scope);
                            continue;
                        }
                        scopesToBeValidated.add(scope);
                    }
                    accessTokenDO.setScope(scopesToBeValidated.toArray(new String[0]));
                }
            }
            catch (IllegalArgumentException e) {
                return this.buildIntrospectionErrorResponse(e.getMessage());
            }
            if (this.hasAccessTokenExpired(accessTokenDO)) {
                introResp.setActive(false);
                return introResp;
            }
            if (accessTokenDO.getValidityPeriodInMillis() < 0L) {
                introResp.setExp(Long.MAX_VALUE);
            } else {
                introResp.setExp((accessTokenDO.getValidityPeriodInMillis() + accessTokenDO.getIssuedTime().getTime()) / 1000L);
            }
            introResp.setIat(accessTokenDO.getIssuedTime().getTime() / 1000L);
            introResp.setNbf(accessTokenDO.getIssuedTime().getTime() / 1000L);
            introResp.setScope(OAuth2Util.buildScopeString(accessTokenDO.getScope()));
            introResp.setUsername(this.getAuthzUser(accessTokenDO));
            introResp.setClientId(accessTokenDO.getConsumerKey());
            if (accessTokenDO.getTokenBinding() != null) {
                introResp.setBindingType(accessTokenDO.getTokenBinding().getBindingType());
                introResp.setBindingReference(accessTokenDO.getTokenBinding().getBindingReference());
            }
            if (accessTokenDO.getTokenType() != null) {
                introResp.setAut(accessTokenDO.getTokenType());
            }
            messageContext.addProperty("AccessTokenDO", (Object)accessTokenDO);
        }
        if (messageContext.getProperty("JWT_ACCESS_TOKEN") != null && "true".equalsIgnoreCase((String)messageContext.getProperty("JWT_ACCESS_TOKEN"))) {
            if (messageContext.getProperty("sub") != null) {
                introResp.setSub((String)messageContext.getProperty("sub"));
            }
            if (messageContext.getProperty("iss") != null) {
                introResp.setIss((String)messageContext.getProperty("iss"));
            }
            if (messageContext.getProperty("aud") != null) {
                introResp.setAud((String)messageContext.getProperty("aud"));
            }
            if (messageContext.getProperty("jti") != null) {
                introResp.setJti((String)messageContext.getProperty("jti"));
            }
            if (messageContext.getProperty("nbf") != null) {
                introResp.setNbf(Long.parseLong((String)messageContext.getProperty("nbf")));
            }
        }
        if (!tokenValidator.validateAccessDelegation(messageContext)) {
            introResp.setActive(false);
            return this.buildIntrospectionErrorResponse("Invalid access delegation");
        }
        if (!tokenValidator.validateScope(messageContext)) {
            introResp.setActive(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Scope validation has failed at app level.");
            }
            return this.buildIntrospectionErrorResponse("Scope validation failed");
        }
        this.addAllowedScopes(messageContext, requestedAllowedScopes.toArray(new String[0]));
        introResp.setActive(true);
        return introResp;
    }

    private String getAuthzUser(AccessTokenDO accessTokenDO) throws IdentityOAuth2Exception {
        AuthenticatedUser user = accessTokenDO.getAuthzUser();
        if (user.isFederatedUser()) {
            return user.getAuthenticatedSubjectIdentifier();
        }
        String consumerKey = accessTokenDO.getConsumerKey();
        try {
            boolean buildSubjectIdentifierFromSPConfig = Boolean.parseBoolean(IdentityUtil.getProperty((String)BUILD_FQU_FROM_SP_CONFIG));
            if (buildSubjectIdentifierFromSPConfig) {
                ServiceProvider serviceProvider = this.getServiceProvider(consumerKey);
                boolean useTenantDomainInLocalSubjectIdentifier = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseTenantDomainInLocalSubjectIdentifier();
                boolean useUserStoreDomainInLocalSubjectIdentifier = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
                return user.getUsernameAsSubjectIdentifier(useUserStoreDomainInLocalSubjectIdentifier, useTenantDomainInLocalSubjectIdentifier);
            }
            return user.toFullQualifiedUsername();
        }
        catch (IdentityApplicationManagementException | InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id:" + consumerKey, e);
        }
    }

    private ServiceProvider getServiceProvider(String consumerKey) throws IdentityApplicationManagementException, IdentityOAuth2Exception, InvalidOAuthClientException {
        String spTenantDomain = OAuth2Util.getTenantDomainOfOauthApp(consumerKey);
        return OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(consumerKey, "oauth2", spTenantDomain);
    }

    private OAuth2ClientApplicationDTO buildClientAppErrorResponse(String errorMessage) {
        OAuth2TokenValidationResponseDTO responseDTO = new OAuth2TokenValidationResponseDTO();
        OAuth2ClientApplicationDTO clientApp = new OAuth2ClientApplicationDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)errorMessage);
        }
        responseDTO.setValid(false);
        responseDTO.setErrorMsg(errorMessage);
        clientApp.setAccessTokenValidationResponse(responseDTO);
        return clientApp;
    }

    private OAuth2IntrospectionResponseDTO buildIntrospectionErrorResponse(String errorMessage) {
        OAuth2IntrospectionResponseDTO response = new OAuth2IntrospectionResponseDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)errorMessage);
        }
        response.setActive(false);
        response.setError(errorMessage);
        return response;
    }

    private OAuth2TokenValidator findAccessTokenValidator(OAuth2TokenValidationRequestDTO.OAuth2AccessToken accessToken) throws IdentityOAuth2Exception {
        if (accessToken == null) {
            throw new IllegalArgumentException("Access token is not present in the validation request");
        }
        String accessTokenIdentifier = accessToken.getIdentifier();
        if (accessTokenIdentifier == null) {
            throw new IllegalArgumentException("Access token identifier is not present in the validation request");
        }
        OAuth2TokenValidator tokenValidator = this.isJWTTokenValidation(accessToken.getIdentifier()) ? this.tokenValidators.get(BEARER_TOKEN_TYPE_JWT) : this.tokenValidators.get(accessToken.getTokenType());
        if (tokenValidator == null) {
            throw new IllegalArgumentException("Unsupported access token type: " + accessToken.getTokenType());
        }
        return tokenValidator;
    }

    private long getAccessTokenExpirationTime(AccessTokenDO accessTokenDO) {
        long expiryTime = OAuth2Util.getAccessTokenExpireMillis(accessTokenDO);
        if ("APPLICATION_USER".equals(accessTokenDO.getTokenType()) && OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() < 0L) {
            return Long.MAX_VALUE;
        }
        if ("APPLICATION".equals(accessTokenDO.getTokenType()) && OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() < 0L) {
            return Long.MAX_VALUE;
        }
        if (expiryTime < 0L) {
            return Long.MAX_VALUE;
        }
        return expiryTime / 1000L;
    }

    private boolean hasAccessTokenExpired(AccessTokenDO accessTokenDO) {
        if (accessTokenDO.getValidityPeriod() < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access Token has infinite lifetime");
            }
        } else if (OAuth2Util.getAccessTokenExpireMillis(accessTokenDO) == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access Token has expired");
            }
            return true;
        }
        return false;
    }

    private boolean hasRefreshTokenExpired(AccessTokenDO accessTokenDO) {
        if (accessTokenDO.getRefreshTokenValidityPeriodInMillis() < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access Token has infinite lifetime");
            }
        } else if (OAuth2Util.getRefreshTokenExpireTimeMillis(accessTokenDO) == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access Token has expired");
            }
            return true;
        }
        return false;
    }

    private AccessTokenDO findRefreshToken(String refreshToken) throws IdentityOAuth2Exception {
        return OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().getRefreshToken(refreshToken);
    }

    private boolean isJWTTokenValidation(String tokenIdentifier) {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)ENABLE_JWT_TOKEN_VALIDATION)) && OAuth2Util.isParsableJWT(tokenIdentifier);
    }

    private boolean isSkipValidatorForJWT(OAuth2TokenValidator tokenValidator, boolean isJWTTokenValidation) {
        return isJWTTokenValidation && BEARER_TOKEN_TYPE.equals(tokenValidator.getTokenType());
    }

    private void addAllowedScopes(OAuth2TokenValidationMessageContext oAuth2TokenValidationMessageContext, String[] allowedScopes) {
        Object[] scopes = oAuth2TokenValidationMessageContext.getResponseDTO().getScope();
        String[] scopesToReturn = (String[])ArrayUtils.addAll((Object[])scopes, (Object[])allowedScopes);
        oAuth2TokenValidationMessageContext.getResponseDTO().setScope(scopesToReturn);
    }
}

