/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeHandler;

public class OIDCScopeHandler
extends OAuth2ScopeHandler {
    private static final Log log = LogFactory.getLog(OIDCScopeHandler.class);

    @Override
    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        Set<String> idTokenNotAllowedGrantTypesSet = OAuthServerConfiguration.getInstance().getIdTokenNotAllowedGrantTypesSet();
        String grantType = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType();
        if (GrantType.AUTHORIZATION_CODE.toString().equals(grantType)) {
            return true;
        }
        if (!idTokenNotAllowedGrantTypesSet.contains(grantType)) {
            return true;
        }
        String[] scopes = (String[])ArrayUtils.removeElement((Object[])tokReqMsgCtx.getScope(), (Object)"openid");
        tokReqMsgCtx.setScope(scopes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("id_token is not allowed for requested grant type: " + grantType + ". Removing 'openid' scope."));
        }
        return true;
    }

    @Override
    public boolean canHandle(OAuthTokenReqMessageContext tokReqMsgCtx) {
        String[] scopes = tokReqMsgCtx.getScope();
        return scopes != null && Arrays.asList(scopes).contains("openid");
    }
}

