/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.validators.DefaultOAuth2TokenValidator;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class OAuth2JWTTokenValidator
extends DefaultOAuth2TokenValidator {
    private static final String ALGO_PREFIX = "RS";
    private static final Log log = LogFactory.getLog(OAuth2JWTTokenValidator.class);
    private static final String OIDC_IDP_ENTITY_ID = "IdPEntityId";
    private static final String DOT_SEPARATOR = ".";

    @Override
    public boolean validateAccessToken(OAuth2TokenValidationMessageContext validationReqDTO) throws IdentityOAuth2Exception {
        if (!this.isJWT(validationReqDTO.getRequestDTO().getAccessToken().getIdentifier())) {
            return false;
        }
        try {
            SignedJWT signedJWT = this.getSignedJWT(validationReqDTO);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            if (claimsSet == null) {
                throw new IdentityOAuth2Exception("Claim values are empty in the given Token.");
            }
            if (!this.validateRequiredFields(claimsSet)) {
                return false;
            }
            IdentityProvider identityProvider = this.getResidentIDPForIssuer(claimsSet.getIssuer());
            if (!this.validateSignature(signedJWT, identityProvider)) {
                return false;
            }
            if (!this.checkExpirationTime(claimsSet.getExpirationTime())) {
                return false;
            }
            this.checkNotBeforeTime(claimsSet.getNotBeforeTime());
        }
        catch (JOSEException | ParseException e) {
            throw new IdentityOAuth2Exception("Error while validating Token.", e);
        }
        return true;
    }

    @Override
    public String getTokenType() {
        return "JWT";
    }

    protected X509Certificate resolveSignerCertificate(JWSHeader header, IdentityProvider idp) throws IdentityOAuth2Exception {
        X509Certificate x509Certificate;
        String tenantDomain = this.getTenantDomain();
        try {
            x509Certificate = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)idp.getCertificate());
        }
        catch (CertificateException e) {
            throw new IdentityOAuth2Exception("Error occurred while decoding public certificate of Identity Provider " + idp.getIdentityProviderName() + " for tenant domain " + tenantDomain, e);
        }
        return x509Certificate;
    }

    private SignedJWT getSignedJWT(OAuth2TokenValidationMessageContext validationReqDTO) throws ParseException {
        return SignedJWT.parse((String)validationReqDTO.getRequestDTO().getAccessToken().getIdentifier());
    }

    private String resolveSubject(JWTClaimsSet claimsSet) {
        return claimsSet.getSubject();
    }

    private IdentityProvider getResidentIDPForIssuer(String jwtIssuer) throws IdentityOAuth2Exception {
        IdentityProvider residentIdentityProvider;
        String tenantDomain = this.getTenantDomain();
        String issuer = "";
        try {
            residentIdentityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format("Error while getting Resident Identity Provider of '%s' tenant.", tenantDomain);
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
        FederatedAuthenticatorConfig[] fedAuthnConfigs = residentIdentityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        if (oauthAuthenticatorConfig != null) {
            issuer = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)OIDC_IDP_ENTITY_ID).getValue();
        }
        if (!jwtIssuer.equals(issuer)) {
            throw new IdentityOAuth2Exception("No Registered IDP found for the token with issuer name : " + jwtIssuer);
        }
        return residentIdentityProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateSignature(SignedJWT signedJWT, IdentityProvider idp) throws JOSEException, IdentityOAuth2Exception {
        RSASSAVerifier verifier = null;
        JWSHeader header = signedJWT.getHeader();
        X509Certificate x509Certificate = this.resolveSignerCertificate(header, idp);
        if (x509Certificate == null) {
            throw new IdentityOAuth2Exception("Unable to locate certificate for Identity Provider: " + idp.getDisplayName());
        }
        String alg = signedJWT.getHeader().getAlgorithm().getName();
        if (StringUtils.isEmpty((String)alg)) {
            throw new IdentityOAuth2Exception("Algorithm must not be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signature Algorithm found in the Token Header: " + alg));
        }
        if (alg.indexOf(ALGO_PREFIX) == 0) {
            PublicKey publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof RSAPublicKey)) throw new IdentityOAuth2Exception("Public key is not an RSA public key.");
            verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Signature Algorithm not supported yet: " + alg));
        }
        if (verifier == null) {
            throw new IdentityOAuth2Exception("Could not create a signature verifier for algorithm type: " + alg);
        }
        boolean isValid = signedJWT.verify(verifier);
        if (!log.isDebugEnabled()) return isValid;
        log.debug((Object)("Signature verified: " + isValid));
        return isValid;
    }

    private boolean checkExpirationTime(Date expirationTime) {
        long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        long expirationTimeInMillis = expirationTime.getTime();
        long currentTimeInMillis = System.currentTimeMillis();
        if (currentTimeInMillis + timeStampSkewMillis > expirationTimeInMillis) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token is expired., Expiration Time(ms) : " + expirationTimeInMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". Token Rejected and validation terminated."));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Expiration Time(exp) of Token was validated successfully.");
        }
        return true;
    }

    private boolean checkNotBeforeTime(Date notBeforeTime) throws IdentityOAuth2Exception {
        if (notBeforeTime != null) {
            long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
            long notBeforeTimeMillis = notBeforeTime.getTime();
            long currentTimeInMillis = System.currentTimeMillis();
            if (currentTimeInMillis + timeStampSkewMillis < notBeforeTimeMillis) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token is used before Not_Before_Time., Not Before Time(ms) : " + notBeforeTimeMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". Token Rejected and validation terminated."));
                }
                throw new IdentityOAuth2Exception("Token is used before Not_Before_Time.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not Before Time(nbf) of Token was validated successfully.");
            }
        }
        return true;
    }

    private boolean validateRequiredFields(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String subject = this.resolveSubject(claimsSet);
        List audience = claimsSet.getAudience();
        String jti = claimsSet.getJWTID();
        if (StringUtils.isEmpty((String)claimsSet.getIssuer()) || StringUtils.isEmpty((String)subject) || claimsSet.getExpirationTime() == null || audience == null || jti == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Mandatory fields(Issuer, Subject, Expiration time, jtl or Audience) are empty in the given Token.");
            }
            return false;
        }
        return true;
    }

    private String getTenantDomain() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        return tenantDomain;
    }

    private boolean isJWT(String tokenIdentifier) {
        return StringUtils.countMatches((String)tokenIdentifier, (String)DOT_SEPARATOR) == 2;
    }
}

