/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.ResourceScopeCacheEntry;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeValidator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class JDBCScopeValidator
extends OAuth2ScopeValidator {
    public static final String CHECK_ROLES_FROM_SAML_ASSERTION = "checkRolesFromSamlAssertion";
    public static final String RETRIEVE_ROLES_FROM_USERSTORE_FOR_SCOPE_VALIDATION = "retrieveRolesFromUserStoreForScopeValidation";
    private static final String SCOPE_VALIDATOR_NAME = "Role based scope validator";
    private static final String OPENID = "openid";
    private static final Log log = LogFactory.getLog(JDBCScopeValidator.class);

    @Override
    public boolean validateScope(AccessTokenDO accessTokenDO, String resource) throws IdentityOAuth2Exception {
        if (resource == null) {
            return true;
        }
        String[] scopes = accessTokenDO.getScope();
        if (scopes == null || scopes.length == 0) {
            return true;
        }
        String resourceScope = null;
        int resourceTenantId = -1;
        boolean cacheHit = false;
        OAuthCacheKey cacheKey = new OAuthCacheKey(resource);
        CacheEntry result = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(cacheKey));
        if (result != null && result instanceof ResourceScopeCacheEntry) {
            resourceScope = ((ResourceScopeCacheEntry)result).getScope();
            resourceTenantId = ((ResourceScopeCacheEntry)result).getTenantId();
            cacheHit = true;
        }
        if (!cacheHit) {
            Pair<String, Integer> scopeMap = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().findTenantAndScopeOfResource(resource);
            if (scopeMap != null) {
                resourceScope = (String)scopeMap.getLeft();
                resourceTenantId = (Integer)scopeMap.getRight();
            }
            cacheKey = new OAuthCacheKey(resource);
            ResourceScopeCacheEntry cacheEntry = new ResourceScopeCacheEntry(resourceScope);
            cacheEntry.setTenantId(resourceTenantId);
            OAuthCache.getInstance().addToCache(cacheKey, (Serializable)((Object)cacheEntry));
        }
        if (resourceScope == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource '" + resource + "' is not protected with a scope"));
            }
            return true;
        }
        ArrayList<String> scopeList = new ArrayList<String>(Arrays.asList(scopes));
        if (!scopeList.contains(resourceScope)) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token '" + accessTokenDO.getAccessToken() + "' does not bear the scope '" + resourceScope + "'"));
            }
            return false;
        }
        if (accessTokenDO.getAuthzUser().isFederatedUser() && (Boolean.parseBoolean(System.getProperty(CHECK_ROLES_FROM_SAML_ASSERTION)) || !Boolean.parseBoolean(System.getProperty(RETRIEVE_ROLES_FROM_USERSTORE_FOR_SCOPE_VALIDATION)))) {
            return true;
        }
        try {
            AuthenticatedUser authzUser = accessTokenDO.getAuthzUser();
            int tenantId = this.getTenantId((User)authzUser);
            Object[] userRoles = this.getUserRoles((User)authzUser);
            if (ArrayUtils.isEmpty((Object[])userRoles)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No roles associated for the user " + authzUser.getUserName()));
                }
                return false;
            }
            return this.isUserAuthorizedForScope(resourceScope, (String[])userRoles, tenantId);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error when getting the tenant's UserStoreManager or when getting roles of user ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws UserStoreException, IdentityOAuth2Exception {
        return this.validateScope(tokReqMsgCtx.getScope(), tokReqMsgCtx.getAuthorizedUser());
    }

    @Override
    public boolean validateScope(OAuthAuthzReqMessageContext authzReqMessageContext) throws UserStoreException, IdentityOAuth2Exception {
        return this.validateScope(authzReqMessageContext.getAuthorizationReqDTO().getScopes(), authzReqMessageContext.getAuthorizationReqDTO().getUser());
    }

    private boolean validateScope(String[] requestedScopes, AuthenticatedUser user) throws UserStoreException, IdentityOAuth2Exception {
        requestedScopes = (String[])ArrayUtils.removeElement((Object[])requestedScopes, (Object)OPENID);
        try {
            String[] oidcScopes;
            for (String oidcScope : oidcScopes = OAuth2ServiceComponentHolder.getInstance().getOAuthAdminService().getScopeNames()) {
                requestedScopes = (String[])ArrayUtils.removeElement((Object[])requestedScopes, (Object)oidcScope);
            }
        }
        catch (IdentityOAuthAdminException e) {
            log.error((Object)"Unable to obtain OIDC scopes list.");
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])requestedScopes)) {
            return true;
        }
        int tenantId = this.getTenantId((User)user);
        String[] userRoles = this.getUserRoles((User)user);
        for (String scope : requestedScopes) {
            if (!this.isScopeValid(scope, tenantId)) {
                log.error((Object)("Requested scope " + scope + " is invalid"));
                return false;
            }
            if (this.isUserAuthorizedForScope(scope, userRoles, tenantId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getValidatorName() {
        return SCOPE_VALIDATOR_NAME;
    }

    private boolean isScopeValid(String scopeName, int tenantId) {
        Scope scope = null;
        try {
            scope = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopeByName(scopeName, tenantId);
        }
        catch (IdentityOAuth2ScopeServerException e) {
            log.error((Object)("Error while retrieving scope with name :" + scopeName));
        }
        return scope != null;
    }

    private boolean isUserAuthorizedForScope(String scopeName, String[] userRoles, int tenantId) throws IdentityOAuth2Exception {
        Set<String> rolesOfScope = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getBindingsOfScopeByScopeName(scopeName, tenantId);
        if (CollectionUtils.isEmpty(rolesOfScope)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Did not find any roles associated to the scope " + scopeName));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            StringBuilder logMessage = new StringBuilder("Found roles of scope '" + scopeName + "' ");
            logMessage.append(String.join((CharSequence)",", rolesOfScope));
            log.debug((Object)logMessage.toString());
        }
        if (ArrayUtils.isEmpty((Object[])userRoles)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User does not have required roles for scope " + scopeName));
            }
            return false;
        }
        HashSet<String> scopeRoles = new HashSet<String>(rolesOfScope);
        rolesOfScope.retainAll(Arrays.asList(userRoles));
        if (rolesOfScope.isEmpty()) {
            boolean validInternalUserRole = this.validateInternalUserRoles(scopeRoles, userRoles);
            if (validInternalUserRole) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("User does not have required roles for scope " + scopeName));
            }
            return false;
        }
        return true;
    }

    private boolean validateInternalUserRoles(Set<String> scopeRoles, String[] userRoles) {
        for (String role : scopeRoles) {
            String domain;
            int index = role.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
            if (index <= 0 || !"Internal".equalsIgnoreCase(domain = role.substring(0, index))) continue;
            for (String userRole : userRoles) {
                if (!role.equalsIgnoreCase(userRole)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getUserRoles(User user) throws UserStoreException {
        Object[] userRoles;
        boolean tenantFlowStarted = false;
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        int tenantId = this.getTenantId(user);
        try {
            if (tenantId != -1234) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(realmService.getTenantManager().getDomain(tenantId), true);
                tenantFlowStarted = true;
            }
            UserStoreManager userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            userRoles = userStoreManager.getRoleListOfUser(MultitenantUtils.getTenantAwareUsername((String)user.toFullQualifiedUsername()));
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])userRoles) && log.isDebugEnabled()) {
            StringBuilder logMessage = new StringBuilder("Found roles of user ");
            logMessage.append(user.getUserName());
            logMessage.append(" ");
            logMessage.append(String.join((CharSequence)",", (CharSequence[])userRoles));
            log.debug((Object)logMessage.toString());
        }
        return userRoles;
    }

    private int getTenantId(User user) throws UserStoreException {
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        if (tenantId == 0 || tenantId == -1) {
            tenantId = IdentityTenantUtil.getTenantIdOfUser((String)user.getUserName());
        }
        return tenantId;
    }
}

