/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeBindingCache;
import org.wso2.carbon.identity.oauth.cache.OAuthScopeBindingCacheKey;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;

public class JDBCPermissionBasedInternalScopeValidator {
    private static final String PERMISSION_ROOT = "/permission";
    private static final Log log = LogFactory.getLog(JDBCPermissionBasedInternalScopeValidator.class);
    private static final String PERMISSION_BINDING_TYPE = "PERMISSION";
    private static final String ROOT = "/";
    private static final String ADMIN_PERMISSION_ROOT = "/permission/admin";
    private static final String INTERNAL_SCOPE_PREFIX = "internal_";
    private static final String EVERYONE_PERMISSION = "everyone_permission";

    public String[] validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) {
        Object[] requestedScopes = this.getRequestedScopes(tokReqMsgCtx.getScope());
        if (ArrayUtils.isEmpty((Object[])requestedScopes)) {
            return requestedScopes;
        }
        List<Scope> userAllowedScopes = this.getUserAllowedScopes(tokReqMsgCtx.getAuthorizedUser(), (String[])requestedScopes);
        Object[] userAllowedScopesAsArray = this.getScopes(userAllowedScopes);
        if (ArrayUtils.contains((Object[])requestedScopes, (Object)"SYSTEM")) {
            return userAllowedScopesAsArray;
        }
        ArrayList<Object> scopesToRespond = new ArrayList<Object>();
        for (Object scope : requestedScopes) {
            if (!ArrayUtils.contains((Object[])userAllowedScopesAsArray, (Object)scope)) continue;
            scopesToRespond.add(scope);
        }
        return scopesToRespond.toArray(new String[0]);
    }

    public String[] validateScope(OAuthAuthzReqMessageContext authzReqMessageContext) {
        Object[] requestedScopes = this.getRequestedScopes(authzReqMessageContext.getAuthorizationReqDTO().getScopes());
        if (ArrayUtils.isEmpty((Object[])requestedScopes)) {
            return requestedScopes;
        }
        List<Scope> userAllowedScopes = this.getUserAllowedScopes(authzReqMessageContext.getAuthorizationReqDTO().getUser(), (String[])requestedScopes);
        Object[] userAllowedScopesAsArray = this.getScopes(userAllowedScopes);
        if (ArrayUtils.contains((Object[])requestedScopes, (Object)"SYSTEM")) {
            return userAllowedScopesAsArray;
        }
        ArrayList<Object> scopesToRespond = new ArrayList<Object>();
        for (Object scope : requestedScopes) {
            if (!ArrayUtils.contains((Object[])userAllowedScopesAsArray, (Object)scope)) continue;
            scopesToRespond.add(scope);
        }
        return scopesToRespond.toArray(new String[0]);
    }

    private String[] getRequestedScopes(String[] scopes) {
        ArrayList<String> requestedScopes = new ArrayList<String>();
        if (scopes == null) {
            return null;
        }
        for (String scope : scopes) {
            if (!scope.startsWith(INTERNAL_SCOPE_PREFIX) && !scope.equalsIgnoreCase("SYSTEM")) continue;
            requestedScopes.add(scope);
        }
        return requestedScopes.toArray(new String[0]);
    }

    private String[] getScopes(List<Scope> scopes) {
        return (String[])scopes.stream().map(Scope::getName).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Scope> getUserAllowedScopes(AuthenticatedUser authenticatedUser, String[] requestedScopes) {
        ArrayList<Scope> userAllowedScopes = new ArrayList<Scope>();
        try {
            if (requestedScopes == null) {
                ArrayList<Scope> arrayList = new ArrayList<Scope>();
                return arrayList;
            }
            boolean isSystemScope = ArrayUtils.contains((Object[])requestedScopes, (Object)"SYSTEM");
            int tenantId = IdentityTenantUtil.getTenantId((String)authenticatedUser.getTenantDomain());
            this.startTenantFlow(authenticatedUser.getTenantDomain(), tenantId);
            AuthorizationManager authorizationManager = OAuthComponentServiceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            Object[] allowedUIResourcesForUser = this.getAllowedUIResourcesOfUser(authenticatedUser, authorizationManager);
            Set<Scope> allScopes = this.getScopesOfPermissionType(tenantId);
            if (ArrayUtils.contains((Object[])allowedUIResourcesForUser, (Object)ROOT) || ArrayUtils.contains((Object[])allowedUIResourcesForUser, (Object)PERMISSION_ROOT)) {
                ArrayList<Scope> arrayList = new ArrayList<Scope>(allScopes);
                return arrayList;
            }
            if (ArrayUtils.contains((Object[])allowedUIResourcesForUser, (Object)ADMIN_PERMISSION_ROOT)) {
                ArrayList<Scope> arrayList = new ArrayList<Scope>(this.getAdminAllowedScopes(allScopes, requestedScopes));
                return arrayList;
            }
            for (Scope scope : allScopes) {
                if (!isSystemScope && !ArrayUtils.contains((Object[])requestedScopes, (Object)scope.getName())) continue;
                List<ScopeBinding> bindings = scope.getScopeBindings();
                boolean isScopeAllowed = true;
                block11: for (ScopeBinding scopeBinding : bindings) {
                    if (!PERMISSION_BINDING_TYPE.equalsIgnoreCase(scopeBinding.getBindingType())) continue;
                    for (String binding : scopeBinding.getBindings()) {
                        boolean isAllowed = false;
                        for (Object allowedScope : allowedUIResourcesForUser) {
                            if (!(binding + ROOT).startsWith((String)allowedScope + ROOT)) continue;
                            isAllowed = true;
                            break;
                        }
                        if (isAllowed) continue;
                        isScopeAllowed = false;
                        continue block11;
                    }
                }
                if (!isScopeAllowed) continue;
                userAllowedScopes.add(scope);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while accessing Authorization Manager.", (Throwable)e);
        }
        catch (IdentityOAuth2ScopeServerException e) {
            log.error((Object)"Error while retrieving oAuth2 scopes.", (Throwable)((Object)e));
        }
        finally {
            this.endTenantFlow();
        }
        return userAllowedScopes;
    }

    private String[] getAllowedUIResourcesOfUser(AuthenticatedUser authenticatedUser, AuthorizationManager authorizationManager) throws UserStoreException {
        Object[] allowedUIResourcesForUser = authorizationManager.getAllowedUIResourcesForUser(IdentityUtil.addDomainToName((String)authenticatedUser.getUserName(), (String)authenticatedUser.getUserStoreDomain()), ROOT);
        return (String[])ArrayUtils.add((Object[])allowedUIResourcesForUser, (Object)EVERYONE_PERMISSION);
    }

    private Set<Scope> getScopesOfPermissionType(int tenantId) throws IdentityOAuth2ScopeServerException {
        Set<Scope> allScopes;
        Scope[] scopesFromCache = OAuthScopeBindingCache.getInstance().getValueFromCache(new OAuthScopeBindingCacheKey(PERMISSION_BINDING_TYPE, tenantId));
        if (scopesFromCache != null) {
            allScopes = Arrays.stream(scopesFromCache).collect(Collectors.toSet());
        } else {
            allScopes = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopes(tenantId, PERMISSION_BINDING_TYPE);
            if (CollectionUtils.isNotEmpty(allScopes)) {
                OAuthScopeBindingCache.getInstance().addToCache(new OAuthScopeBindingCacheKey(PERMISSION_BINDING_TYPE, tenantId), allScopes.toArray(new Scope[0]));
            }
        }
        return allScopes;
    }

    private void startTenantFlow(String tenantDomain, int tenantId) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
    }

    private void endTenantFlow() {
        PrivilegedCarbonContext.endTenantFlow();
    }

    private Set<Scope> getAdminAllowedScopes(Set<Scope> allScopes, String[] requestedScopes) {
        HashSet<Scope> adminAllowedScopes = new HashSet<Scope>(allScopes);
        for (Scope scope : allScopes) {
            if (!ArrayUtils.contains((Object[])requestedScopes, (Object)scope.getName())) continue;
            List<ScopeBinding> scopeBindings = scope.getScopeBindings();
            block1: for (ScopeBinding scopeBinding : scopeBindings) {
                if (!PERMISSION_BINDING_TYPE.equalsIgnoreCase(scopeBinding.getBindingType())) continue;
                List<String> bindings = scopeBinding.getBindings();
                for (String binding : bindings) {
                    if (binding.startsWith(ADMIN_PERMISSION_ROOT) || binding.equals(EVERYONE_PERMISSION)) continue;
                    adminAllowedScopes.remove(scope);
                    continue block1;
                }
            }
        }
        return adminAllowedScopes;
    }
}

