/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.validators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeValidator;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidator;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;

public class DefaultOAuth2TokenValidator
implements OAuth2TokenValidator {
    public static final String TOKEN_TYPE = "bearer";
    private static final String ACCESS_TOKEN_DO = "AccessTokenDO";
    private static final String RESOURCE = "resource";
    private static final Log log = LogFactory.getLog(DefaultOAuth2TokenValidator.class);

    @Override
    public boolean validateAccessDelegation(OAuth2TokenValidationMessageContext messageContext) throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean validateScope(OAuth2TokenValidationMessageContext messageContext) throws IdentityOAuth2Exception {
        Object[] scopeValidators;
        OAuthAppDO app;
        AccessTokenDO accessTokenDO = (AccessTokenDO)((Object)messageContext.getProperty(ACCESS_TOKEN_DO));
        if (accessTokenDO == null) {
            return false;
        }
        try {
            app = OAuth2Util.getAppInformationByClientId(accessTokenDO.getConsumerKey());
            scopeValidators = app.getScopeValidators();
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception(String.format("Exception occurred when getting app information for client id %s ", accessTokenDO.getConsumerKey()), e);
        }
        if (ArrayUtils.isEmpty((Object[])scopeValidators)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("There is no scope validator registered for %s@%s", app.getApplicationName(), OAuth2Util.getTenantDomainOfOauthApp(app)));
            }
            return true;
        }
        String resource = this.getResourceFromMessageContext(messageContext);
        Set<OAuth2ScopeValidator> oAuth2ScopeValidators = OAuthServerConfiguration.getInstance().getOAuth2ScopeValidators();
        ArrayList<Object> appScopeValidators = new ArrayList<Object>(Arrays.asList(scopeValidators));
        for (OAuth2ScopeValidator validator : oAuth2ScopeValidators) {
            if (validator == null || !appScopeValidators.contains(validator.getValidatorName()) || !validator.canHandle(messageContext)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Validating scope of token %s using %s", accessTokenDO.getTokenId(), validator.getValidatorName()));
            }
            boolean isValid = validator.validateScope(accessTokenDO, resource);
            appScopeValidators.remove(validator.getValidatorName());
            if (isValid) continue;
            return false;
        }
        if (!appScopeValidators.isEmpty()) {
            throw new IdentityOAuth2Exception(String.format("The scope validators %s registered for application %s@%s are not found in the server configuration ", StringUtils.join(appScopeValidators, (String)", "), app.getApplicationName(), OAuth2Util.getTenantDomainOfOauthApp(app)));
        }
        List<ScopeValidator> globalScopeValidators = OAuthComponentServiceHolder.getInstance().getScopeValidators();
        for (ScopeValidator validator : globalScopeValidators) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Engaging global scope validator in token issuer flow : " + validator.getName()));
            }
            boolean isGlobalValidScope = validator.validateScope(messageContext);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Scope Validation was" + isGlobalValidScope + "at the global level by : " + validator.getName()));
        }
        return true;
    }

    private String getResourceFromMessageContext(OAuth2TokenValidationMessageContext messageContext) {
        String resource = null;
        if (messageContext.getRequestDTO().getContext() != null) {
            for (OAuth2TokenValidationRequestDTO.TokenValidationContextParam resourceParam : messageContext.getRequestDTO().getContext()) {
                if (resourceParam == null || !RESOURCE.equals(resourceParam.getKey())) continue;
                resource = resourceParam.getValue();
                break;
            }
        }
        return resource;
    }

    @Override
    public boolean validateAccessToken(OAuth2TokenValidationMessageContext validationReqDTO) throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public String getTokenType() {
        return "Bearer";
    }
}

