/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.Oauth2ScopeConstants;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeValidator;
import org.wso2.carbon.user.api.UserStoreException;

public class Oauth2ScopeUtils {
    private static final Log log = LogFactory.getLog(Oauth2ScopeUtils.class);
    public static final String OAUTH_APP_DO_PROPERTY_NAME = "OAuthAppDO";

    public static IdentityOAuth2ScopeServerException generateServerException(Oauth2ScopeConstants.ErrorMessages error, String data) throws IdentityOAuth2ScopeServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityOAuth2ScopeServerException)IdentityException.error(IdentityOAuth2ScopeServerException.class, (String)error.getCode(), (String)errorDescription);
    }

    public static IdentityOAuth2ScopeServerException generateServerException(Oauth2ScopeConstants.ErrorMessages error, String data, Throwable e) throws IdentityOAuth2ScopeServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityOAuth2ScopeServerException)IdentityException.error(IdentityOAuth2ScopeServerException.class, (String)error.getCode(), (String)errorDescription, (Throwable)e);
    }

    public static IdentityOAuth2ScopeServerException generateServerException(Oauth2ScopeConstants.ErrorMessages error, Throwable e) throws IdentityOAuth2ScopeServerException {
        return (IdentityOAuth2ScopeServerException)IdentityException.error(IdentityOAuth2ScopeServerException.class, (String)error.getCode(), (String)error.getMessage(), (Throwable)e);
    }

    public static IdentityOAuth2ScopeClientException generateClientException(Oauth2ScopeConstants.ErrorMessages error, String data) throws IdentityOAuth2ScopeClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityOAuth2ScopeClientException)IdentityException.error(IdentityOAuth2ScopeClientException.class, (String)error.getCode(), (String)errorDescription);
    }

    public static IdentityOAuth2ScopeClientException generateClientException(Oauth2ScopeConstants.ErrorMessages error, String data, Throwable e) throws IdentityOAuth2ScopeClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityOAuth2ScopeClientException)IdentityException.error(IdentityOAuth2ScopeClientException.class, (String)error.getCode(), (String)errorDescription, (Throwable)e);
    }

    public static int getTenantID() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public static boolean validateByApplicationScopeValidator(OAuthTokenReqMessageContext tokenReqMsgContext, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO = Oauth2ScopeUtils.isATokenRequest(tokenReqMsgContext) ? Oauth2ScopeUtils.getOAuthAppDO(tokenReqMsgContext) : Oauth2ScopeUtils.getOAuthAppDO(authzReqMessageContext);
        Object[] scopeValidators = oAuthAppDO.getScopeValidators();
        if (ArrayUtils.isEmpty((Object[])scopeValidators)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("There is no scope validator registered for %s@%s", oAuthAppDO.getApplicationName(), OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO)));
            }
            return true;
        }
        ArrayList<Object> appScopeValidators = new ArrayList<Object>(Arrays.asList(scopeValidators));
        if (Oauth2ScopeUtils.isATokenRequest(tokenReqMsgContext) ? Oauth2ScopeUtils.hasScopeValidationFailed(tokenReqMsgContext, appScopeValidators, null) : Oauth2ScopeUtils.hasScopeValidationFailed(null, appScopeValidators, authzReqMessageContext)) {
            return false;
        }
        if (!appScopeValidators.isEmpty()) {
            throw new IdentityOAuth2Exception(String.format("The scope validators %s registered for application %s@%s are not found in the server configuration ", StringUtils.join(appScopeValidators, (String)", "), oAuthAppDO.getApplicationName(), OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO)));
        }
        return true;
    }

    private static boolean isATokenRequest(OAuthTokenReqMessageContext tokenReqMsgContext) {
        return tokenReqMsgContext != null;
    }

    private static OAuthAppDO getOAuthAppDO(OAuthTokenReqMessageContext tokenReqMsgContext) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO = (OAuthAppDO)tokenReqMsgContext.getProperty(OAUTH_APP_DO_PROPERTY_NAME);
        if (oAuthAppDO == null) {
            try {
                if (tokenReqMsgContext.getOauth2AccessTokenReqDTO() != null) {
                    throw new IdentityOAuth2Exception("OAuth2 Access Token Request Object was null when obtaining OAuth Application.");
                }
                oAuthAppDO = OAuth2Util.getAppInformationByClientId(tokenReqMsgContext.getOauth2AccessTokenReqDTO().getClientId());
            }
            catch (InvalidOAuthClientException e) {
                throw new IdentityOAuth2Exception("Error while retrieving OAuth application for client id: " + tokenReqMsgContext.getOauth2AccessTokenReqDTO().getClientId(), e);
            }
        }
        return oAuthAppDO;
    }

    private static OAuthAppDO getOAuthAppDO(OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO = (OAuthAppDO)authzReqMessageContext.getProperty(OAUTH_APP_DO_PROPERTY_NAME);
        if (oAuthAppDO == null) {
            try {
                if (authzReqMessageContext.getAuthorizationReqDTO() != null) {
                    throw new IdentityOAuth2Exception("Authorization Request Object was null when obtaining OAuth Application.");
                }
                oAuthAppDO = OAuth2Util.getAppInformationByClientId(authzReqMessageContext.getAuthorizationReqDTO().getConsumerKey());
            }
            catch (InvalidOAuthClientException e) {
                throw new IdentityOAuth2Exception("Error while retrieving OAuth application for client id: " + authzReqMessageContext.getAuthorizationReqDTO().getConsumerKey(), e);
            }
        }
        return oAuthAppDO;
    }

    private static boolean hasScopeValidationFailed(OAuthTokenReqMessageContext tokenReqMsgContext, List<String> appScopeValidators, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        return !Oauth2ScopeUtils.iterateOAuth2ScopeValidators(authzReqMessageContext, tokenReqMsgContext, appScopeValidators);
    }

    private static boolean iterateOAuth2ScopeValidators(OAuthAuthzReqMessageContext authzReqMessageContext, OAuthTokenReqMessageContext tokenReqMsgContext, List<String> appScopeValidators) throws IdentityOAuth2Exception {
        Set<OAuth2ScopeValidator> oAuth2ScopeValidators = OAuthServerConfiguration.getInstance().getOAuth2ScopeValidators();
        for (OAuth2ScopeValidator validator : oAuth2ScopeValidators) {
            boolean isValid;
            if (validator == null || !appScopeValidators.contains(validator.getValidatorName())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Validating scope of token request using %s", validator.getValidatorName()));
            }
            try {
                isValid = authzReqMessageContext != null ? validator.validateScope(authzReqMessageContext) : validator.validateScope(tokenReqMsgContext);
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error while validating scopes from application scope validator", e);
            }
            appScopeValidators.remove(validator.getValidatorName());
            if (isValid) continue;
            return false;
        }
        return true;
    }
}

