/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthRuntimeException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.ServiceProviderProperty;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.cache.AppInfoCache;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dao.OAuthConsumerDAO;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth.user.UserInfoEndpointException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;
import org.wso2.carbon.identity.oauth2.config.SpOAuth2ExpiryTimeConfiguration;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.ClientCredentialDO;
import org.wso2.carbon.identity.oauth2.token.JWTTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationGrantHandler;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuth2Util {
    public static final String REMOTE_ACCESS_TOKEN = "REMOTE_ACCESS_TOKEN";
    public static final String JWT_ACCESS_TOKEN = "JWT_ACCESS_TOKEN";
    public static final String ACCESS_TOKEN_DO = "AccessTokenDo";
    public static final String OAUTH2_VALIDATION_MESSAGE_CONTEXT = "OAuth2TokenValidationMessageContext";
    public static final String CONFIG_ELEM_OAUTH = "OAuth";
    public static final String OPENID_CONNECT = "OpenIDConnect";
    public static final String ENABLE_OPENID_CONNECT_AUDIENCES = "EnableAudiences";
    public static final String OPENID_CONNECT_AUDIENCE = "audience";
    public static final String OPENID_SCOPE = "openid";
    public static final String OPENID_CONNECT_AUDIENCE_IDENTITY_CONFIG = "Audience";
    private static final String OPENID_CONNECT_AUDIENCES = "Audiences";
    private static final String DOT_SEPARATER = ".";
    private static final String IDP_ENTITY_ID = "IdPEntityId";
    public static final String DEFAULT_TOKEN_TYPE = "Default";
    public static final String SCOPE = "scope";
    public static final String CLIENT_ID = "client_id";
    public static final String USERNAME = "username";
    public static final String TOKEN_TYPE = "token_type";
    public static final String NBF = "nbf";
    public static final String AUD = "aud";
    public static final String ISS = "iss";
    public static final String JTI = "jti";
    public static final String SUB = "sub";
    public static final String EXP = "exp";
    public static final String IAT = "iat";
    public static final String USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS = "userAccessTokenExpireTime";
    public static final String REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS = "refreshTokenExpireTime";
    public static final String APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS = "applicationAccessTokenExpireTime";
    private static final Log log = LogFactory.getLog(OAuth2Util.class);
    private static final String INTERNAL_LOGIN_SCOPE = "internal_login";
    private static final String IDENTITY_PATH = "identity";
    public static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String PERMISSION = "Permission";
    private static long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
    private static ThreadLocal<Integer> clientTenantId = new ThreadLocal();
    private static ThreadLocal<OAuthTokenReqMessageContext> tokenRequestContext = new ThreadLocal();
    private static ThreadLocal<OAuthAuthzReqMessageContext> authzRequestContext = new ThreadLocal();
    private static Pattern pkceCodeVerifierPattern = Pattern.compile("[\\w\\-\\._~]+");
    private static final String ALLOW_WEAK_RSA_SIGNER_KEY = "allow_weak_rsa_signer_key";
    private static Map<Integer, Certificate> publicCerts = new ConcurrentHashMap<Integer, Certificate>();
    private static Map<Integer, Key> privateKeys = new ConcurrentHashMap<Integer, Key>();
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String SHA384_WITH_RSA = "SHA384withRSA";
    private static final String SHA512_WITH_RSA = "SHA512withRSA";
    private static final String SHA256_WITH_HMAC = "SHA256withHMAC";
    private static final String SHA384_WITH_HMAC = "SHA384withHMAC";
    private static final String SHA512_WITH_HMAC = "SHA512withHMAC";
    private static final String SHA256_WITH_EC = "SHA256withEC";
    private static final String SHA384_WITH_EC = "SHA384withEC";
    private static final String SHA512_WITH_EC = "SHA512withEC";
    private static final String SHA256_WITH_PS = "SHA256withPS";
    private static final String SHA256 = "SHA-256";
    private static final String SHA384 = "SHA-384";
    private static final String SHA512 = "SHA-512";
    private static final String CLIENT_SECRET_BASIC = "client_secret_basic";
    private static final String CLIENT_SECRET_POST = "client_secret_post";
    private static final String PRIVATE_KEY_JWT = "private_key_jwt";
    private static final String QUERY_RESPONSE_MODE = "query";
    private static final String FRAGMENT_RESPONSE_MODE = "fragment";
    private static final String FORM_POST_RESPONSE_MODE = "form_post";

    private OAuth2Util() {
    }

    public static OAuthAuthzReqMessageContext getAuthzRequestContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retreived OAuthAuthzReqMessageContext from threadlocal");
        }
        return authzRequestContext.get();
    }

    public static void setAuthzRequestContext(OAuthAuthzReqMessageContext context) {
        authzRequestContext.set(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added OAuthAuthzReqMessageContext to threadlocal");
        }
    }

    public static void clearAuthzRequestContext() {
        authzRequestContext.remove();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleared OAuthAuthzReqMessageContext");
        }
    }

    public static OAuthTokenReqMessageContext getTokenRequestContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retreived OAuthTokenReqMessageContext from threadlocal");
        }
        return tokenRequestContext.get();
    }

    public static void setTokenRequestContext(OAuthTokenReqMessageContext context) {
        tokenRequestContext.set(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added OAuthTokenReqMessageContext to threadlocal");
        }
    }

    public static void clearTokenRequestContext() {
        tokenRequestContext.remove();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleared OAuthTokenReqMessageContext");
        }
    }

    public static int getClientTenatId() {
        if (clientTenantId.get() == null) {
            return -1;
        }
        return clientTenantId.get();
    }

    public static void setClientTenatId(int tenantId) {
        Integer id = tenantId;
        clientTenantId.set(id);
    }

    public static void clearClientTenantId() {
        clientTenantId.remove();
    }

    public static String buildScopeString(String[] scopes) {
        if (scopes != null) {
            Arrays.sort(scopes);
            return StringUtils.join((Object[])scopes, (String)" ");
        }
        return null;
    }

    public static String[] buildScopeArray(String scopeStr) {
        if (StringUtils.isNotBlank((String)scopeStr)) {
            scopeStr = scopeStr.trim();
            return scopeStr.split("\\s");
        }
        return new String[0];
    }

    public static boolean authenticateClient(String clientId, String clientSecretProvided) throws IdentityOAuthAdminException, IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO appDO = OAuth2Util.getAppInformationByClientId(clientId);
        if (appDO == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find a valid application with the provided client_id: " + clientId));
            }
            return false;
        }
        boolean isHashDisabled = OAuth2Util.isHashDisabled();
        String appClientSecret = appDO.getOauthConsumerSecret();
        if (isHashDisabled) {
            if (!StringUtils.equals((String)appClientSecret, (String)clientSecretProvided)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided the Client ID : " + clientId + " and Client Secret do not match with the issued credentials."));
                }
                return false;
            }
        } else {
            TokenPersistenceProcessor persistenceProcessor = OAuth2Util.getPersistenceProcessor();
            String processedProvidedClientSecret = persistenceProcessor.getProcessedClientSecret(clientSecretProvided);
            if (!StringUtils.equals((String)appClientSecret, (String)processedProvidedClientSecret)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided the Client ID : " + clientId + " and Client Secret do not match with the issued credentials."));
                }
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully authenticated the client with client id : " + clientId));
        }
        return true;
    }

    public static TokenPersistenceProcessor getPersistenceProcessor() {
        TokenPersistenceProcessor persistenceProcessor;
        try {
            persistenceProcessor = OAuthServerConfiguration.getInstance().getPersistenceProcessor();
        }
        catch (IdentityOAuth2Exception e) {
            String msg = "Error retrieving TokenPersistenceProcessor configured in OAuth.TokenPersistenceProcessor in identity.xml. Defaulting to PlainTextPersistenceProcessor.";
            log.warn((Object)msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)((Object)e));
            }
            persistenceProcessor = new PlainTextPersistenceProcessor();
        }
        return persistenceProcessor;
    }

    public static boolean isHashDisabled() {
        boolean isHashEnabled = OAuthServerConfiguration.getInstance().isClientSecretHashEnabled();
        return !isHashEnabled;
    }

    public static boolean isHashEnabled() {
        boolean isHashEnabled = OAuthServerConfiguration.getInstance().isClientSecretHashEnabled();
        return isHashEnabled;
    }

    public static String getAuthenticatedUsername(String clientId, String clientSecretProvided) throws IdentityOAuthAdminException, IdentityOAuth2Exception, InvalidOAuthClientException {
        boolean cacheHit = false;
        String username = null;
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive(username);
        if (OAuth2Util.authenticateClient(clientId, clientSecretProvided)) {
            CacheEntry cacheResult = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(new OAuthCacheKey(clientId + ":" + username)));
            if (cacheResult != null && cacheResult instanceof ClientCredentialDO) {
                username = ((ClientCredentialDO)cacheResult).getClientSecret();
                cacheHit = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Username was available in the cache : " + username));
                }
            }
            if (username == null) {
                OAuthConsumerDAO oAuthConsumerDAO = new OAuthConsumerDAO();
                username = oAuthConsumerDAO.getAuthenticatedUsername(clientId, clientSecretProvided);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Username fetch from the database");
                }
            }
            if (username != null && !cacheHit) {
                if (isUsernameCaseSensitive) {
                    OAuthCache.getInstance().addToCache(new OAuthCacheKey(clientId + ":" + username), (Serializable)((Object)new ClientCredentialDO(username)));
                } else {
                    OAuthCache.getInstance().addToCache(new OAuthCacheKey(clientId + ":" + username.toLowerCase()), (Serializable)((Object)new ClientCredentialDO(username)));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caching username : " + username));
                }
            }
        }
        return username;
    }

    public static String buildCacheKeyStringForAuthzCode(String clientId, String authzCode) {
        return clientId + ":" + authzCode;
    }

    @Deprecated
    public static String buildCacheKeyStringForToken(String clientId, String scope, String authorizedUser) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (isUsernameCaseSensitive) {
            return clientId + ":" + authorizedUser + ":" + scope;
        }
        return clientId + ":" + authorizedUser.toLowerCase() + ":" + scope;
    }

    @Deprecated
    public static String buildCacheKeyStringForToken(String clientId, String scope, String authorizedUser, String authenticatedIDP) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (isUsernameCaseSensitive) {
            return clientId + ":" + authorizedUser + ":" + scope + ":" + authenticatedIDP;
        }
        return clientId + ":" + authorizedUser.toLowerCase() + ":" + scope + ":" + authenticatedIDP;
    }

    public static String buildCacheKeyStringForToken(String clientId, String scope, String authorizedUser, String authenticatedIDP, String tokenBindingReference) {
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)authorizedUser);
        if (isUsernameCaseSensitive) {
            return clientId + ":" + authorizedUser + ":" + scope + ":" + authenticatedIDP + ":" + tokenBindingReference;
        }
        return clientId + ":" + authorizedUser.toLowerCase() + ":" + scope + ":" + authenticatedIDP + ":" + tokenBindingReference;
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"})
    public static String getTokenBindingReference(String tokenBindingValue) {
        if (StringUtils.isBlank((String)tokenBindingValue)) {
            return null;
        }
        return DigestUtils.md5Hex((String)tokenBindingValue);
    }

    public static AccessTokenDO validateAccessTokenDO(AccessTokenDO accessTokenDO) {
        long refreshValidityPeriodMillis;
        long refreshTokenValidityMillis;
        long validityPeriodMillis = accessTokenDO.getValidityPeriodInMillis();
        long issuedTime = accessTokenDO.getIssuedTime().getTime();
        long accessTokenValidityMillis = OAuth2Util.getTimeToExpire(issuedTime, validityPeriodMillis);
        if (accessTokenValidityMillis > 1000L && (refreshTokenValidityMillis = OAuth2Util.getTimeToExpire(issuedTime, refreshValidityPeriodMillis = OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L)) > 1000L) {
            accessTokenDO.setValidityPeriodInMillis(accessTokenValidityMillis);
            accessTokenDO.setRefreshTokenValidityPeriodInMillis(refreshTokenValidityMillis);
            accessTokenDO.setIssuedTime(new Timestamp(issuedTime));
            return accessTokenDO;
        }
        return null;
    }

    public static boolean checkAccessTokenPartitioningEnabled() {
        return OAuthServerConfiguration.getInstance().isAccessTokenPartitioningEnabled();
    }

    public static boolean checkUserNameAssertionEnabled() {
        return OAuthServerConfiguration.getInstance().isUserNameAssertionEnabled();
    }

    public static String getAccessTokenPartitioningDomains() {
        return OAuthServerConfiguration.getInstance().getAccessTokenPartitioningDomains();
    }

    public static Map<String, String> getAvailableUserStoreDomainMappings() throws IdentityOAuth2Exception {
        TreeMap<String, String> userStoreDomainMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String domainsStr = OAuth2Util.getAccessTokenPartitioningDomains();
        if (domainsStr != null) {
            String[] userStoreDomainsArr;
            for (String userStoreDomains : userStoreDomainsArr = domainsStr.split(",")) {
                String[] mapping = userStoreDomains.trim().split(":");
                if (mapping.length < 2) {
                    throw new IdentityOAuth2Exception("Domain mapping has not defined correctly");
                }
                userStoreDomainMap.put(mapping[1].trim(), mapping[0].trim());
            }
        }
        return userStoreDomainMap;
    }

    public static String getMappedUserStoreDomain(String userStoreDomain) throws IdentityOAuth2Exception {
        String mappedUserStoreDomain = userStoreDomain;
        Map<String, String> availableDomainMappings = OAuth2Util.getAvailableUserStoreDomainMappings();
        if (userStoreDomain != null && availableDomainMappings.containsKey(userStoreDomain)) {
            mappedUserStoreDomain = availableDomainMappings.get(userStoreDomain);
        }
        return mappedUserStoreDomain;
    }

    public static String getPartitionedTableByUserStore(String tableName, String userStoreDomain) throws IdentityOAuth2Exception {
        if (StringUtils.isNotBlank((String)tableName) && StringUtils.isNotBlank((String)userStoreDomain) && !IdentityUtil.getPrimaryDomainName().equalsIgnoreCase(userStoreDomain)) {
            String mappedUserStoreDomain = OAuth2Util.getMappedUserStoreDomain(userStoreDomain);
            tableName = tableName + "_" + mappedUserStoreDomain;
        }
        return tableName;
    }

    public static String getTokenPartitionedSqlByUserStore(String sql, String userStoreDomain) throws IdentityOAuth2Exception {
        String partitionedSql = sql;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            String partitionedAccessTokenTable = OAuth2Util.getPartitionedTableByUserStore("IDN_OAUTH2_ACCESS_TOKEN", userStoreDomain);
            String accessTokenScopeTable = "IDN_OAUTH2_ACCESS_TOKEN_SCOPE";
            String partitionedAccessTokenScopeTable = OAuth2Util.getPartitionedTableByUserStore(accessTokenScopeTable, userStoreDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("PartitionedAccessTokenTable: " + partitionedAccessTokenTable + " & PartitionedAccessTokenScopeTable: " + partitionedAccessTokenScopeTable + " for user store domain: " + userStoreDomain));
            }
            String wordBoundaryRegex = "\\b";
            partitionedSql = sql.replaceAll(wordBoundaryRegex + "IDN_OAUTH2_ACCESS_TOKEN" + wordBoundaryRegex, partitionedAccessTokenTable);
            partitionedSql = partitionedSql.replaceAll(wordBoundaryRegex + accessTokenScopeTable + wordBoundaryRegex, partitionedAccessTokenScopeTable);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Original SQL: " + sql));
                log.debug((Object)("Partitioned SQL: " + partitionedSql));
            }
        }
        return partitionedSql;
    }

    public static String getTokenPartitionedSqlByUserId(String sql, String username) throws IdentityOAuth2Exception {
        String partitionedSql = sql;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            String[] strArr;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculating partitioned sql for username: " + username));
            }
            String userStore = null;
            if (username != null && (strArr = username.split(UserCoreConstants.DOMAIN_SEPARATOR)) != null && strArr.length > 1) {
                userStore = strArr[0];
            }
            partitionedSql = OAuth2Util.getTokenPartitionedSqlByUserStore(sql, userStore);
        }
        return partitionedSql;
    }

    public static String getTokenPartitionedSqlByToken(String sql, String token) throws IdentityOAuth2Exception {
        String partitionedSql = sql;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Calculating partitioned sql for token: " + token));
                } else {
                    log.debug((Object)"Calculating partitioned sql for token");
                }
            }
            String userId = OAuth2Util.getUserIdFromAccessToken(token);
            partitionedSql = OAuth2Util.getTokenPartitionedSqlByUserId(sql, userId);
        }
        return partitionedSql;
    }

    public static String getUserStoreDomainFromUserId(String userId) throws IdentityOAuth2Exception {
        String[] strArr;
        String userStoreDomain = null;
        if (userId != null && (strArr = userId.split(UserCoreConstants.DOMAIN_SEPARATOR)) != null && strArr.length > 1) {
            userStoreDomain = OAuth2Util.getMappedUserStoreDomain(strArr[0]);
        }
        return userStoreDomain;
    }

    public static String getUserStoreDomainFromAccessToken(String apiKey) throws IdentityOAuth2Exception {
        String userId;
        String userStoreDomain = null;
        String decodedKey = new String(Base64.decodeBase64((byte[])apiKey.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
        String[] tmpArr = decodedKey.split(":");
        if (tmpArr != null && (userId = tmpArr[1]) != null) {
            userStoreDomain = OAuth2Util.getUserStoreDomainFromUserId(userId);
        }
        return userStoreDomain;
    }

    @Deprecated
    public static String getAccessTokenStoreTableFromUserId(String userId) throws IdentityOAuth2Exception {
        String[] strArr;
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (userId != null && (strArr = userId.split(UserCoreConstants.DOMAIN_SEPARATOR)).length > 1) {
            String userStore = strArr[0];
            accessTokenStoreTable = OAuth2Util.getPartitionedTableByUserStore("IDN_OAUTH2_ACCESS_TOKEN", userStore);
        }
        return accessTokenStoreTable;
    }

    @Deprecated
    public static String getAccessTokenStoreTableFromAccessToken(String apiKey) throws IdentityOAuth2Exception {
        String userId = OAuth2Util.getUserIdFromAccessToken(apiKey);
        return OAuth2Util.getAccessTokenStoreTableFromUserId(userId);
    }

    public static String getUserIdFromAccessToken(String apiKey) {
        String userId = null;
        String decodedKey = new String(Base64.decodeBase64((byte[])apiKey.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
        String[] tmpArr = decodedKey.split(":");
        if (tmpArr != null && tmpArr.length > 1) {
            userId = tmpArr[1];
        }
        return userId;
    }

    public static long getTokenExpireTimeMillis(AccessTokenDO accessTokenDO) {
        if (accessTokenDO == null) {
            throw new IllegalArgumentException("accessTokenDO is 'NULL'");
        }
        long accessTokenValidity = OAuth2Util.getAccessTokenExpireMillis(accessTokenDO);
        long refreshTokenValidity = OAuth2Util.getRefreshTokenExpireTimeMillis(accessTokenDO);
        if (accessTokenValidity > 1000L && (refreshTokenValidity > 1000L || refreshTokenValidity < 0L)) {
            return accessTokenValidity;
        }
        return 0L;
    }

    public static long getRefreshTokenExpireTimeMillis(AccessTokenDO accessTokenDO) {
        if (accessTokenDO == null) {
            throw new IllegalArgumentException("accessTokenDO is 'NULL'");
        }
        long refreshTokenValidityPeriodMillis = accessTokenDO.getRefreshTokenValidityPeriodInMillis();
        if (refreshTokenValidityPeriodMillis < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Refresh Token has infinite lifetime");
            }
            return -1L;
        }
        long refreshTokenIssuedTime = accessTokenDO.getRefreshTokenIssuedTime().getTime();
        long refreshTokenValidity = OAuth2Util.getTimeToExpire(refreshTokenIssuedTime, refreshTokenValidityPeriodMillis);
        if (refreshTokenValidity > 1000L) {
            return refreshTokenValidity;
        }
        return 0L;
    }

    public static long getAccessTokenExpireMillis(AccessTokenDO accessTokenDO) {
        if (accessTokenDO == null) {
            throw new IllegalArgumentException("accessTokenDO is 'NULL'");
        }
        long validityPeriodMillis = accessTokenDO.getValidityPeriodInMillis();
        if (validityPeriodMillis < 0L) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Access Token(hashed) : " + DigestUtils.sha256Hex((String)accessTokenDO.getAccessToken()) + " has infinite lifetime"));
                } else {
                    log.debug((Object)"Access Token has infinite lifetime");
                }
            }
            return -1L;
        }
        long issuedTime = accessTokenDO.getIssuedTime().getTime();
        long validityMillis = OAuth2Util.getTimeToExpire(issuedTime, validityPeriodMillis);
        if (validityMillis > 1000L) {
            return validityMillis;
        }
        return 0L;
    }

    @Deprecated
    public static long calculateValidityInMillis(long issuedTimeInMillis, long validityPeriodMillis) {
        return OAuth2Util.getTimeToExpire(issuedTimeInMillis, validityPeriodMillis);
    }

    public static long getTimeToExpire(long issuedTimeInMillis, long validityPeriodMillis) {
        return issuedTimeInMillis + validityPeriodMillis - (System.currentTimeMillis() - timestampSkew);
    }

    public static int getTenantId(String tenantDomain) throws IdentityOAuth2Exception {
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        try {
            return realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String error = "Error in obtaining tenant ID from tenant domain : " + tenantDomain;
            throw new IdentityOAuth2Exception(error, e);
        }
    }

    public static String getTenantDomain(int tenantId) throws IdentityOAuth2Exception {
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        try {
            return realmService.getTenantManager().getDomain(tenantId);
        }
        catch (UserStoreException e) {
            String error = "Error in obtaining tenant domain from tenant ID : " + tenantId;
            throw new IdentityOAuth2Exception(error, e);
        }
    }

    public static int getTenantIdFromUserName(String username) throws IdentityOAuth2Exception {
        String domainName = MultitenantUtils.getTenantDomain((String)username);
        return OAuth2Util.getTenantId(domainName);
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"})
    public static String hashScopes(String[] scope) {
        return DigestUtils.md5Hex((String)OAuth2Util.buildScopeString(scope));
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"})
    public static String hashScopes(String scope) {
        if (scope != null) {
            return DigestUtils.md5Hex((String)OAuth2Util.buildScopeString(OAuth2Util.buildScopeArray(scope)));
        }
        return null;
    }

    public static AuthenticatedUser getUserFromUserName(String username) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)username)) {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            String tenantAwareUsernameWithNoUserDomain = UserCoreUtil.removeDomainFromName((String)tenantAwareUsername);
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)username).toUpperCase();
            AuthenticatedUser user = new AuthenticatedUser();
            user.setUserName(tenantAwareUsernameWithNoUserDomain);
            user.setTenantDomain(tenantDomain);
            user.setUserStoreDomain(userStoreDomain);
            return user;
        }
        throw new IllegalArgumentException("Cannot create user from empty user name");
    }

    public static String getIDTokenIssuer() {
        String issuer = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenIssuerIdentifier();
        if (StringUtils.isBlank((String)issuer)) {
            issuer = OAuthURL.getOAuth2TokenEPUrl();
        }
        return issuer;
    }

    private static String buildUrl(String defaultContext, Supplier<String> getValueFromFileBasedConfig) {
        String oauth2EndpointURLInFile = null;
        if (getValueFromFileBasedConfig != null) {
            oauth2EndpointURLInFile = getValueFromFileBasedConfig.get();
        }
        return OAuth2Util.buildServiceUrl(defaultContext, oauth2EndpointURLInFile);
    }

    public static String buildServiceUrl(String defaultContext, String oauth2EndpointURLInFile) {
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            try {
                return ServiceURLBuilder.create().addPath(new String[]{defaultContext}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException e) {
                throw new OAuthRuntimeException("Error while building url for context: " + defaultContext);
            }
        }
        if (StringUtils.isNotBlank((String)oauth2EndpointURLInFile)) {
            return oauth2EndpointURLInFile;
        }
        try {
            return ServiceURLBuilder.create().addPath(new String[]{defaultContext}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw new OAuthRuntimeException("Error while building url for context: " + defaultContext);
        }
    }

    private static boolean isNotSuperTenant(String tenantDomain) {
        return StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equals(tenantDomain);
    }

    public static boolean isOIDCAuthzRequest(Set<String> scope) {
        return scope.contains(OPENID_SCOPE);
    }

    public static boolean isOIDCAuthzRequest(String[] scope) {
        for (String openidscope : scope) {
            if (!openidscope.equals(OPENID_SCOPE)) continue;
            return true;
        }
        return false;
    }

    public static boolean validatePKCECodeVerifier(String codeVerifier) {
        Matcher pkceCodeVerifierMatcher = pkceCodeVerifierPattern.matcher(codeVerifier);
        return pkceCodeVerifierMatcher.matches() && codeVerifier.length() >= 43 && codeVerifier.length() <= 128;
    }

    public static boolean validatePKCECodeChallenge(String codeChallenge, String codeChallengeMethod) {
        if (codeChallengeMethod == null || "plain".equals(codeChallengeMethod)) {
            return OAuth2Util.validatePKCECodeVerifier(codeChallenge);
        }
        return "S256".equals(codeChallengeMethod) && codeChallenge != null && codeChallenge.trim().length() == 43;
    }

    @Deprecated
    public static boolean doPKCEValidation(String referenceCodeChallenge, String codeVerifier, String challengeMethod, OAuthAppDO oAuthAppDO) throws IdentityOAuth2Exception {
        return OAuth2Util.validatePKCE(referenceCodeChallenge, codeVerifier, challengeMethod, oAuthAppDO);
    }

    public static boolean validatePKCE(String referenceCodeChallenge, String verificationCode, String challengeMethod, OAuthAppDO oAuthApp) throws IdentityOAuth2Exception {
        block15: {
            if (oAuthApp != null && oAuthApp.isPkceMandatory() || referenceCodeChallenge != null) {
                if (challengeMethod == null || challengeMethod.trim().length() == 0) {
                    challengeMethod = "plain";
                }
                if (verificationCode == null || verificationCode.trim().length() == 0) {
                    if (oAuthApp.isPkceMandatory()) {
                        throw new IdentityOAuth2Exception("No PKCE code verifier found.PKCE is mandatory for this oAuth 2.0 application.");
                    }
                    if (referenceCodeChallenge == null || referenceCodeChallenge.trim().length() == 0) {
                        return true;
                    }
                    throw new IdentityOAuth2Exception("Empty PKCE code_verifier sent. This authorization code requires a PKCE verification to obtain an access token.");
                }
                if (!OAuth2Util.validatePKCECodeVerifier(verificationCode)) {
                    throw new IdentityOAuth2Exception("Code verifier used is not up to RFC 7636 specifications.");
                }
                if ("plain".equals(challengeMethod)) {
                    if (!oAuthApp.isPkceSupportPlain()) {
                        throw new IdentityOAuth2Exception("This application does not allow 'plain' transformation algorithm.");
                    }
                    if (!referenceCodeChallenge.equals(verificationCode)) {
                        return false;
                    }
                } else {
                    if ("S256".equals(challengeMethod)) {
                        try {
                            MessageDigest messageDigest = MessageDigest.getInstance(SHA256);
                            byte[] hash = messageDigest.digest(verificationCode.getBytes(StandardCharsets.US_ASCII));
                            String referencePKCECodeChallenge = new String(Base64.encodeBase64URLSafe((byte[])hash), StandardCharsets.UTF_8).trim();
                            if (!referencePKCECodeChallenge.equals(referenceCodeChallenge)) {
                                return false;
                            }
                            break block15;
                        }
                        catch (NoSuchAlgorithmException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Failed to create SHA256 Message Digest.");
                            }
                            return false;
                        }
                    }
                    throw new IdentityOAuth2Exception("Invalid OAuth2 Token Response. Invalid PKCE Code Challenge Method '" + challengeMethod + "'");
                }
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isPKCESupportEnabled() {
        return OAuth2ServiceComponentHolder.isPkceEnabled();
    }

    public static boolean isImplicitResponseType(String responseType) {
        return StringUtils.isNotBlank((String)responseType) && "id_token".equals(responseType) || "token".equals(responseType) || "id_token token".equals(responseType);
    }

    public static boolean isHybridResponseType(String responseType) {
        return StringUtils.isNotBlank((String)responseType) && "code token".equals(responseType) || "code id_token".equals(responseType) || "code id_token token".equals(responseType);
    }

    public static void initiateOIDCScopes(int tenantId) {
        List<ScopeDTO> scopeClaimsList = OAuth2Util.loadScopeConfigFile();
        try {
            OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().addScopes(tenantId, scopeClaimsList);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
    }

    public static List<String> getOIDCScopes(String tenantDomain) {
        ArrayList<String> scopes = new ArrayList<String>();
        try {
            int tenantId = OAuthComponentServiceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            List<ScopeDTO> scopesDTOList = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().getScopes(tenantId);
            if (CollectionUtils.isNotEmpty(scopesDTOList)) {
                for (ScopeDTO scope : scopesDTOList) {
                    scopes.add(scope.getName());
                }
            }
        }
        catch (IdentityOAuth2Exception | UserStoreException e) {
            log.error((Object)"Error while retrieving OIDC scopes.", (Throwable)e);
        }
        return scopes;
    }

    public static AccessTokenDO getAccessTokenDOfromTokenIdentifier(String accessTokenIdentifier) throws IdentityOAuth2Exception {
        return OAuth2Util.getAccessTokenDOFromTokenIdentifier(accessTokenIdentifier, false);
    }

    public static AccessTokenDO getAccessTokenDOFromTokenIdentifier(String accessTokenIdentifier, boolean includeExpired) throws IdentityOAuth2Exception {
        boolean cacheHit = false;
        AccessTokenDO accessTokenDO = null;
        String processedToken = OAuth2Util.getPersistenceProcessor().getProcessedAccessTokenIdentifier(accessTokenIdentifier);
        OAuthCacheKey cacheKey = new OAuthCacheKey(accessTokenIdentifier);
        CacheEntry result = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(cacheKey));
        if (result != null && result instanceof AccessTokenDO) {
            accessTokenDO = (AccessTokenDO)result;
            cacheHit = true;
        }
        if (accessTokenDO == null) {
            accessTokenDO = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessToken(accessTokenIdentifier, includeExpired);
        }
        if (accessTokenDO == null) {
            throw new IllegalArgumentException("Invalid Access Token. Access token is not ACTIVE.");
        }
        if (!cacheHit & OAuth2Util.isHashDisabled()) {
            OAuthCache.getInstance().addToCache(cacheKey, (Serializable)((Object)accessTokenDO));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access Token Info object was added back to the cache.");
            }
        }
        return accessTokenDO;
    }

    public static String getClientIdForAccessToken(String accessTokenIdentifier) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO = OAuth2Util.getAccessTokenDOfromTokenIdentifier(accessTokenIdentifier);
        return accessTokenDO.getConsumerKey();
    }

    @Deprecated
    public static void initTokenExpiryTimesOfSps(int tenantId) {
        try {
            UserRegistry registry = OAuth2ServiceComponentHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            if (!registry.resourceExists("/identity/config/spTokenExpireTime")) {
                Resource resource = registry.newResource();
                registry.put("/identity/config/spTokenExpireTime", resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating registry collection for :/identity/config/spTokenExpireTime", (Throwable)e);
        }
    }

    @Deprecated
    public static SpOAuth2ExpiryTimeConfiguration getSpTokenExpiryTimeConfig(String consumerKey, int tenantId) {
        SpOAuth2ExpiryTimeConfiguration spTokenTimeObject;
        block19: {
            spTokenTimeObject = new SpOAuth2ExpiryTimeConfiguration();
            try {
                String errorMsg;
                JSONObject spTimeObject;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SP wise token expiry time feature is applied for tenant id : " + tenantId + "and consumer key : " + consumerKey));
                }
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)OAuth2Util.getTenantDomain(tenantId));
                Registry registry = IdentityTenantUtil.getConfigRegistry((int)tenantId);
                if (!registry.resourceExists("/identity/config/spTokenExpireTime")) break block19;
                Resource resource = registry.get("/identity/config/spTokenExpireTime");
                String jsonString = "{}";
                Object consumerKeyObject = resource.getProperties().get(consumerKey);
                if (consumerKeyObject instanceof List && !((List)consumerKeyObject).isEmpty()) {
                    jsonString = ((List)consumerKeyObject).get(0).toString();
                }
                if ((spTimeObject = new JSONObject(jsonString)).length() <= 0) break block19;
                if (spTimeObject.has(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS) && !spTimeObject.isNull(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS)) {
                    try {
                        spTokenTimeObject.setUserAccessTokenExpiryTime(Long.parseLong(spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The user access token expiry time :" + spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + "  for application id : " + consumerKey));
                        }
                    }
                    catch (NumberFormatException e) {
                        errorMsg = String.format("Invalid value provided as user access token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value", consumerKey, tenantId, spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                        log.error((Object)errorMsg, (Throwable)e);
                    }
                } else {
                    spTokenTimeObject.setUserAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L);
                }
                if (spTimeObject.has(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS) && !spTimeObject.isNull(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS)) {
                    try {
                        spTokenTimeObject.setApplicationAccessTokenExpiryTime(Long.parseLong(spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The application access token expiry time :" + spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + "  for application id : " + consumerKey));
                        }
                    }
                    catch (NumberFormatException e) {
                        errorMsg = String.format("Invalid value provided as application access token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value ", consumerKey, tenantId, spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                        log.error((Object)errorMsg, (Throwable)e);
                    }
                } else {
                    spTokenTimeObject.setApplicationAccessTokenExpiryTime(OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() * 1000L);
                }
                if (spTimeObject.has(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS) && !spTimeObject.isNull(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS)) {
                    try {
                        spTokenTimeObject.setRefreshTokenExpiryTime(Long.parseLong(spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The refresh token expiry time :" + spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + " for application id : " + consumerKey));
                        }
                        break block19;
                    }
                    catch (NumberFormatException e) {
                        errorMsg = String.format("Invalid value provided as refresh token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value", consumerKey, tenantId, spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                        log.error((Object)errorMsg, (Throwable)e);
                    }
                    break block19;
                }
                spTokenTimeObject.setRefreshTokenExpiryTime(OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L);
            }
            catch (RegistryException e) {
                log.error((Object)"Error while getting data from the registry.", (Throwable)e);
            }
            catch (IdentityException e) {
                log.error((Object)("Error while getting the tenant domain from tenant id : " + tenantId), (Throwable)e);
            }
        }
        return spTokenTimeObject;
    }

    public static List<String> getOIDCAudience(String clientId, OAuthAppDO oAuthAppDO) {
        List<String> oidcAudiences = OAuth2Util.getDefinedCustomOIDCAudiences(oAuthAppDO);
        if (!oidcAudiences.contains(clientId)) {
            oidcAudiences.add(0, clientId);
        } else {
            Collections.swap(oidcAudiences, oidcAudiences.indexOf(clientId), 0);
        }
        return oidcAudiences;
    }

    private static List<String> getDefinedCustomOIDCAudiences(OAuthAppDO oAuthAppDO) {
        ArrayList<String> audiences = new ArrayList();
        if (OAuth2ServiceComponentHolder.isAudienceEnabled() && CollectionUtils.isNotEmpty(audiences = OAuth2Util.getAudienceListFromOAuthAppDO(oAuthAppDO))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OIDC Audiences " + audiences + " had been retrieved for the client_id: " + oAuthAppDO.getOauthConsumerKey()));
            }
            return audiences;
        }
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement oauthElem = configParser.getConfigElement(CONFIG_ELEM_OAUTH);
        if (oauthElem == null) {
            log.warn((Object)"Error in OAuth Configuration: <OAuth> configuration element is not available in identity.xml.");
            return audiences;
        }
        OMElement oidcConfig = oauthElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", OPENID_CONNECT));
        if (oidcConfig == null) {
            log.warn((Object)"Error in OAuth Configuration: <OpenIDConnect> element is not available in identity.xml.");
            return audiences;
        }
        OMElement audienceConfig = oidcConfig.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", OPENID_CONNECT_AUDIENCES));
        if (audienceConfig == null) {
            return audiences;
        }
        Iterator iterator = audienceConfig.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", OPENID_CONNECT_AUDIENCE_IDENTITY_CONFIG));
        while (iterator.hasNext()) {
            String supportedAudienceName;
            OMElement supportedAudience = (OMElement)iterator.next();
            if (supportedAudience == null || !StringUtils.isNotBlank((String)(supportedAudienceName = IdentityUtil.fillURLPlaceholders((String)supportedAudience.getText())))) continue;
            audiences.add(supportedAudienceName);
        }
        return audiences;
    }

    private static List<String> getAudienceListFromOAuthAppDO(OAuthAppDO oAuthAppDO) {
        if (oAuthAppDO.getAudiences() == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(oAuthAppDO.getAudiences()));
    }

    public static OauthTokenIssuer getOAuthTokenIssuerForOAuthApp(String clientId) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO appDO;
        try {
            appDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (IdentityOAuth2Exception e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + clientId, (Throwable)((Object)e));
        }
        return OAuth2Util.getOAuthTokenIssuerForOAuthApp(appDO);
    }

    public static OauthTokenIssuer getOAuthTokenIssuerForOAuthApp(OAuthAppDO appDO) throws IdentityOAuth2Exception {
        OauthTokenIssuer oauthIdentityTokenGenerator;
        if (appDO.getTokenType() != null) {
            oauthIdentityTokenGenerator = OAuthServerConfiguration.getInstance().addAndReturnTokenIssuerInstance(appDO.getTokenType());
            if (oauthIdentityTokenGenerator == null) {
                oauthIdentityTokenGenerator = OAuthServerConfiguration.getInstance().getIdentityOauthTokenIssuer();
            }
        } else {
            oauthIdentityTokenGenerator = OAuthServerConfiguration.getInstance().getIdentityOauthTokenIssuer();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token type is not set for service provider app with client Id: " + appDO.getOauthConsumerKey() + ". Hence the default Identity OAuth token issuer will be used. No custom token generator is set."));
            }
        }
        return oauthIdentityTokenGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ScopeDTO> loadScopeConfigFile() {
        ArrayList<ScopeDTO> listOIDCScopesClaims = new ArrayList<ScopeDTO>();
        String configDirPath = CarbonUtils.getCarbonConfigDirPath();
        String confXml = Paths.get(configDirPath, IDENTITY_PATH, "oidc-scope-config.xml").toString();
        File configfile = new File(confXml);
        if (!configfile.exists()) {
            log.warn((Object)("OIDC scope-claim Configuration File is not present at: " + confXml));
        }
        XMLStreamReader parser = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configfile);
            parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                ScopeDTO scope = new ScopeDTO();
                OMElement omElement = (OMElement)iterator.next();
                String configType = omElement.getAttributeValue(new QName("id"));
                scope.setName(configType);
                scope.setDisplayName(configType);
                scope.setClaim(OAuth2Util.loadClaimConfig(omElement));
                listOIDCScopesClaims.add(scope);
            }
        }
        catch (XMLStreamException e) {
            log.warn((Object)"Error while loading scope config.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"Error while loading email config.", (Throwable)e);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
                if (stream != null) {
                    IdentityIOStreamUtils.closeInputStream((InputStream)stream);
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while closing XML stream", (Throwable)e);
            }
        }
        return listOIDCScopesClaims;
    }

    private static String[] loadClaimConfig(OMElement configElement) {
        StringBuilder claimConfig = new StringBuilder();
        Iterator it = configElement.getChildElements();
        while (it.hasNext()) {
            String commaSeparatedClaimNames;
            OMElement element = (OMElement)it.next();
            if (!"Claim".equals(element.getLocalName()) || !StringUtils.isNotBlank((String)(commaSeparatedClaimNames = element.getText()))) continue;
            claimConfig.append(commaSeparatedClaimNames.trim());
        }
        return claimConfig.toString().split(",");
    }

    public static OAuthAppDO getAppInformationByClientId(String clientId) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO oAuthAppDO = (OAuthAppDO)AppInfoCache.getInstance().getValueFromCache((Serializable)((Object)clientId));
        if (oAuthAppDO != null) {
            return oAuthAppDO;
        }
        oAuthAppDO = new OAuthAppDAO().getAppInformation(clientId);
        if (oAuthAppDO != null) {
            AppInfoCache.getInstance().addToCache((Serializable)((Object)clientId), oAuthAppDO);
        }
        return oAuthAppDO;
    }

    public static String getTenantDomainOfOauthApp(OAuthAppDO oAuthAppDO) {
        String tenantDomain = "carbon.super";
        if (oAuthAppDO != null && oAuthAppDO.getUser() != null) {
            tenantDomain = oAuthAppDO.getUser().getTenantDomain();
        }
        return tenantDomain;
    }

    public static String getTenantDomainOfOauthApp(String clientId) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        return OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO);
    }

    @Deprecated
    public static String mapSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        return OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm(signatureAlgorithm).getName();
    }

    public static JWEAlgorithm mapEncryptionAlgorithmForJWEAlgorithm(String encryptionAlgorithm) throws IdentityOAuth2Exception {
        JWEAlgorithm jweAlgorithm = JWEAlgorithm.parse((String)encryptionAlgorithm);
        if (jweAlgorithm.getRequirement() != null) {
            return jweAlgorithm;
        }
        throw new IdentityOAuth2Exception("Unsupported Encryption Algorithm: " + encryptionAlgorithm);
    }

    public static EncryptionMethod mapEncryptionMethodForJWEAlgorithm(String encryptionMethod) throws IdentityOAuth2Exception {
        EncryptionMethod method = EncryptionMethod.parse((String)encryptionMethod);
        if (method.getRequirement() != null) {
            return method;
        }
        log.error((Object)"Unsupported Encryption Method in identity.xml");
        throw new IdentityOAuth2Exception("Unsupported Encryption Method: " + encryptionMethod);
    }

    public static JWSAlgorithm mapSignatureAlgorithmForJWSAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        if (NONE.equalsIgnoreCase(signatureAlgorithm)) {
            return new JWSAlgorithm(JWSAlgorithm.NONE.getName());
        }
        if (SHA256_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS256;
        }
        if (SHA384_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS384;
        }
        if (SHA512_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS512;
        }
        if (SHA256_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS256;
        }
        if (SHA384_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS384;
        }
        if (SHA512_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS512;
        }
        if (SHA256_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES256;
        }
        if (SHA384_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES384;
        }
        if (SHA512_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES512;
        }
        if (SHA256_WITH_PS.equals(signatureAlgorithm)) {
            return JWSAlgorithm.PS256;
        }
        log.error((Object)"Unsupported Signature Algorithm in identity.xml");
        throw new IdentityOAuth2Exception("Unsupported Signature Algorithm in identity.xml");
    }

    public static boolean checkAudienceEnabled() {
        String configAudienceValue;
        boolean isAudienceEnabled = false;
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement oauthElem = configParser.getConfigElement(CONFIG_ELEM_OAUTH);
        if (oauthElem == null) {
            log.warn((Object)"Error in OAuth Configuration. OAuth element is not available.");
            return isAudienceEnabled;
        }
        OMElement configOpenIDConnect = oauthElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", OPENID_CONNECT));
        if (configOpenIDConnect == null) {
            log.warn((Object)"Error in OAuth Configuration. OpenID element is not available.");
            return isAudienceEnabled;
        }
        OMElement configAudience = configOpenIDConnect.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", ENABLE_OPENID_CONNECT_AUDIENCES));
        if (configAudience != null && StringUtils.isNotBlank((String)(configAudienceValue = configAudience.getText()))) {
            isAudienceEnabled = Boolean.parseBoolean(configAudienceValue);
        }
        return isAudienceEnabled;
    }

    public static String getFederatedUserDomain(String authenticatedIDP) {
        if (IdentityUtil.isNotBlank((String)authenticatedIDP)) {
            return "FEDERATED:" + authenticatedIDP;
        }
        return "FEDERATED";
    }

    public static boolean validateIdToken(String idToken) {
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        try {
            RSAPublicKey publicKey;
            String tenantDomain;
            String clientId = (String)SignedJWT.parse((String)idToken).getJWTClaimsSet().getAudience().get(0);
            if (isJWTSignedWithSPKey) {
                OAuthAppDO oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
                tenantDomain = OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO);
            } else {
                tenantDomain = MultitenantUtils.getTenantDomain((String)SignedJWT.parse((String)idToken).getJWTClaimsSet().getSubject());
            }
            if (StringUtils.isEmpty((String)tenantDomain)) {
                return false;
            }
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(DOT_SEPARATER, "-");
                String jksName = ksName + ".jks";
                publicKey = (RSAPublicKey)keyStoreManager.getKeyStore(jksName).getCertificate(tenantDomain).getPublicKey();
            } else {
                publicKey = (RSAPublicKey)keyStoreManager.getDefaultPublicKey();
            }
            SignedJWT signedJWT = SignedJWT.parse((String)idToken);
            RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException | ParseException e) {
            log.error((Object)"Error occurred while validating id token signature.");
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while validating id token signature.");
            return false;
        }
    }

    public static String mapDigestAlgorithm(Algorithm signatureAlgorithm) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.ES256.equals((Object)signatureAlgorithm) || JWSAlgorithm.PS256.equals((Object)signatureAlgorithm)) {
            return SHA256;
        }
        if (JWSAlgorithm.RS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.ES384.equals((Object)signatureAlgorithm)) {
            return SHA384;
        }
        if (JWSAlgorithm.RS512.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)signatureAlgorithm) || JWSAlgorithm.ES512.equals((Object)signatureAlgorithm)) {
            return SHA512;
        }
        throw new RuntimeException("Provided signature algorithm: " + signatureAlgorithm + " is not supported");
    }

    public static JWT encryptJWT(JWTClaimsSet jwtClaimsSet, JWEAlgorithm encryptionAlgorithm, EncryptionMethod encryptionMethod, String spTenantDomain, String clientId) throws IdentityOAuth2Exception {
        if (OAuth2Util.isRSAAlgorithm(encryptionAlgorithm)) {
            return OAuth2Util.encryptWithRSA(jwtClaimsSet, encryptionAlgorithm, encryptionMethod, spTenantDomain, clientId);
        }
        throw new RuntimeException("Provided encryption algorithm: " + encryptionAlgorithm + " is not supported");
    }

    private static JWT encryptWithRSA(JWTClaimsSet jwtClaimsSet, JWEAlgorithm encryptionAlgorithm, EncryptionMethod encryptionMethod, String spTenantDomain, String clientId) throws IdentityOAuth2Exception {
        String thumbPrint;
        Certificate publicCert;
        String jwksUri;
        if (StringUtils.isBlank((String)spTenantDomain)) {
            spTenantDomain = "carbon.super";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigned super tenant domain as signing domain when encrypting id token for client_id: " + clientId));
            }
        }
        if (StringUtils.isBlank((String)(jwksUri = OAuth2Util.getSPJwksUrl(clientId, spTenantDomain)))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Jwks uri is not configured for the service provider associated with client_id: %s. Checking for x509 certificate", clientId));
            }
            publicCert = OAuth2Util.getX509CertOfOAuthApp(clientId, spTenantDomain);
            thumbPrint = OAuth2Util.getThumbPrint(publicCert);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Fetching public keys for the client %s from jwks uri %s", clientId, jwksUri));
            }
            publicCert = OAuth2Util.getPublicCertFromJWKS(jwksUri);
            thumbPrint = OAuth2Util.getJwkThumbPrint(publicCert);
        }
        PublicKey publicKey = publicCert.getPublicKey();
        return OAuth2Util.encryptWithPublicKey(publicKey, jwtClaimsSet, encryptionAlgorithm, encryptionMethod, spTenantDomain, clientId, thumbPrint);
    }

    private static JWT encryptWithPublicKey(Key publicKey, JWTClaimsSet jwtClaimsSet, JWEAlgorithm encryptionAlgorithm, EncryptionMethod encryptionMethod, String spTenantDomain, String clientId, String thumbPrint) throws IdentityOAuth2Exception {
        JWEHeader.Builder headerBuilder = new JWEHeader.Builder(encryptionAlgorithm, encryptionMethod);
        try {
            headerBuilder.keyID(thumbPrint);
            JWEHeader header = headerBuilder.build();
            EncryptedJWT encryptedJWT = new EncryptedJWT(header, jwtClaimsSet);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Encrypting JWT using the algorithm: " + encryptionAlgorithm + ", method: " + encryptionMethod + ", tenant: " + spTenantDomain + " & header: " + header.toString()));
            }
            RSAEncrypter encrypter = new RSAEncrypter((RSAPublicKey)publicKey);
            encryptedJWT.encrypt((JWEEncrypter)encrypter);
            return encryptedJWT;
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Error occurred while encrypting JWT for the client_id: " + clientId + " with the tenant domain: " + spTenantDomain, e);
        }
    }

    public static JWSSigner createJWSSigner(RSAPrivateKey privateKey) {
        boolean allowWeakKey = Boolean.parseBoolean(System.getProperty(ALLOW_WEAK_RSA_SIGNER_KEY));
        if (allowWeakKey && log.isDebugEnabled()) {
            log.debug((Object)"System flag 'allow_weak_rsa_signer_key' is  enabled. So weak keys (key length less than 2048)  will be allowed for signing.");
        }
        return new RSASSASigner((PrivateKey)privateKey, allowWeakKey);
    }

    public static JWT signJWT(JWTClaimsSet jwtClaimsSet, JWSAlgorithm signatureAlgorithm, String tenantDomain) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)signatureAlgorithm) || JWSAlgorithm.PS256.equals((Object)signatureAlgorithm)) {
            return OAuth2Util.signJWTWithRSA(jwtClaimsSet, signatureAlgorithm, tenantDomain);
        }
        if (JWSAlgorithm.HS256.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)signatureAlgorithm)) {
            throw new RuntimeException("Provided signature algorithm: " + signatureAlgorithm + " is not supported");
        }
        throw new RuntimeException("Provided signature algorithm: " + signatureAlgorithm + " is not supported");
    }

    public static JWT signJWTWithRSA(JWTClaimsSet jwtClaimsSet, JWSAlgorithm signatureAlgorithm, String tenantDomain) throws IdentityOAuth2Exception {
        try {
            if (StringUtils.isBlank((String)tenantDomain)) {
                tenantDomain = "carbon.super";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Assign super tenant domain as signing domain.");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signing JWT using the algorithm: " + signatureAlgorithm + " & key of the tenant: " + tenantDomain));
            }
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            Key privateKey = OAuth2Util.getPrivateKey(tenantDomain, tenantId);
            JWSSigner signer = OAuth2Util.createJWSSigner((RSAPrivateKey)privateKey);
            JWSHeader.Builder headerBuilder = new JWSHeader.Builder(signatureAlgorithm);
            headerBuilder.keyID(OAuth2Util.getKID(OAuth2Util.getCertificate(tenantDomain, tenantId), signatureAlgorithm, tenantDomain));
            headerBuilder.x509CertThumbprint(new Base64URL(OAuth2Util.getThumbPrint(tenantDomain, tenantId)));
            SignedJWT signedJWT = new SignedJWT(headerBuilder.build(), jwtClaimsSet);
            signedJWT.sign(signer);
            return signedJWT;
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Error occurred while signing JWT", e);
        }
    }

    public static Key getPrivateKey(String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        Key privateKey;
        if (!privateKeys.containsKey(tenantId)) {
            try {
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while loading registry for tenant " + tenantDomain, e);
            }
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(DOT_SEPARATER, "-");
                String jksName = ksName + ".jks";
                privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
            } else {
                try {
                    privateKey = tenantKSM.getDefaultPrivateKey();
                }
                catch (Exception e) {
                    throw new IdentityOAuth2Exception("Error while obtaining private key for super tenant", e);
                }
            }
            privateKeys.put(tenantId, privateKey);
        } else {
            privateKey = privateKeys.get(tenantId);
        }
        return privateKey;
    }

    public static String getKID(String certThumbprint, JWSAlgorithm signatureAlgorithm) {
        return certThumbprint + "_" + signatureAlgorithm.toString();
    }

    public static String getKID(Certificate certificate, JWSAlgorithm signatureAlgorithm, String tenantDomain) throws IdentityOAuth2Exception {
        return OAuth2ServiceComponentHolder.getKeyIDProvider().getKeyId(certificate, signatureAlgorithm, tenantDomain);
    }

    public static String getThumbPrint(String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        try {
            Certificate certificate = OAuth2Util.getCertificate(tenantDomain, tenantId);
            return OAuth2Util.getThumbPrint(certificate);
        }
        catch (Exception e) {
            String error = "Error in obtaining certificate for tenant " + tenantDomain;
            throw new IdentityOAuth2Exception(error, e);
        }
    }

    public static String getThumbPrint(Certificate certificate, String alias) throws IdentityOAuth2Exception {
        return OAuth2Util.getThumbPrint(certificate);
    }

    public static String getThumbPrint(Certificate certificate) throws IdentityOAuth2Exception {
        try {
            MessageDigest digestValue = MessageDigest.getInstance(SHA256);
            byte[] der = certificate.getEncoded();
            digestValue.update(der);
            byte[] digestInBytes = digestValue.digest();
            String publicCertThumbprint = OAuth2Util.hexify(digestInBytes);
            String thumbprint = new String(new Base64(0, null, true).encode(publicCertThumbprint.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Thumbprint value: %s calculated for Certificate: %s using algorithm: %s", thumbprint, certificate, digestValue.getAlgorithm()));
            }
            return thumbprint;
        }
        catch (CertificateEncodingException e) {
            String error = "Error occurred while encoding thumbPrint from certificate.";
            throw new IdentityOAuth2Exception(error, e);
        }
        catch (NoSuchAlgorithmException e) {
            String error = "Error in obtaining SHA-256 thumbprint from certificate.";
            throw new IdentityOAuth2Exception(error, e);
        }
    }

    private static boolean isRSAAlgorithm(JWEAlgorithm algorithm) {
        return JWEAlgorithm.RSA_OAEP.equals((Object)algorithm) || JWEAlgorithm.RSA1_5.equals((Object)algorithm) || JWEAlgorithm.RSA_OAEP_256.equals((Object)algorithm);
    }

    public static Certificate getCertificate(String tenantDomain, int tenantId) throws IdentityOAuth2Exception {
        Certificate publicCert = null;
        if (!publicCerts.containsKey(tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Obtaining certificate for the tenant %s", tenantDomain));
            }
            try {
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while loading registry for tenant " + tenantDomain, e);
            }
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            KeyStore keyStore = null;
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(DOT_SEPARATER, "-");
                String jksName = ksName + ".jks";
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Loading default tenant certificate for tenant : %s from the KeyStore %s", tenantDomain, ksName));
                }
                try {
                    keyStore = tenantKSM.getKeyStore(jksName);
                    publicCert = keyStore.getCertificate(tenantDomain);
                }
                catch (KeyStoreException e) {
                    throw new IdentityOAuth2Exception("Error occurred while loading public certificate for tenant: " + tenantDomain, e);
                }
                catch (Exception e) {
                    throw new IdentityOAuth2Exception("Error occurred while loading Keystore for tenant: " + tenantDomain, e);
                }
            }
            try {
                publicCert = tenantKSM.getDefaultPrimaryCertificate();
            }
            catch (Exception e) {
                throw new IdentityOAuth2Exception("Error occurred while loading default public certificate for tenant: " + tenantDomain, e);
            }
            if (publicCert != null) {
                publicCerts.put(tenantId, publicCert);
            }
        } else {
            publicCert = publicCerts.get(tenantId);
        }
        return publicCert;
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public static List<String> getEssentialClaims(String essentialClaims, String claimType) {
        JSONObject newJSON;
        JSONObject jsonObjectClaims = new JSONObject(essentialClaims);
        ArrayList<String> essentialClaimsList = new ArrayList<String>();
        if (jsonObjectClaims.toString().contains(claimType) && (newJSON = jsonObjectClaims.getJSONObject(claimType)) != null) {
            Iterator keys = newJSON.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (newJSON.isNull(key)) continue;
                String value = newJSON.get(key).toString();
                JSONObject jsonObjectValues = new JSONObject(value);
                Iterator claimKeyValues = jsonObjectValues.keys();
                while (claimKeyValues.hasNext()) {
                    String claimKey = (String)claimKeyValues.next();
                    String claimValue = jsonObjectValues.get(claimKey).toString();
                    if (!Boolean.parseBoolean(claimValue) || !claimKey.equals("essential")) continue;
                    essentialClaimsList.add(key);
                }
            }
        }
        return essentialClaimsList;
    }

    public static String getSanitizedUserStoreDomain(String userStoreDomain) {
        userStoreDomain = StringUtils.isNotBlank((String)userStoreDomain) ? userStoreDomain.toUpperCase() : IdentityUtil.getPrimaryDomainName();
        return userStoreDomain;
    }

    public static String getUserStoreForFederatedUser(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (authenticatedUser == null) {
            throw new IllegalArgumentException("Authenticated user cannot be null");
        }
        String userStoreDomain = OAuth2Util.getUserStoreDomainFromUserId(authenticatedUser.toString());
        if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && authenticatedUser.isFederatedUser()) {
            userStoreDomain = OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() ? "FEDERATED" : OAuth2Util.getFederatedUserDomain(authenticatedUser.getFederatedIdPName());
        }
        return userStoreDomain;
    }

    public static String addUsernameToToken(AuthenticatedUser authenticatedUser, String token) {
        if (authenticatedUser == null) {
            throw new IllegalArgumentException("Authenticated user cannot be null");
        }
        if (StringUtils.isBlank((String)token)) {
            throw new IllegalArgumentException("Token cannot be blank");
        }
        String usernameForToken = authenticatedUser.toString();
        if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && authenticatedUser.isFederatedUser()) {
            usernameForToken = OAuth2Util.getFederatedUserDomain(authenticatedUser.getFederatedIdPName());
            usernameForToken = usernameForToken + UserCoreConstants.DOMAIN_SEPARATOR + authenticatedUser.getAuthenticatedSubjectIdentifier();
        }
        String tokenStrToEncode = token + ":" + usernameForToken;
        return Base64Utils.encode((byte[])tokenStrToEncode.getBytes(Charsets.UTF_8));
    }

    public static boolean isValidJson(String redirectURL) {
        try {
            new JSONObject(redirectURL);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    public static List<String> essentialClaimsFromRequestParam(String claimRequestor, Map<String, List<RequestedClaim>> requestedClaimsFromRequestParam) {
        ArrayList<String> essentialClaimsfromRequestParam = new ArrayList<String>();
        List<RequestedClaim> claimsforClaimRequestor = requestedClaimsFromRequestParam.get(claimRequestor);
        if (CollectionUtils.isNotEmpty(claimsforClaimRequestor)) {
            for (RequestedClaim claimforClaimRequestor : claimsforClaimRequestor) {
                String claim = claimforClaimRequestor.getName();
                if (!claimforClaimRequestor.isEssential()) continue;
                essentialClaimsfromRequestParam.add(claim);
            }
        }
        return essentialClaimsfromRequestParam;
    }

    public static AuthenticatedUser getAuthenticatedUser(AccessTokenDO accessTokenDO) {
        AuthenticatedUser authenticatedUser = null;
        if (accessTokenDO != null) {
            authenticatedUser = accessTokenDO.getAuthzUser();
        }
        if (authenticatedUser != null) {
            authenticatedUser.setFederatedUser(OAuth2Util.isFederatedUser(authenticatedUser));
        }
        return authenticatedUser;
    }

    public static boolean isFederatedUser(AuthenticatedUser authenticatedUser) {
        String userStoreDomain = authenticatedUser.getUserStoreDomain();
        boolean isExplicitlyFederatedUser = StringUtils.startsWith((String)userStoreDomain, (String)"FEDERATED") || authenticatedUser.isFederatedUser();
        boolean isFederatedUserNotMappedToLocalUser = !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal();
        return isExplicitlyFederatedUser && isFederatedUserNotMappedToLocalUser;
    }

    public static ServiceProvider getServiceProvider(String clientId, String tenantDomain) throws IdentityOAuth2Exception {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        try {
            return applicationMgtService.getServiceProviderByClientId(clientId, "oauth2", tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error while obtaining the service provider for client_id: " + clientId + " of tenantDomain: " + tenantDomain, e);
        }
    }

    public static ServiceProvider getServiceProvider(String clientId) throws IdentityOAuth2Exception {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        String tenantDomain = null;
        try {
            tenantDomain = OAuth2Util.getTenantDomainOfOauthApp(clientId);
            return applicationMgtService.getServiceProviderByClientId(clientId, "oauth2", tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error while obtaining the service provider for client_id: " + clientId + " of tenantDomain: " + tenantDomain, e);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Could not find an existing app for clientId: " + clientId, e);
        }
    }

    public static Certificate getX509CertOfOAuthApp(String clientId, String tenantDomain) throws IdentityOAuth2Exception {
        try {
            ServiceProvider serviceProvider = OAuth2Util.getServiceProvider(clientId, tenantDomain);
            String certificateContent = serviceProvider.getCertificateContent();
            if (StringUtils.isNotBlank((String)certificateContent)) {
                return IdentityUtil.convertPEMEncodedContentToCertificate((String)certificateContent);
            }
            throw new IdentityOAuth2Exception("Public certificate not configured for Service Provider with client_id: " + clientId + " of tenantDomain: " + tenantDomain);
        }
        catch (CertificateException e) {
            throw new IdentityOAuth2Exception("Error while building X509 cert of oauth app with client_id: " + clientId + " of tenantDomain: " + tenantDomain, e);
        }
    }

    public static boolean isParsableJWT(String tokenIdentifier) {
        if (StringUtils.isBlank((String)tokenIdentifier)) {
            return false;
        }
        try {
            JWTParser.parse((String)tokenIdentifier);
            return true;
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided token identifier is not a parsable JWT.", (Throwable)e);
            }
            return false;
        }
    }

    public static boolean isJWT(String tokenIdentifier) {
        return StringUtils.countMatches((String)tokenIdentifier, (String)DOT_SEPARATER) == 2;
    }

    public static boolean isIDTokenEncrypted(String idToken) {
        return StringUtils.countMatches((String)idToken, (String)DOT_SEPARATER) == 4;
    }

    @Deprecated
    public static OauthTokenIssuer getTokenIssuer(String accessToken) throws IdentityOAuth2Exception {
        OauthTokenIssuer oauthTokenIssuer = null;
        String consumerKey = null;
        if (OAuth2Util.isJWT(accessToken) || OAuth2Util.isIDTokenEncrypted(accessToken)) {
            oauthTokenIssuer = new JWTTokenIssuer();
        } else {
            try {
                consumerKey = OAuth2Util.getClientIdForAccessToken(accessToken);
                if (consumerKey != null) {
                    oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
                }
            }
            catch (IllegalArgumentException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Consumer key is not found for token identifier: " + accessToken), (Throwable)e);
                }
            }
            catch (InvalidOAuthClientException e) {
                throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + consumerKey, e);
            }
        }
        return oauthTokenIssuer;
    }

    public static void triggerOnTokenExceptionListeners(Throwable exception, Map<String, Object> params) {
        block5: {
            try {
                OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
                if (oAuthEventInterceptorProxy != null) {
                    try {
                        oAuthEventInterceptorProxy.onTokenIssueException(exception, params);
                    }
                    catch (IdentityOAuth2Exception e) {
                        log.error((Object)"Error while invoking OAuthEventInterceptor for onTokenIssueException", (Throwable)((Object)e));
                    }
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Error occurred while executing oAuthEventInterceptorProxy for onTokenIssueException.", e);
            }
        }
    }

    public static void triggerOnIntrospectionExceptionListeners(OAuth2TokenValidationRequestDTO introspectionRequest, OAuth2IntrospectionResponseDTO introspectionResponse) {
        block5: {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("error", introspectionResponse.getError());
            try {
                OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
                if (oAuthEventInterceptorProxy != null) {
                    try {
                        oAuthEventInterceptorProxy.onTokenValidationException(introspectionRequest, params);
                    }
                    catch (IdentityOAuth2Exception e) {
                        log.error((Object)"Error while invoking OAuthEventInterceptor for onTokenValidationException", (Throwable)((Object)e));
                    }
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Error occurred while executing oAuthEventInterceptorProxy for onTokenValidationException.", e);
            }
        }
    }

    public static List<String> getSupportedGrantTypes() {
        Map<String, AuthorizationGrantHandler> supportedGrantTypesMap = OAuthServerConfiguration.getInstance().getSupportedGrantTypes();
        List<String> supportedGrantTypes = new ArrayList<String>();
        if (supportedGrantTypesMap != null && !supportedGrantTypesMap.isEmpty()) {
            supportedGrantTypes = supportedGrantTypesMap.keySet().stream().collect(Collectors.toList());
        }
        return supportedGrantTypes;
    }

    public static List<String> getSupportedClientAuthenticationMethods() {
        ArrayList<String> clientAuthenticationMethods = new ArrayList<String>();
        clientAuthenticationMethods.add(CLIENT_SECRET_BASIC);
        clientAuthenticationMethods.add(CLIENT_SECRET_POST);
        return clientAuthenticationMethods;
    }

    public static List<String> getSupportedCodeChallengeMethods() {
        ArrayList<String> codeChallengeMethods = new ArrayList<String>();
        codeChallengeMethods.add("S256");
        codeChallengeMethods.add("plain");
        return codeChallengeMethods;
    }

    public static List<String> getSupportedResponseModes() {
        ArrayList<String> responseModes = new ArrayList<String>();
        responseModes.add(QUERY_RESPONSE_MODE);
        responseModes.add(FRAGMENT_RESPONSE_MODE);
        responseModes.add(FORM_POST_RESPONSE_MODE);
        return responseModes;
    }

    public static List<String> getRequestObjectSigningAlgValuesSupported() {
        ArrayList<String> requestObjectSigningAlgValues = new ArrayList<String>();
        requestObjectSigningAlgValues.add(JWSAlgorithm.RS256.getName());
        requestObjectSigningAlgValues.add(JWSAlgorithm.RS384.getName());
        requestObjectSigningAlgValues.add(JWSAlgorithm.RS512.getName());
        requestObjectSigningAlgValues.add(JWSAlgorithm.PS256.getName());
        requestObjectSigningAlgValues.add(JWSAlgorithm.NONE.getName());
        return requestObjectSigningAlgValues;
    }

    public static boolean isRequestParameterSupported() {
        return Boolean.TRUE;
    }

    public static boolean isClaimsParameterSupported() {
        return Boolean.TRUE;
    }

    public static String getFederatedIdPFromDomain(String userStoreDomain) {
        String[] tokens;
        if (StringUtils.startsWith((String)userStoreDomain, (String)"FEDERATED") && (tokens = userStoreDomain.split(":")).length == 2) {
            return tokens[1];
        }
        return null;
    }

    @Deprecated
    public static AuthenticatedUser createAuthenticatedUser(String username, String userStoreDomain, String tenantDomain) {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(username);
        authenticatedUser.setTenantDomain(tenantDomain);
        if (StringUtils.startsWith((String)userStoreDomain, (String)"FEDERATED") && !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Federated prefix found in domain: " + userStoreDomain + " for user: " + username + " in tenant domain: " + tenantDomain + ". Flag user as a federated user."));
            }
            authenticatedUser.setFederatedUser(true);
            authenticatedUser.setFederatedIdPName(OAuth2Util.getFederatedIdPFromDomain(userStoreDomain));
        } else {
            authenticatedUser.setUserStoreDomain(userStoreDomain);
        }
        return authenticatedUser;
    }

    public static AuthenticatedUser createAuthenticatedUser(String username, String userStoreDomain, String tenantDomain, String idpName) {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(username);
        authenticatedUser.setTenantDomain(tenantDomain);
        if (StringUtils.startsWith((String)userStoreDomain, (String)"FEDERATED") && !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal()) {
            authenticatedUser.setFederatedUser(true);
            if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                authenticatedUser.setFederatedIdPName(idpName);
            } else {
                authenticatedUser.setFederatedIdPName(OAuth2Util.getFederatedIdPFromDomain(userStoreDomain));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Federated prefix found in domain: " + userStoreDomain + " for user: " + username + " in tenant domain: " + tenantDomain + ". Flag user as a federated user. " + authenticatedUser.getFederatedIdPName() + " is set as the authenticated idp."));
            }
        } else {
            authenticatedUser.setUserStoreDomain(userStoreDomain);
            authenticatedUser.setFederatedIdPName(idpName);
        }
        return authenticatedUser;
    }

    public static String getIdTokenIssuer(String tenantDomain) throws IdentityOAuth2Exception {
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            try {
                return ServiceURLBuilder.create().addPath(new String[]{"oauth2/token"}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException e) {
                String errorMsg = String.format("Error while building the absolute url of the context: '%s',  for the tenant domain: '%s'", "oauth2/token", tenantDomain);
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
        }
        return OAuth2Util.getIssuerLocation(tenantDomain);
    }

    public static String getIssuerLocation(String tenantDomain) throws IdentityOAuth2Exception {
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            try {
                OAuth2Util.startTenantFlow(tenantDomain);
                String string = ServiceURLBuilder.create().addPath(new String[]{"oauth2/token"}).build().getAbsolutePublicURL();
                return string;
            }
            catch (URLBuilderException e) {
                String errorMsg = String.format("Error while building the absolute url of the context: '%s',  for the tenant domain: '%s'", "oauth2/token", tenantDomain);
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            finally {
                OAuth2Util.endTenantFlow();
            }
        }
        IdentityProvider identityProvider = OAuth2Util.getResidentIdp(tenantDomain);
        FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oidcAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        return IdentityApplicationManagementUtil.getProperty((Property[])oidcAuthenticatorConfig.getProperties(), (String)IDP_ENTITY_ID).getValue();
    }

    private static IdentityProvider getResidentIdp(String tenantDomain) throws IdentityOAuth2Exception {
        try {
            return IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format("Error while getting Resident Identity Provider of '%s' tenant.", tenantDomain);
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
    }

    public static OAuthRevocationRequestDTO buildOAuthRevocationRequest(OAuthClientAuthnContext oAuthClientAuthnContext, String accessToken) {
        OAuthRevocationRequestDTO revocationRequestDTO = new OAuthRevocationRequestDTO();
        revocationRequestDTO.setToken(accessToken);
        revocationRequestDTO.setOauthClientAuthnContext(oAuthClientAuthnContext);
        revocationRequestDTO.setConsumerKey(oAuthClientAuthnContext.getClientId());
        return revocationRequestDTO;
    }

    public static AccessTokenDO findAccessToken(String tokenIdentifier, boolean includeExpired) throws IdentityOAuth2Exception {
        HashMap<String, OauthTokenIssuer> allOAuthTokenIssuerMap = new HashMap<String, OauthTokenIssuer>(OAuthServerConfiguration.getInstance().getOauthTokenIssuerMap());
        HashMap<String, OauthTokenIssuer> defaultOAuthTokenIssuerMap = new HashMap<String, OauthTokenIssuer>();
        OAuth2Util.extractDefaultOauthTokenIssuers(allOAuthTokenIssuerMap, defaultOAuthTokenIssuerMap);
        AccessTokenDO accessTokenDO = OAuth2Util.getAccessTokenDOFromMatchingTokenIssuer(tokenIdentifier, defaultOAuthTokenIssuerMap, includeExpired);
        if (accessTokenDO != null) {
            return accessTokenDO;
        }
        accessTokenDO = OAuth2Util.getAccessTokenDOFromMatchingTokenIssuer(tokenIdentifier, allOAuthTokenIssuerMap, includeExpired);
        if (accessTokenDO == null && !includeExpired) {
            throw new IllegalArgumentException("Invalid Access Token. ACTIVE access token is not found.");
        }
        return accessTokenDO;
    }

    private static AccessTokenDO getAccessTokenDOFromMatchingTokenIssuer(String tokenIdentifier, Map<String, OauthTokenIssuer> tokenIssuerMap, boolean includeExpired) throws IdentityOAuth2Exception {
        if (tokenIssuerMap != null) {
            for (Map.Entry<String, OauthTokenIssuer> oauthTokenIssuerEntry : tokenIssuerMap.entrySet()) {
                try {
                    OauthTokenIssuer oauthTokenIssuer = oauthTokenIssuerEntry.getValue();
                    String tokenAlias = oauthTokenIssuer.getAccessTokenHash(tokenIdentifier);
                    AccessTokenDO accessTokenDO = oauthTokenIssuer.usePersistedAccessTokenAlias() ? OAuth2Util.getAccessTokenDOFromTokenIdentifier(tokenAlias, includeExpired) : OAuth2Util.getAccessTokenDOFromTokenIdentifier(tokenIdentifier, includeExpired);
                    if (accessTokenDO == null) continue;
                    return accessTokenDO;
                }
                catch (OAuthSystemException e) {
                    if (!log.isDebugEnabled()) continue;
                    if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                        log.debug((Object)("Token issuer: " + oauthTokenIssuerEntry.getKey() + " was tried and failed to parse the received token: " + tokenIdentifier));
                        continue;
                    }
                    log.debug((Object)("Token issuer: " + oauthTokenIssuerEntry.getKey() + " was tried and failed to parse the received token."));
                }
                catch (IllegalArgumentException e) {
                    if (!log.isDebugEnabled()) continue;
                    if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                        log.debug((Object)("Token issuer: " + oauthTokenIssuerEntry.getKey() + " was tried and failed to get the token from database: " + tokenIdentifier));
                        continue;
                    }
                    log.debug((Object)("Token issuer: " + oauthTokenIssuerEntry.getKey() + " was tried and failed  to get the token from database."));
                }
            }
        }
        return null;
    }

    private static void extractDefaultOauthTokenIssuers(Map<String, OauthTokenIssuer> allOAuthTokenIssuerMap, Map<String, OauthTokenIssuer> defaultOAuthTokenIssuerMap) {
        defaultOAuthTokenIssuerMap.put("JWT", allOAuthTokenIssuerMap.get("JWT"));
        allOAuthTokenIssuerMap.remove("JWT");
        defaultOAuthTokenIssuerMap.put(DEFAULT_TOKEN_TYPE, allOAuthTokenIssuerMap.get(DEFAULT_TOKEN_TYPE));
        allOAuthTokenIssuerMap.remove(DEFAULT_TOKEN_TYPE);
    }

    public static String getAccessTokenIdentifier(OAuth2TokenValidationResponseDTO tokenResponse) throws UserInfoEndpointException {
        if (tokenResponse.getAuthorizationContextToken().getTokenString() != null) {
            AccessTokenDO accessTokenDO = null;
            try {
                accessTokenDO = OAuth2Util.findAccessToken(tokenResponse.getAuthorizationContextToken().getTokenString(), false);
            }
            catch (IdentityOAuth2Exception e) {
                throw new UserInfoEndpointException("Error occurred while obtaining access token.", (Throwable)((Object)e));
            }
            if (accessTokenDO != null) {
                return accessTokenDO.getAccessToken();
            }
        }
        return null;
    }

    public static void addTokenDOtoCache(AccessTokenDO newTokenBean) throws IdentityOAuth2Exception {
        OauthTokenIssuer tokenIssuer = null;
        try {
            tokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(newTokenBean.getConsumerKey());
            String tokenAlias = tokenIssuer.getAccessTokenHash(newTokenBean.getAccessToken());
            OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(tokenAlias);
            AccessTokenDO tokenDO = AccessTokenDO.clone(newTokenBean);
            tokenDO.setAccessToken(tokenAlias);
            OAuthCache.getInstance().addToCache(accessTokenCacheKey, (Serializable)((Object)tokenDO));
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Access token DO was added to OAuthCache with cache key: " + accessTokenCacheKey.getCacheKeyString()));
                } else {
                    log.debug((Object)"Access token DO was added to OAuthCache");
                }
            }
        }
        catch (OAuthSystemException e) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                throw new IdentityOAuth2Exception("Error while getting the token alias from token issuer: " + tokenIssuer.toString() + " for the token: " + newTokenBean.getAccessToken(), e);
            }
            throw new IdentityOAuth2Exception("Error while getting the token alias from token issuer: " + tokenIssuer.toString(), e);
        }
        catch (InvalidOAuthClientException e) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                throw new IdentityOAuth2Exception("Error while getting the token issuer for the token: " + newTokenBean.getAccessToken(), e);
            }
            throw new IdentityOAuth2Exception("Error while getting the token issuer", e);
        }
    }

    public static String getAuthenticatedIDP(AuthenticatedUser user) {
        String authenticatedIDP;
        if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
            if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && user.isFederatedUser()) {
                authenticatedIDP = user.getFederatedIdPName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IDP_ID column is available. User is federated and not mapped to local users. Authenticated IDP is set to:" + authenticatedIDP + " for user:" + user.toString()));
                }
            } else {
                authenticatedIDP = "LOCAL";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IDP_ID column is available. Authenticated IDP is set to:" + authenticatedIDP + " for user:" + user.toString()));
                }
            }
        } else {
            authenticatedIDP = user.getFederatedIdPName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("IDP_ID column is not available. Authenticated IDP is set to:" + authenticatedIDP + " for user:" + user.toString()));
            }
        }
        return authenticatedIDP;
    }

    public static String getUserStoreDomain(AuthenticatedUser user) {
        String userDomain;
        if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled() && !OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && user.isFederatedUser()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDP_ID column is available. User is federated and not mapped to local users.");
            }
            userDomain = "FEDERATED";
        } else if (!OAuthServerConfiguration.getInstance().isMapFederatedUsersToLocal() && user.isFederatedUser()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDP_ID column is not available. User is federated and not mapped to local users.");
            }
            userDomain = OAuth2Util.getFederatedUserDomain(user.getFederatedIdPName());
        } else {
            userDomain = user.getUserStoreDomain();
            if (log.isDebugEnabled()) {
                if (OAuth2ServiceComponentHolder.isIDPIdColumnEnabled()) {
                    log.debug((Object)"IDP_ID column is available. User is not federated or mapped to local users.");
                } else {
                    log.debug((Object)"IDP_ID column is not available. User is not federated or mapped to local users.");
                }
            }
        }
        String sanitizedUserDomain = OAuth2Util.getSanitizedUserStoreDomain(userDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User domain is set to:" + sanitizedUserDomain + " for user:" + user.toString()));
        }
        return sanitizedUserDomain;
    }

    public static boolean checkIDPIdColumnAvailable() {
        boolean isIdpIdAvailableInTokenAuditTable;
        String columnIdpId = "IDP_ID";
        boolean isIdpIdAvailableInAuthzCodeTable = FrameworkUtils.isTableColumnExists((String)"IDN_OAUTH2_AUTHORIZATION_CODE", (String)columnIdpId);
        boolean isIdpIdAvailableInTokenTable = FrameworkUtils.isTableColumnExists((String)"IDN_OAUTH2_ACCESS_TOKEN", (String)columnIdpId);
        if (OAuthServerConfiguration.getInstance().useRetainOldAccessTokens()) {
            isIdpIdAvailableInTokenAuditTable = FrameworkUtils.isTableColumnExists((String)"IDN_OAUTH2_ACCESS_TOKEN_AUDIT", (String)columnIdpId);
        } else {
            isIdpIdAvailableInTokenAuditTable = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retaining old access tokens in IDN_OAUTH2_ACCESS_TOKEN_AUDIT is disabled, therefore ignoring the availability of IDP_ID column in IDN_OAUTH2_ACCESS_TOKEN_AUDIT table.");
            }
        }
        return isIdpIdAvailableInAuthzCodeTable && isIdpIdAvailableInTokenTable && isIdpIdAvailableInTokenAuditTable;
    }

    public static void initiateOAuthScopePermissionsBindings(int tenantId) {
        try {
            if (!OAuth2Util.hasScopesAlreadyAdded(tenantId)) {
                List<Scope> scopes = OAuth2Util.loadOauthScopeBinding();
                for (Scope scope : scopes) {
                    OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().addScope(scope, tenantId);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OAuth scopes are loaded for the tenant : " + tenantId));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"OAuth scopes are already loaded");
            }
        }
        catch (IdentityOAuth2ScopeException e) {
            log.error((Object)"Error while registering OAuth scopes with permissions bindings", (Throwable)((Object)e));
        }
    }

    private static boolean hasScopesAlreadyAdded(int tenantId) throws IdentityOAuth2ScopeServerException {
        Scope loginScope = OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopeByName(INTERNAL_LOGIN_SCOPE, tenantId);
        if (loginScope == null) {
            return false;
        }
        List<ScopeBinding> scopeBindings = loginScope.getScopeBindings();
        for (ScopeBinding scopeBinding : scopeBindings) {
            if (!"PERMISSION".equalsIgnoreCase(scopeBinding.getBindingType())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Scope> loadOauthScopeBinding() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        String configDirPath = CarbonUtils.getCarbonConfigDirPath();
        String confXml = Paths.get(configDirPath, IDENTITY_PATH, "oauth-scope-bindings.xml").toString();
        File configFile = new File(confXml);
        if (!configFile.exists()) {
            log.warn((Object)("OAuth scope binding File is not present at: " + confXml));
            return new ArrayList<Scope>();
        }
        XMLStreamReader parser = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement omElement = (OMElement)iterator.next();
                String scopeName = omElement.getAttributeValue(new QName(NAME));
                String displayName = omElement.getAttributeValue(new QName(DISPLAY_NAME));
                String description = omElement.getAttributeValue(new QName(DESCRIPTION));
                List<String> bindingPermissions = OAuth2Util.loadScopePermissions(omElement);
                ScopeBinding scopeBinding = new ScopeBinding("PERMISSION", bindingPermissions);
                ArrayList<ScopeBinding> scopeBindings = new ArrayList<ScopeBinding>();
                scopeBindings.add(scopeBinding);
                Scope scope = new Scope(scopeName, displayName, scopeBindings, description);
                scopes.add(scope);
            }
        }
        catch (XMLStreamException e) {
            log.warn((Object)"Error while loading scope config.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"Error while loading email config.", (Throwable)e);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
                if (stream != null) {
                    IdentityIOStreamUtils.closeInputStream((InputStream)stream);
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while closing XML stream", (Throwable)e);
            }
        }
        return scopes;
    }

    private static List<String> loadScopePermissions(OMElement configElement) {
        ArrayList<String> permissions = new ArrayList<String>();
        Iterator it = configElement.getChildElements();
        while (it.hasNext()) {
            OMElement element = (OMElement)it.next();
            Iterator permissonsIterator = element.getChildElements();
            while (permissonsIterator.hasNext()) {
                OMElement permissionElement = (OMElement)permissonsIterator.next();
                if (!PERMISSION.equals(permissionElement.getLocalName())) continue;
                String permisson = permissionElement.getText();
                permissions.add(permisson);
            }
        }
        return permissions;
    }

    public static boolean isValidTokenBinding(TokenBinding tokenBinding, HttpServletRequest request) {
        if (request == null || tokenBinding == null || StringUtils.isBlank((String)tokenBinding.getBindingReference()) || StringUtils.isBlank((String)tokenBinding.getBindingType())) {
            return true;
        }
        Optional<TokenBinder> tokenBinderOptional = OAuth2ServiceComponentHolder.getInstance().getTokenBinder(tokenBinding.getBindingType());
        if (!tokenBinderOptional.isPresent()) {
            log.warn((Object)("Token binder with type: " + tokenBinding.getBindingType() + " is not available."));
            return false;
        }
        return tokenBinderOptional.get().isValidTokenBinding(request, tokenBinding.getBindingReference());
    }

    private static X509Certificate getPublicCertFromJWKS(String jwksUri) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Attempting to retrieve public certificate from the Jwks uri: %s.", jwksUri));
        }
        try {
            JWKSet publicKeys = JWKSet.load((URL)new URL(jwksUri));
            JWK jwk = null;
            List jwkList = publicKeys.getKeys();
            for (JWK currentJwk : jwkList) {
                if (KeyUse.SIGNATURE != currentJwk.getKeyUse()) continue;
                jwk = currentJwk;
                break;
            }
            if (jwk != null) {
                X509Certificate certificate = (X509Certificate)jwk.getParsedX509CertChain().get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Retrieved the public signing certificate successfully from the jwks uri: %s", jwksUri));
                }
                return certificate;
            }
            throw new IdentityOAuth2Exception(String.format("Failed to retrieve public certificate from jwks uri: %s", jwksUri));
        }
        catch (IOException | ParseException e) {
            throw new IdentityOAuth2Exception(String.format("Failed to retrieve public certificate from jwks uri: %s", jwksUri), e);
        }
    }

    private static String getSPJwksUrl(String clientId, String spTenantDomain) throws IdentityOAuth2Exception {
        ServiceProviderProperty[] spPropertyArray;
        String jwksUri = null;
        ServiceProvider serviceProvider = OAuth2Util.getServiceProvider(clientId, spTenantDomain);
        for (ServiceProviderProperty spProperty : spPropertyArray = serviceProvider.getSpProperties()) {
            if (!"jwksURI".equals(spProperty.getName())) continue;
            jwksUri = spProperty.getValue();
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Retrieved jwks uri: %s for the service provider associated with client_id: %s", jwksUri, clientId));
        }
        return jwksUri;
    }

    public static String getJwkThumbPrint(Certificate certificate) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Calculating SHA-1 JWK thumb-print for certificate: %s", certificate.toString()));
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(certificate.getEncoded());
            X509Certificate x509 = (X509Certificate)cf.generateCertificate(bais);
            Base64URL jwkThumbprint = RSAKey.parse((X509Certificate)x509).computeThumbprint("SHA-1");
            String thumbprintString = jwkThumbprint.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Calculated SHA-1 JWK thumbprint %s from the certificate", thumbprintString));
            }
            return thumbprintString;
        }
        catch (JOSEException | CertificateException e) {
            throw new IdentityOAuth2Exception("Error occurred while generating SHA-1 JWK thumbprint", e);
        }
    }

    public static void validateRequestTenantDomain(String tenantDomainOfApp) throws InvalidOAuthClientException {
        String tenantDomainFromContext;
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && !StringUtils.equals((String)(tenantDomainFromContext = IdentityTenantUtil.getTenantDomainFromContext()), (String)tenantDomainOfApp)) {
            throw new InvalidOAuthClientException("A valid client with the given client_id cannot be found in tenantDomain: " + tenantDomainFromContext);
        }
    }

    private static void startTenantFlow(String tenantDomain) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(IdentityTenantUtil.getTenantId((String)tenantDomain));
    }

    private static void endTenantFlow() {
        PrivilegedCarbonContext.endTenantFlow();
    }

    public static boolean isAllowedScope(List<String> allowedScopesList, String scope) {
        for (String scopeTobeSkipped : allowedScopesList) {
            if (!scope.matches(scopeTobeSkipped)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(scope + " is found in the allowed list of scopes."));
            }
            return true;
        }
        return false;
    }

    public static class OAuthURL {
        public static String getOAuth1RequestTokenUrl() {
            String oauth1RequestTokenUrl = OAuthServerConfiguration.getInstance().getOAuth1RequestTokenUrl();
            if (StringUtils.isBlank((String)oauth1RequestTokenUrl)) {
                oauth1RequestTokenUrl = IdentityUtil.getServerURL((String)"oauth/request-token", (boolean)true, (boolean)true);
            }
            return oauth1RequestTokenUrl;
        }

        public static String getOAuth1AuthorizeUrl() {
            String oauth1AuthorizeUrl = OAuthServerConfiguration.getInstance().getOAuth1AuthorizeUrl();
            if (StringUtils.isBlank((String)oauth1AuthorizeUrl)) {
                oauth1AuthorizeUrl = IdentityUtil.getServerURL((String)"oauth/authorize-url", (boolean)true, (boolean)true);
            }
            return oauth1AuthorizeUrl;
        }

        public static String getOAuth1AccessTokenUrl() {
            String oauth1AccessTokenUrl = OAuthServerConfiguration.getInstance().getOAuth1AccessTokenUrl();
            if (StringUtils.isBlank((String)oauth1AccessTokenUrl)) {
                oauth1AccessTokenUrl = IdentityUtil.getServerURL((String)"oauth/access-token", (boolean)true, (boolean)true);
            }
            return oauth1AccessTokenUrl;
        }

        public static String getOAuth2AuthzEPUrl() {
            return OAuth2Util.buildUrl("oauth2/authorize", OAuthServerConfiguration.getInstance()::getOAuth2AuthzEPUrl);
        }

        public static String getOAuth2TokenEPUrl() {
            return OAuth2Util.buildUrl("oauth2/token", OAuthServerConfiguration.getInstance()::getOAuth2TokenEPUrl);
        }

        public static String getOAuth2DCREPUrl(String tenantDomain) throws URISyntaxException {
            String oauth2TokenEPUrl = OAuth2Util.buildUrl("/api/identity/oauth2/dcr/v1.0/register", OAuthServerConfiguration.getInstance()::getOAuth2DCREPUrl);
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && OAuth2Util.isNotSuperTenant(tenantDomain)) {
                oauth2TokenEPUrl = OAuthURL.appendTenantDomainAsPathParamInLegacyMode(oauth2TokenEPUrl, tenantDomain);
            }
            return oauth2TokenEPUrl;
        }

        public static String getOAuth2JWKSPageUrl(String tenantDomain) throws URISyntaxException {
            String auth2JWKSPageUrl = OAuth2Util.buildUrl("/oauth2/jwks", OAuthServerConfiguration.getInstance()::getOAuth2JWKSPageUrl);
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && OAuth2Util.isNotSuperTenant(tenantDomain)) {
                auth2JWKSPageUrl = OAuthURL.appendTenantDomainAsPathParamInLegacyMode(auth2JWKSPageUrl, tenantDomain);
            }
            return auth2JWKSPageUrl;
        }

        public static String getOidcWebFingerEPUrl() {
            return OAuth2Util.buildUrl(".well-know/webfinger", OAuthServerConfiguration.getInstance()::getOidcWebFingerEPUrl);
        }

        public static String getOidcDiscoveryEPUrl(String tenantDomain) throws URISyntaxException {
            String oidcDiscoveryEPUrl = OAuth2Util.buildUrl("/oauth2/oidcdiscovery", OAuthServerConfiguration.getInstance()::getOidcDiscoveryUrl);
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && OAuth2Util.isNotSuperTenant(tenantDomain)) {
                oidcDiscoveryEPUrl = OAuthURL.appendTenantDomainAsPathParamInLegacyMode(oidcDiscoveryEPUrl, tenantDomain);
            }
            return oidcDiscoveryEPUrl;
        }

        public static String getOAuth2UserInfoEPUrl() {
            return OAuth2Util.buildUrl("oauth2/userinfo", OAuthServerConfiguration.getInstance()::getOauth2UserInfoEPUrl);
        }

        public static String getOAuth2RevocationEPUrl() {
            return OAuth2Util.buildUrl("oauth2/revoke", OAuthServerConfiguration.getInstance()::getOauth2RevocationEPUrl);
        }

        public static String getOAuth2IntrospectionEPUrl() {
            return OAuth2Util.buildUrl("oauth2/introspect", OAuthServerConfiguration.getInstance()::getOauth2IntrospectionEPUrl);
        }

        public static String getOAuth2IntrospectionEPUrl(String tenantDomain) throws URISyntaxException {
            String getOAuth2IntrospectionEPUrl = OAuth2Util.buildUrl("oauth2/introspect", OAuthServerConfiguration.getInstance()::getOauth2IntrospectionEPUrl);
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && OAuth2Util.isNotSuperTenant(tenantDomain)) {
                getOAuth2IntrospectionEPUrl = OAuthURL.appendTenantDomainAsPathParamInLegacyMode(getOAuth2IntrospectionEPUrl, tenantDomain);
            }
            return getOAuth2IntrospectionEPUrl;
        }

        public static String getOIDCConsentPageUrl() {
            return OAuth2Util.buildUrl("/authenticationendpoint/oauth2_consent.do", OAuthServerConfiguration.getInstance()::getOIDCConsentPageUrl);
        }

        public static String getOAuth2ConsentPageUrl() {
            return OAuth2Util.buildUrl("/authenticationendpoint/oauth2_authz.do", OAuthServerConfiguration.getInstance()::getOauth2ConsentPageUrl);
        }

        public static String getOAuth2ErrorPageUrl() {
            return OAuth2Util.buildUrl("/authenticationendpoint/oauth2_error.do", OAuthServerConfiguration.getInstance()::getOauth2ErrorPageUrl);
        }

        private static String appendTenantDomainAsPathParamInLegacyMode(String url, String tenantDomain) throws URISyntaxException {
            URI uri = new URI(url);
            URI uriModified = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/t/" + tenantDomain + uri.getPath(), uri.getQuery(), uri.getFragment());
            return uriModified.toString();
        }
    }
}

