/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;

public class OAuth2TokenUtil {
    private static final Log log = LogFactory.getLog(OAuth2TokenUtil.class);

    public static void postIssueAccessToken(String tokenId, String sessionDataKey) throws IdentityOAuth2Exception {
        String eventName = "POST_ISSUE_ACCESS_TOKEN";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("TOKEN_ID", tokenId);
        properties.put("SESSION_DATA_KEY", sessionDataKey);
        Event requestObjectPersistanceEvent = new Event(eventName, properties);
        IdentityEventService identityEventService = OpenIDConnectServiceComponentHolder.getIdentityEventService();
        try {
            if (identityEventService != null) {
                identityEventService.handleEvent(requestObjectPersistanceEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The event " + eventName + " triggered after the access token " + tokenId + " is issued."));
                }
            }
        }
        catch (IdentityEventException e) {
            throw new IdentityOAuth2Exception("Error while invoking the request object persistance handler when issuing the access token id: " + tokenId);
        }
    }

    public static void postUpdateAccessToken(String acessTokenId, String tokenState) throws IdentityOAuth2Exception {
        String eventName = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)acessTokenId)) {
            eventName = "POST_REVOKE_ACESS_TOKEN_BY_ID";
            properties.put("TOKEN_STATE", tokenState);
            properties.put("TOKEN_ID", acessTokenId);
        }
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }

    public static void postUpdateAccessTokens(List<String> acessTokens, String tokenState) throws IdentityOAuth2Exception {
        String eventName = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(acessTokens)) {
            eventName = "POST_REVOKE_ACESS_TOKEN";
            properties.put("TOKEN_STATE", tokenState);
            properties.put("ACEESS_TOKENS", acessTokens);
        }
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }

    public static void postRefreshAccessToken(String oldAcessTokenId, String acessTokenId, String tokenState) throws IdentityOAuth2Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)acessTokenId)) {
            properties.put("OLD_ACCESS_TOKEN", oldAcessTokenId);
            properties.put("NEW_ACCESS_TOKEN", acessTokenId);
        }
        String eventName = "POST_REFRESH_TOKEN";
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }

    public static void postRevokeCode(String codeId, String tokenState, String tokenId) throws IdentityOAuth2Exception {
        String eventName = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)codeId)) {
            properties.put("TOKEN_STATE", tokenState);
            properties.put("TOKEN_ID", tokenId);
            properties.put("CODE_ID", codeId);
            eventName = "POST_REVOKE_CODE_BY_ID";
        }
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }

    public static void postRevokeCodes(List<AuthzCodeDO> authzCodeDOs, String tokenState) throws IdentityOAuth2Exception {
        String eventName = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(authzCodeDOs)) {
            properties.put("TOKEN_STATE", tokenState);
            eventName = "POST_REVOKE_CODE";
            properties.put("CODES", authzCodeDOs);
        }
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }

    private static void triggerEvent(String eventName, HashMap<String, Object> properties) throws IdentityOAuth2Exception {
        try {
            if (StringUtils.isNotBlank((String)eventName)) {
                Event requestObjectPersistanceEvent = new Event(eventName, properties);
                IdentityEventService identityEventService = OpenIDConnectServiceComponentHolder.getIdentityEventService();
                if (identityEventService != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The event: " + eventName + " triggered."));
                    }
                    identityEventService.handleEvent(requestObjectPersistanceEvent);
                }
            }
        }
        catch (IdentityEventException e) {
            String message = "Error while triggering the event: " + eventName;
            log.error((Object)message, (Throwable)e);
            throw new IdentityOAuth2Exception(message, e);
        }
    }

    public static void postIssueCode(String codeId, String sessionDataKey) throws IdentityOAuth2Exception {
        String eventName = "POST_ISSUE_CODE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CODE_ID", codeId);
        properties.put("SESSION_DATA_KEY", sessionDataKey);
        OAuth2TokenUtil.triggerEvent(eventName, properties);
    }
}

