/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamedPreparedStatement {
    private PreparedStatement preparedStatement;
    private List<String> fields = new ArrayList<String>();

    public NamedPreparedStatement(Connection connection, String sqlQuery, Map<String, Integer> repetition) throws SQLException {
        int pos;
        while ((pos = sqlQuery.indexOf(":")) != -1) {
            int end = sqlQuery.substring(pos).indexOf(";");
            if (end == -1) {
                throw new SQLException("Cannot find the end of the placeholder.");
            }
            this.fields.add(sqlQuery.substring(pos + 1, end += pos));
            StringBuilder builder = new StringBuilder("?");
            if (repetition.get(sqlQuery.substring(pos + 1, end)) != null) {
                for (int i = 0; i < repetition.get(sqlQuery.substring(pos + 1, end)) - 1; ++i) {
                    builder.append(", ?");
                }
            }
            sqlQuery = String.format("%s %s %s", sqlQuery.substring(0, pos), builder.toString(), sqlQuery.substring(end + 1));
        }
        this.preparedStatement = connection.prepareStatement(sqlQuery);
    }

    public NamedPreparedStatement(Connection connection, String sqlQuery) throws SQLException {
        this(connection, sqlQuery, new HashMap<String, Integer>());
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setLong(String name, long value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setLong(this.getIndex(name), value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setInt(this.getIndex(name), value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setString(this.getIndex(name), value);
        }
    }

    public void setString(String name, List<String> values) throws SQLException {
        int indexInc = 0;
        for (String value : values) {
            this.preparedStatement.setString(this.getIndex(name) + indexInc, value);
            ++indexInc;
        }
    }

    public void setObject(String name, Object value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setObject(this.getIndex(name), value);
        }
    }

    public void setTimeStamp(String name, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setTimestamp(this.getIndex(name), timestamp, calendar);
        }
    }

    private int getIndex(String name) {
        return this.fields.indexOf(name) + 1;
    }
}

