/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;

public class ClaimsUtil {
    private static final Log log = LogFactory.getLog(ClaimsUtil.class);
    private static final String INBOUND_AUTH2_TYPE = "oauth2";
    private static final String SP_DIALECT = "http://wso2.org/oidc/claim";

    public static boolean isInLocalDialect(Map<String, String> attributes) {
        Iterator<String> iterator = attributes.keySet().iterator();
        if (iterator.hasNext()) {
            return iterator.next().startsWith("http://wso2.org/claims/");
        }
        return false;
    }

    public static Map<String, String> convertFederatedClaimsToLocalDialect(Map<String, String> remoteClaims, ClaimMapping[] idPClaimMappings, String tenantDomain) {
        if (log.isDebugEnabled()) {
            StringBuilder claimUris = new StringBuilder();
            for (String key : remoteClaims.keySet()) {
                claimUris.append(key).append(",");
            }
            log.debug((Object)("Converting federated user claims to local dialect. Converting claim urls: " + claimUris.toString()));
        }
        if (idPClaimMappings != null && idPClaimMappings.length > 0) {
            Map localToIdPClaimMap = FrameworkUtils.getClaimMappings((ClaimMapping[])idPClaimMappings, (boolean)true);
            Map<String, String> defaultValuesForClaims = ClaimsUtil.loadDefaultValuesForClaims(idPClaimMappings);
            Map<String, String> convertedClaims = ClaimsUtil.mapRemoteClaimsToLocalClaims(remoteClaims, localToIdPClaimMap, defaultValuesForClaims);
            if (log.isDebugEnabled()) {
                StringBuilder claimUris = new StringBuilder();
                for (String key : convertedClaims.keySet()) {
                    claimUris.append(key).append(",");
                }
                log.debug((Object)("Converted federated user claims to local dialect. Converting claim urls: " + claimUris.toString()));
            }
            return convertedClaims;
        }
        return remoteClaims;
    }

    private static ServiceProvider getServiceProvider(OAuthTokenReqMessageContext requestMsgCtx) throws IdentityApplicationManagementException {
        String spTenantDomain = requestMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        if (StringUtils.isBlank((String)spTenantDomain)) {
            spTenantDomain = "carbon.super";
        }
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        String spName = applicationMgtService.getServiceProviderNameByClientId(requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId(), INBOUND_AUTH2_TYPE, spTenantDomain);
        return applicationMgtService.getApplicationExcludingFileBasedSPs(spName, spTenantDomain);
    }

    public static Map<String, String> convertClaimsToOIDCDialect(OAuthTokenReqMessageContext requestMsgCtx, Map<String, String> userClaims) throws IdentityApplicationManagementException, IdentityException {
        String spName;
        ApplicationManagementService applicationMgtService;
        ServiceProvider serviceProvider;
        String spTenantDomain;
        HashMap<String, String> mappedAppClaims = new HashMap<String, String>();
        if (log.isDebugEnabled()) {
            StringBuilder claimUris = new StringBuilder();
            for (String key : userClaims.keySet()) {
                claimUris.append(key).append(",");
            }
            log.debug((Object)("Converting user claims from local dialect to OIDC dialect for user: " + requestMsgCtx.getAuthorizedUser() + ", client id:" + requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId() + ", converting claim urls: " + claimUris.toString()));
        }
        if (StringUtils.isBlank((String)(spTenantDomain = requestMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain()))) {
            spTenantDomain = "carbon.super";
        }
        if ((serviceProvider = (applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService()).getApplicationExcludingFileBasedSPs(spName = applicationMgtService.getServiceProviderNameByClientId(requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId(), INBOUND_AUTH2_TYPE, spTenantDomain), spTenantDomain)) == null) {
            return mappedAppClaims;
        }
        ClaimMapping[] spClaimMappings = serviceProvider.getClaimConfig().getClaimMappings();
        if (spClaimMappings == null || spClaimMappings.length <= 0) {
            spClaimMappings = new ClaimMapping[]{};
        }
        ArrayList<String> requestedLocalClaims = new ArrayList<String>();
        for (ClaimMapping mapping : spClaimMappings) {
            if (!mapping.isRequested()) continue;
            requestedLocalClaims.add(mapping.getLocalClaim().getClaimUri());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested number of local claims: " + requestedLocalClaims.size()));
        }
        Map spToLocalClaimMappings = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(SP_DIALECT, null, spTenantDomain, false);
        for (Map.Entry oidcToLocalClaimMapping : spToLocalClaimMappings.entrySet()) {
            String value = userClaims.get(oidcToLocalClaimMapping.getValue());
            if (value == null || !requestedLocalClaims.contains(oidcToLocalClaimMapping.getValue())) continue;
            mappedAppClaims.put((String)oidcToLocalClaimMapping.getKey(), value);
            if (!log.isDebugEnabled() || !IdentityUtil.isTokenLoggable((String)"UserClaims")) continue;
            log.debug((Object)("Mapped claim: key -  " + (String)oidcToLocalClaimMapping.getKey() + " value -" + value));
        }
        if (log.isDebugEnabled()) {
            StringBuilder claimUris = new StringBuilder();
            for (String key : mappedAppClaims.keySet()) {
                claimUris.append(key).append(",");
            }
            log.debug((Object)("Converted user claims from local dialect to OIDC dialect for user: " + requestMsgCtx.getAuthorizedUser() + ", client id:" + requestMsgCtx.getOauth2AccessTokenReqDTO().getClientId() + ", converted claim urls: " + claimUris.toString()));
        }
        return mappedAppClaims;
    }

    public static Map<String, String> handleClaimMapping(IdentityProvider identityProvider, Map<String, String> attributes, String tenantDomain, OAuthTokenReqMessageContext tokenReqMsgCtx) throws IdentityException, IdentityApplicationManagementException {
        boolean proxyUserAttributes;
        boolean bl = proxyUserAttributes = !OAuthServerConfiguration.getInstance().isConvertOriginalClaimsFromAssertionsToOIDCDialect();
        if (proxyUserAttributes) {
            ClaimsUtil.setHasNonOIDCClaimsProperty(tokenReqMsgCtx);
            return attributes;
        }
        Object[] idPClaimMappings = identityProvider.getClaimConfig().getClaimMappings();
        Map<Object, Object> claimsAfterSPMapping = new HashMap();
        ServiceProvider serviceProvider = ClaimsUtil.getServiceProvider(tokenReqMsgCtx);
        if (ArrayUtils.isNotEmpty((Object[])idPClaimMappings)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Claim mappings exist for identity provider " + identityProvider.getIdentityProviderName()));
            }
            Map<String, String> claimsAfterIdpMapping = ClaimsUtil.handleClaimsForIDP(attributes, tenantDomain, identityProvider, false, (ClaimMapping[])idPClaimMappings);
            if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                log.debug((Object)("Claims of user : " + tokenReqMsgCtx.getAuthorizedUser() + " after IDP  claim mapping " + claimsAfterIdpMapping.toString()));
            }
            if (ClaimsUtil.isSPRequestedClaimsExist(tokenReqMsgCtx)) {
                claimsAfterSPMapping = ClaimsUtil.convertClaimsToOIDCDialect(tokenReqMsgCtx, claimsAfterIdpMapping);
                claimsAfterSPMapping = ClaimsUtil.handleUnMappedClaims(tokenReqMsgCtx, attributes, claimsAfterSPMapping, (ClaimMapping[])idPClaimMappings);
            } else if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                log.debug((Object)("IDP claims exists, SP claims does not exist, for the identity provider " + identityProvider.getIdentityProviderName() + ", service provider " + serviceProvider.getApplicationName() + ", hence cannot do claim mapping"));
            }
        } else {
            Map<String, String> claimsAfterIdpMapping = attributes;
            if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                log.debug((Object)("IDP claims do not exist for, identity provider, " + identityProvider.getIdentityProviderName() + ", hence directly copying custom claims, " + claimsAfterIdpMapping.toString()));
            }
            if (ClaimsUtil.isSPRequestedClaimsExist(tokenReqMsgCtx)) {
                claimsAfterSPMapping = ClaimsUtil.convertClaimsToOIDCDialect(tokenReqMsgCtx, claimsAfterIdpMapping);
                if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                    log.debug((Object)("IDP claims do not exist but SP Claim mappings exists for, identity provider, " + identityProvider.getIdentityProviderName() + ", and Service Provider, " + serviceProvider.getApplicationName() + ", claims after SP mapping, " + claimsAfterSPMapping.toString()));
                }
                claimsAfterSPMapping = ClaimsUtil.handleUnMappedClaims(tokenReqMsgCtx, attributes, claimsAfterSPMapping, (ClaimMapping[])idPClaimMappings);
            } else {
                ClaimsUtil.setHasNonOIDCClaimsProperty(tokenReqMsgCtx);
                claimsAfterSPMapping = attributes;
                if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                    log.debug((Object)("IDP claims and SP Claim mappings do not exists for, identity provider, " + identityProvider.getIdentityProviderName() + ", and Service Provider, " + serviceProvider.getApplicationName() + ", hence claims are proxied, " + claimsAfterSPMapping.toString()));
                }
            }
        }
        return claimsAfterSPMapping;
    }

    private static boolean isUserClaimsInTokenLoggable() {
        return IdentityUtil.isTokenLoggable((String)"UserClaims");
    }

    private static void setHasNonOIDCClaimsProperty(OAuthTokenReqMessageContext tokenReqMsgCtx) {
        tokenReqMsgCtx.addProperty("hasNonOIDCClaims", true);
    }

    private static boolean isSPRequestedClaimsExist(OAuthTokenReqMessageContext tokenReqMsgCtx) throws IdentityApplicationManagementException {
        boolean isSPClaimMappingExist = false;
        ServiceProvider serviceProvider = ClaimsUtil.getServiceProvider(tokenReqMsgCtx);
        ClaimConfig claimConfig = serviceProvider.getClaimConfig();
        ClaimMapping[] claimMappings = claimConfig.getClaimMappings();
        if (claimMappings != null) {
            for (ClaimMapping claimMapping : claimMappings) {
                if (!claimMapping.isRequested()) continue;
                isSPClaimMappingExist = true;
                break;
            }
        }
        if (isSPClaimMappingExist && log.isDebugEnabled()) {
            log.debug((Object)("Service provider " + serviceProvider.getApplicationName() + " has requested claim mappings"));
        }
        return isSPClaimMappingExist;
    }

    private static Map<String, String> handleUnMappedClaims(OAuthTokenReqMessageContext tokenReqMsgCtx, Map<String, String> userAttributes, Map<String, String> claimsAfterIDPandSPMapping, ClaimMapping[] idPClaimMappings) throws IdentityApplicationManagementException {
        boolean isAddUnmappedUserAttributes = OAuthServerConfiguration.getInstance().isAddUnmappedUserAttributes();
        if (isAddUnmappedUserAttributes) {
            claimsAfterIDPandSPMapping = ClaimsUtil.addMissingClaims(tokenReqMsgCtx, userAttributes, claimsAfterIDPandSPMapping, idPClaimMappings);
            ClaimsUtil.setHasNonOIDCClaimsProperty(tokenReqMsgCtx);
            if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
                log.debug((Object)("AddUnMappedAttributes is set to true in identity level, hence OIDC claims after conversion, for the user : " + tokenReqMsgCtx.getAuthorizedUser() + ", " + claimsAfterIDPandSPMapping.toString()));
            }
        } else if (ClaimsUtil.isUserClaimsInTokenLoggable() && log.isDebugEnabled()) {
            log.debug((Object)("AddUnMappedAttributes is set to false in identity level, hence OIDC claims after conversion, for the user : " + tokenReqMsgCtx.getAuthorizedUser() + ", " + claimsAfterIDPandSPMapping.toString()));
        }
        return claimsAfterIDPandSPMapping;
    }

    private static Map<String, String> addMissingClaims(OAuthTokenReqMessageContext tokenReqMsgCtx, Map<String, String> userAttributes, Map<String, String> claimsAfterIDPandSPMapping, ClaimMapping[] idPClaimMappings) throws IdentityApplicationManagementException {
        boolean isUserClaimsLoggable = ClaimsUtil.isUserClaimsInTokenLoggable();
        ServiceProvider serviceProvider = ClaimsUtil.getServiceProvider(tokenReqMsgCtx);
        ClaimConfig serviceProviderClaimConfig = serviceProvider.getClaimConfig();
        AuthenticatedUser authenticatedUser = tokenReqMsgCtx.getAuthorizedUser();
        userAttributes.forEach((key, value) -> {
            boolean foundMatching = false;
            String localClaimUri = null;
            if (ArrayUtils.isNotEmpty((Object[])idPClaimMappings)) {
                for (ClaimMapping claimMapping : idPClaimMappings) {
                    if (!claimMapping.getRemoteClaim().getClaimUri().equals(key)) continue;
                    localClaimUri = claimMapping.getLocalClaim().getClaimUri();
                    foundMatching = true;
                    break;
                }
                if (!foundMatching) {
                    if (isUserClaimsLoggable && log.isDebugEnabled()) {
                        log.debug((Object)("IDP Claim mapping does not exist for " + key + ", hence adding value " + value + " for the user : " + authenticatedUser));
                    }
                    claimsAfterIDPandSPMapping.put((String)key, (String)value);
                } else {
                    ClaimMapping[] spClaimMapping;
                    foundMatching = false;
                    for (ClaimMapping claimMapping : spClaimMapping = serviceProviderClaimConfig.getClaimMappings()) {
                        if (!claimMapping.getLocalClaim().getClaimUri().equals(localClaimUri) || !claimMapping.isRequested()) continue;
                        foundMatching = true;
                        break;
                    }
                    if (!foundMatching) {
                        if (isUserClaimsLoggable && log.isDebugEnabled()) {
                            log.debug((Object)("IDP Claim mapping exist, but SP Claim mapping does not exist for " + key + ", hence adding value " + value + " for the user : " + authenticatedUser));
                        }
                        claimsAfterIDPandSPMapping.put((String)key, (String)value);
                    }
                }
            } else {
                ClaimMapping[] spClaimMapping;
                for (ClaimMapping claimMapping : spClaimMapping = serviceProviderClaimConfig.getClaimMappings()) {
                    if (!claimMapping.getLocalClaim().getClaimUri().equals(key) || !claimMapping.isRequested()) continue;
                    foundMatching = true;
                    break;
                }
                if (!foundMatching) {
                    if (isUserClaimsLoggable && log.isDebugEnabled()) {
                        log.debug((Object)("SP Claim mapping does not exist for " + key + ", hence adding value " + value + " for the user : " + authenticatedUser));
                    }
                    claimsAfterIDPandSPMapping.put((String)key, (String)value);
                }
            }
        });
        if (isUserClaimsLoggable && log.isDebugEnabled()) {
            log.debug((Object)("Final set of claims for the user : " + authenticatedUser + ": " + claimsAfterIDPandSPMapping.toString()));
        }
        return claimsAfterIDPandSPMapping;
    }

    public static boolean isResidentIdp(IdentityProvider identityProvider) {
        return "LOCAL".equals(identityProvider.getIdentityProviderName());
    }

    public static Map<String, String> mapRemoteClaimsToLocalClaims(Map<String, String> remoteClaims, Map<String, String> localToIdPClaimMap, Map<String, String> defaultValuesForClaims) {
        HashMap<String, String> localUnfilteredClaims = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : localToIdPClaimMap.entrySet()) {
            String localClaimURI = entry.getKey();
            String claimValue = remoteClaims.get(localToIdPClaimMap.get(localClaimURI));
            if (StringUtils.isEmpty((String)claimValue)) {
                claimValue = defaultValuesForClaims.get(localClaimURI);
            }
            if (StringUtils.isEmpty((String)claimValue)) continue;
            localUnfilteredClaims.put(localClaimURI, claimValue);
        }
        return localUnfilteredClaims;
    }

    public static Map<String, String> loadDefaultValuesForClaims(ClaimMapping[] idPClaimMappings) {
        HashMap<String, String> defaultValuesForClaims = new HashMap<String, String>();
        for (ClaimMapping claimMapping : idPClaimMappings) {
            String defaultValue = claimMapping.getDefaultValue();
            if (defaultValue == null || defaultValue.isEmpty()) continue;
            defaultValuesForClaims.put(claimMapping.getLocalClaim().getClaimUri(), defaultValue);
        }
        return defaultValuesForClaims;
    }

    public static Map<String, String> extractClaimsFromAssertion(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenRespDTO responseDTO, Assertion assertion, String userAttributeSeparator) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        List attributeStatementList = assertion.getAttributeStatements();
        if (CollectionUtils.isNotEmpty((Collection)attributeStatementList)) {
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    List values = attribute.getAttributeValues();
                    String attributeValues = null;
                    if (values == null) continue;
                    for (int i = 0; i < values.size(); ++i) {
                        Element value = ((XMLObject)attribute.getAttributeValues().get(i)).getDOM();
                        String attributeValue = value.getTextContent();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Attribute: " + attribute.getName() + ", Value: " + attributeValue));
                        }
                        attributeValues = StringUtils.isBlank(attributeValues) ? attributeValue : attributeValues + userAttributeSeparator + attributeValue;
                        attributes.put(attribute.getName(), attributeValues);
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No AttributeStatement found in the request for client with id: " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId()));
        }
        return attributes;
    }

    public static Map<String, String> handleClaimsForIDP(Map<String, String> attributes, String tenantDomain, IdentityProvider identityProvider, boolean localClaimDialect, ClaimMapping[] idPClaimMappings) {
        Map<String, String> localClaims;
        if (localClaimDialect) {
            localClaims = ClaimsUtil.handleLocalClaims(attributes, identityProvider);
        } else if (idPClaimMappings.length > 0) {
            localClaims = ClaimsUtil.convertFederatedClaimsToLocalDialect(attributes, idPClaimMappings, tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("IDP claims dialect is not local. Converted claims for identity provider: " + identityProvider.getIdentityProviderName()));
            }
        } else {
            localClaims = ClaimsUtil.handleLocalClaims(attributes, identityProvider);
        }
        return localClaims;
    }

    public static Map<String, String> handleClaimsForResidentIDP(Map<String, String> attributes, IdentityProvider identityProvider) {
        HashMap<String, String> localClaims = new HashMap();
        boolean localClaimDialect = identityProvider.getClaimConfig().isLocalClaimDialect();
        if (localClaimDialect) {
            localClaims = ClaimsUtil.handleLocalClaims(attributes, identityProvider);
        } else if (ClaimsUtil.isInLocalDialect(attributes)) {
            localClaims = attributes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("IDP claims dialect is not local. But claims are in local dialect for identity provider: " + identityProvider.getIdentityProviderName() + ". Using attributes in assertion as the IDP claims."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("IDP claims dialect is not local. These claims are not handled for identity provider: " + identityProvider.getIdentityProviderName()));
        }
        return localClaims;
    }

    public static void addUserAttributesToCache(OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext msgCtx, Map<ClaimMapping, String> userAttributes) {
        AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(tokenRespDTO.getAccessToken());
        AuthorizationGrantCacheEntry authorizationGrantCacheEntry = new AuthorizationGrantCacheEntry(userAttributes);
        authorizationGrantCacheEntry.setSubjectClaim(msgCtx.getAuthorizedUser().getAuthenticatedSubjectIdentifier());
        Object hasNonOIDCClaimsProperty = msgCtx.getProperty("hasNonOIDCClaims");
        if (hasNonOIDCClaimsProperty != null) {
            authorizationGrantCacheEntry.setHasNonOIDCClaims((Boolean)hasNonOIDCClaimsProperty);
        } else {
            authorizationGrantCacheEntry.setHasNonOIDCClaims(false);
        }
        if (StringUtils.isNotBlank((String)tokenRespDTO.getTokenId())) {
            authorizationGrantCacheEntry.setTokenId(tokenRespDTO.getTokenId());
        }
        long validityPeriod = TimeUnit.MILLISECONDS.toNanos(tokenRespDTO.getExpiresInMillis());
        authorizationGrantCacheEntry.setValidityPeriod(validityPeriod);
        AuthorizationGrantCache.getInstance().addToCacheByToken(authorizationGrantCacheKey, authorizationGrantCacheEntry);
    }

    private static Map<String, String> handleLocalClaims(Map<String, String> attributes, IdentityProvider identityProvider) {
        HashMap<String, String> localClaims = new HashMap();
        if (ClaimsUtil.isInLocalDialect(attributes)) {
            localClaims = attributes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Claims are in local dialect for identity provider: " + identityProvider.getIdentityProviderName() + ". Using attributes in assertion as the IDP claims."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Claims are not in local dialect for identity provider: " + identityProvider.getIdentityProviderName() + ". Not considering attributes in assertion."));
        }
        return localClaims;
    }
}

