/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.saml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidationProvider;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.NodeList;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.CertificateInfo;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.saml.SAML2TokenCallbackHandler;
import org.wso2.carbon.identity.oauth2.util.ClaimsUtil;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.util.X509CredentialImpl;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.identity.saml.common.util.UnmarshallUtils;
import org.wso2.carbon.identity.saml.common.util.exception.IdentityUnmarshallingException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SAML2BearerGrantHandler
extends AbstractAuthorizationGrantHandler {
    public static final String ASSERTION_ELEMENT = "Assertion";
    public static final String IDP_ENTITY_ID = "IdPEntityId";
    private static final Log log = LogFactory.getLog(SAML2BearerGrantHandler.class);
    private static final String SAMLSSO_AUTHENTICATOR = "samlsso";
    private static final String SAML2SSO_AUTHENTICATOR_NAME = "SAMLSSOAuthenticator";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_LOCATION = "Security.SAMLSignKeyStore.Location";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_TYPE = "Security.SAMLSignKeyStore.Type";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_PASSWORD = "Security.SAMLSignKeyStore.Password";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS = "Security.SAMLSignKeyStore.KeyAlias";
    public static final String SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD = "Security.SAMLSignKeyStore.KeyPassword";
    SAMLSignatureProfileValidator profileValidator = null;

    @Override
    public void init() throws IdentityOAuth2Exception {
        super.init();
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAMLInitializer.doBootstrap();
        }
        catch (InitializationException e) {
            log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            throw new IdentityOAuth2Exception("Error in bootstrapping the OpenSAML3 library");
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
        }
        this.profileValidator = new SAMLSignatureProfileValidator();
    }

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        super.validateGrant(tokReqMsgCtx);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"SAML_Assertion")) {
            log.debug((Object)("Received SAML assertion : " + new String(Base64.decodeBase64((String)tokReqMsgCtx.getOauth2AccessTokenReqDTO().getAssertion()), StandardCharsets.UTF_8)));
        }
        Assertion assertion = this.getAssertionObject(tokReqMsgCtx);
        this.validateSubject(tokReqMsgCtx, assertion);
        this.validateIssuer(tokReqMsgCtx, assertion);
        this.validateSignature(assertion);
        String tenantDomain = this.getTenantDomain(tokReqMsgCtx);
        IdentityProvider identityProvider = this.getIdentityProvider(assertion, tenantDomain);
        if (this.isSAMLSignKeyStoreConfigured()) {
            this.validateSignatureAgainstSAMLSignKeyStoreCertificate(assertion);
        } else {
            this.validateSignatureAgainstIdpCertificate(assertion, tenantDomain, identityProvider);
        }
        this.validateConditions(tokReqMsgCtx, assertion, identityProvider, tenantDomain);
        long timestampSkewInMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        this.validateAssertionTimeWindow(timestampSkewInMillis, this.getNotOnOrAfter(assertion), this.getNotBefore(assertion));
        this.processSubjectConfirmation(tokReqMsgCtx, assertion, identityProvider, tenantDomain, timestampSkewInMillis);
        this.setValuesInMessageContext(tokReqMsgCtx, assertion, identityProvider, tenantDomain);
        this.invokeExtension(tokReqMsgCtx);
        return true;
    }

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("urn:oasis:names:tc:SAML:2.0:cm:bearer");
    }

    @Override
    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokenReqMsgCtx) throws IdentityOAuth2Exception {
        Assertion assertion;
        OAuth2AccessTokenRespDTO responseDTO = super.issue(tokenReqMsgCtx);
        String[] scope = tokenReqMsgCtx.getScope();
        if (OAuth2Util.isOIDCAuthzRequest(scope) && (assertion = (Assertion)tokenReqMsgCtx.getProperty("SAML2Assertion")) != null) {
            this.handleClaimsInAssertion(tokenReqMsgCtx, responseDTO, assertion);
        }
        return responseDTO;
    }

    protected void handleClaimsInAssertion(OAuthTokenReqMessageContext tokenReqMsgCtx, OAuth2AccessTokenRespDTO responseDTO, Assertion assertion) throws IdentityOAuth2Exception {
        Map<String, String> attributes = ClaimsUtil.extractClaimsFromAssertion(tokenReqMsgCtx, responseDTO, assertion, FrameworkUtils.getMultiAttributeSeparator());
        if (attributes != null && attributes.size() > 0) {
            String tenantDomain = tokenReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
            if (StringUtils.isBlank((String)tenantDomain)) {
                tenantDomain = "carbon.super";
            }
            if (OAuthServerConfiguration.getInstance().isConvertOriginalClaimsFromAssertionsToOIDCDialect()) {
                IdentityProvider identityProvider = this.getIdentityProvider(assertion, tenantDomain);
                boolean localClaimDialect = identityProvider.getClaimConfig().isLocalClaimDialect();
                ClaimMapping[] idPClaimMappings = identityProvider.getClaimConfig().getClaimMappings();
                Map<String, String> localClaims = ClaimsUtil.isResidentIdp(identityProvider) ? this.handleClaimsForResidentIDP(attributes, identityProvider) : this.handleClaimsForIDP(attributes, tenantDomain, identityProvider, localClaimDialect, idPClaimMappings);
                if (localClaims != null && StringUtils.isNotBlank((String)localClaims.get("http://wso2.org/claims/role"))) {
                    String updatedRoleClaimValue = this.getUpdatedRoleClaimValue(identityProvider, localClaims.get("http://wso2.org/claims/role"));
                    if (updatedRoleClaimValue != null) {
                        localClaims.put("http://wso2.org/claims/role", updatedRoleClaimValue);
                    } else {
                        localClaims.remove("http://wso2.org/claims/role");
                        if (localClaims.isEmpty()) {
                            SAML2BearerGrantHandler.addUserAttributesToCache(responseDTO, tokenReqMsgCtx, new HashMap<ClaimMapping, String>());
                        }
                    }
                }
                if (localClaims != null && localClaims.size() > 0) {
                    Map<String, String> oidcClaims;
                    try {
                        oidcClaims = ClaimsUtil.convertClaimsToOIDCDialect(tokenReqMsgCtx, localClaims);
                    }
                    catch (IdentityApplicationManagementException | IdentityException e) {
                        throw new IdentityOAuth2Exception("Error while converting user claims to OIDC dialect from idp " + identityProvider.getIdentityProviderName(), e);
                    }
                    Map claimMappings = FrameworkUtils.buildClaimMappings(oidcClaims);
                    SAML2BearerGrantHandler.addUserAttributesToCache(responseDTO, tokenReqMsgCtx, claimMappings);
                }
            } else {
                Map claimMappings = FrameworkUtils.buildClaimMappings(attributes);
                Iterator iterator = claimMappings.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!"http://wso2.org/claims/role".equals(((ClaimMapping)entry.getKey()).getLocalClaim().getClaimUri()) || !StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
                    IdentityProvider identityProvider = this.getIdentityProvider(assertion, tenantDomain);
                    String updatedRoleClaimValue = this.getUpdatedRoleClaimValue(identityProvider, (String)entry.getValue());
                    if (updatedRoleClaimValue != null) {
                        entry.setValue(updatedRoleClaimValue);
                        break;
                    }
                    iterator.remove();
                    break;
                }
                SAML2BearerGrantHandler.addUserAttributesToCache(responseDTO, tokenReqMsgCtx, claimMappings);
            }
        }
    }

    private String getUpdatedRoleClaimValue(IdentityProvider identityProvider, String currentRoleClaimValue) {
        if (StringUtils.equalsIgnoreCase((String)"LOCAL", (String)identityProvider.getIdentityProviderName())) {
            return currentRoleClaimValue;
        }
        PermissionsAndRoleConfig permissionAndRoleConfig = identityProvider.getPermissionAndRoleConfig();
        if (permissionAndRoleConfig != null && ArrayUtils.isNotEmpty((Object[])permissionAndRoleConfig.getRoleMappings())) {
            String[] receivedRoles = currentRoleClaimValue.split(FrameworkUtils.getMultiAttributeSeparator());
            ArrayList<String> updatedRoleClaimValues = new ArrayList<String>();
            block0: for (String receivedRole : receivedRoles) {
                for (RoleMapping roleMapping : permissionAndRoleConfig.getRoleMappings()) {
                    if (!roleMapping.getRemoteRole().equals(receivedRole)) continue;
                    updatedRoleClaimValues.add(roleMapping.getLocalRole().getLocalRoleName());
                    continue block0;
                }
                if (OAuthServerConfiguration.getInstance().isReturnOnlyMappedLocalRoles()) continue;
                updatedRoleClaimValues.add(receivedRole);
            }
            if (!updatedRoleClaimValues.isEmpty()) {
                return StringUtils.join(updatedRoleClaimValues, (String)FrameworkUtils.getMultiAttributeSeparator());
            }
            return null;
        }
        if (!OAuthServerConfiguration.getInstance().isReturnOnlyMappedLocalRoles()) {
            return currentRoleClaimValue;
        }
        return null;
    }

    protected Map<String, String> handleClaimsForIDP(Map<String, String> attributes, String tenantDomain, IdentityProvider identityProvider, boolean localClaimDialect, ClaimMapping[] idPClaimMappings) {
        return ClaimsUtil.handleClaimsForIDP(attributes, tenantDomain, identityProvider, localClaimDialect, idPClaimMappings);
    }

    protected Map<String, String> handleClaimsForResidentIDP(Map<String, String> attributes, IdentityProvider identityProvider) {
        return ClaimsUtil.handleClaimsForResidentIDP(attributes, identityProvider);
    }

    protected static void addUserAttributesToCache(OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext msgCtx, Map<ClaimMapping, String> userAttributes) {
        ClaimsUtil.addUserAttributesToCache(tokenRespDTO, msgCtx, userAttributes);
    }

    private void validateAssertionTimeWindow(long timestampSkewInMillis, DateTime notOnOrAfterFromConditions, DateTime notBeforeConditions) throws IdentityOAuth2Exception {
        if (!this.isWithinValidTimeWindow(notOnOrAfterFromConditions, notBeforeConditions, timestampSkewInMillis)) {
            throw new IdentityOAuth2Exception("Assertion is not valid according to the time window provided in Conditions");
        }
    }

    private void processSubjectConfirmation(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, IdentityProvider identityProvider, String tenantDomain, long timeSkew) throws IdentityOAuth2Exception {
        boolean bearerFound = false;
        Map<DateTime, DateTime> notOnOrAfterAndNotBeforeFromSubjectConfirmation = new HashMap<DateTime, DateTime>();
        ArrayList<String> recipientURLS = new ArrayList<String>();
        List<SubjectConfirmation> subjectConfirmations = this.getSubjectConfirmations(assertion);
        for (SubjectConfirmation subjectConfirmation : subjectConfirmations) {
            bearerFound = this.updateBearerFound(subjectConfirmation, bearerFound);
            if (subjectConfirmation.getSubjectConfirmationData() == null) continue;
            recipientURLS.addAll(this.getRecipientUrls(subjectConfirmation.getSubjectConfirmationData()));
            notOnOrAfterAndNotBeforeFromSubjectConfirmation = this.getValidNotBeforeAndAfterDetails(subjectConfirmation.getSubjectConfirmationData(), timeSkew);
        }
        this.validateBearer(bearerFound);
        String tokenEPAlias = this.getTokenEPAlias(assertion, identityProvider, tenantDomain);
        this.validateRecipient(assertion, tokenEPAlias, recipientURLS);
        this.setValidityPeriod(tokReqMsgCtx, assertion, notOnOrAfterAndNotBeforeFromSubjectConfirmation);
    }

    private void validateBearer(boolean bearerFound) throws IdentityOAuth2Exception {
        if (!bearerFound) {
            throw new IdentityOAuth2Exception("Failed to find a SubjectConfirmation with a Method attribute having : urn:oasis:names:tc:SAML:2.0:cm:bearer");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValidityPeriod(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, Map<DateTime, DateTime> notOnOrAfterAndNotBefore) throws IdentityOAuth2Exception {
        long curTimeInMillis = Calendar.getInstance().getTimeInMillis();
        DateTime notOnOrAfterFromSubjectConfirmation = null;
        DateTime notOnOrAfter = this.getNotOnOrAfter(assertion);
        if (notOnOrAfter != null) {
            tokReqMsgCtx.setValidityPeriod(notOnOrAfter.getMillis() - curTimeInMillis);
            return;
        } else {
            if (notOnOrAfterAndNotBefore.isEmpty()) throw new IdentityOAuth2Exception("Cannot find valid NotOnOrAfter details in assertion");
            if (log.isDebugEnabled()) {
                log.debug((Object)"NotOnORAfter details are not found in Conditions. Evaluating values received in SubjectConfirmationData");
            }
            for (Map.Entry<DateTime, DateTime> entry : notOnOrAfterAndNotBefore.entrySet()) {
                if (!this.isSubjectConfirmationTimeWindowIncludedInConditionsTimeWindow(notOnOrAfter, this.getNotBefore(assertion), entry)) continue;
                notOnOrAfterFromSubjectConfirmation = entry.getKey();
            }
            if (notOnOrAfterFromSubjectConfirmation != null) {
                tokReqMsgCtx.setValidityPeriod(notOnOrAfterFromSubjectConfirmation.getMillis() - curTimeInMillis);
                return;
            } else {
                if (!log.isDebugEnabled()) throw new IdentityOAuth2Exception("Cannot find valid NotOnOrAfter details in assertion");
                log.debug((Object)"Valid NotOnORAfter details are not found in SubjectConfirmation");
                throw new IdentityOAuth2Exception("Cannot find valid NotOnOrAfter details in assertion");
            }
        }
    }

    private boolean isSubjectConfirmationTimeWindowIncludedInConditionsTimeWindow(DateTime notOnOrAfter, DateTime notBefore, Map.Entry<DateTime, DateTime> entry) {
        if (notOnOrAfter != null && notOnOrAfter.isBefore((ReadableInstant)entry.getKey())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Conditions has earlier expiry than SubjectConfirmationData");
            }
            return false;
        }
        if (notBefore != null && entry.getValue() != null && notBefore.isAfter((ReadableInstant)entry.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NotBefore in SubjectConfirmationData has earlier value than NotBefore in Conditions");
            }
            return false;
        }
        return true;
    }

    private void validateRecipient(Assertion assertion, String tokenEndpointAlias, List<String> recipientURLS) throws IdentityOAuth2Exception {
        if (CollectionUtils.isNotEmpty(recipientURLS) && !recipientURLS.contains(tokenEndpointAlias)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("None of the recipient URLs match against the token endpoint alias : " + tokenEndpointAlias));
            }
            throw new IdentityOAuth2Exception("Recipient validation failed");
        }
    }

    private void setValuesInMessageContext(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, IdentityProvider identityProvider, String tenantDomain) throws IdentityOAuth2Exception {
        this.setUserInMessageContext(tokReqMsgCtx, identityProvider, assertion, tenantDomain);
        tokReqMsgCtx.setScope(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope());
        tokReqMsgCtx.addProperty("SAML2Assertion", assertion);
    }

    private void invokeExtension(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        SAML2TokenCallbackHandler callback = OAuthServerConfiguration.getInstance().getSAML2TokenCallbackHandler();
        if (callback != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking the SAML2 Token callback handler");
            }
            callback.handleSAML2Token(tokReqMsgCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateSignatureAgainstIdpCertificate(Assertion assertion, String tenantDomain, IdentityProvider identityProvider) throws IdentityOAuth2Exception {
        boolean isExceptionThrown = false;
        SignatureException signatureException = null;
        Object[] certificateInfos = identityProvider.getCertificateInfoArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)(certificateInfos.length + " certificates found for Identity Provider " + identityProvider.getIdentityProviderName()));
        }
        if (ArrayUtils.isEmpty((Object[])certificateInfos)) {
            throw new IdentityOAuth2Exception("No certificates found for Identity Provider " + identityProvider.getIdentityProviderName() + " of tenant domain " + tenantDomain);
        }
        try {
            Thread thread = Thread.currentThread();
            ClassLoader originalClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(SignatureValidationProvider.class.getClassLoader());
            try {
                int index = 0;
                for (Object certificateInfo : certificateInfos) {
                    X509Certificate x509Certificate = this.getIdpCertificate(tenantDomain, identityProvider, (CertificateInfo)certificateInfo);
                    X509CredentialImpl x509Credential = new X509CredentialImpl(x509Certificate);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Validating the signature with certificate " + certificateInfo.getThumbPrint() + " at index: " + index));
                        }
                        SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)x509Credential);
                        isExceptionThrown = false;
                        break;
                    }
                    catch (SignatureException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Signature validation failed with certificate " + certificateInfo.getThumbPrint() + " at index: " + index));
                        }
                        isExceptionThrown = true;
                        if (signatureException == null) {
                            signatureException = e;
                        } else {
                            signatureException.addSuppressed((Throwable)e);
                        }
                        ++index;
                    }
                }
                if (isExceptionThrown) {
                    throw signatureException;
                }
            }
            finally {
                thread.setContextClassLoader(originalClassLoader);
            }
        }
        catch (SignatureException e) {
            throw new IdentityOAuth2Exception("Error while validating the signature.", e);
        }
    }

    private X509Certificate getIdpCertificate(String tenantDomain, IdentityProvider identityProvider, CertificateInfo certificateInfo) throws IdentityOAuth2Exception {
        X509Certificate x509Certificate;
        try {
            x509Certificate = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)certificateInfo.getCertValue());
        }
        catch (CertificateException e) {
            throw new IdentityOAuth2Exception("Error occurred while decoding public certificate with thumbprint " + certificateInfo.getThumbPrint() + " of Identity Provider " + identityProvider.getIdentityProviderName() + " for tenant domain " + tenantDomain, e);
        }
        return x509Certificate;
    }

    private void validateSignature(Assertion assertion) throws IdentityOAuth2Exception {
        try {
            this.profileValidator.validate(assertion.getSignature());
        }
        catch (SignatureException e) {
            throw new IdentityOAuth2Exception("Signature do not adhere to the SAML signature profile.", e);
        }
    }

    private Map<DateTime, DateTime> getValidNotBeforeAndAfterDetails(SubjectConfirmationData subjectConfirmationData, long timeSkew) throws IdentityOAuth2Exception {
        DateTime notBefore;
        HashMap<DateTime, DateTime> timeConstrainsFromSubjectConfirmation = new HashMap<DateTime, DateTime>();
        DateTime notOnOrAfter = subjectConfirmationData.getNotOnOrAfter();
        if (this.isWithinValidTimeWindow(notOnOrAfter, notBefore = subjectConfirmationData.getNotBefore(), timeSkew)) {
            if (notOnOrAfter != null) {
                timeConstrainsFromSubjectConfirmation.put(notOnOrAfter, notBefore);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find valid NotOnOrAfter and NotBefore attributes in SubjectConfirmationData " + subjectConfirmationData.toString()));
            }
        }
        return timeConstrainsFromSubjectConfirmation;
    }

    private List<String> getRecipientUrls(SubjectConfirmationData subjectConfirmationData) {
        ArrayList<String> recipientURLS = new ArrayList<String>();
        if (subjectConfirmationData.getRecipient() != null) {
            recipientURLS.add(subjectConfirmationData.getRecipient());
        }
        return recipientURLS;
    }

    private DateTime getNotBefore(Assertion assertion) {
        return assertion.getConditions().getNotBefore();
    }

    private DateTime getNotOnOrAfter(Assertion assertion) {
        return assertion.getConditions().getNotOnOrAfter();
    }

    private boolean isWithinValidTimeWindow(DateTime notOnOrAfterFromConditions, DateTime notBeforeConditions, long timestampSkewInMillis) throws IdentityOAuth2Exception {
        if (notOnOrAfterFromConditions != null && this.isExpired(notOnOrAfterFromConditions, timestampSkewInMillis)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NotOnOrAfter :" + notOnOrAfterFromConditions + ". Assertion is not valid anymore"));
            }
            return false;
        }
        if (this.isBeforeValidPeriod(notBeforeConditions, timestampSkewInMillis)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NotBefore :" + notBeforeConditions + ". Assertion is not valid during this time"));
            }
            return false;
        }
        return true;
    }

    private boolean isBeforeValidPeriod(DateTime notBeforeConditions, long timestampSkewInMillis) {
        return notBeforeConditions != null && notBeforeConditions.minus(timestampSkewInMillis).isAfterNow();
    }

    private boolean isExpired(DateTime notOnOrAfterFromConditions, long timestampSkewInMillis) {
        return notOnOrAfterFromConditions.plus(timestampSkewInMillis).isBeforeNow();
    }

    private boolean updateBearerFound(SubjectConfirmation subjectConfirmation, boolean bearerFound) throws IdentityOAuth2Exception {
        if (subjectConfirmation.getMethod() != null) {
            if (subjectConfirmation.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")) {
                bearerFound = true;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find Method attribute in SubjectConfirmation " + subjectConfirmation.toString()));
            }
            throw new IdentityOAuth2Exception("Cannot find Method attribute in SubjectConfirmation");
        }
        return bearerFound;
    }

    private List<SubjectConfirmation> getSubjectConfirmations(Assertion assertion) throws IdentityOAuth2Exception {
        List subjectConfirmations = assertion.getSubject().getSubjectConfirmations();
        if (subjectConfirmations == null || subjectConfirmations.isEmpty()) {
            throw new IdentityOAuth2Exception("No SubjectConfirmation exist in Assertion");
        }
        return subjectConfirmations;
    }

    private String getTokenEPAlias(Assertion assertion, IdentityProvider identityProvider, String tenantDomain) throws IdentityOAuth2Exception {
        String tokenEndpointAlias = ClaimsUtil.isResidentIdp(identityProvider) ? this.getTokenEPAliasFromResidentIdp(assertion, identityProvider, tenantDomain) : identityProvider.getAlias();
        return tokenEndpointAlias;
    }

    private void validateConditions(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, IdentityProvider identityProvider, String tenantDomain) throws IdentityOAuth2Exception {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            throw new IdentityOAuth2Exception("SAML Assertion doesn't contain Conditions");
        }
        String tokenEndpointAlias = this.getTokenEPAlias(assertion, identityProvider, tenantDomain);
        this.validateAudience(identityProvider, conditions, tokenEndpointAlias, tenantDomain);
    }

    private boolean validateTokenEPAlias(IdentityProvider identityProvider, String tokenEndpointAlias, String tenantDomain) throws IdentityOAuth2Exception {
        if (StringUtils.isBlank((String)tokenEndpointAlias)) {
            if (log.isDebugEnabled()) {
                String errorMsg = "Token Endpoint alias has not been configured in the Identity Provider : " + identityProvider.getIdentityProviderName() + " in tenant : " + tenantDomain;
                log.debug((Object)errorMsg);
            }
            throw new IdentityOAuth2Exception("Token Endpoint alias has not been configured in the Identity Provider");
        }
        return true;
    }

    private boolean validateAudienceRestriction(List<AudienceRestriction> audienceRestrictions) throws IdentityOAuth2Exception {
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            if (log.isDebugEnabled()) {
                String message = "SAML Assertion doesn't contain AudienceRestrictions";
                log.debug((Object)message);
            }
            throw new IdentityOAuth2Exception("Audience restriction not found in the saml assertion");
        }
        return true;
    }

    private boolean validateAudience(IdentityProvider identityProvider, Conditions conditions, String tokenEndpointAlias, String tenantDomain) throws IdentityOAuth2Exception {
        this.validateTokenEPAlias(identityProvider, tokenEndpointAlias, tenantDomain);
        List audienceRestrictions = conditions.getAudienceRestrictions();
        this.validateAudienceRestriction(audienceRestrictions);
        boolean audienceFound = false;
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (CollectionUtils.isNotEmpty((Collection)audienceRestriction.getAudiences())) {
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!audience.getAudienceURI().equals(tokenEndpointAlias)) continue;
                    audienceFound = true;
                    break;
                }
            }
            if (!audienceFound) continue;
            break;
        }
        if (!audienceFound) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Assertion Audience Restriction validation failed against the Audience : " + tokenEndpointAlias + " of Identity Provider : " + identityProvider.getIdentityProviderName() + " in tenant : " + tenantDomain));
            }
            throw new IdentityOAuth2Exception("SAML Assertion Audience Restriction validation failed");
        }
        return true;
    }

    private String getTokenEPAliasFromResidentIdp(Assertion assertion, IdentityProvider identityProvider, String tenantDomain) throws IdentityOAuth2Exception {
        String tokenEndpointAlias = null;
        FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        Property oauthProperty = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)"OAuth2TokenEPUrl");
        if (oauthProperty != null) {
            tokenEndpointAlias = oauthProperty.getValue();
        }
        return tokenEndpointAlias;
    }

    private boolean validateIdpEntityId(Assertion assertion, String tenantDomain, String idpEntityId) throws IdentityOAuth2Exception {
        if (idpEntityId == null || !assertion.getIssuer().getValue().equals(idpEntityId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Token Issuer verification failed against resident Identity Provider in tenant : " + tenantDomain + ". Received : " + assertion.getIssuer().getValue() + ", Expected : " + idpEntityId));
            }
            throw new IdentityOAuth2Exception("Issuer verification failed against resident idp");
        }
        return true;
    }

    private String getIdpEntityId(FederatedAuthenticatorConfig[] fedAuthnConfigs) {
        String idpEntityId = null;
        FederatedAuthenticatorConfig samlAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)SAMLSSO_AUTHENTICATOR);
        Property samlProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlAuthenticatorConfig.getProperties(), (String)IDP_ENTITY_ID);
        if (samlProperty != null) {
            idpEntityId = samlProperty.getValue();
        }
        return idpEntityId;
    }

    private IdentityProvider getIdentityProvider(Assertion assertion, String tenantDomain) throws IdentityOAuth2Exception {
        try {
            IdentityProvider identityProvider = this.getIdentityProviderFromManager(assertion, tenantDomain);
            this.checkNullIdentityProvider(assertion, tenantDomain, identityProvider);
            if (ClaimsUtil.isResidentIdp(identityProvider)) {
                identityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found an idp with given information. IDP name : " + identityProvider.getIdentityProviderName()));
            }
            return identityProvider;
        }
        catch (IdentityProviderManagementException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while retrieving identity provider for issuer : " + assertion.getIssuer().getValue() + " for tenantDomain : " + tenantDomain), (Throwable)e);
            }
            throw new IdentityOAuth2Exception("Error while retrieving identity provider");
        }
    }

    private IdentityProvider getIdentityProviderFromManager(Assertion assertion, String tenantDomain) throws IdentityProviderManagementException, IdentityOAuth2Exception {
        IdentityProvider identityProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving identity provider : " + assertion.getIssuer().getValue() + " for authenticator name " + SAMLSSO_AUTHENTICATOR));
        }
        if ((identityProvider = this.getIdPByAuthenticatorPropertyValue(assertion, tenantDomain, SAMLSSO_AUTHENTICATOR)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Couldnt find an idp for samlsso authenticator. Hence retrieving identity provider : " + assertion.getIssuer().getValue() + " for authenticator name " + SAML2SSO_AUTHENTICATOR_NAME));
            }
            identityProvider = this.getIdPByAuthenticatorPropertyValue(assertion, tenantDomain, SAML2SSO_AUTHENTICATOR_NAME);
        }
        if (identityProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Token Issuer : " + assertion.getIssuer().getValue() + " is not registered as a local Identity Provider in tenant : " + tenantDomain + ". Hence checking if the assertion is from resident IdP with IdP Entity ID Alias enabled"));
            }
            if (this.validateIdpEntityIdAliasFromSAMLSP(assertion, tenantDomain).booleanValue()) {
                identityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
            }
        }
        return identityProvider;
    }

    private IdentityProvider getIdPByAuthenticatorPropertyValue(Assertion assertion, String tenantDomain, String authenticatorProperty) throws IdentityProviderManagementException {
        return IdentityProviderManager.getInstance().getIdPByAuthenticatorPropertyValue(IDP_ENTITY_ID, assertion.getIssuer().getValue(), tenantDomain, authenticatorProperty, false);
    }

    private void checkNullIdentityProvider(Assertion assertion, String tenantDomain, IdentityProvider identityProvider) throws IdentityOAuth2Exception {
        if (identityProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Token Issuer : " + assertion.getIssuer().getValue() + " not registered as a local Identity Provider in tenant : " + tenantDomain));
            }
            throw new IdentityOAuth2Exception("Identity provider is null");
        }
    }

    private Boolean validateIdpEntityIdAliasFromSAMLSP(Assertion assertion, String tenantDomain) throws IdentityOAuth2Exception {
        Conditions conditions = assertion.getConditions();
        List audienceRestrictions = conditions.getAudienceRestrictions();
        this.validateAudienceRestriction(audienceRestrictions);
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (!CollectionUtils.isNotEmpty((Collection)audienceRestriction.getAudiences())) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                SAMLSSOServiceProviderDO samlssoServiceProviderDO = this.getSAMLSSOServiceProvider(audience.getAudienceURI(), tenantDomain);
                if (samlssoServiceProviderDO == null || samlssoServiceProviderDO.getIdpEntityIDAlias() == null || !samlssoServiceProviderDO.getIdpEntityIDAlias().equals(assertion.getIssuer().getValue())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token Issuer verified against IdP Entity ID Alias : " + samlssoServiceProviderDO.getIdpEntityIDAlias() + " of SAML Service Provider " + samlssoServiceProviderDO.getIssuer() + " in tenant : " + tenantDomain + "."));
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No SAML Service Provider configuration with IdP Entity ID Alias similar to token issuer found.");
        }
        return false;
    }

    private SAMLSSOServiceProviderDO getSAMLSSOServiceProvider(String issuerName, String tenantDomain) throws IdentityOAuth2Exception {
        int tenantId;
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
            tenantId = -1234;
        } else {
            try {
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error occurred while retrieving tenant id for the domain : " + tenantDomain, e);
            }
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(tenantId);
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            Registry registry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            SAMLSSOServiceProviderDO sAMLSSOServiceProviderDO = persistenceManager.getServiceProvider(registry, issuerName);
            return sAMLSSOServiceProviderDO;
        }
        catch (IdentityException e) {
            throw new IdentityOAuth2Exception("Error occurred while validating existence of SAML service provider '" + issuerName + "' that issued the assertion in the tenant domain '" + tenantDomain + "'");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private boolean validateIssuer(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion) throws IdentityOAuth2Exception {
        if (this.issuerNotFoundInAssertion(assertion)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Issuer is empty in the SAML assertion. Token request for user : " + tokReqMsgCtx.getAuthorizedUser()));
            }
            throw new IdentityOAuth2Exception("Issuer is empty in the SAML assertion");
        }
        return true;
    }

    private boolean issuerNotFoundInAssertion(Assertion assertion) {
        return assertion.getIssuer() == null || StringUtils.isEmpty((String)assertion.getIssuer().getValue());
    }

    private boolean validateSubject(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion) throws IdentityOAuth2Exception {
        if (assertion.getSubject() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find a Subject in the Assertion. Token request for the user : " + tokReqMsgCtx.getAuthorizedUser()));
            }
            throw new IdentityOAuth2Exception("Cannot find a Subject in the Assertion");
        }
        this.validateNameId(tokReqMsgCtx, assertion);
        return true;
    }

    private void validateNameId(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion) throws IdentityOAuth2Exception {
        if (StringUtils.isBlank((String)this.getNameIdValue(assertion))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NameID in Assertion is not found in subject. Token request for the user : " + tokReqMsgCtx.getAuthorizedUser()));
            }
            throw new IdentityOAuth2Exception("NameID in Assertion cannot be empty");
        }
    }

    protected String getUserId(OAuthTokenReqMessageContext tokReqMsgCtx, IdentityProvider identityProvider, Assertion assertion) throws IdentityOAuth2Exception {
        if (OAuthServerConfiguration.getInstance().getSaml2UserIdFromClaims()) {
            if (this.isUserIdFromClaimsEnabled(identityProvider)) {
                Map<String, String> attributes = ClaimsUtil.extractClaimsFromAssertion(tokReqMsgCtx, null, assertion, FrameworkUtils.getMultiAttributeSeparator());
                String userClaimURI = identityProvider.getClaimConfig().getUserClaimURI();
                if (StringUtils.isNotBlank((String)userClaimURI)) {
                    String userClaimValue;
                    if (attributes != null && StringUtils.isNotBlank((String)(userClaimValue = attributes.get(userClaimURI)))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using the user claim URI value : " + userClaimValue + " as the user id."));
                        }
                        return userClaimValue;
                    }
                    throw new IdentityOAuth2Exception("User id found among claims option and user claim URI : " + userClaimURI + " are configured for the SAML federated identity provider : " + identityProvider.getIdentityProviderName() + ", but user claim value is not present in the SAML assertion.");
                }
                throw new IdentityOAuth2Exception("SAML federated authenticator configuration IsUserIdInClaims is enabled to the identity provider : " + identityProvider.getIdentityProviderName() + " but User ID Claim URI is not selected in basic claim configuration.");
            }
            throw new IdentityOAuth2Exception("UserIdFromClaims configuration is enabled for saml bearer grant but SAML federated authenticator configuration IsUserIdInClaims is not enabled to the identity provider : " + identityProvider.getIdentityProviderName());
        }
        String nameIdValue = this.getNameIdValue(assertion);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the name identifier : " + nameIdValue + " as the user id."));
        }
        return nameIdValue;
    }

    private boolean isUserIdFromClaimsEnabled(IdentityProvider identityProvider) {
        Property isUserIdInClaims;
        FederatedAuthenticatorConfig fedSAMLAuthnConfig;
        FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
        if (fedAuthnConfigs != null && (fedSAMLAuthnConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)SAML2SSO_AUTHENTICATOR_NAME)) != null && (isUserIdInClaims = IdentityApplicationManagementUtil.getProperty((Property[])fedSAMLAuthnConfig.getProperties(), (String)"IsUserIdInClaims")) != null && "TRUE".equalsIgnoreCase(isUserIdInClaims.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IsUserIdInClaims is enabled to the SAML federated identity provider : " + identityProvider.getIdentityProviderName()));
            }
            return true;
        }
        return false;
    }

    private String getNameIdValue(Assertion assertion) throws IdentityOAuth2Exception {
        if (assertion.getSubject().getNameID() != null) {
            return assertion.getSubject().getNameID().getValue();
        }
        throw new IdentityOAuth2Exception("NameID value is null. Cannot proceed");
    }

    private Assertion getAssertionObject(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        try {
            XMLObject samlObject = UnmarshallUtils.unmarshall((String)new String(Base64.decodeBase64((String)tokReqMsgCtx.getOauth2AccessTokenReqDTO().getAssertion()), StandardCharsets.UTF_8));
            this.validateAssertionList(samlObject);
            return this.getAssertion(samlObject);
        }
        catch (IdentityUnmarshallingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while unmashalling the assertion", (Throwable)e);
            }
            throw new IdentityOAuth2Exception("Error while unmashalling the assertion", e);
        }
    }

    private Assertion getAssertion(XMLObject samlObject) throws IdentityOAuth2Exception {
        if (samlObject instanceof Assertion) {
            return (Assertion)samlObject;
        }
        throw new IdentityOAuth2Exception("Only Assertion objects are validated in SAML2Bearer Grant Type");
    }

    private boolean validateAssertionList(XMLObject samlObject) throws IdentityOAuth2Exception {
        NodeList assertionList = samlObject.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", ASSERTION_ELEMENT);
        if (assertionList.getLength() > 0) {
            throw new IdentityOAuth2Exception("Nested assertions found in request");
        }
        return true;
    }

    private String getTenantDomain(OAuthTokenReqMessageContext tokReqMsgCtx) {
        String tenantDomain = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        return tenantDomain;
    }

    protected void setUserInMessageContext(OAuthTokenReqMessageContext tokReqMsgCtx, IdentityProvider identityProvider, Assertion assertion, String spTenantDomain) throws IdentityOAuth2Exception {
        if ("FEDERATED".equalsIgnoreCase(OAuthServerConfiguration.getInstance().getSaml2BearerTokenUserType())) {
            this.setFederatedUser(tokReqMsgCtx, assertion, spTenantDomain);
        } else if ("LOCAL".equalsIgnoreCase(OAuthServerConfiguration.getInstance().getSaml2BearerTokenUserType())) {
            try {
                this.setLocalUser(tokReqMsgCtx, assertion, spTenantDomain);
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error while building local user from given assertion", e);
            }
        } else if ("LEGACY".equalsIgnoreCase(OAuthServerConfiguration.getInstance().getSaml2BearerTokenUserType())) {
            this.createLegacyUser(tokReqMsgCtx, assertion);
        } else if (ClaimsUtil.isResidentIdp(identityProvider)) {
            try {
                this.setLocalUser(tokReqMsgCtx, assertion, spTenantDomain);
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error while building local user from given assertion", e);
            }
        } else {
            this.setFederatedUser(tokReqMsgCtx, assertion, spTenantDomain);
        }
    }

    protected void setFederatedUser(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, String tenantDomain) throws IdentityOAuth2Exception {
        IdentityProvider identityProvider = this.getIdentityProvider(assertion, tenantDomain);
        String subjectIdentifier = this.getUserId(tokReqMsgCtx, identityProvider, assertion);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting federated user : " + subjectIdentifier + ". with SP tenant domain : " + tenantDomain));
        }
        AuthenticatedUser user = AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)subjectIdentifier);
        user.setUserName(subjectIdentifier);
        user.setFederatedIdPName(this.getIdentityProvider(assertion, this.getTenantDomain(tokReqMsgCtx)).getIdentityProviderName());
        tokReqMsgCtx.setAuthorizedUser(user);
    }

    protected void setLocalUser(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, String spTenantDomain) throws UserStoreException, IdentityOAuth2Exception {
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        UserStoreManager userStoreManager = null;
        ServiceProvider serviceProvider = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving service provider for client id : " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId() + ". Tenant domain : " + spTenantDomain));
            }
            serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId(), "oauth2", spTenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error while retrieving service provider for client id : " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId() + " in tenant domain " + spTenantDomain);
        }
        AuthenticatedUser authenticatedUser = this.buildLocalUser(tokReqMsgCtx, assertion, serviceProvider, spTenantDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting local user with username :" + authenticatedUser.getUserName() + ". User store domain :" + authenticatedUser.getUserStoreDomain() + ". Tenant domain : " + authenticatedUser.getTenantDomain() + " . Authenticated subjectIdentifier : " + authenticatedUser.getAuthenticatedSubjectIdentifier()));
        }
        if (!spTenantDomain.equalsIgnoreCase(authenticatedUser.getTenantDomain()) && !serviceProvider.isSaasApp()) {
            throw new IdentityOAuth2Exception("Non SaaS app tries to issue token for a different tenant domain. User tenant domain : " + authenticatedUser.getTenantDomain() + ". SP tenant domain : " + spTenantDomain);
        }
        userStoreManager = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)authenticatedUser.getTenantDomain())).getUserStoreManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking whether the user exists in local user store");
        }
        if (this.userDoesNotExist(userStoreManager, authenticatedUser)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + authenticatedUser.getUsernameAsSubjectIdentifier(true, false) + " doesn't exist in local user store."));
            }
            throw new IdentityOAuth2Exception("User not found in local user store");
        }
        tokReqMsgCtx.setAuthorizedUser(authenticatedUser);
    }

    private boolean userDoesNotExist(UserStoreManager userStoreManager, AuthenticatedUser authenticatedUser) throws UserStoreException {
        return !userStoreManager.isExistingUser(authenticatedUser.getUsernameAsSubjectIdentifier(true, false));
    }

    protected AuthenticatedUser buildLocalUser(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion, ServiceProvider serviceProvider, String spTenantDomain) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        IdentityProvider identityProvider = this.getIdentityProvider(assertion, spTenantDomain);
        String subjectIdentifier = this.getUserId(tokReqMsgCtx, identityProvider, assertion);
        String userTenantDomain = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building local user with assertion subject : " + subjectIdentifier));
        }
        authenticatedUser.setUserStoreDomain(UserCoreUtil.extractDomainFromName((String)subjectIdentifier));
        authenticatedUser.setUserName(MultitenantUtils.getTenantAwareUsername((String)UserCoreUtil.removeDomainFromName((String)subjectIdentifier)));
        userTenantDomain = MultitenantUtils.getTenantDomain((String)subjectIdentifier);
        if (!serviceProvider.isSaasApp() && !subjectIdentifier.endsWith("carbon.super") && "carbon.super".equalsIgnoreCase(userTenantDomain)) {
            userTenantDomain = spTenantDomain;
        }
        authenticatedUser.setTenantDomain(userTenantDomain);
        authenticatedUser.setAuthenticatedSubjectIdentifier(authenticatedUser.getUserName(), serviceProvider);
        authenticatedUser.setFederatedIdPName(this.getIdentityProvider(assertion, this.getTenantDomain(tokReqMsgCtx)).getIdentityProviderName());
        return authenticatedUser;
    }

    protected void createLegacyUser(OAuthTokenReqMessageContext tokReqMsgCtx, Assertion assertion) throws IdentityOAuth2Exception {
        String tenantDomain = this.getTenantDomain(tokReqMsgCtx);
        IdentityProvider identityProvider = this.getIdentityProvider(assertion, tenantDomain);
        String resourceOwnerUserName = this.getUserId(tokReqMsgCtx, identityProvider, assertion);
        AuthenticatedUser user = OAuth2Util.getUserFromUserName(resourceOwnerUserName);
        user.setAuthenticatedSubjectIdentifier(resourceOwnerUserName);
        user.setFederatedUser(true);
        user.setFederatedIdPName(this.getIdentityProvider(assertion, this.getTenantDomain(tokReqMsgCtx)).getIdentityProviderName());
        tokReqMsgCtx.setAuthorizedUser(user);
    }

    protected void validateSignatureAgainstSAMLSignKeyStoreCertificate(Assertion assertion) throws IdentityOAuth2Exception {
        try {
            X509Certificate x509Certificate = this.getCertificateFromSAMLSignKeyStore();
            X509CredentialImpl x509Credential = new X509CredentialImpl(x509Certificate);
            SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)x509Credential);
        }
        catch (SignatureException e) {
            if (StringUtils.isNotEmpty((String)assertion.getIssuer().getValue())) {
                throw new IdentityOAuth2Exception("Error while validating the signature from SAML sign keystore for SAML Token Issuer: " + assertion.getIssuer().getValue(), e);
            }
            throw new IdentityOAuth2Exception("Error while validating the signature from SAML sign keystore, SAML Token Issuer is null.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate getCertificateFromSAMLSignKeyStore() throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting the certificate from separate SAMLSignKeyStore.");
        }
        String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
        try (FileInputStream smalKeystoreFile = new FileInputStream(keyStoreLocation);){
            String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            char[] keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD).toCharArray();
            keyStore.load(smalKeystoreFile, keyStorePassword);
            KeyStore samlSignKeyStore = keyStore;
            String keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS);
            X509Certificate x509Certificate = (X509Certificate)samlSignKeyStore.getCertificate(keyAlias);
            return x509Certificate;
        }
        catch (FileNotFoundException e) {
            throw new IdentityOAuth2Exception("Unable to locate SAML sign keystore.", e);
        }
        catch (IOException e) {
            throw new IdentityOAuth2Exception("Unable to read SAML sign keystore.", e);
        }
        catch (CertificateException e) {
            throw new IdentityOAuth2Exception("Unable to read certificate from SAML sign keystore.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityOAuth2Exception("Unable to load algorithm.", e);
        }
        catch (KeyStoreException e) {
            throw new IdentityOAuth2Exception("Unable to load SAML sign keystore.", e);
        }
    }

    private boolean isSAMLSignKeyStoreConfigured() {
        String keyStoreLocation = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_LOCATION);
        String keyStoreType = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_TYPE);
        String keyStorePassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_PASSWORD);
        String keyAlias = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_ALIAS);
        String keyPassword = ServerConfiguration.getInstance().getFirstProperty(SECURITY_SAML_SIGN_KEY_STORE_KEY_PASSWORD);
        return StringUtils.isNotBlank((String)keyStoreLocation) && StringUtils.isNotBlank((String)keyStoreType) && StringUtils.isNotBlank((String)keyStorePassword) && StringUtils.isNotBlank((String)keyAlias) && StringUtils.isNotBlank((String)keyPassword);
    }
}

