/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.saml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.saml.SAML2TokenCallbackHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.util.X509CredentialImpl;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.identity.saml.common.util.UnmarshallUtils;
import org.wso2.carbon.identity.saml.common.util.exception.IdentityUnmarshallingException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class SAML1BearerGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(SAML1BearerGrantHandler.class);
    SAMLSignatureProfileValidator profileValidator = null;
    private boolean audienceRestrictionValidationEnabled = false;
    private static final String SAML10_BEARER_GRANT_TYPE_CONFIG_FILE = "SAML10_BearerGrantType.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IdentityOAuth2Exception {
        super.init();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAMLInitializer.doBootstrap();
        }
        catch (InitializationException e) {
            String errorMessage = "Error in bootstrapping the OpenSAML library";
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        this.profileValidator = new SAMLSignatureProfileValidator();
        Properties grantTypeProperties = new Properties();
        InputStream stream = loader.getResourceAsStream("repository/conf/SAML10_BearerGrantType.properties");
        if (stream != null) {
            try {
                grantTypeProperties.load(stream);
                this.audienceRestrictionValidationEnabled = Boolean.parseBoolean(grantTypeProperties.getProperty("audienceRestrictionValidationEnabled"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Audience restriction validation enabled is set to " + this.audienceRestrictionValidationEnabled));
                }
            }
            catch (IOException e) {
                log.warn((Object)"Failed to load the SAML-1.0-BearerGrantType.properties stream. The default configurations are used instead of configurations defined in SAML10_BearerGrantType.properties file.");
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Failed to close the input stream of SAML10_BearerGrantType.properties", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        Subject subject;
        Assertion assertion;
        String tenantDomain;
        IdentityProvider identityProvider;
        boolean validGrant;
        block63: {
            String tokenEndpointAlias;
            block62: {
                block65: {
                    block64: {
                        RequestParameter[] requestParameters;
                        validGrant = super.validateGrant(tokReqMsgCtx);
                        identityProvider = null;
                        tokenEndpointAlias = null;
                        tenantDomain = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
                        if (tenantDomain == null || "".equals(tenantDomain)) {
                            tenantDomain = "carbon.super";
                        }
                        for (RequestParameter requestParameter : requestParameters = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getRequestParameters()) {
                            if (!requestParameter.getKey().equals("assertion")) continue;
                            String[] values = requestParameter.getValue();
                            tokReqMsgCtx.getOauth2AccessTokenReqDTO().setAssertion(values[0]);
                            break;
                        }
                        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"SAML_Assertion")) {
                            log.debug((Object)("Received SAML assertion : " + new String(Base64.decodeBase64((String)tokReqMsgCtx.getOauth2AccessTokenReqDTO().getAssertion()), StandardCharsets.UTF_8)));
                        }
                        try {
                            XMLObject samlObject = UnmarshallUtils.unmarshall((String)new String(Base64.decodeBase64((String)tokReqMsgCtx.getOauth2AccessTokenReqDTO().getAssertion()), StandardCharsets.UTF_8));
                            NodeList assertionList = samlObject.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
                            if (assertionList.getLength() > 0) {
                                log.error((Object)"Invalid schema for SAML Assertion. Nested assertions detected.");
                                return false;
                            }
                            if (!(samlObject instanceof Assertion)) {
                                log.error((Object)"Only Assertion objects are validated in SAML1Bearer Grant Type");
                                return false;
                            }
                            assertion = (Assertion)samlObject;
                        }
                        catch (IdentityUnmarshallingException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Error occurred while unmarshalling SAML1.0 assertion", (Throwable)e);
                            }
                            return false;
                        }
                        List authenticationStatements = assertion.getAuthenticationStatements();
                        if (authenticationStatements == null || authenticationStatements.size() <= 0) break block64;
                        AuthenticationStatement authenticationStatement = (AuthenticationStatement)authenticationStatements.get(0);
                        subject = authenticationStatement.getSubject();
                        if (subject != null) {
                            String resourceOwnerUserName = subject.getNameIdentifier().getNameIdentifier();
                            if (resourceOwnerUserName == null || resourceOwnerUserName.equals("")) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"NameID in Assertion cannot be empty");
                                }
                                return false;
                            }
                            AuthenticatedUser user = OAuth2Util.getUserFromUserName(resourceOwnerUserName);
                            user.setAuthenticatedSubjectIdentifier(resourceOwnerUserName);
                            user.setFederatedUser(true);
                            tokReqMsgCtx.setAuthorizedUser(user);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Resource Owner User Name is set to " + resourceOwnerUserName));
                            }
                            break block65;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Subject element cannot be empty.");
                            }
                            return false;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Authentication Statement cannot be empty");
                    }
                    return false;
                }
                if (assertion.getIssuer() == null || assertion.getIssuer().isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Issuer is empty in the SAML assertion");
                    }
                    return false;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Issuer is :" + assertion.getIssuer()));
                    }
                    if ((identityProvider = IdentityProviderManager.getInstance().getIdPByAuthenticatorPropertyValue("IdPEntityId", assertion.getIssuer(), tenantDomain, false)) != null) {
                        if ("LOCAL".equals(identityProvider.getIdentityProviderName())) {
                            identityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
                            FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
                            String idpEntityId = null;
                            FederatedAuthenticatorConfig samlAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"samlsso");
                            Property samlProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlAuthenticatorConfig.getProperties(), (String)"IdPEntityId");
                            if (samlProperty != null) {
                                idpEntityId = samlProperty.getValue();
                            }
                            if (idpEntityId == null || !assertion.getIssuer().equals(idpEntityId)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"SAML Token Issuer verification failed or Issuer not registered");
                                }
                                return false;
                            }
                            FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
                            Property oauthProperty = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)"OAuth2TokenEPUrl");
                            if (oauthProperty != null) {
                                tokenEndpointAlias = oauthProperty.getValue();
                            }
                            break block62;
                        }
                        tokenEndpointAlias = identityProvider.getAlias();
                        break block62;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SAML Token Issuer verification failed or Issuer not registered");
                    }
                    return false;
                }
                catch (IdentityProviderManagementException e) {
                    if (!log.isDebugEnabled()) break block62;
                    log.debug((Object)"Error while getting Federated Identity Provider ", (Throwable)e);
                }
            }
            if (this.audienceRestrictionValidationEnabled) {
                if (tokenEndpointAlias == null || tokenEndpointAlias.equals("")) {
                    String errorMsg = "Token Endpoint alias of the local Identity Provider has not been configured for " + identityProvider.getIdentityProviderName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMsg);
                    }
                    return false;
                }
                Conditions conditions = assertion.getConditions();
                if (conditions != null) {
                    List audienceRestrictions = conditions.getAudienceRestrictionConditions();
                    if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
                        boolean audienceFound = false;
                        for (AudienceRestrictionCondition audienceRestriction : audienceRestrictions) {
                            if (audienceRestriction.getAudiences() != null && audienceRestriction.getAudiences().size() > 0) {
                                for (Audience audience : audienceRestriction.getAudiences()) {
                                    if (!audience.getUri().equals(tokenEndpointAlias)) continue;
                                    audienceFound = true;
                                    break;
                                }
                            }
                            if (!audienceFound) continue;
                        }
                        if (!audienceFound) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"SAML Assertion Audience Restriction validation failed");
                            }
                            return false;
                        }
                        break block63;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SAML Assertion doesn't contain AudienceRestrictions");
                        }
                        return false;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SAML Assertion doesn't contain Conditions");
                }
                return false;
            }
        }
        DateTime notOnOrAfterFromConditions = null;
        HashSet notOnOrAfterFromSubjectConfirmations = new HashSet();
        boolean bearerFound = false;
        if (assertion.getConditions() != null && assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfterFromConditions = assertion.getConditions().getNotOnOrAfter();
        }
        SubjectConfirmation subjectConfirmation = subject.getSubjectConfirmation();
        List confirmationMethods = subjectConfirmation.getConfirmationMethods();
        for (ConfirmationMethod confirmationMethod : confirmationMethods) {
            if (!"urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(confirmationMethod.getConfirmationMethod())) continue;
            bearerFound = true;
        }
        if (!bearerFound) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find a subject confirmation with method urn:oasis:names:tc:SAML:1.0:cm:bearer in subject confirmation " + subject.getSubjectConfirmation()));
            }
            return false;
        }
        XMLObject confirmationData = subject.getSubjectConfirmation().getSubjectConfirmationData();
        if (confirmationData == null) {
            log.warn((Object)"Subject confirmation data is missing.");
        }
        long timestampSkewInMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        if (notOnOrAfterFromConditions != null && notOnOrAfterFromConditions.plus(timestampSkewInMillis).isBeforeNow()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NotOnOrAfter is having an expired timestamp in Conditions element");
            }
            return false;
        }
        boolean validSubjectConfirmationDataExists = false;
        if (!notOnOrAfterFromSubjectConfirmations.isEmpty()) {
            for (DateTime entry : notOnOrAfterFromSubjectConfirmations) {
                if (!entry.plus(timestampSkewInMillis).isAfterNow()) continue;
                validSubjectConfirmationDataExists = true;
            }
        }
        if (notOnOrAfterFromConditions == null && !validSubjectConfirmationDataExists) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No valid NotOnOrAfter element found in SubjectConfirmations");
            }
            return false;
        }
        try {
            this.profileValidator.validate(assertion.getSignature());
        }
        catch (SignatureException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signature did not conform to SAML1.0 Signature profile", (Throwable)e);
            }
            return false;
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)identityProvider.getCertificate());
        }
        catch (CertificateException e) {
            String message = "Error occurred while decoding public certificate of Identity Provider " + identityProvider.getIdentityProviderName() + " for tenant domain " + tenantDomain;
            throw new IdentityOAuth2Exception(message, e);
        }
        try {
            X509CredentialImpl x509Credential = new X509CredentialImpl(x509Certificate);
            SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)x509Credential);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signature validation successful");
            }
        }
        catch (SignatureException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature validation failure:" + e.getMessage()), (Throwable)e);
            }
            return false;
        }
        tokReqMsgCtx.setScope(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope());
        tokReqMsgCtx.addProperty("SAML2Assertion", assertion);
        SAML2TokenCallbackHandler callback = OAuthServerConfiguration.getInstance().getSAML2TokenCallbackHandler();
        if (callback != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking the SAML2 Token callback handler");
            }
            callback.handleSAML2Token(tokReqMsgCtx);
        }
        return validGrant;
    }

    @Override
    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean authorizeAccessDelegation(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("urn:oasis:names:tc:SAML:1.0:cm:bearer");
    }
}

