/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.saml;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.wso2.carbon.identity.oauth2.util.X509CredentialImpl;

public class CarbonKeyStoreCredentialResolver
extends KeyStoreCredentialResolver {
    private static final Log log = LogFactory.getLog(CarbonKeyStoreCredentialResolver.class);
    private KeyStore keyStore;

    public CarbonKeyStoreCredentialResolver(KeyStore store, Map<String, String> passwords) throws IllegalArgumentException {
        super(store, passwords);
        this.keyStore = store;
    }

    public Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        try {
            HashSet<Credential> credentialSet = new HashSet<Credential>();
            Enumeration<String> en = this.keyStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
                X509CredentialImpl credential = new X509CredentialImpl(cert);
                if (criteriaSet.get(EntityIdCriterion.class) != null) {
                    if (!((EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class)).getEntityId().equals(alias)) continue;
                    credentialSet.add((Credential)credential);
                    break;
                }
                credentialSet.add((Credential)credential);
            }
            return credentialSet;
        }
        catch (KeyStoreException e) {
            log.error((Object)e);
            throw new SecurityException("Error reading certificates from key store");
        }
    }
}

