/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHttpResponse
extends Response {
    private int status = 500;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private static final Log log = LogFactory.getLog(SimpleHttpResponse.class);

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public void addHeader(String headerName, String headerValue) {
        List<String> current = this.headers.get(headerName);
        if (current == null) {
            current = new ArrayList<String>();
        }
        current.add(headerValue);
        this.headers.put(headerName, current);
    }

    public void setHeader(String headerName, String headerValue) {
        List<String> current = this.headers.get(headerName);
        if (current == null) {
            current = new ArrayList<String>();
        } else {
            current.clear();
        }
        current.add(headerValue);
        this.headers.put(headerName, current);
    }

    public String getStatusString() {
        if (this.status == 401) {
            return "Unauthorized";
        }
        return "Unknown";
    }

    public void flushBuffer() {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.status + " " + this.getStatusString()));
            for (Map.Entry<String, List<String>> headerEntry : this.headers.entrySet()) {
                for (String valueEntry : headerEntry.getValue()) {
                    log.debug((Object)(headerEntry.getKey() + ": " + valueEntry));
                }
            }
        }
    }

    public String[] getHeaderValues(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues == null ? null : headerValues.toArray(new String[0]);
    }

    public String getHeader(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        if (headerValues == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String headerValue : headerValues) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(headerValue);
        }
        return sb.toString();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void sendError(int rc, String message) {
        this.status = rc;
    }

    public void sendError(int rc) {
        this.status = rc;
    }
}

