/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util.SimpleHttpSession;

public class SimpleHttpRequest
extends Request {
    private static int remotePorts = 0;
    private String requestURI = null;
    private String queryString = null;
    private String remoteUser = null;
    private String method = "GET";
    private String remoteHost = null;
    private String remoteAddr = null;
    private int remotePort;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private byte[] content = null;
    private HttpSession simpleSession = new SimpleHttpSession();
    private Principal principal = null;

    public SimpleHttpRequest(Connector connector) {
        super(connector);
        this.remotePort = SimpleHttpRequest.nextRemotePort();
    }

    public static synchronized int nextRemotePort() {
        return ++remotePorts;
    }

    public static synchronized void resetRemotePort() {
        remotePorts = 0;
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String methodName) {
        this.method = methodName;
    }

    public int getContentLength() {
        return this.content == null ? -1 : this.content.length;
    }

    public void setContentLength(int length) {
        this.content = new byte[length];
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String username) {
        this.remoteUser = username;
    }

    public HttpSession getSession() {
        return this.simpleSession;
    }

    public HttpSession getSession(boolean create) {
        if (this.simpleSession == null && create) {
            this.simpleSession = new SimpleHttpSession();
        }
        return this.simpleSession;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        if (this.queryString != null) {
            for (String eachParameter : this.queryString.split("[&]")) {
                String[] pair = eachParameter.split("=");
                String value = pair.length == 2 ? pair[1] : "";
                this.addParameter(pair[0], value);
            }
        }
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public void addParameter(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }
}

