/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import waffle.util.Base64;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class NTLMAuthenticationGrantHandlerWithHandshake
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(NTLMAuthenticationGrantHandlerWithHandshake.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String SCHEME_NTLM = "NTLM";
    private static final String SERVER_CONNECTION = "server-connection";
    private static final String SECURITY_PACKAGE = "Negotiate";
    private static final int MESSAGE_TYPE_BYTE_INDEX = 8;
    private static final int NTLM_TYPE_1_TOKEN = 1;
    private static final int NTLM_TYPE_3_TOKEN = 3;
    private static WindowsAuthProviderImpl provider = new WindowsAuthProviderImpl();

    public int getNLTMMessageType(byte[] decodedNLTMMessage) throws IdentityOAuth2Exception {
        if (decodedNLTMMessage.length <= 8) {
            throw new IdentityOAuth2Exception("Cannot extract message type from NLTM Token. Decoded token length is less than 8.");
        }
        byte messageType = decodedNLTMMessage[8];
        if (messageType < 1 || messageType > 3) {
            throw new IdentityOAuth2Exception("Invalid NLTM message type:" + messageType + ". Should be one of 1,2 or 3.");
        }
        return messageType;
    }

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        boolean validGrant = super.validateGrant(tokReqMsgCtx);
        if (!validGrant) {
            return false;
        }
        String token = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getWindowsToken();
        IWindowsSecurityContext serverContext = null;
        if (token != null) {
            byte[] bytesToken = Base64.decode((String)token);
            int tokenType = this.getNLTMMessageType(bytesToken);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received NTLM token Type " + tokenType + ":" + token));
            }
            if (tokenType == 1) {
                serverContext = provider.acceptSecurityToken(SERVER_CONNECTION, bytesToken, SECURITY_PACKAGE);
                String type2Token = Base64.encode((byte[])serverContext.getToken());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent NTLM token Type 2:" + type2Token));
                }
                ResponseHeader[] responseHeaders = new ResponseHeader[]{new ResponseHeader()};
                responseHeaders[0].setKey(HEADER_WWW_AUTHENTICATE);
                responseHeaders[0].setValue("NTLM " + type2Token);
                tokReqMsgCtx.addProperty("RESPONSE_HEADERS", responseHeaders);
                return false;
            }
            if (tokenType == 3) {
                serverContext = provider.acceptSecurityToken(SERVER_CONNECTION, bytesToken, SECURITY_PACKAGE);
                String resourceOwnerUserNameWithDomain = serverContext.getIdentity().getFqn();
                String resourceOwnerUserName = resourceOwnerUserNameWithDomain.split("\\\\")[1];
                tokReqMsgCtx.setAuthorizedUser(OAuth2Util.getUserFromUserName(resourceOwnerUserName));
                return true;
            }
            log.error((Object)("Unknown NTLM token, Type " + tokenType + ":" + token));
            return false;
        }
        throw new IdentityOAuth2Exception("Received NTLM token is null");
    }
}

