/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm;

import com.sun.jna.platform.win32.Sspi;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util.SimpleFilterChain;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util.SimpleHttpRequest;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.iwa.ntlm.util.SimpleHttpResponse;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import waffle.servlet.NegotiateSecurityFilter;
import waffle.util.Base64;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class NTLMAuthenticationGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static final Log log = LogFactory.getLog(NTLMAuthenticationGrantHandler.class);
    String securityPackage = "Negotiate";

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        boolean authenticated;
        block16: {
            if (!super.validateGrant(tokReqMsgCtx)) {
                return false;
            }
            NegotiateSecurityFilter filter = new NegotiateSecurityFilter();
            filter.setAuth((IWindowsAuthProvider)new WindowsAuthProviderImpl());
            try {
                filter.init(null);
            }
            catch (ServletException e) {
                log.error((Object)"Error while initializing Negotiate Security Filter", (Throwable)e);
                throw new IdentityOAuth2Exception("Error while initializing Negotiate Security Filter", e);
            }
            String token = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getWindowsToken();
            filter.setRoleFormat("both");
            if (token != null) {
                if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"NTLM_Token")) {
                    log.debug((Object)("Received NTLM Token : " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getWindowsToken()));
                }
                IWindowsCredentialsHandle clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)this.securityPackage);
                clientCredentials.initialize();
                WindowsSecurityContextImpl clientContext = new WindowsSecurityContextImpl();
                clientContext.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
                clientContext.setCredentialsHandle(clientCredentials.getHandle());
                clientContext.setSecurityPackage(this.securityPackage);
                clientContext.initialize(null, null, WindowsAccountImpl.getCurrentUsername());
                SimpleHttpRequest request = new SimpleHttpRequest(new Connector());
                SimpleFilterChain filterChain = new SimpleFilterChain();
                try {
                    while (true) {
                        request.addHeader("Authorization", this.securityPackage + " " + token);
                        SimpleHttpResponse response = new SimpleHttpResponse();
                        try {
                            filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
                        }
                        catch (IOException e) {
                            log.error((Object)"You have been given wrong inputs to negotiate filter", (Throwable)e);
                            throw new IdentityOAuth2Exception("Error while processing negotiate the filter.", e);
                        }
                        Subject subject = (Subject)request.getSession().getAttribute("javax.security.auth.subject");
                        boolean bl = authenticated = subject != null && subject.getPrincipals().size() > 0;
                        if (authenticated) {
                            String resourceOwnerUserNameWithDomain;
                            String[] splitValues;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"NTLM token is authenticated");
                            }
                            if ((splitValues = (resourceOwnerUserNameWithDomain = WindowsAccountImpl.getCurrentUsername()).split("\\\\")).length == 2) {
                                String resourceOwnerUserName = splitValues[1];
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Username of resource owner: " + resourceOwnerUserName));
                                }
                                tokReqMsgCtx.setAuthorizedUser(OAuth2Util.getUserFromUserName(resourceOwnerUserName));
                                break block16;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Invalid format for username: " + resourceOwnerUserNameWithDomain));
                            }
                        }
                        String continueToken = response.getHeader("WWW-Authenticate").substring(this.securityPackage.length() + 1);
                        byte[] continueTokenBytes = Base64.decode((String)continueToken);
                        Sspi.SecBufferDesc continueTokenBuffer = new Sspi.SecBufferDesc(2, continueTokenBytes);
                        clientContext.initialize(clientContext.getHandle(), continueTokenBuffer, "localhost");
                        token = Base64.encode((byte[])clientContext.getToken());
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while validating the NTLM authentication grant", (Throwable)e);
                    throw new IdentityOAuth2Exception("Error while validating the NTLM authentication grant", e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"NTLM token is null");
            }
            throw new IdentityOAuth2Exception("NTLM token is null");
        }
        return authenticated;
    }

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("iwa:ntlm");
    }
}

