/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class RefreshGrantHandler
extends AbstractAuthorizationGrantHandler {
    public static final String PREV_ACCESS_TOKEN = "previousAccessToken";
    public static final int LAST_ACCESS_TOKEN_RETRIEVAL_LIMIT = 10;
    public static final int ALLOWED_MINIMUM_VALIDITY_PERIOD = 1000;
    public static final String DEACTIVATED_ACCESS_TOKEN = "DeactivatedAccessToken";
    private static final Log log = LogFactory.getLog(RefreshGrantHandler.class);
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        super.validateGrant(tokReqMsgCtx);
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        RefreshTokenValidationDataDO validationBean = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().validateRefreshToken(tokenReq.getClientId(), tokenReq.getRefreshToken());
        this.validatePersistedAccessToken(validationBean, tokenReq.getClientId());
        this.validateRefreshTokenInRequest(tokenReq, validationBean);
        this.validateTokenBindingReference(tokenReq, validationBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh token validation successful for Client id : " + tokenReq.getClientId() + ", Authorized User : " + validationBean.getAuthorizedUser() + ", Token Scope : " + OAuth2Util.buildScopeString(validationBean.getScope())));
        }
        this.setPropertiesForTokenGeneration(tokReqMsgCtx, validationBean);
        return true;
    }

    @Override
    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        RefreshTokenValidationDataDO validationBean = (RefreshTokenValidationDataDO)tokReqMsgCtx.getProperty(PREV_ACCESS_TOKEN);
        if (this.isRefreshTokenExpired(validationBean)) {
            return this.handleError("invalid_grant", "Refresh token is expired.", tokenReq);
        }
        AccessTokenDO accessTokenBean = this.createAccessTokenBean(tokReqMsgCtx, tokenReq, validationBean);
        this.persistNewToken(tokReqMsgCtx, accessTokenBean, tokenReq.getClientId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisted an access token for the refresh token, Client ID : " + tokenReq.getClientId() + ", Authorized user : " + tokReqMsgCtx.getAuthorizedUser() + ", Timestamp : " + accessTokenBean.getIssuedTime() + ", Validity period (s) : " + accessTokenBean.getValidityPeriod() + ", Scope : " + OAuth2Util.buildScopeString(tokReqMsgCtx.getScope()) + ", Token State : " + "ACTIVE" + " and User Type : " + this.getTokenType()));
        }
        this.setTokenDataToMessageContext(tokReqMsgCtx, accessTokenBean);
        RefreshGrantHandler.addUserAttributesToCache(accessTokenBean, tokReqMsgCtx);
        return this.buildTokenResponse(tokReqMsgCtx, accessTokenBean);
    }

    @Override
    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        if (!super.validateScope(tokReqMsgCtx)) {
            return false;
        }
        Object[] requestedScopes = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope();
        Object[] grantedScopes = tokReqMsgCtx.getScope();
        if (ArrayUtils.isNotEmpty((Object[])requestedScopes)) {
            if (ArrayUtils.isEmpty((Object[])grantedScopes)) {
                return false;
            }
            List<Object> grantedScopeList = Arrays.asList(grantedScopes);
            for (Object scope : requestedScopes) {
                if (grantedScopeList.contains(scope)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("scope: " + (String)scope + "is not granted for this refresh token"));
                }
                return false;
            }
            tokReqMsgCtx.setScope((String[])requestedScopes);
        }
        return true;
    }

    private void setPropertiesForTokenGeneration(OAuthTokenReqMessageContext tokReqMsgCtx, RefreshTokenValidationDataDO validationBean) throws IdentityOAuth2Exception {
        tokReqMsgCtx.setAuthorizedUser(validationBean.getAuthorizedUser());
        tokReqMsgCtx.setScope(validationBean.getScope());
        if (StringUtils.isNotBlank((String)validationBean.getTokenBindingReference()) && !"NONE".equals(validationBean.getTokenBindingReference())) {
            Optional<TokenBinding> tokenBindingOptional = OAuthTokenPersistenceFactory.getInstance().getTokenBindingMgtDAO().getTokenBinding(validationBean.getTokenId());
            tokenBindingOptional.ifPresent(tokReqMsgCtx::setTokenBinding);
        }
        tokReqMsgCtx.addProperty(PREV_ACCESS_TOKEN, validationBean);
    }

    private boolean validateRefreshTokenInRequest(OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean) throws IdentityOAuth2Exception {
        this.validateRefreshTokenStatus(validationBean, tokenReq.getClientId());
        if (this.isLatestRefreshToken(tokenReq, validationBean)) {
            return true;
        }
        throw new IdentityOAuth2Exception("Invalid refresh token value in the request");
    }

    private boolean isLatestRefreshToken(OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Evaluating refresh token. Token value: " + tokenReq.getRefreshToken() + ", Token state: " + validationBean.getRefreshTokenState()));
        }
        if (!"ACTIVE".equals(validationBean.getRefreshTokenState())) {
            List<AccessTokenDO> accessTokenBeans = this.getAccessTokenBeans(tokenReq, validationBean, this.getUserStoreDomain(validationBean.getAuthorizedUser()));
            for (AccessTokenDO token : accessTokenBeans) {
                if (!tokenReq.getRefreshToken().equals(token.getRefreshToken()) || !"ACTIVE".equals(token.getTokenState()) && !"EXPIRED".equals(token.getTokenState())) continue;
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refresh token: " + tokenReq.getRefreshToken() + " is not the latest"));
            }
            this.removeIfCached(tokenReq, validationBean);
            return false;
        }
        return true;
    }

    private void removeIfCached(OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean) {
        if (this.cacheEnabled) {
            this.clearCache(tokenReq.getClientId(), validationBean.getAuthorizedUser().toString(), validationBean.getScope(), validationBean.getAccessToken(), validationBean.getAuthorizedUser().getFederatedIdPName(), validationBean.getTokenBindingReference());
        }
    }

    private List<AccessTokenDO> getAccessTokenBeans(OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean, String userStoreDomain) throws IdentityOAuth2Exception {
        List<AccessTokenDO> accessTokenBeans = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessTokens(tokenReq.getClientId(), validationBean.getAuthorizedUser(), userStoreDomain, OAuth2Util.buildScopeString(validationBean.getScope()), validationBean.getTokenBindingReference(), true, 10);
        if (accessTokenBeans == null || accessTokenBeans.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No previous access tokens found. User: " + validationBean.getAuthorizedUser() + ", client: " + tokenReq.getClientId() + ", scope: " + OAuth2Util.buildScopeString(validationBean.getScope())));
            }
            throw new IdentityOAuth2Exception("No previous access tokens found");
        }
        return accessTokenBeans;
    }

    private boolean validateRefreshTokenStatus(RefreshTokenValidationDataDO validationBean, String clientId) throws IdentityOAuth2Exception {
        String tokenState = validationBean.getRefreshTokenState();
        if (tokenState != null && !"ACTIVE".equals(tokenState) && !"EXPIRED".equals(tokenState)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refresh Token state is " + tokenState + " for client: " + clientId + ". Expected 'Active' or 'EXPIRED'"));
            }
            throw new IdentityOAuth2Exception("Invalid refresh token state");
        }
        return true;
    }

    private boolean validatePersistedAccessToken(RefreshTokenValidationDataDO validationBean, String clientId) throws IdentityOAuth2Exception {
        if (validationBean.getAccessToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid Refresh Token provided for Client with Client Id : " + clientId));
            }
            throw new IdentityOAuth2Exception("Persisted access token data not found");
        }
        return true;
    }

    private OAuth2AccessTokenRespDTO buildTokenResponse(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO accessTokenBean) {
        String scope = OAuth2Util.buildScopeString(tokReqMsgCtx.getScope());
        OAuth2AccessTokenRespDTO tokenResp = new OAuth2AccessTokenRespDTO();
        tokenResp.setAccessToken(accessTokenBean.getAccessToken());
        tokenResp.setRefreshToken(accessTokenBean.getRefreshToken());
        if (accessTokenBean.getValidityPeriodInMillis() > 0L) {
            tokenResp.setExpiresIn(accessTokenBean.getValidityPeriod());
            tokenResp.setExpiresInMillis(accessTokenBean.getValidityPeriodInMillis());
        } else {
            tokenResp.setExpiresIn(Long.MAX_VALUE);
            tokenResp.setExpiresInMillis(Long.MAX_VALUE);
        }
        tokenResp.setAuthorizedScopes(scope);
        return tokenResp;
    }

    private void persistNewToken(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO accessTokenBean, String clientId) throws IdentityOAuth2Exception {
        String userStoreDomain = this.getUserStoreDomain(tokReqMsgCtx.getAuthorizedUser());
        RefreshTokenValidationDataDO oldAccessToken = (RefreshTokenValidationDataDO)tokReqMsgCtx.getProperty(PREV_ACCESS_TOKEN);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
            log.debug((Object)("Previous access token (hashed): " + DigestUtils.sha256Hex((String)oldAccessToken.getAccessToken())));
        }
        OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().invalidateAndCreateNewAccessToken(oldAccessToken.getTokenId(), "INACTIVE", clientId, UUID.randomUUID().toString(), accessTokenBean, userStoreDomain);
        this.updateCacheIfEnabled(tokReqMsgCtx, accessTokenBean, clientId, oldAccessToken);
    }

    private void updateCacheIfEnabled(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO accessTokenBean, String clientId, RefreshTokenValidationDataDO oldAccessToken) throws IdentityOAuth2Exception {
        if (this.isHashDisabled && this.cacheEnabled) {
            String scope = OAuth2Util.buildScopeString(tokReqMsgCtx.getScope());
            String authorizedUser = tokReqMsgCtx.getAuthorizedUser().toString();
            String authenticatedIDP = tokReqMsgCtx.getAuthorizedUser().getFederatedIdPName();
            String cacheKeyString = OAuth2Util.buildCacheKeyStringForToken(clientId, scope, authorizedUser, authenticatedIDP, oldAccessToken.getTokenBindingReference());
            OAuthCacheKey oauthCacheKey = new OAuthCacheKey(cacheKeyString);
            OAuthCache.getInstance().clearCacheEntry(oauthCacheKey);
            OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(oldAccessToken.getAccessToken());
            OAuthCache.getInstance().clearCacheEntry(accessTokenCacheKey);
            OAuthCache.getInstance().addToCache(oauthCacheKey, (Serializable)((Object)accessTokenBean));
            OAuth2Util.addTokenDOtoCache(accessTokenBean);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access Token info for the refresh token was added to the cache for the client id : " + clientId + ". Old access token entry was also removed from the cache."));
            }
        }
    }

    private void setTokenDataToMessageContext(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO accessTokenBean) {
        tokReqMsgCtx.setValidityPeriod(accessTokenBean.getValidityPeriodInMillis());
        tokReqMsgCtx.setRefreshTokenvalidityPeriod(accessTokenBean.getRefreshTokenValidityPeriodInMillis());
        tokReqMsgCtx.setAccessTokenIssuedTime(accessTokenBean.getIssuedTime().getTime());
        tokReqMsgCtx.setRefreshTokenIssuedTime(accessTokenBean.getRefreshTokenIssuedTime().getTime());
        tokReqMsgCtx.addProperty("RESPONSE_HEADERS", this.getResponseHeaders(tokReqMsgCtx));
    }

    private ResponseHeader[] getResponseHeaders(OAuthTokenReqMessageContext tokReqMsgCtx) {
        ResponseHeader[] respHeaders = new ResponseHeader[1];
        ResponseHeader header = new ResponseHeader();
        header.setKey(DEACTIVATED_ACCESS_TOKEN);
        header.setValue(((RefreshTokenValidationDataDO)tokReqMsgCtx.getProperty(PREV_ACCESS_TOKEN)).getAccessToken());
        respHeaders[0] = header;
        return respHeaders;
    }

    private OAuthAppDO getOAuthApp(String clientId) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + clientId, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Provider specific expiry time enabled for application : " + clientId + ". Application access token expiry time : " + oAuthAppDO.getApplicationAccessTokenExpiryTime() + ", User access token expiry time : " + oAuthAppDO.getUserAccessTokenExpiryTime() + ", Refresh token expiry time : " + oAuthAppDO.getRefreshTokenExpiryTime()));
        }
        return oAuthAppDO;
    }

    private OAuth2AccessTokenRespDTO handleError(String errorCode, String errorMsg, OAuth2AccessTokenReqDTO tokenReqDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth-Error-Code=" + errorCode + " client-id=" + tokenReqDTO.getClientId() + " grant-type=" + tokenReqDTO.getGrantType() + " scope=" + OAuth2Util.buildScopeString(tokenReqDTO.getScope())));
        }
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        tokenRespDTO.setError(true);
        tokenRespDTO.setErrorCode(errorCode);
        tokenRespDTO.setErrorMsg(errorMsg);
        return tokenRespDTO;
    }

    private void clearCache(String clientId, String authorizedUser, String[] scopes, String accessToken, String authenticatedIDP, String tokenBindingReference) {
        String cacheKeyString = OAuth2Util.buildCacheKeyStringForToken(clientId, OAuth2Util.buildScopeString(scopes), authorizedUser, authenticatedIDP, tokenBindingReference);
        OAuthCacheKey oauthCacheKey = new OAuthCacheKey(cacheKeyString);
        OAuthCache.getInstance().clearCacheEntry(oauthCacheKey);
        OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(accessToken);
        OAuthCache.getInstance().clearCacheEntry(accessTokenCacheKey);
    }

    private boolean isRefreshTokenExpired(RefreshTokenValidationDataDO validationBean) {
        long issuedTime = validationBean.getIssuedTime().getTime();
        long refreshValidity = validationBean.getValidityPeriodInMillis();
        if (refreshValidity < 0L) {
            return false;
        }
        return OAuth2Util.getTimeToExpire(issuedTime, refreshValidity) < 1000L;
    }

    private void setTokenData(AccessTokenDO accessTokenDO, OAuthTokenReqMessageContext tokReqMsgCtx, RefreshTokenValidationDataDO validationBean, OAuth2AccessTokenReqDTO tokenReq, Timestamp timestamp) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO = this.getOAuthApp(tokenReq.getClientId());
        this.createTokens(accessTokenDO, tokReqMsgCtx);
        this.setRefreshTokenData(accessTokenDO, tokenReq, validationBean, oAuthAppDO, accessTokenDO.getRefreshToken(), timestamp, tokReqMsgCtx);
        this.modifyTokensIfUsernameAssertionEnabled(accessTokenDO, tokReqMsgCtx);
        this.setValidityPeriod(accessTokenDO, tokReqMsgCtx, oAuthAppDO);
    }

    private void setValidityPeriod(AccessTokenDO accessTokenDO, OAuthTokenReqMessageContext tokReqMsgCtx, OAuthAppDO oAuthAppDO) {
        long validityPeriodInMillis = this.getValidityPeriodInMillis(tokReqMsgCtx, oAuthAppDO);
        accessTokenDO.setValidityPeriod(validityPeriodInMillis / 1000L);
        accessTokenDO.setValidityPeriodInMillis(validityPeriodInMillis);
    }

    private void createTokens(AccessTokenDO accessTokenDO, OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        try {
            OauthTokenIssuer oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(accessTokenDO.getConsumerKey());
            String accessToken = oauthTokenIssuer.accessToken(tokReqMsgCtx);
            String refreshToken = oauthTokenIssuer.refreshToken(tokReqMsgCtx);
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("New access token (hashed): " + DigestUtils.sha256Hex((String)accessToken) + " & new refresh token (hashed): " + DigestUtils.sha256Hex((String)refreshToken)));
                } else {
                    log.debug((Object)"Access token and refresh token generated.");
                }
            }
            accessTokenDO.setAccessToken(accessToken);
            accessTokenDO.setRefreshToken(refreshToken);
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception("Error when generating the tokens.", e);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + accessTokenDO.getConsumerKey(), e);
        }
    }

    private void modifyTokensIfUsernameAssertionEnabled(AccessTokenDO accessTokenDO, OAuthTokenReqMessageContext tokReqMsgCtx) {
        if (OAuth2Util.checkUserNameAssertionEnabled()) {
            String accessToken = OAuth2Util.addUsernameToToken(tokReqMsgCtx.getAuthorizedUser(), accessTokenDO.getAccessToken());
            String refreshToken = OAuth2Util.addUsernameToToken(tokReqMsgCtx.getAuthorizedUser(), accessTokenDO.getRefreshToken());
            accessTokenDO.setAccessToken(accessToken);
            accessTokenDO.setRefreshToken(refreshToken);
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Encoded access token (hashed): " + DigestUtils.sha256Hex((String)accessToken) + " & encoded refresh token (hashed): " + DigestUtils.sha256Hex((String)refreshToken)));
                } else {
                    log.debug((Object)"Access token and refresh token encoded using Base64 encoding.");
                }
            }
        }
    }

    private AccessTokenDO createAccessTokenBean(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean) throws IdentityOAuth2Exception {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String tokenId = UUID.randomUUID().toString();
        AccessTokenDO accessTokenDO = new AccessTokenDO();
        accessTokenDO.setConsumerKey(tokenReq.getClientId());
        accessTokenDO.setAuthzUser(tokReqMsgCtx.getAuthorizedUser());
        accessTokenDO.setScope(tokReqMsgCtx.getScope());
        accessTokenDO.setTokenType(this.getTokenType());
        accessTokenDO.setTokenState("ACTIVE");
        accessTokenDO.setTokenId(tokenId);
        accessTokenDO.setGrantType(tokenReq.getGrantType());
        accessTokenDO.setIssuedTime(timestamp);
        accessTokenDO.setTokenBinding(tokReqMsgCtx.getTokenBinding());
        this.setTokenData(accessTokenDO, tokReqMsgCtx, validationBean, tokenReq, timestamp);
        return accessTokenDO;
    }

    private long getValidityPeriodInMillis(OAuthTokenReqMessageContext tokReqMsgCtx, OAuthAppDO oAuthAppDO) {
        long validityPeriodInMillis = oAuthAppDO.getUserAccessTokenExpiryTime() != 0L ? oAuthAppDO.getUserAccessTokenExpiryTime() * 1000L : OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
        long callbackValidityPeriod = tokReqMsgCtx.getValidityPeriod();
        if (callbackValidityPeriod != -1L) {
            validityPeriodInMillis = callbackValidityPeriod * 1000L;
        }
        return validityPeriodInMillis;
    }

    private void setRefreshTokenData(AccessTokenDO accessTokenDO, OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean, OAuthAppDO oAuthAppDO, String refreshToken, Timestamp timestamp, OAuthTokenReqMessageContext tokenReqMessageContext) {
        Timestamp refreshTokenIssuedTime = null;
        long refreshTokenValidityPeriod = 0L;
        if (!this.isRenewRefreshToken(oAuthAppDO.getRenewRefreshTokenEnabled())) {
            refreshToken = tokenReq.getRefreshToken();
            refreshTokenIssuedTime = validationBean.getIssuedTime();
            refreshTokenValidityPeriod = validationBean.getValidityPeriodInMillis();
        } else if (!OAuthServerConfiguration.getInstance().isExtendRenewedTokenExpiryTimeEnabled()) {
            refreshTokenIssuedTime = validationBean.getIssuedTime();
            refreshTokenValidityPeriod = validationBean.getValidityPeriodInMillis();
        }
        if (refreshTokenIssuedTime == null) {
            refreshTokenIssuedTime = timestamp;
        }
        accessTokenDO.setRefreshToken(refreshToken);
        accessTokenDO.setRefreshTokenIssuedTime(refreshTokenIssuedTime);
        accessTokenDO.setRefreshTokenValidityPeriodInMillis(this.getRefreshTokenValidityPeriod(refreshTokenValidityPeriod, oAuthAppDO, tokenReqMessageContext));
    }

    private long getRefreshTokenValidityPeriod(long refreshTokenValidityPeriod, OAuthAppDO oAuthAppDO, OAuthTokenReqMessageContext tokenReqMessageContext) {
        long validityPeriodFromMsgContext = tokenReqMessageContext.getRefreshTokenvalidityPeriod();
        if (validityPeriodFromMsgContext != -1L && validityPeriodFromMsgContext > 0L) {
            refreshTokenValidityPeriod = validityPeriodFromMsgContext * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppDO.getOauthConsumerKey() + ", using refresh token validity period configured from OAuthTokenReqMessageContext: " + refreshTokenValidityPeriod + " ms"));
            }
        } else if (refreshTokenValidityPeriod == 0L) {
            refreshTokenValidityPeriod = oAuthAppDO.getRefreshTokenExpiryTime() != 0L ? oAuthAppDO.getRefreshTokenExpiryTime() * 1000L : OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L;
        }
        return refreshTokenValidityPeriod;
    }

    private static void addUserAttributesToCache(AccessTokenDO accessTokenBean, OAuthTokenReqMessageContext msgCtx) {
        AuthorizationGrantCacheEntry grantCacheEntry;
        RefreshTokenValidationDataDO oldAccessToken = (RefreshTokenValidationDataDO)msgCtx.getProperty(PREV_ACCESS_TOKEN);
        AuthorizationGrantCacheKey oldAuthorizationGrantCacheKey = new AuthorizationGrantCacheKey(oldAccessToken.getAccessToken());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting AuthorizationGrantCacheEntry using access token id: " + accessTokenBean.getTokenId()));
        }
        if ((grantCacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByTokenId(oldAuthorizationGrantCacheKey, oldAccessToken.getTokenId())) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting user attributes cached against the previous access token with access token id: " + oldAccessToken.getTokenId()));
            }
            AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(accessTokenBean.getAccessToken());
            if (StringUtils.isNotBlank((String)accessTokenBean.getTokenId())) {
                grantCacheEntry.setTokenId(accessTokenBean.getTokenId());
            } else {
                grantCacheEntry.setTokenId(null);
            }
            grantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(accessTokenBean.getValidityPeriodInMillis()));
            AuthorizationGrantCache.getInstance().clearCacheEntryByTokenId(oldAuthorizationGrantCacheKey, oldAccessToken.getTokenId());
            AuthorizationGrantCache.getInstance().addToCacheByToken(authorizationGrantCacheKey, grantCacheEntry);
        }
    }

    private boolean isRenewRefreshToken(String renewRefreshToken) {
        if (StringUtils.isNotBlank((String)renewRefreshToken)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading the Oauth application specific renew refresh token value as " + renewRefreshToken + " from the IDN_OIDC_PROPERTY table"));
            }
            return Boolean.parseBoolean(renewRefreshToken);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading the global renew refresh token value from the identity.xml");
        }
        return OAuthServerConfiguration.getInstance().isRefreshTokenRenewalEnabled();
    }

    private void validateTokenBindingReference(OAuth2AccessTokenReqDTO tokenReqDTO, RefreshTokenValidationDataDO validationDataDO) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        if (StringUtils.isBlank((String)validationDataDO.getTokenBindingReference()) || "NONE".equals(validationDataDO.getTokenBindingReference())) {
            return;
        }
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(tokenReqDTO.getClientId());
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Failed load the application with client id: " + tokenReqDTO.getClientId());
        }
        if (StringUtils.isBlank((String)oAuthAppDO.getTokenBindingType())) {
            return;
        }
        Optional<TokenBinder> tokenBinderOptional = OAuth2ServiceComponentHolder.getInstance().getTokenBinder(oAuthAppDO.getTokenBindingType());
        if (!tokenBinderOptional.isPresent()) {
            throw new IdentityOAuth2Exception("Token binder for the binding type: " + oAuthAppDO.getTokenBindingType() + " is not registered.");
        }
        TokenBinder tokenBinder = tokenBinderOptional.get();
        if (oAuthAppDO.isTokenBindingValidationEnabled() && !tokenBinder.isValidTokenBinding(tokenReqDTO, validationDataDO.getTokenBindingReference())) {
            throw new IdentityOAuth2Exception("Invalid token binding value is present in the request.");
        }
    }
}

