/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.config.UserStorePreferenceOrderSupplier;
import org.wso2.carbon.user.core.model.UserMgtContext;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class PasswordGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static final Log log = LogFactory.getLog(PasswordGrantHandler.class);
    private static final String OAUTH2 = "oauth2";
    private static final String IS_INITIAL_LOGIN = "isInitialLogin";
    private static final String PASSWORD_GRANT_AUTHENTICATOR_NAME = "BASIC";
    private static final String PUBLISH_PASSWORD_GRANT_LOGIN = "OAuth.PublishPasswordGrantLogin";
    private static final String REMOTE_IP_ADDRESS = "remote-ip-address";

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("password");
    }

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        super.validateGrant(tokReqMsgCtx);
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        ServiceProvider serviceProvider = this.getServiceProvider(tokenReq);
        this.validateUserTenant(tokenReq, serviceProvider);
        this.validateUserCredentials(tokenReq, serviceProvider);
        this.setPropertiesForTokenGeneration(tokReqMsgCtx, tokenReq, serviceProvider);
        return true;
    }

    private void setPropertiesForTokenGeneration(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenReqDTO tokenReq, ServiceProvider serviceProvider) {
        AuthenticatedUser user = this.getAuthenticatedUser(tokenReq, serviceProvider);
        tokReqMsgCtx.setAuthorizedUser(user);
        tokReqMsgCtx.setScope(tokenReq.getScope());
    }

    private boolean validateUserTenant(OAuth2AccessTokenReqDTO tokenReq, ServiceProvider serviceProvider) throws IdentityOAuth2Exception {
        String userTenantDomain = MultitenantUtils.getTenantDomain((String)tokenReq.getResourceOwnerUsername());
        if (!serviceProvider.isSaasApp() && !userTenantDomain.equals(tokenReq.getTenantDomain())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non-SaaS service provider. Application tenantDomain(" + tokenReq.getTenantDomain() + ") != User tenant domain(" + userTenantDomain + ")"));
            }
            throw new IdentityOAuth2Exception("Users in the tenant domain : " + userTenantDomain + " do not have access to application " + serviceProvider.getApplicationName());
        }
        return true;
    }

    private ServiceProvider getServiceProvider(OAuth2AccessTokenReqDTO tokenReq) throws IdentityOAuth2Exception {
        ServiceProvider serviceProvider;
        try {
            serviceProvider = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProviderByClientId(tokenReq.getClientId(), OAUTH2, tokenReq.getTenantDomain());
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error occurred while retrieving OAuth2 application data for client id " + tokenReq.getClientId(), e);
        }
        if (serviceProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find an application for client id: " + tokenReq.getClientId() + ", scope: " + OAUTH2 + ", tenant: " + tokenReq.getTenantDomain()));
            }
            throw new IdentityOAuth2Exception("Service Provider not found");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved service provider: " + serviceProvider.getApplicationName() + " for client: " + tokenReq.getClientId() + ", scope: " + OAUTH2 + ", tenant: " + tokenReq.getTenantDomain()));
        }
        return serviceProvider;
    }

    private boolean validateUserCredentials(OAuth2AccessTokenReqDTO tokenReq, ServiceProvider serviceProvider) throws IdentityOAuth2Exception {
        boolean isPublishPasswordGrantLoginEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)PUBLISH_PASSWORD_GRANT_LOGIN));
        try {
            UserStorePreferenceOrderSupplier userStorePreferenceOrderSupplier = FrameworkUtils.getUserStorePreferenceOrderSupplier(null, (ServiceProvider)serviceProvider);
            UserMgtContext userMgtContext = new UserMgtContext();
            userMgtContext.setUserStorePreferenceOrderSupplier(userStorePreferenceOrderSupplier);
            if (userStorePreferenceOrderSupplier != null) {
                UserCoreUtil.setUserMgtContextInThreadLocal((UserMgtContext)userMgtContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"UserMgtContext had been set as the thread local.");
                }
            }
            UserStoreManager userStoreManager = this.getUserStoreManager(tokenReq);
            String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)tokenReq.getResourceOwnerUsername());
            boolean authenticated = userStoreManager.authenticate(tenantAwareUserName, (Object)tokenReq.getResourceOwnerPassword());
            if (log.isDebugEnabled()) {
                log.debug((Object)("user " + tokenReq.getResourceOwnerUsername() + " authenticated: " + authenticated));
            }
            if (!authenticated) {
                if (isPublishPasswordGrantLoginEnabled) {
                    this.publishAuthenticationData(tokenReq, false, serviceProvider);
                }
                if ("carbon.super".equalsIgnoreCase(MultitenantUtils.getTenantDomain((String)tokenReq.getResourceOwnerUsername()))) {
                    throw new IdentityOAuth2Exception("Authentication failed for " + tenantAwareUserName);
                }
                throw new IdentityOAuth2Exception("Authentication failed for " + tokenReq.getResourceOwnerUsername());
            }
            if (isPublishPasswordGrantLoginEnabled) {
                this.publishAuthenticationData(tokenReq, true, serviceProvider);
            }
        }
        catch (UserStoreException e) {
            if (isPublishPasswordGrantLoginEnabled) {
                this.publishAuthenticationData(tokenReq, false, serviceProvider);
            }
            String message = e.getMessage();
            if (!(e.getCause() instanceof IdentityException)) {
                throw new IdentityOAuth2Exception(message, e);
            }
            IdentityException identityException = (IdentityException)e.getCause();
            if (StringUtils.isNotBlank((String)identityException.getErrorCode())) {
                message = identityException.getErrorCode() + " " + e.getMessage();
            }
            throw new IdentityOAuth2Exception(message, e);
        }
        finally {
            UserCoreUtil.removeUserMgtContextInThreadLocal();
            if (log.isDebugEnabled()) {
                log.debug((Object)"UserMgtContext had been remove from the thread local.");
            }
        }
        return true;
    }

    protected void publishAuthenticationData(OAuth2AccessTokenReqDTO tokenReq, boolean authenticated, ServiceProvider serviceProvider) {
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(tokenReq, serviceProvider);
        AuthenticationContext authenticationContext = this.initializeAuthContext(authenticatedUser, serviceProvider);
        AuthenticationDataPublisher authnDataPublisherProxy = OAuth2ServiceComponentHolder.getAuthenticationDataPublisherProxy();
        if (authnDataPublisherProxy != null && authnDataPublisherProxy.isEnabled((MessageContext)authenticationContext)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("user", authenticatedUser);
            paramMap.put(REMOTE_IP_ADDRESS, IdentityUtil.getClientIpAddress((HttpServletRequest)tokenReq.getHttpServletRequestWrapper()));
            Map unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
            if (authenticated) {
                authnDataPublisherProxy.publishAuthenticationStepSuccess(null, authenticationContext, unmodifiableParamMap);
                authnDataPublisherProxy.publishAuthenticationSuccess(null, authenticationContext, unmodifiableParamMap);
            } else {
                authnDataPublisherProxy.publishAuthenticationStepFailure(null, authenticationContext, unmodifiableParamMap);
                authnDataPublisherProxy.publishAuthenticationFailure(null, authenticationContext, unmodifiableParamMap);
            }
        }
    }

    private AuthenticationContext initializeAuthContext(AuthenticatedUser authenticatedUser, ServiceProvider serviceProvider) {
        AuthenticationContext authenticationContext = new AuthenticationContext();
        String contextId = UUIDGenerator.generateUUID();
        authenticationContext.setContextIdentifier(contextId);
        authenticationContext.setTenantDomain(authenticatedUser.getTenantDomain());
        authenticationContext.setRequestType(OAUTH2);
        authenticationContext.setRememberMe(false);
        authenticationContext.setForceAuthenticate(true);
        authenticationContext.setPassiveAuthenticate(false);
        authenticationContext.setProperty(IS_INITIAL_LOGIN, (Object)true);
        SequenceConfig sequenceConfig = new SequenceConfig();
        sequenceConfig.setAuthenticatedUser(authenticatedUser);
        ApplicationConfig applicationConfig = new ApplicationConfig(serviceProvider);
        sequenceConfig.setApplicationConfig(applicationConfig);
        sequenceConfig.setAuthenticatedIdPs("LOCAL");
        authenticationContext.setSequenceConfig(sequenceConfig);
        AuthenticatedIdPData authenticatedIdPData = new AuthenticatedIdPData();
        authenticatedIdPData.setUser(authenticatedUser);
        authenticatedIdPData.setIdpName("LOCAL");
        AuthenticatorConfig authenticatorConfig = new AuthenticatorConfig();
        authenticatorConfig.setName(PASSWORD_GRANT_AUTHENTICATOR_NAME);
        authenticatedIdPData.addAuthenticator(authenticatorConfig);
        authenticationContext.getCurrentAuthenticatedIdPs().put("LOCAL", authenticatedIdPData);
        authenticationContext.setServiceProviderName(sequenceConfig.getApplicationConfig().getApplicationName());
        return authenticationContext;
    }

    private UserStoreManager getUserStoreManager(OAuth2AccessTokenReqDTO tokenReq) throws IdentityOAuth2Exception {
        UserStoreManager userStoreManager;
        int tenantId = this.getTenantId(tokenReq);
        RealmService realmService = OAuthComponentServiceHolder.getInstance().getRealmService();
        try {
            userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (UserStoreException e) {
            throw new IdentityOAuth2Exception(e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved user store manager for tenant id: " + tenantId));
        }
        return userStoreManager;
    }

    private int getTenantId(OAuth2AccessTokenReqDTO tokenReq) throws IdentityOAuth2Exception {
        int tenantId;
        String username = tokenReq.getResourceOwnerUsername();
        String userTenantDomain = MultitenantUtils.getTenantDomain((String)username);
        try {
            tenantId = IdentityTenantUtil.getTenantId((String)userTenantDomain);
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)("Token request with Password Grant Type for an invalid tenant : " + userTenantDomain));
            throw new IdentityOAuth2Exception(e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved tenant id: " + tenantId + " for tenant domain: " + userTenantDomain));
        }
        return tenantId;
    }

    private AuthenticatedUser getAuthenticatedUser(OAuth2AccessTokenReqDTO tokenReq, ServiceProvider serviceProvider) {
        String username = this.getFullQualifiedUsername(tokenReq);
        AuthenticatedUser user = OAuth2Util.getUserFromUserName(username);
        user.setAuthenticatedSubjectIdentifier(user.getUserName(), serviceProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Token request with password grant type from user: " + user));
        }
        return user;
    }

    private String getFullQualifiedUsername(OAuth2AccessTokenReqDTO tokenReq) {
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)tokenReq.getResourceOwnerUsername());
        String userTenantDomain = MultitenantUtils.getTenantDomain((String)tokenReq.getResourceOwnerUsername());
        String userNameWithTenant = tenantAwareUsername + "@" + userTenantDomain;
        if (!userNameWithTenant.contains(CarbonConstants.DOMAIN_SEPARATOR) && StringUtils.isNotBlank((String)UserCoreUtil.getDomainFromThreadLocal())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User store domain is not found in username. Adding domain: " + UserCoreUtil.getDomainFromThreadLocal()));
            }
            return UserCoreUtil.getDomainFromThreadLocal() + CarbonConstants.DOMAIN_SEPARATOR + userNameWithTenant;
        }
        return userNameWithTenant;
    }
}

