/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AuthorizationCodeValidationResult;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class AuthorizationCodeGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static final String AUTHZ_CODE = "AuthorizationCode";
    private static final int ALLOWED_MINIMUM_VALIDITY_PERIOD = 1000;
    private static final Log log = LogFactory.getLog(AuthorizationCodeGrantHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        super.validateGrant(tokReqMsgCtx);
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        AuthzCodeDO authzCodeBean = this.getPersistedAuthzCode(tokenReq);
        this.validateAuthzCodeFromRequest(authzCodeBean, tokenReq.getClientId(), tokenReq.getAuthorizationCode());
        try {
            this.validateCallbackUrlFromRequest(tokenReq.getCallbackURI(), authzCodeBean.getCallbackUrl());
            this.validatePKCECode(authzCodeBean, tokenReq.getPkceCodeVerifier());
            this.setPropertiesForTokenGeneration(tokReqMsgCtx, tokenReq, authzCodeBean);
        }
        finally {
            tokReqMsgCtx.addProperty("code_id", authzCodeBean.getAuthzCodeId());
            this.revokeAuthorizationCode(authzCodeBean);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found Authorization Code for Client : " + tokenReq.getClientId() + ", authorized user : " + authzCodeBean.getAuthorizedUser() + ", scope : " + OAuth2Util.buildScopeString(authzCodeBean.getScope())));
        }
        return true;
    }

    @Override
    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenRespDTO tokenResp = super.issue(tokReqMsgCtx);
        String authzCode = this.retrieveAuthzCode(tokReqMsgCtx);
        this.deactivateAuthzCode(tokReqMsgCtx, tokenResp.getTokenId(), authzCode);
        this.clearAuthzCodeCache(tokReqMsgCtx, authzCode);
        return tokenResp;
    }

    private void setPropertiesForTokenGeneration(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenReqDTO tokenReq, AuthzCodeDO authzCodeBean) {
        tokReqMsgCtx.setAuthorizedUser(authzCodeBean.getAuthorizedUser());
        tokReqMsgCtx.setScope(authzCodeBean.getScope());
        tokReqMsgCtx.addProperty(AUTHZ_CODE, tokenReq.getAuthorizationCode());
    }

    private boolean validateCallbackUrlFromRequest(String callbackUrlFromRequest, String callbackUrlFromPersistedAuthzCode) throws IdentityOAuth2Exception {
        if (StringUtils.isEmpty((String)callbackUrlFromPersistedAuthzCode)) {
            return true;
        }
        if (!callbackUrlFromPersistedAuthzCode.equals(callbackUrlFromRequest)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received callback url in the request : " + callbackUrlFromRequest + " is not matching with persisted callback url " + callbackUrlFromPersistedAuthzCode));
            }
            throw new IdentityOAuth2Exception("Callback url mismatch");
        }
        return true;
    }

    private void clearAuthzCodeCache(OAuthTokenReqMessageContext tokReqMsgCtx, String authzCode) {
        if (this.cacheEnabled) {
            String clientId = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId();
            OAuthCacheKey cacheKey = new OAuthCacheKey(OAuth2Util.buildCacheKeyStringForAuthzCode(clientId, authzCode));
            OAuthCache.getInstance().clearCacheEntry(cacheKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache was cleared for authorization code info for client id : " + clientId));
            }
        }
    }

    private void deactivateAuthzCode(OAuthTokenReqMessageContext tokReqMsgCtx, String tokenId, String authzCode) throws IdentityOAuth2Exception {
        try {
            AuthzCodeDO authzCodeDO = new AuthzCodeDO();
            authzCodeDO.setAuthorizationCode(authzCode);
            authzCodeDO.setOauthTokenId(tokenId);
            authzCodeDO.setAuthzCodeId(tokReqMsgCtx.getProperty("code_id").toString());
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCode(authzCodeDO);
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)AUTHZ_CODE)) {
                log.debug((Object)("Deactivated authorization code : " + authzCode));
            }
        }
        catch (IdentityException e) {
            throw new IdentityOAuth2Exception("Error occurred while deactivating authorization code", e);
        }
    }

    private boolean isExistingTokenUsed(OAuthTokenReqMessageContext tokReqMsgCtx) {
        if (tokReqMsgCtx.getProperty("existingTokenUsed") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token request message context has 'existingTokenUsed' value : " + tokReqMsgCtx.getProperty("existingTokenUsed").toString()));
            }
            return (Boolean)tokReqMsgCtx.getProperty("existingTokenUsed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"'existingTokenUsed' property not set in token request message context");
        }
        return false;
    }

    private String retrieveAuthzCode(OAuthTokenReqMessageContext tokReqMsgCtx) {
        String authzCode = (String)tokReqMsgCtx.getProperty(AUTHZ_CODE);
        if (authzCode == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("authorization code is not saved in the token request message context for client : " + tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId()));
            }
            authzCode = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getAuthorizationCode();
        }
        return authzCode;
    }

    @Override
    public boolean authorizeAccessDelegation(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    protected void storeAccessToken(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, String userStoreDomain, AccessTokenDO newTokenBean, String newAccessToken, AccessTokenDO existingTokenBean) throws IdentityOAuth2Exception {
        try {
            newTokenBean.setAuthorizationCode(oAuth2AccessTokenReqDTO.getAuthorizationCode());
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().insertAccessToken(newAccessToken, oAuth2AccessTokenReqDTO.getClientId(), newTokenBean, existingTokenBean, userStoreDomain);
        }
        catch (IdentityException e) {
            throw new IdentityOAuth2Exception("Error occurred while storing new access token", e);
        }
    }

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("authorization_code");
    }

    private AuthzCodeDO getPersistedAuthzCode(OAuth2AccessTokenReqDTO tokenReqDTO) throws IdentityOAuth2Exception {
        AuthorizationCodeValidationResult validationResult;
        if (this.cacheEnabled) {
            OAuthCacheKey cacheKey = new OAuthCacheKey(OAuth2Util.buildCacheKeyStringForAuthzCode(tokenReqDTO.getClientId(), tokenReqDTO.getAuthorizationCode()));
            AuthzCodeDO authzCodeDO = (AuthzCodeDO)((Object)OAuthCache.getInstance().getValueFromCache(cacheKey));
            if (authzCodeDO != null) {
                return authzCodeDO;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorization Code Info was not available in cache for client id : " + tokenReqDTO.getClientId()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving authorization code information from db for client id : " + tokenReqDTO.getClientId()));
        }
        if ((validationResult = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().validateAuthorizationCode(tokenReqDTO.getClientId(), tokenReqDTO.getAuthorizationCode())) != null) {
            if (!validationResult.isActiveCode()) {
                String tokenAlias = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokenByTokenId(validationResult.getTokenId());
                this.revokeExistingAccessTokens(validationResult.getTokenId(), validationResult.getAuthzCodeDO());
                this.clearTokenCache(tokenAlias, validationResult.getTokenId());
            }
            return validationResult.getAuthzCodeDO();
        }
        return null;
    }

    private void revokeExistingAccessTokens(String tokenId, AuthzCodeDO authzCodeDO) throws IdentityOAuth2Exception {
        OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessToken(tokenId, authzCodeDO.getAuthorizedUser().toString());
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)AUTHZ_CODE)) {
                log.debug((Object)("Validated authorization code(hashed): " + DigestUtils.sha256Hex((String)authzCodeDO.getAuthorizationCode()) + " for client: " + authzCodeDO.getConsumerKey() + " is not active. So revoking the access tokens issued for the authorization code."));
            } else {
                log.debug((Object)("Validated authorization code for client: " + authzCodeDO.getConsumerKey() + " is not active. So revoking the access tokens issued for the authorization code."));
            }
        }
    }

    private String buildCacheKeyForToken(String clientId, AuthzCodeDO authzCodeDO) {
        String scope = OAuth2Util.buildScopeString(authzCodeDO.getScope());
        return OAuth2Util.buildCacheKeyStringForToken(clientId, scope, authzCodeDO.getAuthorizedUser().toString(), authzCodeDO.getAuthorizedUser().getFederatedIdPName(), authzCodeDO.getTokenBindingReference());
    }

    private boolean validateAuthzCodeFromRequest(AuthzCodeDO authzCodeBean, String clientId, String authzCode) throws IdentityOAuth2Exception {
        if (authzCodeBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid token request for client id: " + clientId + "and couldn't find persisted data for authorization code: " + authzCode));
            }
            throw new IdentityOAuth2Exception("Invalid authorization code received from token request");
        }
        if (this.isInactiveAuthzCode(authzCodeBean)) {
            this.clearTokenCache(authzCodeBean, clientId);
            throw new IdentityOAuth2Exception("Inactive authorization code received from token request");
        }
        if (this.isAuthzCodeExpired(authzCodeBean) || this.isAuthzCodeRevoked(authzCodeBean)) {
            throw new IdentityOAuth2Exception("Expired or Revoked authorization code received from token request");
        }
        return true;
    }

    private void clearTokenCache(AuthzCodeDO authzCodeBean, String clientId) {
        if (this.cacheEnabled) {
            String cacheKeyString = this.buildCacheKeyForToken(clientId, authzCodeBean);
            OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(cacheKeyString));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed token from cache for user : " + authzCodeBean.getAuthorizedUser().toString() + ", for client : " + clientId));
            }
        }
    }

    private void clearTokenCache(String tokenAlias, String tokenId) {
        if (this.cacheEnabled) {
            if (tokenAlias == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received token alias is null. Skipping clearing token cache with token alias for tokenId : " + tokenId));
                }
                return;
            }
            OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(tokenAlias));
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Removed token from cache for token alias : " + tokenAlias));
                } else {
                    log.debug((Object)("Removed token from cache for token alias associated with tokenId : " + tokenId));
                }
            }
        }
    }

    private boolean isInactiveAuthzCode(AuthzCodeDO authzCodeBean) {
        if ("INACTIVE".equals(authzCodeBean.getState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid access token request with Client Id : " + authzCodeBean.getConsumerKey() + ", Inactive authorization code : " + authzCodeBean.getAuthorizationCode()));
            }
            return true;
        }
        return false;
    }

    private boolean isAuthzCodeRevoked(AuthzCodeDO authzCodeBean) {
        if ("REVOKED".equals(authzCodeBean.getState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid access token request with Client Id : " + authzCodeBean.getConsumerKey() + ", Revoked authorization code : " + authzCodeBean.getAuthorizationCode()));
            }
            return true;
        }
        return false;
    }

    private boolean isAuthzCodeExpired(AuthzCodeDO authzCodeBean) throws IdentityOAuth2Exception {
        long validityPeriod;
        if ("EXPIRED".equals(authzCodeBean.getState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid access token request with Client Id : " + authzCodeBean.getConsumerKey() + ", Expired authorization code : " + authzCodeBean.getAuthorizationCode()));
            }
            return true;
        }
        long issuedTime = authzCodeBean.getIssuedTime().getTime();
        if (OAuth2Util.getTimeToExpire(issuedTime, validityPeriod = authzCodeBean.getValidityPeriod()) < 1000L) {
            this.markAsExpired(authzCodeBean);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorization Code Issued Time(ms): " + issuedTime + ", Validity Period: " + validityPeriod + ", Timestamp Skew: " + OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L + ", Current Time: " + System.currentTimeMillis()));
            }
            return true;
        }
        return false;
    }

    private void markAsExpired(AuthzCodeDO authzCodeBean) throws IdentityOAuth2Exception {
        OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().updateAuthorizationCodeState(authzCodeBean.getAuthorizationCode(), "EXPIRED");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changed state of authorization code : " + authzCodeBean.getAuthorizationCode() + " to expired"));
        }
        if (this.cacheEnabled) {
            OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(OAuth2Util.buildCacheKeyStringForAuthzCode(authzCodeBean.getConsumerKey(), authzCodeBean.getAuthorizationCode())));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expired Authorization code issued for client " + authzCodeBean.getConsumerKey() + " was removed from the cache."));
            }
        }
    }

    private boolean validatePKCECode(AuthzCodeDO authzCodeBean, String verificationCode) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthApp;
        String pkceCodeChallengeMethod;
        String pkceCodeChallenge = authzCodeBean.getPkceCodeChallenge();
        if (!OAuth2Util.validatePKCE(pkceCodeChallenge, verificationCode, pkceCodeChallengeMethod = authzCodeBean.getPkceCodeChallengeMethod(), oAuthApp = this.getOAuthAppDO(authzCodeBean.getConsumerKey()))) {
            log.warn((Object)"Failed PKCE Verification for oAuth 2.0 request");
            if (log.isDebugEnabled()) {
                log.debug((Object)("PKCE code verification failed for client : " + authzCodeBean.getConsumerKey()));
            }
            throw new IdentityOAuth2Exception("PKCE validation failed");
        }
        return true;
    }

    private void revokeAuthorizationCode(AuthzCodeDO authzCodeBean) throws IdentityOAuth2Exception {
        OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().updateAuthorizationCodeState(authzCodeBean.getAuthorizationCode(), "REVOKED");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changed state of authorization code : " + authzCodeBean.getAuthorizationCode() + " to revoked"));
        }
        if (this.cacheEnabled) {
            OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(OAuth2Util.buildCacheKeyStringForAuthzCode(authzCodeBean.getConsumerKey(), authzCodeBean.getAuthorizationCode())));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Revoked Authorization code issued for client " + authzCodeBean.getConsumerKey() + " was removed from the cache."));
            }
        }
    }

    private OAuthAppDO getOAuthAppDO(String clientId) throws IdentityOAuth2Exception {
        try {
            return OAuth2Util.getAppInformationByClientId(clientId);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for client: " + clientId);
        }
    }
}

