/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.handlers.grant;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth.callback.OAuthCallbackManager;
import org.wso2.carbon.identity.oauth.common.GrantType;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.util.Oauth2ScopeUtils;
import org.wso2.carbon.identity.oauth2.validators.OAuth2ScopeHandler;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;

public abstract class AbstractAuthorizationGrantHandler
implements AuthorizationGrantHandler {
    private static final Log log = LogFactory.getLog(AbstractAuthorizationGrantHandler.class);
    protected OauthTokenIssuer oauthIssuerImpl = OAuthServerConfiguration.getInstance().getIdentityOauthTokenIssuer();
    protected OAuthCallbackManager callbackManager;
    protected boolean cacheEnabled;
    protected OAuthCache oauthCache;
    protected static final String EXISTING_TOKEN_ISSUED = "existingTokenUsed";
    protected static final int SECONDS_TO_MILISECONDS_FACTOR = 1000;
    private boolean isHashDisabled = OAuth2Util.isHashDisabled();

    @Override
    public void init() throws IdentityOAuth2Exception {
        this.callbackManager = new OAuthCallbackManager();
        if (OAuthCache.getInstance().isEnabled()) {
            this.cacheEnabled = true;
            this.oauthCache = OAuthCache.getInstance();
        }
    }

    @Override
    public boolean isConfidentialClient() throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean isOfTypeApplicationUser() throws IdentityOAuth2Exception {
        return true;
    }

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        if (tokReqMsgCtx.getOauth2AccessTokenReqDTO() != null) {
            return true;
        }
        throw new IdentityOAuth2Exception("Token request data not found in the request message context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OauthTokenIssuer oauthTokenIssuer;
        String scope = OAuth2Util.buildScopeString(tokReqMsgCtx.getScope());
        String consumerKey = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId();
        String authorizedUser = tokReqMsgCtx.getAuthorizedUser().toString();
        String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(tokReqMsgCtx.getAuthorizedUser());
        String tokenBindingReference = this.getTokenBindingReference(tokReqMsgCtx);
        try {
            oauthTokenIssuer = OAuth2Util.getOAuthTokenIssuerForOAuthApp(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving oauth issuer for the app with clientId: " + consumerKey, e);
        }
        String string = (consumerKey + ":" + authorizedUser + ":" + scope + ":" + tokenBindingReference).intern();
        synchronized (string) {
            AccessTokenDO existingTokenBean = null;
            if (this.isHashDisabled) {
                existingTokenBean = this.getExistingToken(tokReqMsgCtx, this.getOAuthCacheKey(scope, consumerKey, authorizedUser, authenticatedIDP, tokenBindingReference));
            }
            if (existingTokenBean != null) {
                if (this.accessTokenRenewedPerRequest(oauthTokenIssuer, tokReqMsgCtx)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TokenRenewalPerRequest is enabled. Proceeding to revoke any existing active tokens and issue new token for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + "."));
                    }
                    return this.renewAccessToken(tokReqMsgCtx, scope, consumerKey, existingTokenBean, oauthTokenIssuer);
                }
                long expireTime = this.getAccessTokenExpiryTimeMillis(existingTokenBean);
                if (this.isExistingTokenValid(existingTokenBean, expireTime)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Existing token is active for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + ". Therefore issuing the same token."));
                    }
                    return this.issueExistingAccessToken(tokReqMsgCtx, scope, expireTime, existingTokenBean);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("No active access token found for client Id: " + consumerKey + ", user: " + authorizedUser + " and scope: " + scope + ". Therefore issuing new token."));
            }
            return this.generateNewAccessToken(tokReqMsgCtx, scope, consumerKey, existingTokenBean, oauthTokenIssuer);
        }
    }

    private void setDetailsToMessageContext(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO existingToken) {
        if (existingToken.getIssuedTime() != null) {
            tokReqMsgCtx.setAccessTokenIssuedTime(existingToken.getIssuedTime().getTime());
        }
        if (existingToken.getRefreshTokenIssuedTime() != null) {
            tokReqMsgCtx.setRefreshTokenIssuedTime(existingToken.getRefreshTokenIssuedTime().getTime());
        }
        tokReqMsgCtx.setRefreshTokenvalidityPeriod(existingToken.getRefreshTokenValidityPeriodInMillis());
    }

    @Override
    public boolean isAuthorizedClient(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenReqDTO tokenReqDTO = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        String grantType = tokenReqDTO.getGrantType();
        OAuthAppDO oAuthAppBean = (OAuthAppDO)tokReqMsgCtx.getProperty("OAuthAppDO");
        if (oAuthAppBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuthAppDO is not available in OAuthTokenReqMessageContext for client id: " + tokenReqDTO.getClientId()));
            }
            return false;
        }
        if (StringUtils.isBlank((String)oAuthAppBean.getGrantTypes())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find authorized grant types for client id: " + tokenReqDTO.getClientId()));
            }
            return false;
        }
        if (!oAuthAppBean.getGrantTypes().contains(grantType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Grant Type : " + grantType + " for client id : " + tokenReqDTO.getClientId()));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        if (this.hasValidationByApplicationScopeValidatorsFailed(tokReqMsgCtx)) {
            return false;
        }
        OAuthCallback scopeValidationCallback = new OAuthCallback(tokReqMsgCtx.getAuthorizedUser(), tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId(), OAuthCallback.OAuthCallbackType.SCOPE_VALIDATION_TOKEN);
        scopeValidationCallback.setRequestedScope(tokReqMsgCtx.getScope());
        if (tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType().equals(GrantType.SAML20_BEARER.toString())) {
            scopeValidationCallback.setCarbonGrantType(GrantType.valueOf((String)"SAML20_BEARER".toString()));
        } else if (tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType().equals(GrantType.IWA_NTLM.toString())) {
            scopeValidationCallback.setCarbonGrantType(GrantType.valueOf((String)"IWA_NTLM".toString()));
        } else {
            scopeValidationCallback.setGrantType(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType());
        }
        this.callbackManager.handleCallback(scopeValidationCallback);
        tokReqMsgCtx.setValidityPeriod(scopeValidationCallback.getValidityPeriod());
        tokReqMsgCtx.setScope(scopeValidationCallback.getApprovedScope());
        Set<OAuth2ScopeHandler> scopeHandlers = OAuthServerConfiguration.getInstance().getOAuth2ScopeHandlers();
        boolean isValid = true;
        for (OAuth2ScopeHandler scopeHandler : scopeHandlers) {
            if (scopeHandler == null || !scopeHandler.canHandle(tokReqMsgCtx)) continue;
            isValid = scopeHandler.validateScope(tokReqMsgCtx);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("ScopeHandler: %s validated to: %s", scopeHandler.getClass().getCanonicalName(), isValid));
            }
            if (isValid) continue;
            break;
        }
        List<ScopeValidator> globalScopeValidators = OAuthComponentServiceHolder.getInstance().getScopeValidators();
        for (ScopeValidator validator : globalScopeValidators) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Engaging global scope validator in token issuer flow : " + validator.getName()));
            }
            boolean isGlobalValidScope = validator.validateScope(tokReqMsgCtx);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Scope Validation was" + isGlobalValidScope + "at the global level by : " + validator.getName()));
        }
        return isValid && scopeValidationCallback.isValidScope();
    }

    @Override
    public boolean authorizeAccessDelegation(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuthCallback authzCallback = new OAuthCallback(tokReqMsgCtx.getAuthorizedUser(), tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId(), OAuthCallback.OAuthCallbackType.ACCESS_DELEGATION_TOKEN);
        authzCallback.setRequestedScope(tokReqMsgCtx.getScope());
        if (tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType().equals(GrantType.SAML20_BEARER.toString())) {
            authzCallback.setCarbonGrantType(GrantType.valueOf((String)"SAML20_BEARER"));
        } else if (tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType().equals(GrantType.IWA_NTLM.toString())) {
            authzCallback.setCarbonGrantType(GrantType.valueOf((String)"IWA_NTLM"));
        } else {
            authzCallback.setGrantType(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType());
        }
        this.callbackManager.handleCallback(authzCallback);
        tokReqMsgCtx.setValidityPeriod(authzCallback.getValidityPeriod());
        return authzCallback.isAuthorized();
    }

    protected String getTokenType() throws IdentityOAuth2Exception {
        return this.isOfTypeApplicationUser() ? "APPLICATION_USER" : "APPLICATION";
    }

    protected void storeAccessToken(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, String userStoreDomain, AccessTokenDO newTokenBean, String newAccessToken, AccessTokenDO existingTokenBean) throws IdentityOAuth2Exception {
        try {
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().insertAccessToken(newAccessToken, oAuth2AccessTokenReqDTO.getClientId(), newTokenBean, existingTokenBean, userStoreDomain);
        }
        catch (IdentityException e) {
            throw new IdentityOAuth2Exception("Error occurred while storing new access token : " + newAccessToken, e);
        }
    }

    protected String getUserStoreDomain(AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        String userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            try {
                userStoreDomain = OAuth2Util.getUserStoreForFederatedUser(authenticatedUser);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMsg = "Error occurred while getting user store domain for User ID : " + authenticatedUser;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw new IdentityOAuth2Exception(errorMsg, (Throwable)((Object)e));
            }
        }
        return userStoreDomain;
    }

    private OAuth2AccessTokenRespDTO renewAccessToken(OAuthTokenReqMessageContext tokReqMsgCtx, String scope, String consumerKey, AccessTokenDO existingTokenBean, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().updateAccessTokenState(existingTokenBean.getTokenId(), "REVOKED");
        this.clearExistingTokenFromCache(tokReqMsgCtx, existingTokenBean);
        return this.generateNewAccessToken(tokReqMsgCtx, scope, consumerKey, null, oauthTokenIssuer);
    }

    private OAuth2AccessTokenRespDTO issueExistingAccessToken(OAuthTokenReqMessageContext tokReqMsgCtx, String scope, long expireTime, AccessTokenDO existingTokenBean) throws IdentityOAuth2Exception {
        tokReqMsgCtx.addProperty(EXISTING_TOKEN_ISSUED, true);
        this.setDetailsToMessageContext(tokReqMsgCtx, existingTokenBean);
        return this.createResponseWithTokenBean(existingTokenBean, expireTime, scope);
    }

    private OAuth2AccessTokenRespDTO generateNewAccessToken(OAuthTokenReqMessageContext tokReqMsgCtx, String scope, String consumerKey, AccessTokenDO existingTokenBean, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppBean = this.getoAuthApp(consumerKey);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        long validityPeriodInMillis = this.getConfiguredExpiryTimeForApplication(tokReqMsgCtx, consumerKey, oAuthAppBean);
        AccessTokenDO newTokenBean = this.createNewTokenBean(tokReqMsgCtx, oAuthAppBean, existingTokenBean, timestamp, validityPeriodInMillis, oauthTokenIssuer);
        this.setDetailsToMessageContext(tokReqMsgCtx, validityPeriodInMillis, newTokenBean, timestamp);
        this.persistAccessTokenInDB(tokReqMsgCtx, existingTokenBean, newTokenBean, timestamp, newTokenBean.getAccessToken());
        this.updateCacheIfEnabled(newTokenBean, OAuth2Util.buildScopeString(tokReqMsgCtx.getScope()), oauthTokenIssuer);
        return this.createResponseWithTokenBean(newTokenBean, validityPeriodInMillis, scope);
    }

    private boolean isExistingTokenValid(AccessTokenDO existingTokenBean, long expireTime) {
        if ("ACTIVE".equals(existingTokenBean.getTokenState()) && expireTime != 0L) {
            return true;
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token(hashed) " + DigestUtils.sha256Hex((String)existingTokenBean.getAccessToken()) + " is not valid anymore"));
            } else {
                log.debug((Object)("Latest access token in the database for client: " + existingTokenBean.getConsumerKey() + " is not valid anymore"));
            }
        }
        return false;
    }

    private AccessTokenDO createNewTokenBean(OAuthTokenReqMessageContext tokReqMsgCtx, OAuthAppDO oAuthAppBean, AccessTokenDO existingTokenBean, Timestamp timestamp, long validityPeriodInMillis, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        String tenantDomain = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        this.validateGrantTypeParam(tokenReq);
        AccessTokenDO newTokenBean = new AccessTokenDO();
        newTokenBean.setTokenState("ACTIVE");
        newTokenBean.setConsumerKey(tokenReq.getClientId());
        newTokenBean.setAuthzUser(tokReqMsgCtx.getAuthorizedUser());
        newTokenBean.setScope(tokReqMsgCtx.getScope());
        newTokenBean.setTenantID(OAuth2Util.getTenantId(tenantDomain));
        newTokenBean.setTokenId(UUID.randomUUID().toString());
        newTokenBean.setGrantType(tokenReq.getGrantType());
        newTokenBean.setTokenType(this.getTokenType());
        newTokenBean.setIssuedTime(timestamp);
        newTokenBean.setAccessToken(this.getNewAccessToken(tokReqMsgCtx, oauthTokenIssuer));
        newTokenBean.setValidityPeriodInMillis(validityPeriodInMillis);
        newTokenBean.setValidityPeriod(validityPeriodInMillis / 1000L);
        newTokenBean.setTokenBinding(tokReqMsgCtx.getTokenBinding());
        this.setRefreshTokenDetails(tokReqMsgCtx, oAuthAppBean, existingTokenBean, timestamp, validityPeriodInMillis, tokenReq, newTokenBean, oauthTokenIssuer);
        return newTokenBean;
    }

    private void setRefreshTokenDetails(OAuthTokenReqMessageContext tokReqMsgCtx, OAuthAppDO oAuthAppBean, AccessTokenDO existingTokenBean, Timestamp timestamp, long validityPeriodInMillis, OAuth2AccessTokenReqDTO tokenReq, AccessTokenDO newTokenBean, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        if (this.isRefreshTokenValid(existingTokenBean, validityPeriodInMillis, tokenReq.getClientId())) {
            this.setRefreshTokenDetailsFromExistingToken(existingTokenBean, newTokenBean);
        } else {
            newTokenBean.setRefreshTokenIssuedTime(timestamp);
            newTokenBean.setRefreshTokenValidityPeriodInMillis(this.getRefreshTokenValidityPeriod(tokenReq.getClientId(), oAuthAppBean, tokReqMsgCtx));
            newTokenBean.setRefreshToken(this.getRefreshToken(tokReqMsgCtx, oauthTokenIssuer));
        }
    }

    private void persistAccessTokenInDB(OAuthTokenReqMessageContext tokReqMsgCtx, AccessTokenDO existingTokenBean, AccessTokenDO newTokenBean, Timestamp timestamp, String newAccessToken) throws IdentityOAuth2Exception {
        OAuth2AccessTokenReqDTO tokenReq = tokReqMsgCtx.getOauth2AccessTokenReqDTO();
        this.storeAccessToken(tokenReq, this.getUserStoreDomain(tokReqMsgCtx.getAuthorizedUser()), newTokenBean, newAccessToken, existingTokenBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisted Access Token for Client ID: " + tokenReq.getClientId() + ", Authorized User: " + tokReqMsgCtx.getAuthorizedUser() + ", Is Federated User: " + tokReqMsgCtx.getAuthorizedUser().isFederatedUser() + ", Timestamp: " + timestamp + ", Validity period: " + newTokenBean.getValidityPeriod() + "s, Scope: " + OAuth2Util.buildScopeString(tokReqMsgCtx.getScope()) + " and Token State: " + "ACTIVE"));
        }
    }

    private void updateCacheIfEnabled(AccessTokenDO newTokenBean, String scope, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        if (this.isHashDisabled && this.cacheEnabled) {
            AccessTokenDO tokenToCache;
            block6: {
                tokenToCache = AccessTokenDO.clone(newTokenBean);
                if (oauthTokenIssuer.usePersistedAccessTokenAlias()) {
                    try {
                        String persistedTokenIdentifier = oauthTokenIssuer.getAccessTokenHash(newTokenBean.getAccessToken());
                        tokenToCache.setAccessToken(persistedTokenIdentifier);
                    }
                    catch (OAuthSystemException e) {
                        if (!log.isDebugEnabled()) break block6;
                        if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                            log.debug((Object)("Token issuer: " + oauthTokenIssuer.getClass() + " was tried and failed to parse the received token: " + tokenToCache.getAccessToken()), (Throwable)e);
                        }
                        log.debug((Object)("Token issuer: " + oauthTokenIssuer.getClass() + " was tried and failed to parse the received token."), (Throwable)e);
                    }
                }
            }
            OAuthCacheKey cacheKey = this.getOAuthCacheKey(scope, tokenToCache.getConsumerKey(), tokenToCache.getAuthzUser().toString(), tokenToCache.getAuthzUser().getFederatedIdPName(), this.getTokenBindingReference(tokenToCache));
            this.oauthCache.addToCache(cacheKey, (Serializable)((Object)tokenToCache));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access token was added to OAuthCache with cache key : " + cacheKey.getCacheKeyString()));
            }
            OAuth2Util.addTokenDOtoCache(newTokenBean);
        }
    }

    private void setDetailsToMessageContext(OAuthTokenReqMessageContext tokReqMsgCtx, long validityPeriodInMillis, AccessTokenDO newTokenBean, Timestamp timestamp) {
        tokReqMsgCtx.setValidityPeriod(validityPeriodInMillis);
        tokReqMsgCtx.setRefreshTokenvalidityPeriod(newTokenBean.getRefreshTokenValidityPeriodInMillis());
        tokReqMsgCtx.setAccessTokenIssuedTime(timestamp.getTime());
        tokReqMsgCtx.setRefreshTokenIssuedTime(newTokenBean.getRefreshTokenIssuedTime().getTime());
    }

    private String getNewAccessToken(OAuthTokenReqMessageContext tokReqMsgCtx, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        try {
            String newAccessToken = oauthTokenIssuer.accessToken(tokReqMsgCtx);
            if (OAuth2Util.checkUserNameAssertionEnabled()) {
                newAccessToken = OAuth2Util.addUsernameToToken(tokReqMsgCtx.getAuthorizedUser(), newAccessToken);
            }
            return newAccessToken;
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception("Error while generating access token");
        }
    }

    private String getRefreshToken(OAuthTokenReqMessageContext tokReqMsgCtx, OauthTokenIssuer oauthTokenIssuer) throws IdentityOAuth2Exception {
        try {
            String refreshToken = oauthTokenIssuer.refreshToken(tokReqMsgCtx);
            if (OAuth2Util.checkUserNameAssertionEnabled()) {
                refreshToken = OAuth2Util.addUsernameToToken(tokReqMsgCtx.getAuthorizedUser(), refreshToken);
            }
            return refreshToken;
        }
        catch (OAuthSystemException e) {
            throw new IdentityOAuth2Exception("Error while issueing refresh token");
        }
    }

    private void setRefreshTokenDetailsFromExistingToken(AccessTokenDO existingAccessTokenDO, AccessTokenDO newTokenBean) {
        newTokenBean.setRefreshToken(existingAccessTokenDO.getRefreshToken());
        newTokenBean.setRefreshTokenIssuedTime(existingAccessTokenDO.getRefreshTokenIssuedTime());
        newTokenBean.setRefreshTokenValidityPeriodInMillis(existingAccessTokenDO.getRefreshTokenValidityPeriodInMillis());
    }

    private void validateGrantTypeParam(OAuth2AccessTokenReqDTO tokenReq) throws IdentityOAuth2Exception {
        if (tokenReq.getGrantType() == null) {
            throw new IdentityOAuth2Exception("Grant type not found in the token request");
        }
    }

    private long getRefreshTokenValidityPeriod(String consumerKey, OAuthAppDO oAuthAppBean, OAuthTokenReqMessageContext tokReqMsgCtx) {
        long refreshTokenValidityPeriodInMillis;
        long validityPeriodFromMsgContext = tokReqMsgCtx.getRefreshTokenvalidityPeriod();
        if (validityPeriodFromMsgContext != -1L && validityPeriodFromMsgContext > 0L) {
            refreshTokenValidityPeriodInMillis = validityPeriodFromMsgContext * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppBean.getOauthConsumerKey() + ", using refresh token validity period configured from OAuthTokenReqMessageContext: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        } else if (oAuthAppBean.getRefreshTokenExpiryTime() != 0L) {
            refreshTokenValidityPeriodInMillis = oAuthAppBean.getRefreshTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + consumerKey + ", refresh token validity time " + refreshTokenValidityPeriodInMillis + "ms"));
            }
        } else {
            refreshTokenValidityPeriodInMillis = OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L;
        }
        return refreshTokenValidityPeriodInMillis;
    }

    private void addTokenToCache(OAuthCacheKey cacheKey, AccessTokenDO existingAccessTokenDO) {
        if (this.isHashDisabled && this.cacheEnabled) {
            this.oauthCache.addToCache(cacheKey, (Serializable)((Object)existingAccessTokenDO));
            OAuthCacheKey accessTokenCacheKey = new OAuthCacheKey(existingAccessTokenDO.getAccessToken());
            this.oauthCache.addToCache(accessTokenCacheKey, (Serializable)((Object)existingAccessTokenDO));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access Token info was added to the cache for the cache key : " + cacheKey.getCacheKeyString()));
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Access token was added to OAuthCache for cache key : " + accessTokenCacheKey.getCacheKeyString()));
                }
            }
        }
    }

    private OAuth2AccessTokenRespDTO createResponseWithTokenBean(AccessTokenDO existingAccessTokenDO, long expireTimeMillis, String scope) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        tokenRespDTO.setAccessToken(existingAccessTokenDO.getAccessToken());
        tokenRespDTO.setTokenId(existingAccessTokenDO.getTokenId());
        String consumerKey = existingAccessTokenDO.getConsumerKey();
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for client_id : " + consumerKey, e);
        }
        if (this.issueRefreshToken() && OAuthServerConfiguration.getInstance().getSupportedGrantTypes().containsKey(org.apache.oltu.oauth2.common.message.types.GrantType.REFRESH_TOKEN.toString())) {
            String grantTypes = oAuthAppDO.getGrantTypes();
            List<Object> supportedGrantTypes = new ArrayList();
            if (StringUtils.isNotEmpty((String)grantTypes)) {
                supportedGrantTypes = Arrays.asList(grantTypes.split(" "));
            }
            if (supportedGrantTypes.contains("refresh_token")) {
                tokenRespDTO.setRefreshToken(existingAccessTokenDO.getRefreshToken());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Refresh grant is not allowed for client_id : " + consumerKey + ", therefore not issuing a refresh token."));
            }
        }
        if (expireTimeMillis > 0L) {
            tokenRespDTO.setExpiresIn(expireTimeMillis / 1000L);
            tokenRespDTO.setExpiresInMillis(expireTimeMillis);
        } else {
            tokenRespDTO.setExpiresIn(9223372036854775L);
            tokenRespDTO.setExpiresInMillis(Long.MAX_VALUE);
        }
        tokenRespDTO.setAuthorizedScopes(scope);
        return tokenRespDTO;
    }

    private OAuthCacheKey getOAuthCacheKey(String scope, String consumerKey, String authorizedUser, String authenticatedIDP, String tokenBindingType) {
        String cacheKeyString = OAuth2Util.buildCacheKeyStringForToken(consumerKey, scope, authorizedUser, authenticatedIDP, tokenBindingType);
        return new OAuthCacheKey(cacheKeyString);
    }

    private OAuthAppDO getoAuthApp(String consumerKey) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppBean;
        try {
            oAuthAppBean = OAuth2Util.getAppInformationByClientId(consumerKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Service Provider specific expiry time enabled for application : " + consumerKey + ". Application access token expiry time : " + oAuthAppBean.getApplicationAccessTokenExpiryTime() + ", User access token expiry time : " + oAuthAppBean.getUserAccessTokenExpiryTime() + ", Refresh token expiry time : " + oAuthAppBean.getRefreshTokenExpiryTime()));
            }
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + consumerKey, e);
        }
        return oAuthAppBean;
    }

    private long getAccessTokenExpiryTimeMillis(AccessTokenDO existingAccessTokenDO) throws IdentityOAuth2Exception {
        long expireTimeMillis = this.issueRefreshToken() ? OAuth2Util.getTokenExpireTimeMillis(existingAccessTokenDO) : OAuth2Util.getAccessTokenExpireMillis(existingAccessTokenDO);
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                if (expireTimeMillis > 0L) {
                    log.debug((Object)("Access Token(hashed): " + DigestUtils.sha256Hex((String)existingAccessTokenDO.getAccessToken()) + " is still valid. Remaining time: " + expireTimeMillis + "ms"));
                } else {
                    log.debug((Object)("Infinite lifetime Access Token(hashed) " + DigestUtils.sha256Hex((String)existingAccessTokenDO.getAccessToken()) + " found"));
                }
            } else if (expireTimeMillis > 0L) {
                log.debug((Object)("Valid access token is found in cache for client: " + existingAccessTokenDO.getConsumerKey() + ". Remaining time: " + expireTimeMillis + "ms"));
            } else {
                log.debug((Object)("Infinite lifetime Access Token found in cache for client: " + existingAccessTokenDO.getConsumerKey()));
            }
        }
        return expireTimeMillis;
    }

    private long getConfiguredExpiryTimeForApplication(OAuthTokenReqMessageContext tokReqMsgCtx, String consumerKey, OAuthAppDO oAuthAppBean) throws IdentityOAuth2Exception {
        long validityPeriodInMillis = this.isOfTypeApplicationUser() ? this.getValidityPeriodForApplicationUser(consumerKey, oAuthAppBean) : this.getValidityPeriodForApplication(consumerKey, oAuthAppBean);
        validityPeriodInMillis = this.getValidityPeriodFromCallback(tokReqMsgCtx, consumerKey, validityPeriodInMillis);
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth application id : " + consumerKey + ", access token validity time in milliseconds : " + validityPeriodInMillis));
        }
        return validityPeriodInMillis;
    }

    private long getValidityPeriodFromCallback(OAuthTokenReqMessageContext tokReqMsgCtx, String consumerKey, long validityPeriodInMillis) {
        long callbackValidityPeriod = tokReqMsgCtx.getValidityPeriod();
        if (callbackValidityPeriod != -1L) {
            validityPeriodInMillis = callbackValidityPeriod * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + consumerKey + ", callback access token validity time in milliseconds : " + validityPeriodInMillis));
            }
        }
        return validityPeriodInMillis;
    }

    private long getValidityPeriodForApplication(String consumerKey, OAuthAppDO oAuthAppBean) {
        long validityPeriodInMillis;
        if (oAuthAppBean.getApplicationAccessTokenExpiryTime() != 0L) {
            validityPeriodInMillis = oAuthAppBean.getApplicationAccessTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + consumerKey + ", application access token validity time in milliseconds : " + validityPeriodInMillis));
            }
        } else {
            validityPeriodInMillis = OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() * 1000L;
        }
        return validityPeriodInMillis;
    }

    private long getValidityPeriodForApplicationUser(String consumerKey, OAuthAppDO oAuthAppBean) {
        long validityPeriodInMillis;
        if (oAuthAppBean.getUserAccessTokenExpiryTime() != 0L) {
            validityPeriodInMillis = oAuthAppBean.getUserAccessTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id: " + consumerKey + ", user access token validity time " + validityPeriodInMillis + "ms"));
            }
        } else {
            validityPeriodInMillis = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
        }
        return validityPeriodInMillis;
    }

    private AccessTokenDO getExistingToken(OAuthTokenReqMessageContext tokenMsgCtx, OAuthCacheKey cacheKey) throws IdentityOAuth2Exception {
        AccessTokenDO existingToken = null;
        OAuth2AccessTokenReqDTO tokenReq = tokenMsgCtx.getOauth2AccessTokenReqDTO();
        String scope = OAuth2Util.buildScopeString(tokenMsgCtx.getScope());
        String tokenBindingReference = this.getTokenBindingReference(tokenMsgCtx);
        if (this.cacheEnabled) {
            existingToken = this.getExistingTokenFromCache(cacheKey, tokenReq.getClientId(), tokenMsgCtx.getAuthorizedUser().toString(), scope, tokenBindingReference);
        }
        if (existingToken == null) {
            existingToken = this.getExistingTokenFromDB(tokenMsgCtx, tokenReq, scope, cacheKey);
        }
        return existingToken;
    }

    private AccessTokenDO getExistingTokenFromDB(OAuthTokenReqMessageContext tokenMsgCtx, OAuth2AccessTokenReqDTO tokenReq, String scope, OAuthCacheKey cacheKey) throws IdentityOAuth2Exception {
        AccessTokenDO existingToken = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getLatestAccessToken(tokenReq.getClientId(), tokenMsgCtx.getAuthorizedUser(), this.getUserStoreDomain(tokenMsgCtx.getAuthorizedUser()), scope, this.getTokenBindingReference(tokenMsgCtx), false);
        if (existingToken != null) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)("Retrieved latest access token(hashed): " + DigestUtils.sha256Hex((String)existingToken.getAccessToken()) + " in the state: " + existingToken.getTokenState() + " for client Id: " + tokenReq.getClientId() + " user: " + tokenMsgCtx.getAuthorizedUser() + " and scope: " + scope + " from db"));
                } else {
                    log.debug((Object)("Retrieved latest access token for client Id: " + tokenReq.getClientId() + " user: " + tokenMsgCtx.getAuthorizedUser() + " and scope: " + scope + " from db"));
                }
            }
            long expireTime = this.getAccessTokenExpiryTimeMillis(existingToken);
            if ("ACTIVE".equals(existingToken.getTokenState()) && expireTime != 0L) {
                this.addTokenToCache(cacheKey, existingToken);
            }
        }
        return existingToken;
    }

    private AccessTokenDO getExistingTokenFromCache(OAuthCacheKey cacheKey, String consumerKey, String authorizedUser, String scope, String tokenBindingReference) throws IdentityOAuth2Exception {
        AccessTokenDO existingToken = null;
        CacheEntry cacheEntry = (CacheEntry)((Object)this.oauthCache.getValueFromCache(cacheKey));
        if (cacheEntry instanceof AccessTokenDO) {
            existingToken = (AccessTokenDO)cacheEntry;
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Retrieved active access token(hashed): " + DigestUtils.sha256Hex((String)existingToken.getAccessToken()) + " in the state: " + existingToken.getTokenState() + " for client Id: " + consumerKey + ", user: " + authorizedUser + " ,scope: " + scope + " and token binding reference: " + tokenBindingReference + " from cache"));
            }
            if (this.getAccessTokenExpiryTimeMillis(existingToken) == 0L) {
                this.removeFromCache(cacheKey, consumerKey, existingToken);
            }
        }
        return existingToken;
    }

    private void removeFromCache(OAuthCacheKey cacheKey, String consumerKey, AccessTokenDO existingAccessTokenDO) {
        this.oauthCache.clearCacheEntry(cacheKey);
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token(hashed) " + DigestUtils.sha256Hex((String)existingAccessTokenDO.getAccessToken()) + " is expired. Therefore cleared it from cache and marked it as expired in database"));
            } else {
                log.debug((Object)("Existing access token for client: " + consumerKey + " is expired. Therefore cleared it from cache and marked it as expired in database"));
            }
        }
    }

    private boolean isRefreshTokenValid(AccessTokenDO existingAccessTokenDO, long validityPeriod, String consumerKey) {
        if (this.isHashDisabled && existingAccessTokenDO != null) {
            long refreshTokenExpireTime = OAuth2Util.getRefreshTokenExpireTimeMillis(existingAccessTokenDO);
            if ("ACTIVE".equals(existingAccessTokenDO.getTokenState()) && !this.isRefreshTokenExpired(validityPeriod, refreshTokenExpireTime)) {
                if (log.isDebugEnabled()) {
                    if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                        log.debug((Object)("Existing access token: " + existingAccessTokenDO.getAccessToken() + " has expired, but refresh token:" + existingAccessTokenDO.getRefreshToken() + " is still valid for client: " + consumerKey + ". Remaining time: " + refreshTokenExpireTime + "ms. Using existing refresh token."));
                    } else {
                        log.debug((Object)("Existing access token has expired, but refresh token is still valid for client: " + consumerKey + ". Remaining time: " + refreshTokenExpireTime + "ms. Using existing refresh token."));
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isRefreshTokenExpired(long validityPeriod, long refreshTokenExpireTime) {
        if (refreshTokenExpireTime < 0L) {
            return false;
        }
        return refreshTokenExpireTime <= 0L || refreshTokenExpireTime <= validityPeriod;
    }

    private boolean accessTokenRenewedPerRequest(OauthTokenIssuer oauthTokenIssuer, OAuthTokenReqMessageContext tokReqMsgCtx) {
        boolean isRenewTokenPerRequestEnabledInIssuer = oauthTokenIssuer.renewAccessTokenPerRequest();
        boolean isRenewTokenPerRequestEnabledInTokReqMsgCtx = this.oauthIssuerImpl.renewAccessTokenPerRequest(tokReqMsgCtx);
        boolean isRenewTokenPerRequestEnabledInConfig = OAuthServerConfiguration.getInstance().isTokenRenewalPerRequestEnabled();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token renew per request: OauthTokenIssuer: " + isRenewTokenPerRequestEnabledInIssuer + ", OAuthTokenReqMessageContext: " + isRenewTokenPerRequestEnabledInTokReqMsgCtx + ", Configuration: " + isRenewTokenPerRequestEnabledInConfig));
        }
        return isRenewTokenPerRequestEnabledInIssuer || isRenewTokenPerRequestEnabledInTokReqMsgCtx || isRenewTokenPerRequestEnabledInConfig;
    }

    private void clearExistingTokenFromCache(OAuthTokenReqMessageContext tokenMsgCtx, AccessTokenDO existingTokenBean) {
        if (this.cacheEnabled) {
            String tokenBindingReference = this.getTokenBindingReference(tokenMsgCtx);
            OAuthUtil.clearOAuthCache(existingTokenBean.getConsumerKey(), (User)existingTokenBean.getAuthzUser(), OAuth2Util.buildScopeString(existingTokenBean.getScope()), tokenBindingReference);
            OAuthUtil.clearOAuthCache(existingTokenBean.getConsumerKey(), (User)existingTokenBean.getAuthzUser(), OAuth2Util.buildScopeString(existingTokenBean.getScope()));
            OAuthUtil.clearOAuthCache(existingTokenBean.getConsumerKey(), (User)existingTokenBean.getAuthzUser());
            OAuthUtil.clearOAuthCache(existingTokenBean.getAccessToken());
        }
    }

    private OAuth2Service getOauth2Service() {
        return (OAuth2Service)((Object)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(OAuth2Service.class, null));
    }

    private boolean hasValidationByApplicationScopeValidatorsFailed(OAuthTokenReqMessageContext tokenReqMsgContext) throws IdentityOAuth2Exception {
        return !Oauth2ScopeUtils.validateByApplicationScopeValidator(tokenReqMsgContext, null);
    }

    private String getTokenBindingReference(OAuthTokenReqMessageContext tokReqMsgCtx) {
        if (tokReqMsgCtx.getTokenBinding() == null || StringUtils.isBlank((String)tokReqMsgCtx.getTokenBinding().getBindingReference())) {
            return "NONE";
        }
        return tokReqMsgCtx.getTokenBinding().getBindingReference();
    }

    private String getTokenBindingReference(AccessTokenDO accessTokenDO) {
        if (accessTokenDO.getTokenBinding() == null || StringUtils.isBlank((String)accessTokenDO.getTokenBinding().getBindingReference())) {
            return "NONE";
        }
        return accessTokenDO.getTokenBinding().getBindingReference();
    }
}

