/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.bindings.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.token.bindings.impl.AbstractTokenBinder;

public class SSOSessionBasedTokenBinder
extends AbstractTokenBinder {
    private List<String> supportedGrantTypes = Collections.singletonList("authorization_code");
    private static final String COMMONAUTH_COOKIE = "commonAuthId";

    public String getDisplayName() {
        return "SSO Session Based";
    }

    public String getDescription() {
        return "Bind token to the SSO session. Supported grant types: Code";
    }

    public String getBindingType() {
        return "sso-session";
    }

    public List<String> getSupportedGrantTypes() {
        return Collections.unmodifiableList(this.supportedGrantTypes);
    }

    @Override
    public String getOrGenerateTokenBindingValue(HttpServletRequest request) throws OAuthSystemException {
        return this.retrieveTokenBindingValueFromRequest(request);
    }

    @Override
    public String getTokenBindingValue(HttpServletRequest request) throws OAuthSystemException {
        return this.retrieveTokenBindingValueFromRequest(request);
    }

    private String retrieveTokenBindingValueFromRequest(HttpServletRequest request) throws OAuthSystemException {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            throw new OAuthSystemException("Failed to retrieve token binding value.");
        }
        Optional<Cookie> commonAuthCookieOptional = Arrays.stream(cookies).filter(t -> COMMONAUTH_COOKIE.equals(t.getName())).findAny();
        if (!commonAuthCookieOptional.isPresent() || StringUtils.isBlank((String)commonAuthCookieOptional.get().getValue())) {
            throw new OAuthSystemException("Failed to retrieve token binding value.");
        }
        return DigestUtils.sha256Hex((String)commonAuthCookieOptional.get().getValue());
    }

    @Override
    public void setTokenBindingValueForResponse(HttpServletResponse response, String bindingValue) {
    }

    @Override
    public void clearTokenBindingElements(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public boolean isValidTokenBinding(Object request, String bindingReference) {
        return this.isValidTokenBinding(request, bindingReference, COMMONAUTH_COOKIE);
    }

    @Override
    public boolean isValidTokenBinding(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, String bindingReference) {
        return this.isValidTokenBinding(oAuth2AccessTokenReqDTO, bindingReference, COMMONAUTH_COOKIE);
    }
}

