/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.bindings.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.token.bindings.impl.AbstractTokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CookieBasedTokenBinder
extends AbstractTokenBinder {
    private static final String BINDING_TYPE = "cookie";
    private static final String COOKIE_NAME = "atbv";
    private List<String> supportedGrantTypes = Collections.singletonList("authorization_code");

    public String getBindingType() {
        return BINDING_TYPE;
    }

    public List<String> getSupportedGrantTypes() {
        return Collections.unmodifiableList(this.supportedGrantTypes);
    }

    public String getDisplayName() {
        return "Cookie Based";
    }

    public String getDescription() {
        return "Bind token to the browser cookie. Supported grant types: Code";
    }

    @Override
    public String getOrGenerateTokenBindingValue(HttpServletRequest request) throws OAuthSystemException {
        String tokenBindingValue = this.retrieveTokenBindingValueFromRequest(request);
        if (StringUtils.isNotBlank((String)tokenBindingValue)) {
            return tokenBindingValue;
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public String getTokenBindingValue(HttpServletRequest request) throws OAuthSystemException {
        String tokenBindingValue = this.retrieveTokenBindingValueFromRequest(request);
        if (StringUtils.isNotBlank((String)tokenBindingValue)) {
            return tokenBindingValue;
        }
        throw new OAuthSystemException("Failed to retrieve token binding value.");
    }

    private String retrieveTokenBindingValueFromRequest(HttpServletRequest request) throws OAuthSystemException {
        boolean isTokenBindingValueValid;
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            return null;
        }
        Optional<Cookie> tokenBindingCookieOptional = Arrays.stream(cookies).filter(t -> COOKIE_NAME.equals(t.getName())).findAny();
        if (!tokenBindingCookieOptional.isPresent() || StringUtils.isBlank((String)tokenBindingCookieOptional.get().getValue())) {
            return null;
        }
        String tokenBindingValue = tokenBindingCookieOptional.get().getValue();
        try {
            isTokenBindingValueValid = OAuthTokenPersistenceFactory.getInstance().getTokenBindingMgtDAO().isTokenBindingExistsForBindingReference(OAuth2Util.getTokenBindingReference(tokenBindingValue));
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException("Failed to check token binding reference existence", (Throwable)((Object)e));
        }
        return isTokenBindingValueValid ? tokenBindingValue : null;
    }

    @Override
    public void setTokenBindingValueForResponse(HttpServletResponse response, String bindingValue) {
        Cookie cookie = new Cookie(COOKIE_NAME, bindingValue);
        cookie.setSecure(true);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    @Override
    public void clearTokenBindingElements(HttpServletRequest request, HttpServletResponse response) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isNotEmpty((Object[])cookies)) {
            Arrays.stream(cookies).filter(t -> COOKIE_NAME.equals(t.getName())).findAny().ifPresent(cookie -> {
                cookie.setMaxAge(0);
                cookie.setSecure(true);
                cookie.setHttpOnly(true);
                cookie.setPath("/");
                response.addCookie(cookie);
            });
        }
    }

    @Override
    public boolean isValidTokenBinding(Object request, String bindingReference) {
        return this.isValidTokenBinding(request, bindingReference, COOKIE_NAME);
    }

    @Override
    public boolean isValidTokenBinding(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, String bindingReference) {
        return this.isValidTokenBinding(oAuth2AccessTokenReqDTO, bindingReference, COOKIE_NAME);
    }
}

