/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.bindings.impl;

import java.net.HttpCookie;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.model.HttpRequestHeader;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public abstract class AbstractTokenBinder
implements TokenBinder {
    @Override
    public Optional<String> getTokenBindingValue(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO) {
        if ("authorization_code".equals(oAuth2AccessTokenReqDTO.getGrantType()) && StringUtils.isNotBlank((String)oAuth2AccessTokenReqDTO.getAuthorizationCode())) {
            AuthorizationGrantCacheKey cacheKey = new AuthorizationGrantCacheKey(oAuth2AccessTokenReqDTO.getAuthorizationCode());
            AuthorizationGrantCacheEntry authorizationGrantCacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByCode(cacheKey);
            if (authorizationGrantCacheEntry != null && StringUtils.isNotBlank((String)authorizationGrantCacheEntry.getTokenBindingValue())) {
                return Optional.of(authorizationGrantCacheEntry.getTokenBindingValue());
            }
        }
        return Optional.empty();
    }

    protected boolean isValidTokenBinding(Object request, String bindingReference, String cookieName) {
        if (request == null || StringUtils.isBlank((String)bindingReference) || StringUtils.isBlank((String)cookieName)) {
            return false;
        }
        if (request instanceof HttpServletRequest) {
            return this.isValidTokenBinding((HttpServletRequest)request, bindingReference);
        }
        if (request instanceof OAuth2AccessTokenReqDTO) {
            return this.isValidTokenBinding((OAuth2AccessTokenReqDTO)request, bindingReference, cookieName);
        }
        throw new RuntimeException("Unsupported request type: " + request.getClass().getName());
    }

    private boolean isValidTokenBinding(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, String bindingReference, String cookieName) {
        if ("refresh_token".equals(oAuth2AccessTokenReqDTO.getGrantType())) {
            Object[] httpRequestHeaders = oAuth2AccessTokenReqDTO.getHttpRequestHeaders();
            if (ArrayUtils.isEmpty((Object[])httpRequestHeaders)) {
                return false;
            }
            for (Object httpRequestHeader : httpRequestHeaders) {
                if (!"Cookie".equalsIgnoreCase(((HttpRequestHeader)httpRequestHeader).getName())) continue;
                if (ArrayUtils.isEmpty((Object[])((HttpRequestHeader)httpRequestHeader).getValue())) {
                    return false;
                }
                String[] cookies = ((HttpRequestHeader)httpRequestHeader).getValue()[0].split(";");
                String cookiePrefix = cookieName + "=";
                for (String cookie : cookies) {
                    if (!StringUtils.isNotBlank((String)cookie) || !cookie.trim().startsWith(cookiePrefix)) continue;
                    String receivedBindingReference = OAuth2Util.getTokenBindingReference(HttpCookie.parse(cookie).get(0).getValue());
                    return bindingReference.equals(receivedBindingReference);
                }
            }
            return false;
        }
        throw new RuntimeException("Unsupported grant type: " + oAuth2AccessTokenReqDTO.getGrantType());
    }

    private boolean isValidTokenBinding(HttpServletRequest request, String bindingReference) {
        String tokenBindingValue;
        try {
            tokenBindingValue = this.getTokenBindingValue(request);
        }
        catch (OAuthSystemException e) {
            return false;
        }
        return bindingReference.equals(OAuth2Util.getTokenBindingReference(tokenBindingValue));
    }
}

