/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token.bindings.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class TokenBindingExpiryEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(TokenBindingExpiryEventHandler.class);

    public void handleEvent(Event event) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(event.getEventName() + " event received to TokenBindingExpiryEventHandler."));
        }
        if (!IdentityEventConstants.EventName.SESSION_TERMINATE.name().equals(event.getEventName()) && !IdentityEventConstants.EventName.SESSION_EXPIRE.name().equals(event.getEventName())) {
            return;
        }
        HttpServletRequest request = this.getHttpRequestFromEvent(event);
        Map eventProperties = event.getEventProperties();
        AuthenticationContext context = (AuthenticationContext)eventProperties.get("context");
        try {
            if (request == null) {
                return;
            }
            if ("oidc".equals(request.getParameter("type"))) {
                String consumerKey = context.getRelyingParty();
                String bindingType = OAuth2Util.getAppInformationByClientId(consumerKey).getTokenBindingType();
                if (bindingType != null) {
                    this.revokeTokensForBindingType(request, context.getLastAuthenticatedUser(), consumerKey, bindingType);
                }
                if (!"sso-session".equals(bindingType)) {
                    this.revokeTokensForCommonAuthCookie(request, context.getLastAuthenticatedUser());
                }
            } else {
                this.revokeTokensForCommonAuthCookie(request, context.getLastAuthenticatedUser());
            }
        }
        catch (OAuthSystemException | InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)"Error while revoking the tokens on session termination.", (Throwable)e);
        }
    }

    public String getName() {
        return "TokenBindingExpiryEventHandler";
    }

    private HttpServletRequest getHttpRequestFromEvent(Event event) {
        return (HttpServletRequest)event.getEventProperties().get("request");
    }

    private void revokeTokensForBindingType(HttpServletRequest request, AuthenticatedUser user, String consumerKey, String bindingType) throws IdentityOAuth2Exception, InvalidOAuthClientException, OAuthSystemException {
        this.revokeTokensOfBindingRef(user, this.getBindingRefFromType(request, consumerKey, bindingType));
    }

    private void revokeTokensForCommonAuthCookie(HttpServletRequest request, AuthenticatedUser user) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        this.revokeTokensOfBindingRef(user, this.getBindingRefFromCommonAuthCookie(request));
    }

    private String getBindingRefFromType(HttpServletRequest request, String consumerKey, String bindingType) throws IdentityOAuth2Exception, OAuthSystemException {
        if (StringUtils.isBlank((String)bindingType)) {
            return null;
        }
        Optional<TokenBinder> tokenBinderOptional = OAuth2ServiceComponentHolder.getInstance().getTokenBinder(bindingType);
        if (!tokenBinderOptional.isPresent()) {
            throw new IdentityOAuth2Exception("Token binder for the binding type: " + bindingType + " is not registered.");
        }
        TokenBinder tokenBinder = tokenBinderOptional.get();
        String tokenBindingRef = OAuth2Util.getTokenBindingReference(tokenBinder.getTokenBindingValue(request));
        if (StringUtils.isBlank((String)tokenBindingRef)) {
            throw new IdentityOAuth2Exception("Token binding reference is null for the application " + consumerKey + " with binding type " + bindingType + ".");
        }
        return tokenBindingRef;
    }

    private String getBindingRefFromCommonAuthCookie(HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            return null;
        }
        Optional<Cookie> commonAuthCookieOptional = Arrays.stream(cookies).filter(t -> "commonAuthId".equals(t.getName())).findAny();
        if (!commonAuthCookieOptional.isPresent() || StringUtils.isBlank((String)commonAuthCookieOptional.get().getValue())) {
            return null;
        }
        return OAuth2Util.getTokenBindingReference(DigestUtils.sha256Hex((String)commonAuthCookieOptional.get().getValue()));
    }

    private void revokeTokensOfBindingRef(AuthenticatedUser user, String tokenBindingReference) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        if (StringUtils.isBlank((String)tokenBindingReference) || user == null) {
            return;
        }
        Set<AccessTokenDO> boundTokens = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensByBindingRef(user, tokenBindingReference);
        for (AccessTokenDO accessTokenDO : boundTokens) {
            String consumerKey = accessTokenDO.getConsumerKey();
            if (!OAuth2Util.getAppInformationByClientId(consumerKey).isTokenRevocationWithIDPSessionTerminationEnabled()) continue;
            OAuthUtil.clearOAuthCache(consumerKey, (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()), tokenBindingReference);
            OAuthUtil.clearOAuthCache(consumerKey, (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
            OAuthUtil.clearOAuthCache(consumerKey, (User)accessTokenDO.getAuthzUser());
            OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
            OAuthUtil.invokePreRevocationBySystemListeners(accessTokenDO, Collections.emptyMap());
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{accessTokenDO.getAccessToken()}, OAuth2Util.isHashEnabled());
            OAuthUtil.invokePostRevocationBySystemListeners(accessTokenDO, Collections.emptyMap());
        }
    }
}

