/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuerImpl;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.CustomClaimsCallbackHandler;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JWTTokenIssuer
extends OauthTokenIssuerImpl {
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String SHA384_WITH_RSA = "SHA384withRSA";
    private static final String SHA512_WITH_RSA = "SHA512withRSA";
    private static final String SHA256_WITH_HMAC = "SHA256withHMAC";
    private static final String SHA384_WITH_HMAC = "SHA384withHMAC";
    private static final String SHA512_WITH_HMAC = "SHA512withHMAC";
    private static final String SHA256_WITH_EC = "SHA256withEC";
    private static final String SHA384_WITH_EC = "SHA384withEC";
    private static final String SHA512_WITH_EC = "SHA512withEC";
    private static final String KEY_STORE_EXTENSION = ".jks";
    private static final String AUTHORIZATION_PARTY = "azp";
    private static final String AUDIENCE = "aud";
    private static final String SCOPE = "scope";
    private static final String TOKEN_BINDING_REF = "binding_ref";
    private static final String TOKEN_BINDING_TYPE = "binding_type";
    private static final String EXPIRY_TIME_JWT = "EXPIRY_TIME_JWT";
    private static final Log log = LogFactory.getLog(JWTTokenIssuer.class);
    private static final String INBOUND_AUTH2_TYPE = "oauth2";
    private static Map<Integer, Key> privateKeys = new ConcurrentHashMap<Integer, Key>();
    private Algorithm signatureAlgorithm = null;

    public JWTTokenIssuer() throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"JWT Access token builder is initiated");
        }
        OAuthServerConfiguration config = OAuthServerConfiguration.getInstance();
        this.signatureAlgorithm = this.mapSignatureAlgorithm(config.getSignatureAlgorithm());
    }

    @Override
    public String accessToken(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token request with token request message context. Authorized user " + oAuthTokenReqMessageContext.getAuthorizedUser().toString()));
        }
        try {
            return this.buildJWTToken(oAuthTokenReqMessageContext);
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException((Throwable)((Object)e));
        }
    }

    @Override
    public String accessToken(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token request with authorization request message context message context. Authorized user " + oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getUser().toString()));
        }
        try {
            return this.buildJWTToken(oAuthAuthzReqMessageContext);
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException((Throwable)((Object)e));
        }
    }

    @Override
    public String getAccessTokenHash(String accessToken) throws OAuthSystemException {
        try {
            JWT parsedJwtToken = JWTParser.parse((String)accessToken);
            String jwtId = parsedJwtToken.getJWTClaimsSet().getJWTID();
            if (jwtId == null) {
                throw new OAuthSystemException("JTI could not be retrieved from the JWT token.");
            }
            return jwtId;
        }
        catch (ParseException e) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Error while getting JWTID from token: " + accessToken));
            }
            throw new OAuthSystemException("Error while getting access token hash", (Throwable)e);
        }
    }

    @Override
    public boolean renewAccessTokenPerRequest() {
        return true;
    }

    protected String buildJWTToken(OAuthTokenReqMessageContext request) throws IdentityOAuth2Exception {
        JWTClaimsSet jwtClaimsSet = this.createJWTClaimSet(null, request, request.getOauth2AccessTokenReqDTO().getClientId());
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder(jwtClaimsSet);
        if (request.getScope() != null && Arrays.asList(request.getScope()).contains(AUDIENCE)) {
            jwtClaimsSetBuilder.audience(Arrays.asList(request.getScope()));
        }
        jwtClaimsSet = jwtClaimsSetBuilder.build();
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, request, null);
    }

    protected String buildJWTToken(OAuthAuthzReqMessageContext request) throws IdentityOAuth2Exception {
        JWTClaimsSet jwtClaimsSet = this.createJWTClaimSet(request, null, request.getAuthorizationReqDTO().getConsumerKey());
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder(jwtClaimsSet);
        if (request.getApprovedScope() != null && Arrays.asList(request.getApprovedScope()).contains(AUDIENCE)) {
            jwtClaimsSetBuilder.audience(Arrays.asList(request.getApprovedScope()));
        }
        jwtClaimsSet = jwtClaimsSetBuilder.build();
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, null, request);
    }

    protected String signJWT(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenContext, OAuthAuthzReqMessageContext authorizationContext) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithRSA(jwtClaimsSet, tokenContext, authorizationContext);
        }
        if (JWSAlgorithm.HS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithHMAC(jwtClaimsSet, tokenContext, authorizationContext);
        }
        if (JWSAlgorithm.ES256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.ES384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.ES512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithECDSA(jwtClaimsSet, tokenContext, authorizationContext);
        }
        throw new IdentityOAuth2Exception("Invalid signature algorithm provided. " + this.signatureAlgorithm);
    }

    private String resolveSigningTenantDomain(OAuthTokenReqMessageContext tokenContext, OAuthAuthzReqMessageContext authorizationContext) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser;
        String clientID;
        if (authorizationContext != null) {
            clientID = authorizationContext.getAuthorizationReqDTO().getConsumerKey();
            authenticatedUser = authorizationContext.getAuthorizationReqDTO().getUser();
        } else if (tokenContext != null) {
            clientID = tokenContext.getOauth2AccessTokenReqDTO().getClientId();
            authenticatedUser = tokenContext.getAuthorizedUser();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Empty OAuthTokenReqMessageContext and OAuthAuthzReqMessageContext. Therefore, could not determine the tenant domain to sign the request.");
            }
            throw new IdentityOAuth2Exception("Could not determine the authenticated user and the service provider");
        }
        return this.getSigningTenantDomain(clientID, authenticatedUser);
    }

    private String getSigningTenantDomain(String clientID, AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        String tenantDomain;
        if (OAuthServerConfiguration.getInstance().getUseSPTenantDomainValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using the tenant domain of the SP to sign the token");
            }
            if (StringUtils.isBlank((String)clientID)) {
                throw new IdentityOAuth2Exception("Empty ClientId. Cannot resolve the tenant domain to sign the token");
            }
            try {
                tenantDomain = OAuth2Util.getAppInformationByClientId(clientID).getAppOwner().getTenantDomain();
            }
            catch (InvalidOAuthClientException e) {
                throw new IdentityOAuth2Exception("Error occurred while getting the application information by client id: " + clientID, e);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using the tenant domain of the user to sign the token");
            }
            if (authenticatedUser == null) {
                throw new IdentityOAuth2Exception("Authenticated user is not set. Cannot resolve the tenant domain to sign the token");
            }
            tenantDomain = authenticatedUser.getTenantDomain();
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            throw new IdentityOAuth2Exception("Cannot resolve the tenant domain to sign the token");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Tenant domain: %s will be used to sign the token for the authenticated user: %s", tenantDomain, authenticatedUser.toFullQualifiedUsername()));
        }
        return tenantDomain;
    }

    protected String signJWTWithRSA(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenContext, OAuthAuthzReqMessageContext authorizationContext) throws IdentityOAuth2Exception {
        try {
            Key privateKey;
            String tenantDomain = this.resolveSigningTenantDomain(tokenContext, authorizationContext);
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            if (privateKeys.containsKey(tenantId)) {
                privateKey = privateKeys.get(tenantId);
            } else {
                KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
                if ("carbon.super".equals(tenantDomain)) {
                    try {
                        privateKey = tenantKSM.getDefaultPrivateKey();
                    }
                    catch (Exception e) {
                        throw new IdentityOAuth2Exception("Error while obtaining private key for super tenant", e);
                    }
                } else {
                    String ksName = tenantDomain.trim().replace(".", "-");
                    String jksName = ksName + KEY_STORE_EXTENSION;
                    privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
                }
                privateKeys.put(tenantId, privateKey);
            }
            JWSSigner signer = OAuth2Util.createJWSSigner((RSAPrivateKey)privateKey);
            JWSHeader.Builder headerBuilder = new JWSHeader.Builder((JWSAlgorithm)this.signatureAlgorithm);
            String certThumbPrint = OAuth2Util.getThumbPrint(tenantDomain, tenantId);
            headerBuilder.keyID(OAuth2Util.getKID(OAuth2Util.getCertificate(tenantDomain, tenantId), (JWSAlgorithm)this.signatureAlgorithm, tenantDomain));
            headerBuilder.x509CertThumbprint(new Base64URL(certThumbPrint));
            SignedJWT signedJWT = new SignedJWT(headerBuilder.build(), jwtClaimsSet);
            signedJWT.sign(signer);
            return signedJWT.serialize();
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Error occurred while signing JWT", e);
        }
    }

    protected String signJWTWithHMAC(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenContext, OAuthAuthzReqMessageContext authorizationContext) throws IdentityOAuth2Exception {
        throw new IdentityOAuth2Exception("Given signature algorithm " + this.signatureAlgorithm + " is not supported by the current implementation.");
    }

    protected String signJWTWithECDSA(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext tokenContext, OAuthAuthzReqMessageContext authorizationContext) throws IdentityOAuth2Exception {
        throw new IdentityOAuth2Exception("Given signature algorithm " + this.signatureAlgorithm + " is not supported by the current implementation.");
    }

    protected JWSAlgorithm mapSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        if (StringUtils.isNotBlank((String)signatureAlgorithm)) {
            switch (signatureAlgorithm) {
                case "NONE": {
                    return new JWSAlgorithm(JWSAlgorithm.NONE.getName());
                }
                case "SHA256withRSA": {
                    return JWSAlgorithm.RS256;
                }
                case "SHA384withRSA": {
                    return JWSAlgorithm.RS384;
                }
                case "SHA512withRSA": {
                    return JWSAlgorithm.RS512;
                }
                case "SHA256withHMAC": {
                    return JWSAlgorithm.HS256;
                }
                case "SHA384withHMAC": {
                    return JWSAlgorithm.HS384;
                }
                case "SHA512withHMAC": {
                    return JWSAlgorithm.HS512;
                }
                case "SHA256withEC": {
                    return JWSAlgorithm.ES256;
                }
                case "SHA384withEC": {
                    return JWSAlgorithm.ES384;
                }
                case "SHA512withEC": {
                    return JWSAlgorithm.ES512;
                }
            }
        }
        throw new IdentityOAuth2Exception("Unsupported Signature Algorithm in identity.xml");
    }

    protected JWTClaimsSet createJWTClaimSet(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext, String consumerKey) throws IdentityOAuth2Exception {
        String spTenantDomain;
        long accessTokenLifeTimeInMillis;
        OAuthAppDO oAuthAppDO;
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId(consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + consumerKey, e);
        }
        if (authAuthzReqMessageContext != null) {
            accessTokenLifeTimeInMillis = this.getAccessTokenLifeTimeInMillis(authAuthzReqMessageContext, oAuthAppDO, consumerKey);
            spTenantDomain = authAuthzReqMessageContext.getAuthorizationReqDTO().getTenantDomain();
        } else {
            accessTokenLifeTimeInMillis = this.getAccessTokenLifeTimeInMillis(tokenReqMessageContext, oAuthAppDO, consumerKey);
            spTenantDomain = tokenReqMessageContext.getOauth2AccessTokenReqDTO().getTenantDomain();
        }
        String issuer = OAuth2Util.getIdTokenIssuer(spTenantDomain);
        long curTimeInMillis = Calendar.getInstance().getTimeInMillis();
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(authAuthzReqMessageContext, tokenReqMessageContext);
        String sub = this.getSubjectClaim(consumerKey, spTenantDomain, authenticatedUser);
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.issuer(issuer);
        jwtClaimsSetBuilder.subject(sub);
        jwtClaimsSetBuilder.claim(AUTHORIZATION_PARTY, (Object)consumerKey);
        jwtClaimsSetBuilder.issueTime(new Date(curTimeInMillis));
        jwtClaimsSetBuilder.jwtID(UUID.randomUUID().toString());
        jwtClaimsSetBuilder.notBeforeTime(new Date(curTimeInMillis));
        String scope = this.getScope(authAuthzReqMessageContext, tokenReqMessageContext);
        if (StringUtils.isNotEmpty((String)scope)) {
            jwtClaimsSetBuilder.claim(SCOPE, (Object)scope);
        }
        jwtClaimsSetBuilder.claim("aut", (Object)this.getAuthorizedUserType(authAuthzReqMessageContext, tokenReqMessageContext));
        jwtClaimsSetBuilder.expirationTime(new Date(curTimeInMillis + accessTokenLifeTimeInMillis));
        List<String> audience = OAuth2Util.getOIDCAudience(consumerKey, oAuthAppDO);
        jwtClaimsSetBuilder.audience(audience);
        JWTClaimsSet jwtClaimsSet = authAuthzReqMessageContext != null ? this.handleCustomClaims(jwtClaimsSetBuilder, authAuthzReqMessageContext) : this.handleCustomClaims(jwtClaimsSetBuilder, tokenReqMessageContext);
        jwtClaimsSet = this.handleTokenBinding(jwtClaimsSetBuilder, tokenReqMessageContext);
        return jwtClaimsSet;
    }

    private String getAuthorizedUserType(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext) {
        if (tokenReqMessageContext != null) {
            return (String)tokenReqMessageContext.getProperty("USER_TYPE");
        }
        return (String)authAuthzReqMessageContext.getProperty("USER_TYPE");
    }

    private String getAuthenticatedSubjectIdentifier(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(authAuthzReqMessageContext, tokenReqMessageContext);
        return authenticatedUser.getAuthenticatedSubjectIdentifier();
    }

    private String getSubjectClaim(String clientId, String spTenantDomain, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String subjectClaim;
        if (this.isLocalUser(authorizedUser)) {
            ServiceProvider serviceProvider = this.getServiceProvider(spTenantDomain, clientId);
            if (serviceProvider == null) {
                throw new IdentityOAuth2Exception("Cannot find an service provider for client_id: " + clientId + " in tenantDomain: " + spTenantDomain);
            }
            subjectClaim = this.getSubjectClaimForLocalUser(serviceProvider, authorizedUser);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subject claim: " + subjectClaim + " set for local user: " + authorizedUser + " for application: " + clientId + " of tenantDomain: " + spTenantDomain));
            }
        } else {
            subjectClaim = authorizedUser.getAuthenticatedSubjectIdentifier();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subject claim: " + subjectClaim + " set for federated user: " + authorizedUser + " for application: " + clientId + " of tenantDomain: " + spTenantDomain));
            }
        }
        return subjectClaim;
    }

    private ServiceProvider getServiceProvider(String spTenantDomain, String clientId) throws IdentityOAuth2Exception {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        try {
            String spName = applicationMgtService.getServiceProviderNameByClientId(clientId, INBOUND_AUTH2_TYPE, spTenantDomain);
            return applicationMgtService.getApplicationExcludingFileBasedSPs(spName, spTenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityOAuth2Exception("Error while getting service provider information for client_id: " + clientId + " tenantDomain: " + spTenantDomain, e);
        }
    }

    private boolean isLocalUser(AuthenticatedUser authorizedUser) {
        return !authorizedUser.isFederatedUser();
    }

    private String getSubjectClaimForLocalUser(ServiceProvider serviceProvider, AuthenticatedUser authorizedUser) throws IdentityOAuth2Exception {
        String subject;
        String username = authorizedUser.getUserName();
        String userStoreDomain = authorizedUser.getUserStoreDomain();
        String userTenantDomain = authorizedUser.getTenantDomain();
        String subjectClaimUri = this.getSubjectClaimUriInLocalDialect(serviceProvider);
        if (StringUtils.isNotBlank((String)subjectClaimUri)) {
            String fullQualifiedUsername = authorizedUser.toFullQualifiedUsername();
            try {
                subject = this.getSubjectClaimFromUserStore(subjectClaimUri, authorizedUser);
                if (StringUtils.isBlank((String)subject)) {
                    subject = username;
                    log.warn((Object)("Cannot find subject claim: " + subjectClaimUri + " for user:" + fullQualifiedUsername + ". Defaulting to username: " + subject + " as the subject identifier."));
                }
                subject = this.getFormattedSubjectClaim(serviceProvider, subject, userStoreDomain, userTenantDomain);
            }
            catch (IdentityException e) {
                String error = "Error occurred while getting user claim for user: " + authorizedUser + ", claim: " + subjectClaimUri;
                throw new IdentityOAuth2Exception(error, e);
            }
            catch (UserStoreException e) {
                String error = "Error occurred while getting subject claim: " + subjectClaimUri + " for user: " + fullQualifiedUsername;
                throw new IdentityOAuth2Exception(error, e);
            }
        } else {
            subject = this.getFormattedSubjectClaim(serviceProvider, username, userStoreDomain, userTenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No subject claim defined for service provider: " + serviceProvider.getApplicationName() + ". Using username as the subject claim."));
            }
        }
        return subject;
    }

    private String getFormattedSubjectClaim(ServiceProvider serviceProvider, String subjectClaimValue, String userStoreDomain, String tenantDomain) {
        boolean appendUserStoreDomainToSubjectClaim = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
        boolean appendTenantDomainToSubjectClaim = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseTenantDomainInLocalSubjectIdentifier();
        if (appendTenantDomainToSubjectClaim) {
            subjectClaimValue = UserCoreUtil.addTenantDomainToEntry((String)subjectClaimValue, (String)tenantDomain);
        }
        if (appendUserStoreDomainToSubjectClaim) {
            subjectClaimValue = IdentityUtil.addDomainToName((String)subjectClaimValue, (String)userStoreDomain);
        }
        return subjectClaimValue;
    }

    private String getSubjectClaimUriInLocalDialect(ServiceProvider serviceProvider) {
        String subjectClaimUri = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSubjectClaimUri();
        if (log.isDebugEnabled()) {
            if (StringUtils.isNotBlank((String)subjectClaimUri)) {
                log.debug((Object)(subjectClaimUri + " is defined as subject claim for service provider: " + serviceProvider.getApplicationName()));
            } else {
                log.debug((Object)("No subject claim defined for service provider: " + serviceProvider.getApplicationName()));
            }
        }
        return this.getSubjectClaimUriInLocalDialect(serviceProvider, subjectClaimUri);
    }

    private String getSubjectClaimUriInLocalDialect(ServiceProvider serviceProvider, String subjectClaimUri) {
        ClaimConfig claimConfig;
        if (StringUtils.isNotBlank((String)subjectClaimUri) && (claimConfig = serviceProvider.getClaimConfig()) != null) {
            boolean isLocalClaimDialect = claimConfig.isLocalClaimDialect();
            Object[] claimMappings = claimConfig.getClaimMappings();
            if (!isLocalClaimDialect && ArrayUtils.isNotEmpty((Object[])claimMappings)) {
                for (Object claimMapping : claimMappings) {
                    if (!StringUtils.equals((String)claimMapping.getRemoteClaim().getClaimUri(), (String)subjectClaimUri)) continue;
                    return claimMapping.getLocalClaim().getClaimUri();
                }
            }
        }
        return subjectClaimUri;
    }

    private String getSubjectClaimFromUserStore(String subjectClaimUri, AuthenticatedUser authenticatedUser) throws UserStoreException, IdentityException {
        UserStoreManager userStoreManager = IdentityTenantUtil.getRealm((String)authenticatedUser.getTenantDomain(), (String)authenticatedUser.toFullQualifiedUsername()).getUserStoreManager();
        return userStoreManager.getSecondaryUserStoreManager(authenticatedUser.getUserStoreDomain()).getUserClaimValue(authenticatedUser.getUserName(), subjectClaimUri, null);
    }

    private AuthenticatedUser getAuthenticatedUser(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser = authAuthzReqMessageContext != null ? authAuthzReqMessageContext.getAuthorizationReqDTO().getUser() : tokenReqMessageContext.getAuthorizedUser();
        if (authenticatedUser == null) {
            throw new IdentityOAuth2Exception("Authenticated user is null for the request.");
        }
        return authenticatedUser;
    }

    private String getScope(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        String scopeString = null;
        Object[] scope = tokenReqMessageContext != null ? tokenReqMessageContext.getScope() : authAuthzReqMessageContext.getApprovedScope();
        if (ArrayUtils.isNotEmpty((Object[])scope)) {
            scopeString = OAuth2Util.buildScopeString((String[])scope);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope exist for the jwt access token with subject " + this.getAuthenticatedSubjectIdentifier(authAuthzReqMessageContext, tokenReqMessageContext) + " and the scope is " + scopeString));
            }
        }
        return scopeString;
    }

    protected long getAccessTokenLifeTimeInMillis(OAuthAuthzReqMessageContext authzReqMessageContext, OAuthAppDO oAuthAppDO, String consumerKey) throws IdentityOAuth2Exception {
        long lifetimeInMillis = oAuthAppDO.getUserAccessTokenExpiryTime() * 1000L;
        if (lifetimeInMillis == 0L) {
            lifetimeInMillis = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("User access token time was 0ms. Setting default user access token lifetime : " + lifetimeInMillis + "ms."));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Self Signed Access Token Life time set to : " + lifetimeInMillis + "ms."));
        }
        return lifetimeInMillis;
    }

    protected long getAccessTokenLifeTimeInMillis(OAuthTokenReqMessageContext tokenReqMessageContext, OAuthAppDO oAuthAppDO, String consumerKey) throws IdentityOAuth2Exception {
        long lifetimeInMillis;
        boolean isUserAccessTokenType = this.isUserAccessTokenType(tokenReqMessageContext.getOauth2AccessTokenReqDTO().getGrantType());
        if (isUserAccessTokenType) {
            lifetimeInMillis = oAuthAppDO.getUserAccessTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Access Token Life time set to : " + lifetimeInMillis + "ms."));
            }
        } else {
            lifetimeInMillis = oAuthAppDO.getApplicationAccessTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Application Access Token Life time set to : " + lifetimeInMillis + "ms."));
            }
        }
        if (lifetimeInMillis == 0L) {
            if (isUserAccessTokenType) {
                lifetimeInMillis = OAuthServerConfiguration.getInstance().getUserAccessTokenValidityPeriodInSeconds() * 1000L;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User access token time was 0ms. Setting default user access token lifetime : " + lifetimeInMillis + "ms."));
                }
            } else {
                lifetimeInMillis = OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() * 1000L;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Application access token time was 0ms. Setting default Application access token lifetime : " + lifetimeInMillis + "ms."));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Self Signed Access Token Life time set to : " + lifetimeInMillis + "ms."));
        }
        return lifetimeInMillis;
    }

    protected JWTClaimsSet handleCustomClaims(JWTClaimsSet.Builder jwtClaimsSetBuilder, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        CustomClaimsCallbackHandler claimsCallBackHandler = OAuthServerConfiguration.getInstance().getOpenIDConnectCustomClaimsCallbackHandler();
        return claimsCallBackHandler.handleCustomClaims(jwtClaimsSetBuilder, tokenReqMessageContext);
    }

    protected JWTClaimsSet handleCustomClaims(JWTClaimsSet.Builder jwtClaimsSetBuilder, OAuthAuthzReqMessageContext authzReqMessageContext) throws IdentityOAuth2Exception {
        CustomClaimsCallbackHandler claimsCallBackHandler = OAuthServerConfiguration.getInstance().getOpenIDConnectCustomClaimsCallbackHandler();
        return claimsCallBackHandler.handleCustomClaims(jwtClaimsSetBuilder, authzReqMessageContext);
    }

    private boolean isUserAccessTokenType(String grantType) throws IdentityOAuth2Exception {
        AuthorizationGrantHandler grantHandler = OAuthServerConfiguration.getInstance().getSupportedGrantTypes().get(grantType);
        return grantHandler.isOfTypeApplicationUser();
    }

    private JWTClaimsSet handleTokenBinding(JWTClaimsSet.Builder jwtClaimsSetBuilder, OAuthTokenReqMessageContext tokReqMsgCtx) {
        if (tokReqMsgCtx != null && tokReqMsgCtx.getTokenBinding() != null) {
            jwtClaimsSetBuilder.claim(TOKEN_BINDING_REF, (Object)tokReqMsgCtx.getTokenBinding().getBindingReference());
            jwtClaimsSetBuilder.claim(TOKEN_BINDING_TYPE, (Object)tokReqMsgCtx.getTokenBinding().getBindingType());
        }
        return jwtClaimsSetBuilder.build();
    }
}

