/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AppInfoCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IDTokenValidationFailureException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.JDBCPermissionBasedInternalScopeValidator;
import org.wso2.carbon.identity.openidconnect.IDTokenBuilder;
import org.wso2.carbon.utils.CarbonUtils;

public class AccessTokenIssuer {
    private static AccessTokenIssuer instance;
    private static final Log log;
    private Map<String, AuthorizationGrantHandler> authzGrantHandlers = OAuthServerConfiguration.getInstance().getSupportedGrantTypes();
    public static final String OAUTH_APP_DO = "OAuthAppDO";

    private AccessTokenIssuer() throws IdentityOAuth2Exception {
        AppInfoCache appInfoCache = AppInfoCache.getInstance();
        if (appInfoCache != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully created AppInfoCache under OAuthCacheManager");
            }
        } else {
            log.error((Object)"Error while creating AppInfoCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessTokenIssuer getInstance() throws IdentityOAuth2Exception {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<AccessTokenIssuer> clazz = AccessTokenIssuer.class;
        synchronized (AccessTokenIssuer.class) {
            if (instance != null) return instance;
            instance = new AccessTokenIssuer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessTokenRespDTO issue(OAuth2AccessTokenReqDTO tokenReqDTO) throws IdentityException {
        String grantType = tokenReqDTO.getGrantType();
        OAuth2AccessTokenRespDTO tokenRespDTO = null;
        AuthorizationGrantHandler authzGrantHandler = this.authzGrantHandlers.get(grantType);
        OAuthTokenReqMessageContext tokReqMsgCtx = new OAuthTokenReqMessageContext(tokenReqDTO);
        boolean isRefreshRequest = GrantType.REFRESH_TOKEN.toString().equals(grantType);
        this.triggerPreListeners(tokenReqDTO, tokReqMsgCtx, isRefreshRequest);
        OAuthClientAuthnContext oAuthClientAuthnContext = tokenReqDTO.getoAuthClientAuthnContext();
        if (oAuthClientAuthnContext == null) {
            oAuthClientAuthnContext = new OAuthClientAuthnContext();
            oAuthClientAuthnContext.setAuthenticated(false);
            oAuthClientAuthnContext.setErrorMessage("Client Authentication Failed");
            oAuthClientAuthnContext.setErrorCode("invalid_request");
        }
        if (oAuthClientAuthnContext.isMultipleAuthenticatorsEngaged()) {
            tokenRespDTO = this.handleError("invalid_request", "The client MUST NOT use more than one authentication method in each", tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        boolean isAuthenticated = oAuthClientAuthnContext.isAuthenticated();
        if (authzGrantHandler == null) {
            String errorMsg = "Unsupported grant type : " + grantType + ", is used.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMsg);
            }
            tokenRespDTO = this.handleError("unsupported_grant_type", errorMsg, tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        if (!authzGrantHandler.isConfidentialClient() && StringUtils.isNotEmpty((String)oAuthClientAuthnContext.getClientId())) {
            isAuthenticated = true;
        }
        if (!isAuthenticated && !oAuthClientAuthnContext.isPreviousAuthenticatorEngaged() && authzGrantHandler.isConfidentialClient()) {
            tokenRespDTO = this.handleError("invalid_client", "Unsupported Client Authentication Method!", tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        if (!isAuthenticated) {
            tokenRespDTO = this.handleError(oAuthClientAuthnContext.getErrorCode(), oAuthClientAuthnContext.getErrorMessage(), tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        OAuthAppDO oAuthAppDO = this.getOAuthApplication(tokenReqDTO.getClientId());
        String tenantDomainOfApp = OAuth2Util.getTenantDomainOfOauthApp(oAuthAppDO);
        OAuth2Util.validateRequestTenantDomain(tenantDomainOfApp);
        tokenReqDTO.setTenantDomain(tenantDomainOfApp);
        tokReqMsgCtx.addProperty(OAUTH_APP_DO, oAuthAppDO);
        boolean isOfTypeApplicationUser = authzGrantHandler.isOfTypeApplicationUser();
        if (!isOfTypeApplicationUser) {
            tokReqMsgCtx.setAuthorizedUser(oAuthAppDO.getAppOwner());
            tokReqMsgCtx.addProperty("USER_TYPE", "APPLICATION");
        } else {
            tokReqMsgCtx.addProperty("USER_TYPE", "APPLICATION_USER");
        }
        boolean isAuthorizedClient = false;
        String error = "The authenticated client is not authorized to use this authorization grant type";
        try {
            isAuthorizedClient = authzGrantHandler.isAuthorizedClient(tokReqMsgCtx);
        }
        catch (IdentityOAuth2Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while validating client for authorization", (Throwable)((Object)e));
            }
            error = e.getMessage();
        }
        if (!isAuthorizedClient) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Client Id: " + tokenReqDTO.getClientId() + " is not authorized to use grant type: " + grantType));
            }
            tokenRespDTO = this.handleError("unauthorized_client", error, tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        boolean isValidGrant = false;
        error = "Provided Authorization Grant is invalid";
        try {
            isValidGrant = authzGrantHandler.validateGrant(tokReqMsgCtx);
        }
        catch (IdentityOAuth2Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while validating grant", (Throwable)((Object)e));
            }
            error = e.getMessage();
        }
        if (tokReqMsgCtx.getAuthorizedUser() != null && tokReqMsgCtx.getAuthorizedUser().isFederatedUser()) {
            tokReqMsgCtx.getAuthorizedUser().setTenantDomain(tenantDomainOfApp);
        }
        if (!isValidGrant) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid Grant provided by the client Id: " + tokenReqDTO.getClientId()));
            }
            tokenRespDTO = this.handleError("invalid_grant", error, tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        boolean isAuthorized = authzGrantHandler.authorizeAccessDelegation(tokReqMsgCtx);
        if (!isAuthorized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid authorization for client Id = " + tokenReqDTO.getClientId()));
            }
            tokenRespDTO = this.handleError("unauthorized_client", "Unauthorized Client!", tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        List<String> allowedScopes = OAuthServerConfiguration.getInstance().getAllowedScopes();
        ArrayList<String> requestedAllowedScopes = new ArrayList<String>();
        String[] requestedScopes = tokReqMsgCtx.getScope();
        ArrayList<String> scopesToBeValidated = new ArrayList<String>();
        if (requestedScopes != null) {
            for (String string : requestedScopes) {
                if (OAuth2Util.isAllowedScope(allowedScopes, string)) {
                    requestedAllowedScopes.add(string);
                    continue;
                }
                scopesToBeValidated.add(string);
            }
            tokReqMsgCtx.setScope(scopesToBeValidated.toArray(new String[0]));
        }
        JDBCPermissionBasedInternalScopeValidator scopeValidator = new JDBCPermissionBasedInternalScopeValidator();
        String[] authorizedInternalScopes = scopeValidator.validateScope(tokReqMsgCtx);
        this.removeInternalScopes(tokReqMsgCtx);
        boolean isValidScope = authzGrantHandler.validateScope(tokReqMsgCtx);
        if (!isValidScope) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid scope provided by client Id: " + tokenReqDTO.getClientId()));
            }
            tokenRespDTO = this.handleError("invalid_scope", "Invalid Scope!", tokenReqDTO);
            this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            return tokenRespDTO;
        }
        this.addAuthorizedInternalScopes(tokReqMsgCtx, authorizedInternalScopes);
        this.addAllowedScopes(tokReqMsgCtx, requestedAllowedScopes.toArray(new String[0]));
        this.handleTokenBinding(tokenReqDTO, grantType, tokReqMsgCtx, oAuthAppDO);
        try {
            OAuth2Util.setTokenRequestContext(tokReqMsgCtx);
            tokenRespDTO = authzGrantHandler.issue(tokReqMsgCtx);
            if (tokenRespDTO.isError()) {
                this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
                OAuth2AccessTokenRespDTO oAuth2AccessTokenRespDTO = tokenRespDTO;
                return oAuth2AccessTokenRespDTO;
            }
        }
        finally {
            this.triggerPostListeners(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, isRefreshRequest);
            OAuth2Util.clearTokenRequestContext();
        }
        tokenRespDTO.setCallbackURI(oAuthAppDO.getCallbackUrl());
        String[] stringArray = tokReqMsgCtx.getScope();
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder scopeString = new StringBuilder("");
            for (String scope : stringArray) {
                scopeString.append(scope);
                scopeString.append(" ");
            }
            tokenRespDTO.setAuthorizedScopes(scopeString.toString().trim());
        }
        this.setResponseHeaders(tokReqMsgCtx, tokenRespDTO);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token issued to client Id: " + tokenReqDTO.getClientId() + " username: " + tokReqMsgCtx.getAuthorizedUser() + " and scopes: " + tokenRespDTO.getAuthorizedScopes()));
        }
        if (tokReqMsgCtx.getScope() != null && OAuth2Util.isOIDCAuthzRequest(tokReqMsgCtx.getScope())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Issuing ID token for client: " + tokenReqDTO.getClientId()));
            }
            IDTokenBuilder builder = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenBuilder();
            try {
                String idToken = builder.buildIDToken(tokReqMsgCtx, tokenRespDTO);
                tokenRespDTO.setIDToken(idToken);
            }
            catch (IDTokenValidationFailureException e) {
                log.error((Object)e.getMessage());
                tokenRespDTO = this.handleError("server_error", "Server Error", tokenReqDTO);
                return tokenRespDTO;
            }
        }
        if (GrantType.AUTHORIZATION_CODE.toString().equals(grantType)) {
            this.addUserAttributesAgainstAccessToken(tokenReqDTO, tokenRespDTO);
            this.clearCacheEntryAgainstAuthorizationCode(this.getAuthorizationCode(tokenReqDTO));
        }
        return tokenRespDTO;
    }

    private void addAuthorizedInternalScopes(OAuthTokenReqMessageContext tokReqMsgCtx, String[] authorizedInternalScopes) {
        Object[] scopes = tokReqMsgCtx.getScope();
        String[] scopesToReturn = (String[])ArrayUtils.addAll((Object[])scopes, (Object[])authorizedInternalScopes);
        tokReqMsgCtx.setScope(scopesToReturn);
    }

    private void addAllowedScopes(OAuthTokenReqMessageContext tokReqMsgCtx, String[] allowedScopes) {
        Object[] scopes = tokReqMsgCtx.getScope();
        String[] scopesToReturn = (String[])ArrayUtils.addAll((Object[])scopes, (Object[])allowedScopes);
        tokReqMsgCtx.setScope(scopesToReturn);
    }

    private void removeInternalScopes(OAuthTokenReqMessageContext tokReqMsgCtx) {
        if (tokReqMsgCtx.getScope() == null) {
            return;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scope : tokReqMsgCtx.getScope()) {
            if (scope.startsWith("internal_") || scope.equalsIgnoreCase("SYSTEM")) continue;
            scopes.add(scope);
        }
        tokReqMsgCtx.setScope(scopes.toArray(new String[0]));
    }

    private void handleTokenBinding(OAuth2AccessTokenReqDTO tokenReqDTO, String grantType, OAuthTokenReqMessageContext tokReqMsgCtx, OAuthAppDO oAuthAppDO) throws IdentityOAuth2Exception {
        if (StringUtils.isBlank((String)oAuthAppDO.getTokenBindingType())) {
            tokReqMsgCtx.setTokenBinding(null);
            return;
        }
        Optional<TokenBinder> tokenBinderOptional = OAuth2ServiceComponentHolder.getInstance().getTokenBinder(oAuthAppDO.getTokenBindingType());
        if (!tokenBinderOptional.isPresent()) {
            throw new IdentityOAuth2Exception("Token binder for the binding type: " + oAuthAppDO.getTokenBindingType() + " is not registered.");
        }
        if ("refresh_token".equals(grantType)) {
            return;
        }
        tokReqMsgCtx.setTokenBinding(null);
        TokenBinder tokenBinder = tokenBinderOptional.get();
        if (!tokenBinder.getSupportedGrantTypes().contains(grantType)) {
            return;
        }
        Optional<String> tokenBindingValueOptional = tokenBinder.getTokenBindingValue(tokenReqDTO);
        if (!tokenBindingValueOptional.isPresent()) {
            throw new IdentityOAuth2Exception("Token binding reference cannot be retrieved form the token binder: " + tokenBinder.getBindingType());
        }
        String tokenBindingValue = tokenBindingValueOptional.get();
        tokReqMsgCtx.setTokenBinding(new TokenBinding(tokenBinder.getBindingType(), OAuth2Util.getTokenBindingReference(tokenBindingValue), tokenBindingValue));
    }

    private void triggerPreListeners(OAuth2AccessTokenReqDTO tokenReqDTO, OAuthTokenReqMessageContext tokReqMsgCtx, boolean isRefresh) throws IdentityOAuth2Exception {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (isRefresh) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Triggering refresh token pre renewal listeners for client: " + tokenReqDTO.getClientId()));
                }
                oAuthEventInterceptorProxy.onPreTokenRenewal(tokenReqDTO, tokReqMsgCtx, paramMap);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Triggering access token pre issuer listeners for client: " + tokenReqDTO.getClientId()));
                }
                oAuthEventInterceptorProxy.onPreTokenIssue(tokenReqDTO, tokReqMsgCtx, paramMap);
            }
        }
    }

    private void triggerPostListeners(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, boolean isRefresh) {
        OAuthEventInterceptor oAuthEventInterceptorProxy = OAuthComponentServiceHolder.getInstance().getOAuthEventInterceptorProxy();
        if (isRefresh) {
            if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Triggering refresh token post renewal listeners for client: " + tokenReqDTO.getClientId()));
                    }
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    oAuthEventInterceptorProxy.onPostTokenRenewal(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, paramMap);
                }
                catch (IdentityOAuth2Exception e) {
                    log.error((Object)"Oauth post renewal listener failed", (Throwable)((Object)e));
                }
            }
        } else if (oAuthEventInterceptorProxy != null && oAuthEventInterceptorProxy.isEnabled()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Triggering access token post issuer listeners for client: " + tokenReqDTO.getClientId()));
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                oAuthEventInterceptorProxy.onPostTokenIssue(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, paramMap);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Oauth post issuer listener failed.", (Throwable)((Object)e));
            }
        }
    }

    private void addUserAttributesAgainstAccessToken(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO) {
        AuthorizationGrantCacheKey oldCacheKey = new AuthorizationGrantCacheKey(this.getAuthorizationCode(tokenReqDTO));
        if (oldCacheKey.getUserAttributesId() != null) {
            AuthorizationGrantCacheEntry authorizationGrantCacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByCode(oldCacheKey);
            AuthorizationGrantCacheKey newCacheKey = new AuthorizationGrantCacheKey(tokenRespDTO.getAccessToken());
            if (authorizationGrantCacheEntry != null) {
                authorizationGrantCacheEntry.setTokenId(tokenRespDTO.getTokenId());
                if (log.isDebugEnabled()) {
                    if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                        log.debug((Object)("Adding AuthorizationGrantCache entry for the access token(hashed):" + DigestUtils.sha256Hex((String)newCacheKey.getUserAttributesId())));
                    } else {
                        log.debug((Object)"Adding AuthorizationGrantCache entry for the access token");
                    }
                }
                authorizationGrantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(tokenRespDTO.getExpiresInMillis()));
                AuthorizationGrantCache.getInstance().addToCacheByToken(newCacheKey, authorizationGrantCacheEntry);
            }
        }
    }

    private void clearCacheEntryAgainstAuthorizationCode(String authorizationCode) {
        AuthorizationGrantCacheKey oldCacheKey = new AuthorizationGrantCacheKey(authorizationCode);
        if (oldCacheKey.getUserAttributesId() != null) {
            AuthorizationGrantCache.getInstance().clearCacheEntryByCode(oldCacheKey);
        }
    }

    private String getAuthorizationCode(OAuth2AccessTokenReqDTO tokenReqDTO) {
        return tokenReqDTO.getAuthorizationCode();
    }

    private OAuth2AccessTokenRespDTO handleError(String errorCode, String errorMsg, OAuth2AccessTokenReqDTO tokenReqDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth-Error-Code=" + errorCode + " client-id=" + tokenReqDTO.getClientId() + " grant-type=" + tokenReqDTO.getGrantType() + " scope=" + OAuth2Util.buildScopeString(tokenReqDTO.getScope())));
        }
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        tokenRespDTO.setError(true);
        tokenRespDTO.setErrorCode(errorCode);
        tokenRespDTO.setErrorMsg(errorMsg);
        return tokenRespDTO;
    }

    private void setResponseHeaders(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenRespDTO tokenRespDTO) {
        if (tokReqMsgCtx.getProperty("RESPONSE_HEADERS") != null) {
            tokenRespDTO.setResponseHeaders((ResponseHeader[])tokReqMsgCtx.getProperty("RESPONSE_HEADERS"));
        }
    }

    private OAuthAppDO getOAuthApplication(String consumerKey) throws InvalidOAuthClientException, IdentityOAuth2Exception {
        OAuthAppDO authAppDO = OAuth2Util.getAppInformationByClientId(consumerKey);
        String appState = authAppDO.getState();
        if (StringUtils.isEmpty((String)appState)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A valid OAuth client could not be found for client_id: " + consumerKey));
            }
            throw new InvalidOAuthClientException("A valid OAuth client could not be found for client_id: " + Encode.forHtml((String)consumerKey));
        }
        if (AccessTokenIssuer.isNotActiveState(appState)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("App is not in active state in client ID: " + consumerKey + ". App state is:" + appState));
            }
            throw new InvalidOAuthClientException("Oauth application is not in active state");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Oauth App validation success for consumer key: " + consumerKey));
        }
        return authAppDO;
    }

    private static boolean isNotActiveState(String appState) {
        return !"ACTIVE".equalsIgnoreCase(appState);
    }

    static {
        log = LogFactory.getLog(AccessTokenIssuer.class);
    }
}

