/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.model;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.wso2.carbon.identity.oauth2.model.HttpRequestHeader;

public class HttpRequestHeaderHandler {
    private HttpRequestHeader[] httpRequestHeaders;
    private Cookie[] cookies;

    public HttpRequestHeaderHandler(HttpServletRequest request) {
        this.cookies = request.getCookies();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            ArrayList<HttpRequestHeader> httpHeaderList = new ArrayList<HttpRequestHeader>();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                ArrayList<String> headerValueList = new ArrayList<String>();
                if (headerValues != null) {
                    while (headerValues.hasMoreElements()) {
                        headerValueList.add((String)headerValues.nextElement());
                    }
                }
                httpHeaderList.add(new HttpRequestHeader(headerName, headerValueList.toArray(new String[headerValueList.size()])));
            }
            this.httpRequestHeaders = httpHeaderList.toArray(new HttpRequestHeader[httpHeaderList.size()]);
        }
    }

    public HttpRequestHeader[] getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    public Cookie[] getCookies() {
        return this.cookies != null ? this.cookies : null;
    }
}

