/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.model;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.model.HttpRequestHeader;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;

public class CarbonOAuthTokenRequest
extends OAuthTokenRequest {
    private static final Log log = LogFactory.getLog(CarbonOAuthTokenRequest.class);
    private String assertion;
    private String windowsToken;
    private String tenantDomain;
    private String pkceCodeVerifier;
    private RequestParameter[] requestParameters;
    private HttpRequestHeader[] httpRequestHeaders;
    private OAuthClientAuthnContext oAuthClientAuthnContext;

    public CarbonOAuthTokenRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        super(request);
        Enumeration headerNames;
        this.assertion = request.getParameter("assertion");
        this.windowsToken = request.getParameter("windows_token");
        this.pkceCodeVerifier = request.getParameter("code_verifier");
        this.setClientAuthnContext(request);
        if (request.getParameterNames() != null) {
            ArrayList<RequestParameter> requestParameterList = new ArrayList<RequestParameter>();
            while (request.getParameterNames().hasMoreElements()) {
                String key = (String)request.getParameterNames().nextElement();
                String value = request.getParameter(key);
                requestParameterList.add(new RequestParameter(key, value));
            }
            this.requestParameters = requestParameterList.toArray(new RequestParameter[requestParameterList.size()]);
        }
        if ((headerNames = request.getHeaderNames()) != null) {
            ArrayList<HttpRequestHeader> httpHeaderList = new ArrayList<HttpRequestHeader>();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                ArrayList<String> headerValueList = new ArrayList<String>();
                if (headerValues != null) {
                    while (headerValues.hasMoreElements()) {
                        headerValueList.add((String)headerValues.nextElement());
                    }
                }
                httpHeaderList.add(new HttpRequestHeader(headerName, headerValueList.toArray(new String[headerValueList.size()])));
            }
            this.httpRequestHeaders = httpHeaderList.toArray(new HttpRequestHeader[httpHeaderList.size()]);
        }
    }

    protected OAuthValidator<HttpServletRequest> initValidator() throws OAuthProblemException, OAuthSystemException {
        String requestTypeValue = this.getParam("grant_type");
        if (OAuthUtils.isEmpty((String)requestTypeValue)) {
            throw OAuthUtils.handleOAuthProblemException((String)"Missing grant_type parameter value");
        }
        Class<? extends OAuthValidator<HttpServletRequest>> clazz = OAuthServerConfiguration.getInstance().getSupportedGrantTypeValidators().get(requestTypeValue);
        if (clazz == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Grant Type : " + requestTypeValue + " for client id : " + this.getClientId()));
            }
            throw OAuthProblemException.error((String)"unsupported_grant_type").description("Unsupported grant_type value");
        }
        return (OAuthValidator)OAuthUtils.instantiateClass(clazz);
    }

    public String getAssertion() {
        return this.assertion;
    }

    public String getWindowsToken() {
        return this.windowsToken;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public RequestParameter[] getRequestParameters() {
        return this.requestParameters;
    }

    public String getPkceCodeVerifier() {
        return this.pkceCodeVerifier;
    }

    public HttpRequestHeader[] getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    public OAuthClientAuthnContext getoAuthClientAuthnContext() {
        return this.oAuthClientAuthnContext;
    }

    public void setoAuthClientAuthnContext(OAuthClientAuthnContext oAuthClientAuthnContext) {
        this.oAuthClientAuthnContext = oAuthClientAuthnContext;
    }

    private void setClientAuthnContext(HttpServletRequest request) {
        Object oauthClientAuthnContextObj = request.getAttribute("oauth.client.authentication.context");
        if (oauthClientAuthnContextObj instanceof OAuthClientAuthnContext) {
            this.oAuthClientAuthnContext = (OAuthClientAuthnContext)((Object)oauthClientAuthnContextObj);
        } else {
            this.oAuthClientAuthnContext = new OAuthClientAuthnContext();
            this.oAuthClientAuthnContext.setAuthenticated(false);
            this.oAuthClientAuthnContext.setErrorMessage("Client Authentication Failed");
            this.oAuthClientAuthnContext.setErrorCode("invalid_request");
        }
    }
}

