/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.model;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.model.CarbonOAuthTokenRequest;

public class CarbonOAuthAuthzRequest
extends OAuthAuthzRequest {
    private static final Log log = LogFactory.getLog(CarbonOAuthTokenRequest.class);

    public CarbonOAuthAuthzRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        super(request);
    }

    protected OAuthValidator<HttpServletRequest> initValidator() throws OAuthProblemException, OAuthSystemException {
        String responseTypeValue = this.getParam("response_type");
        if (OAuthUtils.isEmpty((String)responseTypeValue)) {
            throw OAuthUtils.handleOAuthProblemException((String)"Missing response_type parameter value");
        }
        Class<? extends OAuthValidator<HttpServletRequest>> clazz = OAuthServerConfiguration.getInstance().getSupportedResponseTypeValidators().get(responseTypeValue);
        if (clazz == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Response Type : " + responseTypeValue + " for client id : " + this.getClientId()));
            }
            throw OAuthUtils.handleOAuthProblemException((String)"Invalid response_type parameter value");
        }
        return (OAuthValidator)OAuthUtils.instantiateClass(clazz);
    }
}

