/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.model;

import java.sql.Timestamp;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;

public class AccessTokenDO
extends CacheEntry {
    private static final long serialVersionUID = -8123522530178387354L;
    private String consumerKey;
    private AuthenticatedUser authzUser;
    private String[] scope;
    private String tokenState;
    private String refreshToken;
    private String tokenId;
    private String accessToken;
    private String authorizationCode;
    private String grantType;
    private Timestamp issuedTime;
    private Timestamp refreshTokenIssuedTime;
    private long validityPeriod;
    private long validityPeriodInMillis;
    private long refreshTokenValidityPeriod;
    private long refreshTokenValidityPeriodInMillis;
    private int tenantID = -1234;
    private String tokenType;
    private TokenBinding tokenBinding;

    public AccessTokenDO(String consumerKey, AuthenticatedUser authzUser, String[] scope, Timestamp issuedTime, Timestamp refreshTokenIssuedTime, long validityPeriodInMillis, long refreshTokenValidityPeriodInMillis, String tokenType) {
        this.consumerKey = consumerKey;
        this.authzUser = authzUser;
        this.scope = scope;
        this.issuedTime = issuedTime;
        this.refreshTokenIssuedTime = refreshTokenIssuedTime;
        this.validityPeriod = validityPeriodInMillis / 1000L;
        this.validityPeriodInMillis = validityPeriodInMillis;
        this.refreshTokenValidityPeriod = refreshTokenValidityPeriodInMillis / 1000L;
        this.refreshTokenValidityPeriodInMillis = refreshTokenValidityPeriodInMillis;
        this.tokenType = tokenType;
    }

    public AccessTokenDO(String consumerKey, AuthenticatedUser authzUser, String[] scope, Timestamp issuedTime, Timestamp refreshTokenIssuedTime, long validityPeriodInMillis, long refreshTokenValidityPeriodInMillis, String tokenType, String authorizationCode) {
        this(consumerKey, authzUser, scope, issuedTime, refreshTokenIssuedTime, validityPeriodInMillis, refreshTokenValidityPeriodInMillis, tokenType);
        this.authorizationCode = authorizationCode;
    }

    public AccessTokenDO(String consumerKey, AuthenticatedUser authzUser, String[] scope, TokenBinding tokenBinding, Timestamp issuedTime, Timestamp refreshTokenIssuedTime, long validityPeriodInMillis, long refreshTokenValidityPeriodInMillis, String tokenType) {
        this.consumerKey = consumerKey;
        this.authzUser = authzUser;
        this.scope = scope;
        this.issuedTime = issuedTime;
        this.refreshTokenIssuedTime = refreshTokenIssuedTime;
        this.validityPeriodInMillis = validityPeriodInMillis;
        this.refreshTokenValidityPeriodInMillis = refreshTokenValidityPeriodInMillis;
        this.tokenType = tokenType;
        this.tokenBinding = tokenBinding;
    }

    public static AccessTokenDO clone(AccessTokenDO tokenDO) {
        AccessTokenDO newTokenDO = new AccessTokenDO(tokenDO.getConsumerKey(), tokenDO.getAuthzUser(), tokenDO.getScope(), tokenDO.getIssuedTime(), tokenDO.getRefreshTokenIssuedTime(), tokenDO.getValidityPeriodInMillis(), tokenDO.getRefreshTokenValidityPeriodInMillis(), tokenDO.getTokenType());
        newTokenDO.setTenantID(tokenDO.getTenantID());
        newTokenDO.setTokenState(tokenDO.getTokenState());
        newTokenDO.setRefreshToken(tokenDO.getRefreshToken());
        newTokenDO.setAccessToken(tokenDO.getAccessToken());
        newTokenDO.setTokenId(tokenDO.getTokenId());
        newTokenDO.setAuthorizationCode(tokenDO.getAuthorizationCode());
        newTokenDO.setGrantType(tokenDO.getGrantType());
        newTokenDO.setTokenBinding(tokenDO.getTokenBinding());
        return newTokenDO;
    }

    public AccessTokenDO() {
    }

    public int getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(int tenantID) {
        this.tenantID = tenantID;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public AuthenticatedUser getAuthzUser() {
        return this.authzUser;
    }

    public void setAuthzUser(AuthenticatedUser authzUser) {
        this.authzUser = authzUser;
    }

    public String[] getScope() {
        return this.scope;
    }

    public void setScope(String[] scope) {
        this.scope = scope;
    }

    public Timestamp getIssuedTime() {
        return this.issuedTime;
    }

    public void setIssuedTime(Timestamp issuedTime) {
        this.issuedTime = issuedTime;
    }

    public Timestamp getRefreshTokenIssuedTime() {
        return this.refreshTokenIssuedTime;
    }

    public void setRefreshTokenIssuedTime(Timestamp refreshTokenIssuedTime) {
        this.refreshTokenIssuedTime = refreshTokenIssuedTime;
    }

    public long getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(long validityPeriod) {
        this.validityPeriod = validityPeriod;
        this.validityPeriodInMillis = validityPeriod * 1000L;
    }

    public String getTokenState() {
        return this.tokenState;
    }

    public void setTokenState(String tokenState) {
        this.tokenState = tokenState;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public long getValidityPeriodInMillis() {
        return this.validityPeriodInMillis;
    }

    public void setValidityPeriodInMillis(long validityPeriodInMillis) {
        this.validityPeriodInMillis = validityPeriodInMillis;
        this.validityPeriod = validityPeriodInMillis / 1000L;
    }

    public void setRefreshTokenValidityPeriod(long refreshTokenValidityPeriod) {
        this.refreshTokenValidityPeriod = refreshTokenValidityPeriod;
        this.refreshTokenValidityPeriodInMillis = refreshTokenValidityPeriod * 1000L;
    }

    public long getRefreshTokenValidityPeriodInMillis() {
        return this.refreshTokenValidityPeriodInMillis;
    }

    public void setRefreshTokenValidityPeriodInMillis(long refreshTokenValidityPeriodInMillis) {
        this.refreshTokenValidityPeriodInMillis = refreshTokenValidityPeriodInMillis;
        this.refreshTokenValidityPeriod = refreshTokenValidityPeriodInMillis / 1000L;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public TokenBinding getTokenBinding() {
        return this.tokenBinding;
    }

    public void setTokenBinding(TokenBinding tokenBinding) {
        this.tokenBinding = tokenBinding;
    }
}

