/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

public class TenantCreationEventListener
implements TenantMgtListener {
    public void onTenantCreate(TenantInfoBean tenantInfoBean) throws StratosException {
        int tenantId = tenantInfoBean.getTenantId();
        OAuth2Util.initiateOIDCScopes(tenantId);
        OAuth2Util.initiateOAuthScopePermissionsBindings(tenantId);
    }

    public void onTenantUpdate(TenantInfoBean tenantInfoBean) throws StratosException {
    }

    public void onTenantDelete(int i) {
    }

    public void onTenantRename(int i, String s, String s1) throws StratosException {
    }

    public void onTenantInitialActivation(int i) throws StratosException {
    }

    public void onTenantActivation(int i) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
        this.revokeTokens(tenantId);
    }

    public void onSubscriptionPlanChange(int i, String s, String s1) throws StratosException {
    }

    public int getListenerOrder() {
        return 0;
    }

    public void onPreDelete(int tenantId) throws StratosException {
        this.revokeTokens(tenantId);
        try {
            OAuth2ServiceComponentHolder.getInstance().getOAuthAdminService().removeAllOAuthApplicationData(tenantId);
        }
        catch (IdentityOAuthAdminException e) {
            throw new StratosException("Error in deleting all OAuth application data of the tenant: " + tenantId, (Throwable)((Object)e));
        }
    }

    private void revokeTokens(int tenantId) throws StratosException {
        try {
            Set<AccessTokenDO> accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensByTenant(tenantId);
            HashMap<String, AccessTokenDO> latestAccessTokens = new HashMap<String, AccessTokenDO>();
            for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                String keyString = accessTokenDO.getConsumerKey() + ":" + accessTokenDO.getAuthzUser() + ":" + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + ":" + accessTokenDO.getAuthzUser().getFederatedIdPName();
                AccessTokenDO accessTokenDOFromMap = (AccessTokenDO)((Object)latestAccessTokens.get(keyString));
                if (accessTokenDOFromMap != null) {
                    if (accessTokenDOFromMap.getIssuedTime().before(accessTokenDO.getIssuedTime())) {
                        latestAccessTokens.put(keyString, accessTokenDO);
                    }
                } else {
                    latestAccessTokens.put(keyString, accessTokenDO);
                }
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
            }
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens((String[])latestAccessTokens.values().stream().map(AccessTokenDO::getAccessToken).toArray(String[]::new), OAuth2Util.isHashEnabled());
            List<AuthzCodeDO> latestAuthzCodes = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getLatestAuthorizationCodesByTenant(tenantId);
            latestAuthzCodes.stream().map(authzCodeDO -> authzCodeDO.getConsumerKey() + ":" + authzCodeDO.getAuthorizationCode()).forEach(OAuthUtil::clearOAuthCache);
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCodes(latestAuthzCodes);
        }
        catch (IdentityOAuth2Exception e) {
            throw new StratosException("Error occurred while revoking Access Token of tenant: " + tenantId, (Throwable)((Object)e));
        }
    }
}

