/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityCoreConstants;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.user.store.configuration.listener.AbstractUserStoreConfigListener;
import org.wso2.carbon.user.api.UserStoreException;

public class OAuthUserStoreConfigListenerImpl
extends AbstractUserStoreConfigListener {
    public void onUserStoreNamePreUpdate(int tenantId, String currentUserStoreName, String newUserStoreName) throws UserStoreException {
        try {
            Set<AccessTokenDO> accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensOfUserStore(tenantId, currentUserStoreName);
            for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
            }
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().updateUserStoreDomain(tenantId, currentUserStoreName, newUserStoreName);
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().updateUserStoreDomain(tenantId, currentUserStoreName, newUserStoreName);
        }
        catch (IdentityOAuth2Exception e) {
            throw new UserStoreException("Error occurred while renaming user store : " + currentUserStoreName + " in tenant :" + tenantId, (Throwable)((Object)e));
        }
    }

    public void onUserStorePreDelete(int tenantId, String userStoreName) throws UserStoreException {
        this.revokeTokens(tenantId, userStoreName);
    }

    public void onUserStorePreStateChange(IdentityCoreConstants.UserStoreState state, int tenantId, String userStoreName) throws UserStoreException {
        if (state == IdentityCoreConstants.UserStoreState.DISABLED) {
            this.revokeTokens(tenantId, userStoreName);
        }
    }

    private void revokeTokens(int tenantId, String userStoreName) throws UserStoreException {
        try {
            List<AuthzCodeDO> latestAuthzCodes;
            Set<AccessTokenDO> accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensOfUserStore(tenantId, userStoreName);
            HashMap<String, Object> latestAccessTokens = new HashMap<String, Object>();
            for (Object accessTokenDO : accessTokenDOs) {
                String string = accessTokenDO.getConsumerKey() + ":" + accessTokenDO.getAuthzUser() + ":" + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + ":" + accessTokenDO.getAuthzUser().getFederatedIdPName();
                AccessTokenDO accessTokenDOFromMap = (AccessTokenDO)((Object)latestAccessTokens.get(string));
                if (accessTokenDOFromMap != null) {
                    if (accessTokenDOFromMap.getIssuedTime().before(accessTokenDO.getIssuedTime())) {
                        latestAccessTokens.put(string, accessTokenDO);
                    }
                } else {
                    latestAccessTokens.put(string, accessTokenDO);
                }
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
            }
            ArrayList<String> tokensToRevoke = new ArrayList<String>();
            for (Map.Entry entry : latestAccessTokens.entrySet()) {
                tokensToRevoke.add(((AccessTokenDO)((Object)entry.getValue())).getAccessToken());
            }
            if (!tokensToRevoke.isEmpty()) {
                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(tokensToRevoke.toArray(new String[tokensToRevoke.size()]), OAuth2Util.isHashEnabled());
            }
            if (!(latestAuthzCodes = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getLatestAuthorizationCodesByUserStore(tenantId, userStoreName)).isEmpty()) {
                for (AuthzCodeDO authzCodeDO : latestAuthzCodes) {
                    OAuthUtil.clearOAuthCache(authzCodeDO.getConsumerKey() + ":" + authzCodeDO.getAuthorizationCode());
                }
                OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCodes(latestAuthzCodes);
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw new UserStoreException("Error occurred while revoking Access Token of user store : " + userStoreName + " in tenant :" + tenantId, (Throwable)((Object)e));
        }
    }
}

