/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.AbstractIdentityTenantMgtListener;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.stratos.common.exception.StratosException;

public class OAuthTenantMgtListenerImpl
extends AbstractIdentityTenantMgtListener {
    public void onPreDelete(int tenantId) throws StratosException {
        this.clearTokenData(tenantId);
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
        this.clearTokenData(tenantId);
    }

    private void clearTokenData(int tenantId) throws StratosException {
        try {
            Set<AccessTokenDO> accessTokenDOs = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getAccessTokensByTenant(tenantId);
            HashMap<String, Object> latestAccessTokens = new HashMap<String, Object>();
            for (Object accessTokenDO : accessTokenDOs) {
                String string = accessTokenDO.getConsumerKey() + ":" + accessTokenDO.getAuthzUser() + ":" + OAuth2Util.buildScopeString(accessTokenDO.getScope()) + ":" + accessTokenDO.getAuthzUser().getFederatedIdPName();
                AccessTokenDO accessTokenDOFromMap = (AccessTokenDO)((Object)latestAccessTokens.get(string));
                if (accessTokenDOFromMap != null) {
                    if (accessTokenDOFromMap.getIssuedTime().before(accessTokenDO.getIssuedTime())) {
                        latestAccessTokens.put(string, accessTokenDO);
                    }
                } else {
                    latestAccessTokens.put(string, accessTokenDO);
                }
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser(), OAuth2Util.buildScopeString(accessTokenDO.getScope()));
                OAuthUtil.clearOAuthCache(accessTokenDO.getConsumerKey(), (User)accessTokenDO.getAuthzUser());
                OAuthUtil.clearOAuthCache(accessTokenDO.getAccessToken());
            }
            ArrayList<String> tokensToRevoke = new ArrayList<String>();
            for (Map.Entry entry : latestAccessTokens.entrySet()) {
                tokensToRevoke.add(((AccessTokenDO)((Object)entry.getValue())).getAccessToken());
            }
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(tokensToRevoke.toArray(new String[tokensToRevoke.size()]), OAuth2Util.isHashEnabled());
            List<AuthzCodeDO> latestAuthzCodes = OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getLatestAuthorizationCodesByTenant(tenantId);
            for (AuthzCodeDO authzCodeDO : latestAuthzCodes) {
                OAuthUtil.clearOAuthCache(authzCodeDO.getConsumerKey() + ":" + authzCodeDO.getAuthorizationCode());
            }
            OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().deactivateAuthorizationCodes(latestAuthzCodes);
        }
        catch (IdentityOAuth2Exception e) {
            throw new StratosException("Error occurred while revoking the access tokens in tenant " + tenantId, (Throwable)((Object)e));
        }
    }
}

