/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementServerException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementValidationException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.IdentityOAuthClientException;
import org.wso2.carbon.identity.oauth.OAuthAdminService;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.AppInfoCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dao.OAuthConsumerDAO;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthApplicationMgtListener
extends AbstractApplicationMgtListener {
    public static final String OAUTH2 = "oauth2";
    public static final String OAUTH2_CONSUMER_SECRET = "oauthConsumerSecret";
    private static final String OAUTH = "oauth";
    private static final String SAAS_PROPERTY = "saasProperty";
    private static final Log log = LogFactory.getLog(OAuthApplicationMgtListener.class);

    public int getDefaultOrderId() {
        return 901;
    }

    public boolean doPreUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        this.handleOAuthAppAssociationRemoval(serviceProvider);
        this.storeSaaSPropertyValue(serviceProvider);
        this.removeClientSecret(serviceProvider);
        return true;
    }

    public boolean doPostGetServiceProvider(ServiceProvider serviceProvider, String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        this.addClientSecret(serviceProvider);
        return true;
    }

    public boolean doPostGetServiceProviderByClientId(ServiceProvider serviceProvider, String clientId, String clientType, String tenantDomain) throws IdentityApplicationManagementException {
        this.addClientSecret(serviceProvider);
        return true;
    }

    public boolean doPostCreateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        this.addClientSecret(serviceProvider);
        return true;
    }

    public boolean doPostUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        this.revokeAccessTokensWhenSaaSDisabled(serviceProvider, tenantDomain);
        this.addClientSecret(serviceProvider);
        this.updateAuthApplication(serviceProvider);
        this.removeEntriesFromCache(serviceProvider, tenantDomain);
        return true;
    }

    public boolean doPostGetApplicationExcludingFileBasedSPs(ServiceProvider serviceProvider, String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        this.addClientSecret(serviceProvider);
        return true;
    }

    public boolean doPreDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ApplicationManagementService applicationMgtService = OAuth2ServiceComponentHolder.getApplicationMgtService();
        ServiceProvider serviceProvider = applicationMgtService.getApplicationExcludingFileBasedSPs(applicationName, tenantDomain);
        if (serviceProvider != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting OAuth inbound data associated with application: " + applicationName + " in tenantDomain: " + tenantDomain + " during application delete."));
                }
                this.deleteAssociatedOAuthApps(serviceProvider, tenantDomain);
            }
            catch (IdentityOAuthAdminException | IdentityOAuth2Exception e) {
                throw new IdentityApplicationManagementException("Error while cleaning up oauth application data associated with service provider: " + applicationName + " of tenantDomain: " + tenantDomain, (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Service Provider not found with name: " + applicationName));
        }
        return true;
    }

    private Set<String> getOAuthAppsAssociatedWithApplication(ServiceProvider serviceProvider) {
        InboundAuthenticationRequestConfig[] inboundRequestConfigs;
        HashSet<String> oauthKeys = new HashSet<String>();
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && (inboundRequestConfigs = inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) != null) {
            for (InboundAuthenticationRequestConfig inboundRequestConfig : inboundRequestConfigs) {
                if (!StringUtils.equals((String)OAUTH2, (String)inboundRequestConfig.getInboundAuthType()) && !StringUtils.equals((String)inboundRequestConfig.getInboundAuthType(), (String)OAUTH)) continue;
                oauthKeys.add(inboundRequestConfig.getInboundAuthKey());
            }
        }
        return oauthKeys;
    }

    private void deleteAssociatedOAuthApps(ServiceProvider serviceProvider, String tenantDomain) throws IdentityOAuthAdminException, IdentityOAuth2Exception {
        Set<String> associatedOAuthConsumerKeys = this.getOAuthAppsAssociatedWithApplication(serviceProvider);
        for (String consumerKey : associatedOAuthConsumerKeys) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing OAuth application data for clientId: " + consumerKey + " associated with application: " + serviceProvider.getApplicationName() + " tenantDomain: " + tenantDomain));
            }
            OAuth2ServiceComponentHolder.getInstance().getOAuthAdminService().removeOAuthApplicationData(consumerKey);
        }
        this.removeEntriesFromCache(associatedOAuthConsumerKeys);
    }

    public void onPreCreateInbound(ServiceProvider serviceProvider, boolean isUpdate) throws IdentityApplicationManagementException {
        this.validateOAuthInbound(serviceProvider, isUpdate);
    }

    public void doImportServiceProvider(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        try {
            if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
                for (InboundAuthenticationRequestConfig authConfig : serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                    if (!OAUTH.equals(authConfig.getInboundAuthType()) && !OAUTH2.equals(authConfig.getInboundAuthType())) continue;
                    String inboundConfiguration = authConfig.getInboundConfiguration();
                    if (inboundConfiguration == null || "".equals(inboundConfiguration)) {
                        String errorMSg = String.format("No inbound configurations found for oauth in the imported %s", serviceProvider.getApplicationName());
                        throw new IdentityApplicationManagementException(errorMSg);
                    }
                    User owner = serviceProvider.getOwner();
                    OAuthAppDO oAuthAppDO = this.marshelOAuthDO(authConfig.getInboundConfiguration(), serviceProvider.getApplicationName(), owner.getTenantDomain());
                    oAuthAppDO.setAppOwner(this.buildAuthenticatedUser(owner));
                    OAuthConsumerAppDTO oAuthConsumerAppDTO = OAuthUtil.buildConsumerAppDTO(oAuthAppDO);
                    OAuthAppDAO dao = new OAuthAppDAO();
                    String oauthConsumerKey = oAuthConsumerAppDTO.getOauthConsumerKey();
                    boolean isExistingClient = dao.isDuplicateConsumer(oauthConsumerKey);
                    if (oAuthConsumerAppDTO.getOauthConsumerSecret() == null) {
                        if (isExistingClient) {
                            OAuthAppDO app = OAuth2Util.getAppInformationByClientId(oauthConsumerKey);
                            oAuthConsumerAppDTO.setOauthConsumerSecret(app.getOauthConsumerSecret());
                        } else {
                            oAuthConsumerAppDTO.setOauthConsumerSecret(OAuthUtil.getRandomNumber());
                        }
                    }
                    OAuthAdminServiceImpl oAuthAdminService = OAuthComponentServiceHolder.getInstance().getoAuthAdminService();
                    if (isExistingClient) {
                        oAuthAdminService.updateConsumerApplication(oAuthConsumerAppDTO);
                    } else {
                        oAuthAdminService.registerOAuthApplicationData(oAuthConsumerAppDTO);
                    }
                    return;
                }
            }
        }
        catch (IdentityOAuthAdminException | InvalidOAuthClientException | IdentityOAuth2Exception e) {
            String message = "Error occurred when importing OAuth inbound.";
            throw this.handleException(message, (Exception)e);
        }
    }

    private IdentityApplicationManagementException handleException(String message, Exception ex) {
        if (ex instanceof IdentityOAuthClientException || ex instanceof InvalidOAuthClientException) {
            return new IdentityApplicationManagementClientException(message, (Throwable)ex);
        }
        return new IdentityApplicationManagementServerException(message, (Throwable)ex);
    }

    public void doExportServiceProvider(ServiceProvider serviceProvider, Boolean exportSecrets) throws IdentityApplicationManagementException {
        try {
            if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
                for (InboundAuthenticationRequestConfig authConfig : serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                    if (!OAUTH.equals(authConfig.getInboundAuthType()) && !OAUTH2.equals(authConfig.getInboundAuthType())) continue;
                    OAuthAppDAO dao = new OAuthAppDAO();
                    OAuthAppDO authApplication = dao.getAppInformation(authConfig.getInboundAuthKey());
                    String tokenProcessorName = OAuthServerConfiguration.getInstance().getPersistenceProcessor().getClass().getName();
                    if (!"org.wso2.carbon.identity.oauth.tokenprocessor.PlainTextPersistenceProcessor".equals(tokenProcessorName) || !exportSecrets.booleanValue()) {
                        authApplication.setOauthConsumerSecret(null);
                    }
                    Property[] properties = authConfig.getProperties();
                    authConfig.setProperties((Property[])Arrays.stream(properties).filter(property -> !OAUTH2_CONSUMER_SECRET.equals(property.getName())).toArray(Property[]::new));
                    authConfig.setInboundConfiguration(this.unmarshelOAuthDO(authApplication));
                    return;
                }
            }
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            throw new IdentityApplicationManagementException("Error occurred when retrieving OAuth application ", (Throwable)e);
        }
    }

    private void removeClientSecret(ServiceProvider serviceProvider) {
        InboundAuthenticationRequestConfig[] inboundRequestConfigs;
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && (inboundRequestConfigs = inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) != null) {
            for (InboundAuthenticationRequestConfig inboundRequestConfig : inboundRequestConfigs) {
                Object[] props;
                if (!inboundRequestConfig.getInboundAuthType().equals(OAUTH2)) continue;
                for (Property property : props = inboundRequestConfig.getProperties()) {
                    if (!property.getName().equalsIgnoreCase(OAUTH2_CONSUMER_SECRET)) continue;
                    props = (Property[])ArrayUtils.removeElement((Object[])props, (Object)property);
                    inboundRequestConfig.setProperties((Property[])props);
                }
            }
        }
    }

    private void addClientSecret(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        if (serviceProvider == null) {
            return;
        }
        try {
            InboundAuthenticationRequestConfig[] inboundRequestConfigs;
            InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
            if (inboundAuthenticationConfig != null && (inboundRequestConfigs = inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) != null) {
                for (InboundAuthenticationRequestConfig inboundRequestConfig : inboundRequestConfigs) {
                    if (!inboundRequestConfig.getInboundAuthType().equals(OAUTH2)) continue;
                    Object[] props = inboundRequestConfig.getProperties();
                    Property property = new Property();
                    property.setName(OAUTH2_CONSUMER_SECRET);
                    property.setValue(this.getClientSecret(inboundRequestConfig.getInboundAuthKey()));
                    props = (Property[])ArrayUtils.add((Object[])props, (Object)property);
                    inboundRequestConfig.setProperties((Property[])props);
                }
            }
        }
        catch (IdentityOAuthAdminException e) {
            throw new IdentityApplicationManagementException("Injecting client secret failed.", (Throwable)((Object)e));
        }
    }

    private String getClientSecret(String inboundAuthKey) throws IdentityOAuthAdminException {
        OAuthConsumerDAO dao = new OAuthConsumerDAO();
        return dao.getOAuthConsumerSecret(inboundAuthKey);
    }

    private void updateAuthApplication(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        InboundAuthenticationRequestConfig authenticationRequestConfigConfig = null;
        if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                if (!StringUtils.equals((String)authConfig.getInboundAuthType(), (String)OAUTH) && !StringUtils.equals((String)authConfig.getInboundAuthType(), (String)OAUTH2)) continue;
                authenticationRequestConfigConfig = authConfig;
                break;
            }
        }
        if (authenticationRequestConfigConfig == null) {
            return;
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        dao.updateOAuthConsumerApp(serviceProvider.getApplicationName(), authenticationRequestConfigConfig.getInboundAuthKey());
    }

    private void removeEntriesFromCache(Set<String> consumerKeys) throws IdentityOAuth2Exception {
        if (CollectionUtils.isNotEmpty(consumerKeys)) {
            HashSet<AccessTokenDO> accessTokenDOSet = new HashSet<AccessTokenDO>();
            HashSet<AuthzCodeDO> authzCodeDOSet = new HashSet<AuthzCodeDO>();
            AppInfoCache appInfoCache = AppInfoCache.getInstance();
            for (String oauthKey : consumerKeys) {
                accessTokenDOSet.addAll(OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getActiveTokenSetWithTokenIdByConsumerKeyForOpenidScope(oauthKey));
                authzCodeDOSet.addAll(OAuthTokenPersistenceFactory.getInstance().getAuthorizationCodeDAO().getAuthorizationCodeDOSetByConsumerKeyForOpenidScope(oauthKey));
                appInfoCache.clearCacheEntry((Serializable)((Object)oauthKey));
                OAuthCache.getInstance().clearCacheEntry(new OAuthCacheKey(oauthKey));
            }
            if (CollectionUtils.isNotEmpty(accessTokenDOSet)) {
                this.clearCacheEntriesAgainstToken(accessTokenDOSet);
            }
            if (CollectionUtils.isNotEmpty(authzCodeDOSet)) {
                this.clearCacheEntriesAgainstAuthzCode(authzCodeDOSet);
            }
        }
    }

    private void removeEntriesFromCache(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        Set<String> consumerKeys = this.getOAuthAppsAssociatedWithApplication(serviceProvider);
        try {
            this.removeEntriesFromCache(consumerKeys);
        }
        catch (IdentityOAuth2Exception e) {
            String applicationName = serviceProvider.getApplicationName();
            throw new IdentityApplicationManagementException("Error while clearing cache for oauth application data associated with service provider: " + applicationName + " of tenantDomain: " + tenantDomain, (Throwable)((Object)e));
        }
    }

    private void clearCacheEntriesAgainstAuthzCode(Set<AuthzCodeDO> authzCodeDOSet) {
        for (AuthzCodeDO authzCodeDO : authzCodeDOSet) {
            AuthorizationGrantCacheKey grantCacheKey = new AuthorizationGrantCacheKey(authzCodeDO.getAuthorizationCode());
            AuthorizationGrantCache.getInstance().clearCacheEntryByCodeId(grantCacheKey, authzCodeDO.getAuthzCodeId());
            OAuthCacheKey oauthCacheKey = new OAuthCacheKey(authzCodeDO.getAuthorizationCode());
            CacheEntry oauthCacheEntry = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(oauthCacheKey));
            if (oauthCacheEntry == null) continue;
            OAuthCache.getInstance().clearCacheEntry(oauthCacheKey);
        }
    }

    private void clearCacheEntriesAgainstToken(Set<AccessTokenDO> accessTokenDOSet) {
        for (AccessTokenDO accessTokenDo : accessTokenDOSet) {
            AuthorizationGrantCacheKey grantCacheKey = new AuthorizationGrantCacheKey(accessTokenDo.getAccessToken());
            AuthorizationGrantCache.getInstance().clearCacheEntryByTokenId(grantCacheKey, accessTokenDo.getTokenId());
            OAuthCacheKey oauthCacheKey = new OAuthCacheKey(accessTokenDo.getAccessToken());
            CacheEntry oauthCacheEntry = (CacheEntry)((Object)OAuthCache.getInstance().getValueFromCache(oauthCacheKey));
            if (oauthCacheEntry == null) continue;
            OAuthCache.getInstance().clearCacheEntry(oauthCacheKey);
        }
    }

    private void storeSaaSPropertyValue(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        ServiceProvider sp = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProvider(serviceProvider.getApplicationID());
        ((Map)IdentityUtil.threadLocalProperties.get()).put(SAAS_PROPERTY, sp.isSaasApp());
    }

    private void handleOAuthAppAssociationRemoval(ServiceProvider updatedSp) throws IdentityApplicationManagementException {
        InboundAuthenticationRequestConfig updatedOAuthInboundConfig;
        int appId = updatedSp.getApplicationID();
        ServiceProvider storedSp = OAuth2ServiceComponentHolder.getApplicationMgtService().getServiceProvider(appId);
        InboundAuthenticationRequestConfig storedOAuthConfig = this.getOAuthInbound(storedSp);
        if (this.isOAuthInboundAssociationRemoved(storedOAuthConfig, updatedOAuthInboundConfig = this.getOAuthInbound(updatedSp))) {
            String deletedConsumerKey = storedOAuthConfig.getInboundAuthKey();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OAuth inbound with clientId: " + deletedConsumerKey + " has been removed from service provider with id: " + appId + ". Removing the stale OAuth application for clientId: " + deletedConsumerKey));
                }
                OAuth2ServiceComponentHolder.getInstance().getOAuthAdminService().removeOAuthApplicationData(deletedConsumerKey);
            }
            catch (IdentityOAuthAdminException e) {
                String msg = "Error removing OAuth2 inbound data for clientId: %s associated with service provider with id: %s during application update.";
                throw new IdentityApplicationManagementException(String.format(msg, deletedConsumerKey, appId), (Throwable)((Object)e));
            }
        }
    }

    private boolean isOAuthInboundAssociationRemoved(InboundAuthenticationRequestConfig storedOAuthConfig, InboundAuthenticationRequestConfig updatedOAuthInboundConfig) {
        return storedOAuthConfig != null && updatedOAuthInboundConfig == null;
    }

    private InboundAuthenticationRequestConfig getOAuthInbound(ServiceProvider sp) {
        if (sp != null && sp.getInboundAuthenticationConfig() != null && ArrayUtils.isNotEmpty((Object[])sp.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs())) {
            return Arrays.stream(sp.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()).filter(inbound -> OAUTH2.equals(inbound.getInboundAuthType())).findAny().orElse(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeAccessTokensWhenSaaSDisabled(ServiceProvider serviceProvider, String tenantDomain) {
        try {
            boolean wasSaasEnabled = false;
            Object saasStatus = ((Map)IdentityUtil.threadLocalProperties.get()).get(SAAS_PROPERTY);
            if (saasStatus instanceof Boolean) {
                wasSaasEnabled = (Boolean)saasStatus;
            }
            if (wasSaasEnabled && !serviceProvider.isSaasApp()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SaaS setting removed for application: " + serviceProvider.getApplicationName() + "in tenant domain: " + tenantDomain + ", hence proceeding to token revocation of other tenants."));
                }
                int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
                new Thread(() -> {
                    InboundAuthenticationRequestConfig[] configs;
                    for (InboundAuthenticationRequestConfig config : configs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                        if (!OAUTH2.equalsIgnoreCase(config.getInboundAuthType()) || config.getInboundAuthKey() == null) continue;
                        String oauthKey = config.getInboundAuthKey();
                        try {
                            OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().revokeSaaSTokensOfOtherTenants(oauthKey, tenantId);
                        }
                        catch (IdentityOAuth2Exception e) {
                            log.error((Object)("Error occurred while revoking access tokens for client ID: " + config.getInboundAuthKey() + " and tenant domain: " + tenantDomain), (Throwable)((Object)e));
                        }
                    }
                }).start();
            }
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(SAAS_PROPERTY);
        }
    }

    private void validateOAuthInbound(ServiceProvider serviceProvider, boolean isUpdate) throws IdentityApplicationManagementValidationException {
        ArrayList<String> validationMsg = new ArrayList<String>();
        if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                OAuthAppDO oAuthAppDO;
                if (!OAUTH.equals(authConfig.getInboundAuthType()) && !OAUTH2.equals(authConfig.getInboundAuthType())) continue;
                String inboundConfiguration = authConfig.getInboundConfiguration();
                if (inboundConfiguration == null) {
                    return;
                }
                String inboundAuthKey = authConfig.getInboundAuthKey();
                OAuthAppDAO dao = new OAuthAppDAO();
                String tenantDomain = serviceProvider.getOwner().getTenantDomain();
                String userName = serviceProvider.getOwner().getUserName();
                try {
                    oAuthAppDO = this.marshelOAuthDO(inboundConfiguration, serviceProvider.getApplicationName(), tenantDomain);
                }
                catch (IdentityApplicationManagementException e) {
                    validationMsg.add("OAuth inbound configuration in the file is not valid.");
                    break;
                }
                if (!inboundAuthKey.equals(oAuthAppDO.getOauthConsumerKey())) {
                    validationMsg.add(String.format("The Inbound Auth Key of the  application name %s is not match with Oauth Consumer Key %s.", authConfig.getInboundAuthKey(), oAuthAppDO.getOauthConsumerKey()));
                }
                try {
                    if (!isUpdate) {
                        if (dao.isDuplicateConsumer(inboundAuthKey)) {
                            validationMsg.add(String.format("An OAuth application already exists with %s as consumer key", inboundAuthKey));
                            break;
                        }
                        if (dao.isDuplicateApplication(userName, IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain, oAuthAppDO)) {
                            validationMsg.add(String.format("An OAuth application already exists with %s as consumer key", oAuthAppDO.getApplicationName()));
                            break;
                        }
                    }
                }
                catch (IdentityOAuthAdminException identityOAuthAdminException) {
                    // empty catch block
                }
                if (oAuthAppDO.getGrantTypes() != null && (oAuthAppDO.getGrantTypes().contains("authorization_code") || oAuthAppDO.getGrantTypes().contains("implicit")) && StringUtils.isEmpty((String)oAuthAppDO.getCallbackUrl())) {
                    validationMsg.add("Callback Url is required for Code or Implicit grant types");
                }
                this.validateScopeValidators(oAuthAppDO.getScopeValidators(), validationMsg);
                if (!"OAuth-2.0".equals(oAuthAppDO.getOauthVersion())) break;
                this.validateGrants(oAuthAppDO.getGrantTypes().split("\\s"), validationMsg);
                break;
            }
        }
        if (!validationMsg.isEmpty()) {
            throw new IdentityApplicationManagementValidationException(validationMsg.toArray(new String[0]));
        }
    }

    private void validateGrants(String[] requestedGrants, List<String> validationMsg) {
        OAuthAdminService oAuthAdminService = new OAuthAdminService();
        ArrayList<String> allowedGrants = new ArrayList<String>(Arrays.asList(oAuthAdminService.getAllowedGrantTypes()));
        for (String requestedGrant : requestedGrants) {
            if (StringUtils.isBlank((String)requestedGrant) || allowedGrants.contains(requestedGrant)) continue;
            validationMsg.add(String.format("Grant type %s not allowed", requestedGrant));
        }
    }

    private void validateScopeValidators(String[] appScopeValidators, List<String> validationMsg) {
        OAuthAdminService oAuthAdminService = new OAuthAdminService();
        ArrayList<String> scopeValidators = new ArrayList<String>(Arrays.asList(oAuthAdminService.getAllowedScopeValidators()));
        Arrays.stream(appScopeValidators).forEach(validator -> {
            if (!scopeValidators.contains(validator)) {
                validationMsg.add(String.format("The scope validator %s is not available in the server configuration. ", validator));
            }
        });
    }

    private AuthenticatedUser buildAuthenticatedUser(User user) {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(user.getUserName());
        authenticatedUser.setTenantDomain(user.getTenantDomain());
        authenticatedUser.setUserStoreDomain(user.getUserStoreDomain());
        return authenticatedUser;
    }

    private String unmarshelOAuthDO(OAuthAppDO authApplication) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OAuthAppDO.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal((Object)authApplication, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in exporting OAuth application %s@%s", authApplication.getApplicationName(), authApplication.getUser().getTenantDomain()), (Throwable)e);
        }
    }

    private OAuthAppDO marshelOAuthDO(String authConfig, String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OAuthAppDO.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (OAuthAppDO)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(authConfig.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in unmarshelling OAuth application %s@%s", serviceProviderName, tenantDomain), (Throwable)e);
        }
    }
}

