/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationMethodNameTranslator;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.keyidprovider.KeyIDProvider;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;
import org.wso2.carbon.registry.core.service.RegistryService;

public class OAuth2ServiceComponentHolder {
    private static OAuth2ServiceComponentHolder instance = new OAuth2ServiceComponentHolder();
    private static ApplicationManagementService applicationMgtService;
    private static boolean pkceEnabled;
    private static boolean audienceEnabled;
    private static RegistryService registryService;
    private static AuthenticationMethodNameTranslator authenticationMethodNameTranslator;
    private static List<OAuthClientAuthenticator> authenticationHandlers;
    private static List<ClaimProvider> claimProviders;
    private static boolean idpIdColumnEnabled;
    private List<TokenBinder> tokenBinders = new ArrayList<TokenBinder>();
    private OAuthAdminServiceImpl oauthAdminService;
    private static AuthenticationDataPublisher authenticationDataPublisherProxy;
    private static KeyIDProvider keyIDProvider;

    private OAuth2ServiceComponentHolder() {
    }

    public static OAuth2ServiceComponentHolder getInstance() {
        return instance;
    }

    public static ApplicationManagementService getApplicationMgtService() {
        return applicationMgtService;
    }

    public static void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        OAuth2ServiceComponentHolder.applicationMgtService = applicationMgtService;
    }

    @Deprecated
    public static boolean isPkceEnabled() {
        return pkceEnabled;
    }

    public static void setPkceEnabled(boolean pkceEnabled) {
        OAuth2ServiceComponentHolder.pkceEnabled = pkceEnabled;
    }

    public static boolean isAudienceEnabled() {
        return audienceEnabled;
    }

    public static void setAudienceEnabled(boolean audienceEnabled) {
        OAuth2ServiceComponentHolder.audienceEnabled = audienceEnabled;
    }

    public static boolean isIDPIdColumnEnabled() {
        return idpIdColumnEnabled;
    }

    public static void setIDPIdColumnEnabled(boolean idpIdColumnEnabled) {
        OAuth2ServiceComponentHolder.idpIdColumnEnabled = idpIdColumnEnabled;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static void setRegistryService(RegistryService registryService) {
        OAuth2ServiceComponentHolder.registryService = registryService;
    }

    public static void addAuthenticationHandler(OAuthClientAuthenticator clientAuthenticator) {
        authenticationHandlers.add(clientAuthenticator);
        authenticationHandlers.sort((Comparator<OAuthClientAuthenticator>)new HandlerComparator());
    }

    public static List<OAuthClientAuthenticator> getAuthenticationHandlers() {
        return authenticationHandlers;
    }

    public static AuthenticationMethodNameTranslator getAuthenticationMethodNameTranslator() {
        return authenticationMethodNameTranslator;
    }

    public static void setAuthenticationMethodNameTranslator(AuthenticationMethodNameTranslator authenticationMethodNameTranslator) {
        OAuth2ServiceComponentHolder.authenticationMethodNameTranslator = authenticationMethodNameTranslator;
    }

    public static List<ClaimProvider> getClaimProviders() {
        return claimProviders;
    }

    public static void setClaimProvider(ClaimProvider claimProvider) {
        claimProviders.add(claimProvider);
    }

    public static void unregisterClaimProvider(ClaimProvider claimProvider) {
        claimProviders.remove(claimProvider);
    }

    public List<TokenBinder> getTokenBinders() {
        return this.tokenBinders;
    }

    public Optional<TokenBinder> getTokenBinder(String bindingType) {
        return this.tokenBinders.stream().filter(t -> t.getBindingType().equals(bindingType)).findAny();
    }

    public void addTokenBinder(TokenBinder tokenBinder) {
        this.tokenBinders.add(tokenBinder);
    }

    public void removeTokenBinder(TokenBinder tokenBinder) {
        this.tokenBinders.remove(tokenBinder);
    }

    public OAuthAdminServiceImpl getOAuthAdminService() {
        return this.oauthAdminService;
    }

    public void setOAuthAdminService(OAuthAdminServiceImpl oauthAdminService) {
        this.oauthAdminService = oauthAdminService;
    }

    public static void setAuthenticationDataPublisherProxy(AuthenticationDataPublisher authenticationDataPublisherProxy) {
        OAuth2ServiceComponentHolder.authenticationDataPublisherProxy = authenticationDataPublisherProxy;
    }

    public static AuthenticationDataPublisher getAuthenticationDataPublisherProxy() {
        return authenticationDataPublisherProxy;
    }

    public static KeyIDProvider getKeyIDProvider() {
        return keyIDProvider;
    }

    public static void setKeyIDProvider(KeyIDProvider keyIDProvider) {
        OAuth2ServiceComponentHolder.keyIDProvider = keyIDProvider;
    }

    static {
        pkceEnabled = false;
        audienceEnabled = false;
        authenticationHandlers = new ArrayList<OAuthClientAuthenticator>();
        claimProviders = new ArrayList<ClaimProvider>();
        idpIdColumnEnabled = false;
        keyIDProvider = null;
    }
}

