/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationMethodNameTranslator;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.common.token.bindings.TokenBinderInfo;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.OAuth2ScopeService;
import org.wso2.carbon.identity.oauth2.OAuth2Service;
import org.wso2.carbon.identity.oauth2.OAuth2TokenValidationService;
import org.wso2.carbon.identity.oauth2.client.authentication.BasicAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthenticator;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthnService;
import org.wso2.carbon.identity.oauth2.client.authentication.PublicClientAuthenticator;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.device.api.DeviceAuthService;
import org.wso2.carbon.identity.oauth2.device.api.DeviceAuthServiceImpl;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.internal.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.oauth2.internal.OAuthTenantMgtListenerImpl;
import org.wso2.carbon.identity.oauth2.internal.OAuthUserStoreConfigListenerImpl;
import org.wso2.carbon.identity.oauth2.keyidprovider.DefaultKeyIDProviderImpl;
import org.wso2.carbon.identity.oauth2.keyidprovider.KeyIDProvider;
import org.wso2.carbon.identity.oauth2.listener.TenantCreationEventListener;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.token.bindings.handlers.TokenBindingExpiryEventHandler;
import org.wso2.carbon.identity.oauth2.token.bindings.impl.CookieBasedTokenBinder;
import org.wso2.carbon.identity.oauth2.token.bindings.impl.SSOSessionBasedTokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;
import org.wso2.carbon.identity.openidconnect.OpenIDConnectClaimFilter;
import org.wso2.carbon.identity.openidconnect.OpenIDConnectClaimFilterImpl;
import org.wso2.carbon.identity.user.store.configuration.listener.UserStoreConfigListener;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

@Component(name="identity.oauth2.component", immediate=true)
public class OAuth2ServiceComponent {
    private static final Log log = LogFactory.getLog(OAuth2ServiceComponent.class);
    private BundleContext bundleContext;

    @Reference(name="framework.authentication.context.method.name.translator", service=AuthenticationMethodNameTranslator.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationMethodNameTranslator")
    protected void setAuthenticationMethodNameTranslator(AuthenticationMethodNameTranslator authenticationMethodNameTranslator) {
        OAuth2ServiceComponentHolder.setAuthenticationMethodNameTranslator(authenticationMethodNameTranslator);
    }

    protected void unsetAuthenticationMethodNameTranslator(AuthenticationMethodNameTranslator authenticationMethodNameTranslator) {
        if (OAuth2ServiceComponentHolder.getAuthenticationMethodNameTranslator() == authenticationMethodNameTranslator) {
            OAuth2ServiceComponentHolder.setAuthenticationMethodNameTranslator(null);
        }
    }

    protected void activate(ComponentContext context) {
        try {
            ServiceRegistration oauthApplicationMgtListenerSR;
            ServiceRegistration userStoreConfigEventSR;
            ServiceRegistration tenantMgtListenerSR;
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            boolean isRecordExist = OAuthTokenPersistenceFactory.getInstance().getScopeClaimMappingDAO().hasScopesPopulated(tenantId);
            if (!isRecordExist) {
                OAuth2Util.initiateOIDCScopes(tenantId);
            }
            TenantCreationEventListener scopeTenantMgtListener = new TenantCreationEventListener();
            this.bundleContext = context.getBundleContext();
            this.bundleContext.registerService(OAuth2Service.class.getName(), (Object)new OAuth2Service(), null);
            this.bundleContext.registerService(OAuth2ScopeService.class.getName(), (Object)new OAuth2ScopeService(), null);
            ServiceRegistration scopeTenantMgtListenerSR = this.bundleContext.registerService(TenantMgtListener.class.getName(), (Object)scopeTenantMgtListener, null);
            if (scopeTenantMgtListenerSR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" TenantMgtListener is registered");
                }
            } else {
                log.error((Object)"TenantMgtListener could not be registered");
            }
            OAuth2Util.initiateOAuthScopePermissionsBindings(tenantId);
            OAuthServerConfiguration oauthServerConfig = OAuthServerConfiguration.getInstance();
            this.bundleContext.registerService(OAuthServerConfiguration.class.getName(), (Object)oauthServerConfig, null);
            OAuth2TokenValidationService tokenValidationService = new OAuth2TokenValidationService();
            this.bundleContext.registerService(OAuth2TokenValidationService.class.getName(), (Object)tokenValidationService, null);
            OAuthClientAuthnService clientAuthnService = new OAuthClientAuthnService();
            this.bundleContext.registerService(OAuthClientAuthnService.class.getName(), (Object)clientAuthnService, null);
            BasicAuthClientAuthenticator basicAuthClientAuthenticator = new BasicAuthClientAuthenticator();
            this.bundleContext.registerService(OAuthClientAuthenticator.class.getName(), (Object)basicAuthClientAuthenticator, null);
            PublicClientAuthenticator publicClientAuthenticator = new PublicClientAuthenticator();
            this.bundleContext.registerService(OAuthClientAuthenticator.class.getName(), (Object)publicClientAuthenticator, null);
            CookieBasedTokenBinder cookieBasedTokenBinder = new CookieBasedTokenBinder();
            this.bundleContext.registerService(TokenBinderInfo.class.getName(), (Object)cookieBasedTokenBinder, null);
            SSOSessionBasedTokenBinder ssoSessionBasedTokenBinder = new SSOSessionBasedTokenBinder();
            this.bundleContext.registerService(TokenBinderInfo.class.getName(), (Object)ssoSessionBasedTokenBinder, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity OAuth bundle is activated");
            }
            if (OAuth2ServiceComponentHolder.getKeyIDProvider() == null) {
                DefaultKeyIDProviderImpl defaultKeyIDProvider = new DefaultKeyIDProviderImpl();
                OAuth2ServiceComponentHolder.setKeyIDProvider(defaultKeyIDProvider);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Key ID Provider " + DefaultKeyIDProviderImpl.class.getSimpleName() + " registered as the default Key ID Provider implementation."));
                }
            }
            if ((tenantMgtListenerSR = this.bundleContext.registerService(TenantMgtListener.class.getName(), (Object)new OAuthTenantMgtListenerImpl(), null)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OAuth - TenantMgtListener registered.");
                }
            } else {
                log.error((Object)"OAuth - TenantMgtListener could not be registered.");
            }
            if ((userStoreConfigEventSR = this.bundleContext.registerService(UserStoreConfigListener.class.getName(), (Object)new OAuthUserStoreConfigListenerImpl(), null)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OAuth - UserStoreConfigListener registered.");
                }
            } else {
                log.error((Object)"OAuth - UserStoreConfigListener could not be registered.");
            }
            if ((oauthApplicationMgtListenerSR = this.bundleContext.registerService(ApplicationMgtListener.class.getName(), (Object)new OAuthApplicationMgtListener(), null)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OAuth - ApplicationMgtListener registered.");
                }
            } else {
                log.error((Object)"OAuth - ApplicationMgtListener could not be registered.");
            }
            OAuth2ServiceComponentHolder.setPkceEnabled(true);
            ServiceRegistration deviceAuthService = this.bundleContext.registerService(DeviceAuthService.class.getName(), (Object)new DeviceAuthServiceImpl(), null);
            if (deviceAuthService != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"DeviceAuthService registered.");
                }
            } else {
                log.error((Object)"DeviceAuthService could not be registered.");
            }
            this.bundleContext.registerService(OpenIDConnectClaimFilter.class, (Object)new OpenIDConnectClaimFilterImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Default OpenIDConnect Claim filter registered successfully.");
            }
            this.bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new TokenBindingExpiryEventHandler(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"TokenBindingExpiryEventHandler is successfully registered.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating OAuth2ServiceComponent.", e);
        }
        if (OAuth2Util.checkAudienceEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OAuth - OIDC audiences enabled.");
            }
            OAuth2ServiceComponentHolder.setAudienceEnabled(true);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OAuth - OIDC audiences disabled.");
            }
            OAuth2ServiceComponentHolder.setAudienceEnabled(false);
        }
        if (OAuth2Util.checkIDPIdColumnAvailable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDP_ID column is available in all relevant tables. Setting isIDPIdColumnEnabled to true.");
            }
            OAuth2ServiceComponentHolder.setIDPIdColumnEnabled(true);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDP_ID column is not available in all relevant tables. Setting isIDPIdColumnEnabled to false.");
            }
            OAuth2ServiceComponentHolder.setIDPIdColumnEnabled(false);
        }
    }

    @Reference(name="application.mgt.service", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationMgtService")
    protected void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService set in Identity OAuth2ServiceComponent bundle");
        }
        OAuth2ServiceComponentHolder.setApplicationMgtService(applicationMgtService);
    }

    protected void unsetApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService unset in Identity OAuth2ServiceComponent bundle");
        }
        OAuth2ServiceComponentHolder.setApplicationMgtService(null);
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="identity.core.init.event.service", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        OAuth2ServiceComponentHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Registry Service");
        }
        OAuth2ServiceComponentHolder.setRegistryService(null);
    }

    @Reference(name="oauth.client.authenticator", service=OAuthClientAuthenticator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetOAuthClientAuthenticator")
    protected void setOAuthClientAuthenticator(OAuthClientAuthenticator oAuthClientAuthenticator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding OAuth client authentication handler : " + oAuthClientAuthenticator.getName()));
        }
        OAuth2ServiceComponentHolder.addAuthenticationHandler(oAuthClientAuthenticator);
    }

    protected void unsetOAuthClientAuthenticator(OAuthClientAuthenticator oAuthClientAuthenticator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Registry Service");
        }
        OAuth2ServiceComponentHolder.getAuthenticationHandlers().remove(oAuthClientAuthenticator);
    }

    @Reference(name="token.binding.service", service=TokenBinderInfo.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetTokenBinderInfo")
    protected void setTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the token binder for: " + tokenBinderInfo.getBindingType()));
        }
        if (tokenBinderInfo instanceof TokenBinder) {
            OAuth2ServiceComponentHolder.getInstance().addTokenBinder((TokenBinder)tokenBinderInfo);
        }
    }

    protected void unsetTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-setting the token binder for: " + tokenBinderInfo.getBindingType()));
        }
        if (tokenBinderInfo instanceof TokenBinder) {
            OAuth2ServiceComponentHolder.getInstance().removeTokenBinder((TokenBinder)tokenBinderInfo);
        }
    }

    @Reference(name="framework.authentication.data.publisher", service=AuthenticationDataPublisher.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationDataPublisher")
    protected void setAuthenticationDataPublisher(AuthenticationDataPublisher dataPublisher) {
        if ("AuthnDataPublisherProxy".equalsIgnoreCase(dataPublisher.getName()) && dataPublisher.isEnabled(null)) {
            OAuth2ServiceComponentHolder.setAuthenticationDataPublisherProxy(dataPublisher);
        }
    }

    protected void unsetAuthenticationDataPublisher(AuthenticationDataPublisher dataPublisher) {
        if ("AuthnDataPublisherProxy".equalsIgnoreCase(dataPublisher.getName()) && dataPublisher.isEnabled(null)) {
            OAuth2ServiceComponentHolder.setAuthenticationDataPublisherProxy(null);
        }
    }

    @Reference(name="keyid.provider.component", service=KeyIDProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetKeyIDProvider")
    protected void setKeyIDProvider(KeyIDProvider keyIDProvider) {
        KeyIDProvider oldKeyIDProvider = OAuth2ServiceComponentHolder.getKeyIDProvider();
        if (oldKeyIDProvider == null || oldKeyIDProvider.getClass().getSimpleName().equals(DefaultKeyIDProviderImpl.class.getSimpleName())) {
            OAuth2ServiceComponentHolder.setKeyIDProvider(keyIDProvider);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Custom Key ID Provider: " + keyIDProvider.getClass().getSimpleName() + "Registered replacing the default Key ID provider implementation."));
            }
        } else {
            log.warn((Object)("Key ID Provider: " + keyIDProvider.getClass().getSimpleName() + " not registered since a custom Key ID Provider already exists in the placeholder."));
        }
    }

    protected void unsetKeyIDProvider(KeyIDProvider keyIDProvider) {
    }

    @Reference(name="scope.validator.service", service=ScopeValidator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeScopeValidatorService")
    protected void addScopeValidatorService(ScopeValidator scopeValidator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding the Scope validator Service : " + scopeValidator.getName()));
        }
        OAuthComponentServiceHolder.getInstance().addScopeValidator(scopeValidator);
    }

    protected void removeScopeValidatorService(ScopeValidator scopeValidator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing the Scope validator Service : " + scopeValidator.getName()));
        }
        OAuthComponentServiceHolder.getInstance().removeScopeValidator(scopeValidator);
    }
}

