/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.device.grant;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.device.dao.DeviceFlowPersistenceFactory;
import org.wso2.carbon.identity.oauth2.device.model.DeviceFlowDO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class DeviceFlowGrant
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(DeviceFlowGrant.class);

    @Override
    public boolean validateGrant(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws IdentityOAuth2Exception {
        super.validateGrant(oAuthTokenReqMessageContext);
        boolean authStatus = false;
        RequestParameter[] parameters = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getRequestParameters();
        String deviceCode = null;
        for (RequestParameter parameter : parameters) {
            if (!"device_code".equals(parameter.getKey()) || parameter.getValue() == null || parameter.getValue().length <= 0) continue;
            deviceCode = parameter.getValue()[0];
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting ready to release token for device_code: " + deviceCode));
        }
        if (deviceCode != null) {
            DeviceFlowDO deviceFlowDO = DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().getAuthenticationDetails(deviceCode);
            Date date = new Date();
            String deviceStatus = deviceFlowDO.getStatus();
            deviceFlowDO.setScope(this.getScopes(deviceCode));
            deviceFlowDO.setDeviceCode(deviceCode);
            if ("NOT_EXIST".equals(deviceStatus)) {
                throw new IdentityOAuth2Exception("invalid_request");
            }
            if ("EXPIRED".equals(deviceStatus) || DeviceFlowGrant.isExpiredDeviceCode(deviceFlowDO, date)) {
                throw new IdentityOAuth2Exception("expired_token");
            }
            if ("AUTHORIZED".equals(deviceStatus)) {
                authStatus = true;
                DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setDeviceCodeExpired(deviceCode, "EXPIRED");
                this.setPropertiesForTokenGeneration(oAuthTokenReqMessageContext, deviceFlowDO);
            } else if ("USED".equals(deviceStatus) || "PENDING".equals(deviceStatus)) {
                Timestamp newPollTime = new Timestamp(date.getTime());
                if (DeviceFlowGrant.isValidPollTime(newPollTime, deviceFlowDO)) {
                    DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setLastPollTime(deviceCode, newPollTime);
                    throw new IdentityOAuth2Exception("authorization_pending");
                }
                DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setLastPollTime(deviceCode, newPollTime);
                throw new IdentityOAuth2Exception("slow_down");
            }
        }
        return authStatus;
    }

    private void setPropertiesForTokenGeneration(OAuthTokenReqMessageContext tokReqMsgCtx, DeviceFlowDO deviceFlowDO) {
        AuthenticatedUser authzUser = deviceFlowDO.getAuthorizedUser();
        String[] scopeSet = OAuth2Util.buildScopeArray(deviceFlowDO.getScope());
        tokReqMsgCtx.setAuthorizedUser(authzUser);
        if (StringUtils.isNotBlank((String)deviceFlowDO.getScope())) {
            tokReqMsgCtx.setScope(scopeSet);
        } else {
            tokReqMsgCtx.setScope(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope());
        }
    }

    @Override
    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return super.issue(tokReqMsgCtx);
    }

    private static boolean isExpiredDeviceCode(DeviceFlowDO deviceFlowDO, Date date) throws IdentityOAuth2Exception {
        if (deviceFlowDO.getExpiryTime().getTime() < date.getTime()) {
            DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().setDeviceCodeExpired(deviceFlowDO.getDeviceCode(), "EXPIRED");
            return true;
        }
        return false;
    }

    private static boolean isValidPollTime(Timestamp newPollTime, DeviceFlowDO deviceFlowDO) {
        return newPollTime.getTime() - deviceFlowDO.getLastPollTime().getTime() > deviceFlowDO.getPollTime();
    }

    private String getScopes(String deviceCode) throws IdentityOAuth2Exception {
        return String.join((CharSequence)" ", DeviceFlowPersistenceFactory.getInstance().getDeviceFlowDAO().getScopesForDeviceCode(deviceCode));
    }
}

