/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.device.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.device.dao.DeviceFlowDAO;
import org.wso2.carbon.identity.oauth2.device.model.DeviceFlowDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class DeviceFlowDAOImpl
implements DeviceFlowDAO {
    private static final Log log = LogFactory.getLog(DeviceFlowDAOImpl.class);

    @Override
    public void insertDeviceFlowParameters(String deviceCode, String userCode, String consumerKey, Long expiresIn, int interval, String scopes) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisting device_code: " + deviceCode + " for client: " + consumerKey));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            String codeId = UUID.randomUUID().toString();
            this.storeIntoDeviceFlow(codeId, deviceCode, userCode, consumerKey, expiresIn, interval, connection);
            this.storeIntoScopes(codeId, deviceCode, scopes, connection);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when storing the device flow parameters for consumer_key: " + consumerKey, e);
        }
    }

    @Override
    public String getClientIdByUserCode(String userCode) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting client_id for user_code: " + userCode));
        }
        String clientId = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT CONSUMER_KEY FROM IDN_OAUTH2_DEVICE_FLOW INNER JOIN IDN_OAUTH_CONSUMER_APPS ON CONSUMER_KEY_ID = ID WHERE USER_CODE = ?");){
            prepStmt.setString(1, userCode);
            ResultSet resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                clientId = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when getting client id for user_code: " + userCode, e);
        }
        return clientId;
    }

    @Override
    public void setAuthenticationStatus(String userCode, String status) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set authentication status: " + status + " for user_code: " + userCode));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_DEVICE_FLOW SET STATUS = ? WHERE USER_CODE = ?");){
                prepStmt.setString(1, status);
                prepStmt.setString(2, userCode);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when setting user has authenticated for user_code: " + userCode, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when setting user has authenticated for user_code: " + userCode, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public DeviceFlowDO getAuthenticationDetails(String deviceCode) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkClientIdExist(String clientId) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking existence of client_id: " + clientId));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT CONSUMER_KEY FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?");){
            String status;
            prepStmt.setString(1, clientId);
            ResultSet resultSet = prepStmt.executeQuery();
            do {
                if (!resultSet.next()) return false;
            } while ((status = resultSet.getString(1)) == null);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when check the existence of client_id: " + clientId, e);
        }
    }

    @Override
    public String getStatusForUserCode(String userCode) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting status for user_code: " + userCode));
        }
        String status = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT STATUS FROM IDN_OAUTH2_DEVICE_FLOW WHERE USER_CODE = ?");){
            prepStmt.setString(1, userCode);
            ResultSet resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                status = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when getting status for user_code: " + userCode, e);
        }
        return status;
    }

    @Override
    public void setLastPollTime(String deviceCode, Timestamp newPollTime) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting last_poll_time: " + newPollTime + " for device_code: " + deviceCode));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_DEVICE_FLOW SET LAST_POLL_TIME = ? WHERE DEVICE_CODE = ?");){
                prepStmt.setTimestamp(1, newPollTime, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                prepStmt.setString(2, deviceCode);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when setting last poll time for device_code: " + deviceCode, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when setting last poll time for device_code: " + deviceCode, e);
        }
    }

    @Override
    public void setAuthzUserAndStatus(String userCode, String status, AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting authorize user: " + authenticatedUser.getUserName() + " and status: " + status + " for user_code: " + userCode));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_DEVICE_FLOW SET AUTHZ_USER = ?, STATUS = ?, TENANT_ID = ?, USER_DOMAIN = ?, IDP_ID = (SELECT ID FROM IDP WHERE NAME = ? AND TENANT_ID = ?) WHERE USER_CODE = ?");){
                String authenticatedIDP = OAuth2Util.getAuthenticatedIDP(authenticatedUser);
                int tenantId = OAuth2Util.getTenantId(authenticatedUser.getTenantDomain());
                prepStmt.setString(1, authenticatedUser.getUserName());
                prepStmt.setString(2, status);
                prepStmt.setInt(3, tenantId);
                prepStmt.setString(4, OAuth2Util.getUserStoreDomain(authenticatedUser));
                prepStmt.setString(5, authenticatedIDP);
                prepStmt.setInt(6, tenantId);
                prepStmt.setString(7, userCode);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when setting authenticated user for user_code: " + userCode, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when setting authenticated user for user_code: " + userCode, e);
        }
    }

    @Override
    public void setDeviceCodeExpired(String deviceCode, String status) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting status as EXPIRED for device_code: " + deviceCode));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH2_DEVICE_FLOW SET STATUS = ? WHERE DEVICE_CODE = ?");){
                prepStmt.setString(1, status);
                prepStmt.setString(2, deviceCode);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when setting expired status for device_code: " + deviceCode, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when setting expired status for device_code: " + deviceCode, e);
        }
    }

    @Override
    public void setCallbackURI(String clientId, String callbackUri) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting callback_uri: " + callbackUri + " for client_id: " + clientId));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement prepStmt = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CALLBACK_URL = ? WHERE CONSUMER_KEY = ?");){
                prepStmt.setString(1, callbackUri);
                prepStmt.setString(2, clientId);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception("Error when setting expired callBackUri for consumer_key: " + clientId, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when setting expired callBackUri for consumer_key: " + clientId, e);
        }
    }

    @Override
    public String[] getScopesForUserCode(String userCode) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting scopes for user_code: " + userCode));
        }
        ArrayList<String> scopeSet = new ArrayList<String>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT SCOPE FROM (SELECT * FROM IDN_OAUTH2_DEVICE_FLOW INNER JOIN IDN_OAUTH2_DEVICE_FLOW_SCOPES ON IDN_OAUTH2_DEVICE_FLOW.CODE_ID = IDN_OAUTH2_DEVICE_FLOW_SCOPES.SCOPE_ID) DEVICE_FLOW_WITH_SCOPES WHERE USER_CODE = ?");){
            prepStmt.setString(1, userCode);
            ResultSet resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                scopeSet.add(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when getting scopes for user_code: " + userCode, e);
        }
        return scopeSet.toArray(new String[scopeSet.size()]);
    }

    @Override
    public String[] getScopesForDeviceCode(String deviceCode) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting scopes for device_code: " + deviceCode));
        }
        ArrayList<String> scopeSet = new ArrayList<String>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT SCOPE FROM (SELECT * FROM IDN_OAUTH2_DEVICE_FLOW INNER JOIN IDN_OAUTH2_DEVICE_FLOW_SCOPES ON IDN_OAUTH2_DEVICE_FLOW.CODE_ID = IDN_OAUTH2_DEVICE_FLOW_SCOPES.SCOPE_ID) DEVICE_FLOW_WITH_SCOPES WHERE DEVICE_CODE = ?");){
            prepStmt.setString(1, deviceCode);
            ResultSet resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                scopeSet.add(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception("Error when getting scopes for device_code: " + deviceCode, e);
        }
        return scopeSet.toArray(new String[scopeSet.size()]);
    }

    private void storeIntoDeviceFlow(String codeId, String deviceCode, String userCode, String consumerKey, long expiresIn, long interval, Connection connection) throws IdentityOAuth2Exception {
        try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH2_DEVICE_FLOW (CODE_ID, DEVICE_CODE, USER_CODE, CONSUMER_KEY_ID, TIME_CREATED, LAST_POLL_TIME, EXPIRY_TIME, POLL_TIME, STATUS) SELECT ?, ?, ?, ID, ?, ?, ?, ?, ? FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?");){
            Date date = new Date();
            Timestamp timeCreated = new Timestamp(date.getTime());
            long timeExpired = timeCreated.getTime() + expiresIn;
            Timestamp expiredTime = new Timestamp(timeExpired);
            prepStmt.setString(1, codeId);
            prepStmt.setString(2, deviceCode);
            prepStmt.setString(3, userCode);
            prepStmt.setTimestamp(4, timeCreated, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            prepStmt.setTimestamp(5, timeCreated, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            prepStmt.setTimestamp(6, expiredTime, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            prepStmt.setLong(7, interval);
            prepStmt.setString(8, "PENDING");
            prepStmt.setString(9, consumerKey);
            prepStmt.execute();
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when storing the device flow parameters for consumer_key: " + consumerKey, e);
        }
    }

    private void storeIntoScopes(String codeId, String deviceCode, String scope, Connection connection) throws IdentityOAuth2Exception {
        String[] scopeSet = OAuth2Util.buildScopeArray(scope);
        try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_OAUTH2_DEVICE_FLOW_SCOPES (SCOPE_ID, SCOPE) VALUES (?, ?)");){
            for (String scopes : scopeSet) {
                prepStmt.setString(1, codeId);
                prepStmt.setString(2, scopes);
                prepStmt.execute();
            }
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityOAuth2Exception("Error when storing scopes for device_code: " + deviceCode, e);
        }
    }
}

